/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.engine.tools.editor.area;

import com.badlogic.ashley.core.Component;
import com.badlogic.ashley.core.Entity;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.veiset.kgame.engine.ecs.component.PositionComponent;
import org.veiset.kgame.engine.ecs.component.draw.ShadowComponent;
import org.veiset.kgame.engine.ecs.component.draw.SpriteGfxComponent;
import org.veiset.kgame.engine.storage.TextureMetaStore;
import org.veiset.kgame.engine.tools.editor.area.AreaEntity;
import org.veiset.kgame.engine.tools.editor.area.BaseEntityData;
import org.veiset.kgame.engine.tools.editor.area.GraphicEntity;
import org.veiset.kgame.engine.tools.editor.area.GraphicEntityData;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\r\u001a\u00020\u000eH\u0002J\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u001a\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u000e\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u001dJ\u0013\u0010\u001e\u001a\u00020\u001d2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u00d6\u0003J\t\u0010!\u001a\u00020\"H\u00d6\u0001J\b\u0010#\u001a\u00020$H\u0016J\t\u0010%\u001a\u00020$H\u00d6\u0001J\b\u0010&\u001a\u00020\u0016H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006'"}, d2={"Lorg/veiset/kgame/engine/tools/editor/area/GraphicEntity;", "Lorg/veiset/kgame/engine/tools/editor/area/AreaEntity;", "base", "Lorg/veiset/kgame/engine/tools/editor/area/BaseEntityData;", "gfx", "Lorg/veiset/kgame/engine/storage/TextureMetaStore$TextureMeta;", "data", "Lorg/veiset/kgame/engine/tools/editor/area/GraphicEntityData;", "(Lorg/veiset/kgame/engine/tools/editor/area/BaseEntityData;Lorg/veiset/kgame/engine/storage/TextureMetaStore$TextureMeta;Lorg/veiset/kgame/engine/tools/editor/area/GraphicEntityData;)V", "getBase", "()Lorg/veiset/kgame/engine/tools/editor/area/BaseEntityData;", "getData", "()Lorg/veiset/kgame/engine/tools/editor/area/GraphicEntityData;", "entity", "Lcom/badlogic/ashley/core/Entity;", "getEntity", "()Lcom/badlogic/ashley/core/Entity;", "getGfx", "()Lorg/veiset/kgame/engine/storage/TextureMetaStore$TextureMeta;", "setGfx", "(Lorg/veiset/kgame/engine/storage/TextureMetaStore$TextureMeta;)V", "addComponents", "", "component1", "component2", "component3", "copy", "deepCopy", "newId", "", "equals", "other", "", "hashCode", "", "save", "", "toString", "update", "kgame2"})
public final class GraphicEntity
extends AreaEntity {
    @NotNull
    private final BaseEntityData base;
    @NotNull
    private TextureMetaStore.TextureMeta gfx;
    @NotNull
    private final GraphicEntityData data;
    @NotNull
    private final Entity entity;

    /*
     * WARNING - void declaration
     */
    public GraphicEntity(@NotNull BaseEntityData base, @NotNull TextureMetaStore.TextureMeta gfx, @NotNull GraphicEntityData data) {
        void it;
        Intrinsics.checkNotNullParameter((Object)base, (String)"base");
        Intrinsics.checkNotNullParameter((Object)gfx, (String)"gfx");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        super(null);
        this.base = base;
        this.gfx = gfx;
        this.data = data;
        Entity entity = new Entity();
        boolean bl = false;
        boolean bl2 = false;
        Entity entity2 = entity;
        GraphicEntity graphicEntity = this;
        boolean bl3 = false;
        this.addComponents((Entity)it);
        Unit unit = Unit.INSTANCE;
        graphicEntity.entity = entity;
    }

    @Override
    @NotNull
    public BaseEntityData getBase() {
        return this.base;
    }

    @NotNull
    public final TextureMetaStore.TextureMeta getGfx() {
        return this.gfx;
    }

    public final void setGfx(@NotNull TextureMetaStore.TextureMeta textureMeta) {
        Intrinsics.checkNotNullParameter((Object)textureMeta, (String)"<set-?>");
        this.gfx = textureMeta;
    }

    @NotNull
    public final GraphicEntityData getData() {
        return this.data;
    }

    @Override
    @NotNull
    public Entity getEntity() {
        return this.entity;
    }

    @Override
    public void update() {
        this.getEntity().removeAll();
        this.addComponents(this.getEntity());
    }

    @Override
    @NotNull
    public String save() {
        String[] stringArray = new StringBuilder();
        stringArray.append("\n            gfx\n            |id=").append(this.getBase().getId()).append("\n            |position=").append(this.getBase().getPosition().x).append(',').append(this.getBase().getPosition().y).append("\n            |size=").append(this.getBase().getSize().x).append(',').append(this.getBase().getSize().y).append("\n            |textureId=").append(this.gfx.getName()).append("\n            |layer=").append(this.data.getLayer()).append("\n            |shadow=").append(this.data.getShadow()).append("\n            |shadowOpacity=").append(this.data.getShadowOpacity()).append("\n            |shadowSize=").append(this.data.getShadowSize()).append("\n            |opacity=").append(this.data.getOpacity()).append("\n            |shadowOffset=");
        stringArray.append(this.data.getShadowOffset().x).append(',').append(this.data.getShadowOffset().y).append("\n            |boundingBox=").append(this.getBase().getBoundingBox()).append("\n        ");
        CharSequence charSequence = StringsKt.trimIndent((String)stringArray.toString());
        stringArray = new String[]{"\n"};
        return CollectionsKt.joinToString$default((Iterable)StringsKt.split$default((CharSequence)charSequence, (String[])stringArray, (boolean)false, (int)0, (int)6, null), (CharSequence)"", null, null, (int)0, null, (Function1)save.1.INSTANCE, (int)30, null);
    }

    @NotNull
    public final GraphicEntity deepCopy(boolean newId) {
        return new GraphicEntity(this.getBase().deepCopy(newId), this.gfx, GraphicEntityData.deepCopy$default(this.data, null, 1, null));
    }

    private final void addComponents(Entity entity) {
        Entity entity2 = entity.add((Component)new SpriteGfxComponent(this.gfx.getTexture(), this.getBase().getSize(), this.data.getLayer(), 0.0f, this.data.getOpacity(), 8, null)).add((Component)new PositionComponent(this.getBase().getPosition()));
        boolean bl = false;
        boolean bl2 = false;
        Entity it = entity2;
        boolean bl3 = false;
        if (this.getData().getShadow()) {
            it.add((Component)new ShadowComponent(this.getData().getShadowOpacity(), this.getData().getShadowOffset(), null, this.getData().getShadowSize(), false, 20, null));
        }
    }

    @NotNull
    public final BaseEntityData component1() {
        return this.getBase();
    }

    @NotNull
    public final TextureMetaStore.TextureMeta component2() {
        return this.gfx;
    }

    @NotNull
    public final GraphicEntityData component3() {
        return this.data;
    }

    @NotNull
    public final GraphicEntity copy(@NotNull BaseEntityData base, @NotNull TextureMetaStore.TextureMeta gfx, @NotNull GraphicEntityData data) {
        Intrinsics.checkNotNullParameter((Object)base, (String)"base");
        Intrinsics.checkNotNullParameter((Object)gfx, (String)"gfx");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return new GraphicEntity(base, gfx, data);
    }

    public static /* synthetic */ GraphicEntity copy$default(GraphicEntity graphicEntity, BaseEntityData baseEntityData, TextureMetaStore.TextureMeta textureMeta, GraphicEntityData graphicEntityData, int n, Object object) {
        if ((n & 1) != 0) {
            baseEntityData = graphicEntity.getBase();
        }
        if ((n & 2) != 0) {
            textureMeta = graphicEntity.gfx;
        }
        if ((n & 4) != 0) {
            graphicEntityData = graphicEntity.data;
        }
        return graphicEntity.copy(baseEntityData, textureMeta, graphicEntityData);
    }

    @NotNull
    public String toString() {
        return "GraphicEntity(base=" + this.getBase() + ", gfx=" + this.gfx + ", data=" + this.data + ')';
    }

    public int hashCode() {
        int result = this.getBase().hashCode();
        result = result * 31 + this.gfx.hashCode();
        result = result * 31 + this.data.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof GraphicEntity)) {
            return false;
        }
        GraphicEntity graphicEntity = (GraphicEntity)other;
        if (!Intrinsics.areEqual((Object)this.getBase(), (Object)graphicEntity.getBase())) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.gfx, (Object)graphicEntity.gfx)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.data, (Object)graphicEntity.data);
    }
}

