/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.engine.tools.ui.components;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.math.Vector2;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import ktx.graphics.ShapeRendererKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.veiset.kgame.engine.Log;
import org.veiset.kgame.engine.input.MouseKt;
import org.veiset.kgame.engine.math.Vector2Kt;
import org.veiset.kgame.engine.tools.ui.UiComponent;
import org.veiset.kgame.engine.tools.ui.UiComponentsKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0010\n\u0002\u0010\u0007\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\b\u0086\b\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002BE\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00018\u0000\u0012\u0014\b\u0002\u0010\t\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u0002\u0010\fJ\t\u0010\u001d\u001a\u00020\u0004H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0004H\u00c6\u0003J\u000f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007H\u00c6\u0003J\u0010\u0010 \u001a\u0004\u0018\u00018\u0000H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0014J\u0015\u0010!\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u000b0\nH\u00c6\u0003JZ\u0010\"\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00042\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00018\u00002\u0014\b\u0002\u0010\t\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u000b0\nH\u00c6\u0001\u00a2\u0006\u0002\u0010#J\b\u0010$\u001a\u00020%H\u0016J\u0013\u0010&\u001a\u00020'2\b\u0010(\u001a\u0004\u0018\u00010)H\u00d6\u0003J\t\u0010*\u001a\u00020+H\u00d6\u0001J\u0006\u0010,\u001a\u00020%J\u0006\u0010-\u001a\u00020%J\u0015\u0010.\u001a\u00020%2\b\u0010/\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010\u0016J\t\u00100\u001a\u00020\u000bH\u00d6\u0001J\b\u00101\u001a\u00020%H\u0016R \u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001e\u0010\b\u001a\u0004\u0018\u00018\u0000X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0017\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0012R\u001d\u0010\t\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\u001b\u001a\u00020\u001cX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lorg/veiset/kgame/engine/tools/ui/components/TextSelectList;", "T", "Lorg/veiset/kgame/engine/tools/ui/UiComponent;", "position", "Lcom/badlogic/gdx/math/Vector2;", "size", "options", "", "selected", "text", "Lkotlin/Function1;", "", "(Lcom/badlogic/gdx/math/Vector2;Lcom/badlogic/gdx/math/Vector2;Ljava/util/List;Ljava/lang/Object;Lkotlin/jvm/functions/Function1;)V", "getOptions", "()Ljava/util/List;", "setOptions", "(Ljava/util/List;)V", "getPosition", "()Lcom/badlogic/gdx/math/Vector2;", "getSelected", "()Ljava/lang/Object;", "setSelected", "(Ljava/lang/Object;)V", "Ljava/lang/Object;", "getSize", "getText", "()Lkotlin/jvm/functions/Function1;", "ySize", "", "component1", "component2", "component3", "component4", "component5", "copy", "(Lcom/badlogic/gdx/math/Vector2;Lcom/badlogic/gdx/math/Vector2;Ljava/util/List;Ljava/lang/Object;Lkotlin/jvm/functions/Function1;)Lorg/veiset/kgame/engine/tools/ui/components/TextSelectList;", "draw", "", "equals", "", "other", "", "hashCode", "", "next", "previous", "select", "option", "toString", "update", "kgame2"})
public final class TextSelectList<T>
implements UiComponent {
    @NotNull
    private final Vector2 position;
    @NotNull
    private final Vector2 size;
    @NotNull
    private List<? extends T> options;
    @Nullable
    private T selected;
    @NotNull
    private final Function1<T, String> text;
    private final float ySize;

    public TextSelectList(@NotNull Vector2 position, @NotNull Vector2 size, @NotNull List<? extends T> options, @Nullable T selected, @NotNull Function1<? super T, String> text) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Intrinsics.checkNotNullParameter((Object)size, (String)"size");
        Intrinsics.checkNotNullParameter(options, (String)"options");
        Intrinsics.checkNotNullParameter(text, (String)"text");
        this.position = position;
        this.size = size;
        this.options = options;
        this.selected = selected;
        this.text = text;
        this.ySize = 0.25f;
    }

    public /* synthetic */ TextSelectList(Vector2 vector2, Vector2 vector22, List list, Object object, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            object = null;
        }
        if ((n & 0x10) != 0) {
            function1 = 1.INSTANCE;
        }
        this(vector2, vector22, list, object, function1);
    }

    @NotNull
    public final Vector2 getPosition() {
        return this.position;
    }

    @NotNull
    public final Vector2 getSize() {
        return this.size;
    }

    @NotNull
    public final List<T> getOptions() {
        return this.options;
    }

    public final void setOptions(@NotNull List<? extends T> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.options = list;
    }

    @Nullable
    public final T getSelected() {
        return this.selected;
    }

    public final void setSelected(@Nullable T t) {
        this.selected = t;
    }

    @NotNull
    public final Function1<T, String> getText() {
        return this.text;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void draw() {
        UiComponentsKt.getShapeRenderer().begin(ShapeRenderer.ShapeType.Filled);
        UiComponentsKt.getShapeRenderer().setColor(Color.BLACK);
        ShapeRendererKt.rect((ShapeRenderer)UiComponentsKt.getShapeRenderer(), (Vector2)Vector2Kt.dw(this.position), (Vector2)Vector2Kt.dw(this.size));
        UiComponentsKt.getShapeRenderer().end();
        UiComponentsKt.getSpriteBatch().begin();
        Iterable $this$forEachIndexed$iv = this.options;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void s;
            int n = index$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Object t = item$iv;
            int index = n;
            boolean bl2 = false;
            if (Intrinsics.areEqual(this.getSelected(), (Object)s)) {
                UiComponentsKt.getFont().setColor(Color.WHITE);
            } else {
                UiComponentsKt.getFont().setColor(Color.GRAY);
            }
            UiComponentsKt.getFont().draw((Batch)UiComponentsKt.getSpriteBatch(), (CharSequence)this.getText().invoke((Object)s), 12.0f, (-0.1f + (this.getPosition().y + this.getSize().y) - (float)index * this.ySize) * 120.0f);
        }
        UiComponentsKt.getSpriteBatch().end();
    }

    @Override
    public void update() {
        boolean clicked = Vector2Kt.uiPointerWithinSquare(this.position, this.size);
        if (clicked && Gdx.input.isButtonJustPressed(0)) {
            float y = this.position.y + this.size.y - MouseKt.uiPointer().y;
            int selectedItem = (int)(y / this.ySize);
            if (selectedItem < this.options.size()) {
                T t = this.selected = this.options.get(selectedItem);
                Intrinsics.checkNotNull(t);
                Log.INSTANCE.info(Intrinsics.stringPlus((String)"TextList selected: ", (Object)this.text.invoke(t)));
            }
        } else if (clicked && Gdx.input.isButtonJustPressed(1)) {
            this.selected = null;
        }
    }

    public final void next() {
        Object object;
        if (this.selected == null) {
            object = CollectionsKt.firstOrNull(this.options);
        } else {
            T t = this.selected;
            Intrinsics.checkNotNull(t);
            object = this.options.get((this.options.indexOf(t) + 1) % this.options.size());
        }
        this.selected = object;
    }

    public final void previous() {
        Object object;
        if (this.selected == null) {
            object = CollectionsKt.firstOrNull(this.options);
        } else {
            T t = this.selected;
            Intrinsics.checkNotNull(t);
            int indexOf = this.options.indexOf(t);
            object = indexOf == 0 ? CollectionsKt.lastOrNull(this.options) : this.options.get((indexOf - 1) % this.options.size());
        }
        this.selected = object;
    }

    /*
     * WARNING - void declaration
     */
    public final void select(@Nullable T option) {
        Object v0;
        block1: {
            void $this$firstOrNull$iv;
            Iterable iterable = this.options;
            TextSelectList textSelectList = this;
            boolean $i$f$firstOrNull = false;
            Iterator iterator = $this$firstOrNull$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv;
                Object it = element$iv = iterator.next();
                boolean bl = false;
                if (!Intrinsics.areEqual(it, option)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        Object var9_9 = v0;
        textSelectList.selected = var9_9;
    }

    @NotNull
    public final Vector2 component1() {
        return this.position;
    }

    @NotNull
    public final Vector2 component2() {
        return this.size;
    }

    @NotNull
    public final List<T> component3() {
        return this.options;
    }

    @Nullable
    public final T component4() {
        return this.selected;
    }

    @NotNull
    public final Function1<T, String> component5() {
        return this.text;
    }

    @NotNull
    public final TextSelectList<T> copy(@NotNull Vector2 position, @NotNull Vector2 size, @NotNull List<? extends T> options, @Nullable T selected, @NotNull Function1<? super T, String> text) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Intrinsics.checkNotNullParameter((Object)size, (String)"size");
        Intrinsics.checkNotNullParameter(options, (String)"options");
        Intrinsics.checkNotNullParameter(text, (String)"text");
        return new TextSelectList<T>(position, size, options, selected, text);
    }

    public static /* synthetic */ TextSelectList copy$default(TextSelectList textSelectList, Vector2 vector2, Vector2 vector22, List list, Object object, Function1 function1, int n, Object object2) {
        if ((n & 1) != 0) {
            vector2 = textSelectList.position;
        }
        if ((n & 2) != 0) {
            vector22 = textSelectList.size;
        }
        if ((n & 4) != 0) {
            list = textSelectList.options;
        }
        if ((n & 8) != 0) {
            object = textSelectList.selected;
        }
        if ((n & 0x10) != 0) {
            function1 = textSelectList.text;
        }
        return textSelectList.copy(vector2, vector22, list, object, function1);
    }

    @NotNull
    public String toString() {
        return "TextSelectList(position=" + this.position + ", size=" + this.size + ", options=" + this.options + ", selected=" + this.selected + ", text=" + this.text + ')';
    }

    public int hashCode() {
        int result = this.position.hashCode();
        result = result * 31 + this.size.hashCode();
        result = result * 31 + ((Object)this.options).hashCode();
        result = result * 31 + (this.selected == null ? 0 : this.selected.hashCode());
        result = result * 31 + this.text.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TextSelectList)) {
            return false;
        }
        TextSelectList textSelectList = (TextSelectList)other;
        if (!Intrinsics.areEqual((Object)this.position, (Object)textSelectList.position)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.size, (Object)textSelectList.size)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.options, textSelectList.options)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.selected, textSelectList.selected)) {
            return false;
        }
        return Intrinsics.areEqual(this.text, textSelectList.text);
    }
}

