/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.engine.world;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.veiset.kgame.engine.world.GridCell;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\b\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0014\u0010\u0005\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u00060\u0006\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0003H\u0002J\u0018\u0010\u0013\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0003J\u001c\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00070\u00152\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0003J&\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0003J\u0006\u0010\u0019\u001a\u00020\u0010J\u0018\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0003H\u0002J\u001e\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u0007R!\u0010\u0005\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u00060\u0006\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\r\u00a8\u0006\u001d"}, d2={"Lorg/veiset/kgame/engine/world/GridCost;", "", "sizeX", "", "sizeY", "grid", "", "Lorg/veiset/kgame/engine/world/GridCell;", "(II[[Lorg/veiset/kgame/engine/world/GridCell;)V", "getGrid", "()[[Lorg/veiset/kgame/engine/world/GridCell;", "[[Lorg/veiset/kgame/engine/world/GridCell;", "getSizeX", "()I", "getSizeY", "calculateAreaForCell", "", "x", "y", "get", "getAreasThatCanFitSizeOf", "", "sx", "sy", "place", "precalculate", "recalculate", "update", "v", "kgame2"})
public final class GridCost {
    private final int sizeX;
    private final int sizeY;
    @NotNull
    private final GridCell[][] grid;

    public GridCost(int sizeX, int sizeY, @NotNull GridCell[][] grid) {
        Intrinsics.checkNotNullParameter((Object)grid, (String)"grid");
        this.sizeX = sizeX;
        this.sizeY = sizeY;
        this.grid = grid;
    }

    public final int getSizeX() {
        return this.sizeX;
    }

    public final int getSizeY() {
        return this.sizeY;
    }

    @NotNull
    public final GridCell[][] getGrid() {
        return this.grid;
    }

    @Nullable
    public final GridCell get(int x, int y) {
        return this.grid[x][y];
    }

    public final void update(int x, int y, @NotNull GridCell v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        this.grid[x][y] = v;
    }

    public final void precalculate() {
        Iterable $this$forEach$iv = (Iterable)RangesKt.downTo((int)this.sizeY, (int)0);
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            int element$iv;
            int y = element$iv = ((IntIterator)iterator).nextInt();
            boolean bl = false;
            Iterable $this$forEach$iv2 = (Iterable)RangesKt.downTo((int)this.getSizeX(), (int)0);
            boolean $i$f$forEach2 = false;
            Iterator iterator2 = $this$forEach$iv2.iterator();
            while (iterator2.hasNext()) {
                int element$iv2;
                int x = element$iv2 = ((IntIterator)iterator2).nextInt();
                boolean bl2 = false;
                this.calculateAreaForCell(x, y);
            }
        }
    }

    private final void calculateAreaForCell(int x, int y) {
        GridCell gridCell = this.grid[x][y];
        if (gridCell == null) {
            return;
        }
        GridCell cell = gridCell;
        Object[] objectArray = (GridCell[])ArraysKt.getOrNull((Object[])((Object[])this.grid), (int)(x + 1));
        GridCell gridCell2 = objectArray == null ? null : (GridCell)ArraysKt.getOrNull((Object[])objectArray, (int)(y + 1));
        GridCell c1 = gridCell2 == null ? new GridCell(0, 0, 0, 0) : gridCell2;
        Object[] objectArray2 = (GridCell[])ArraysKt.getOrNull((Object[])((Object[])this.grid), (int)x);
        objectArray = objectArray2 == null ? null : (GridCell)ArraysKt.getOrNull((Object[])objectArray2, (int)(y + 1));
        Object c2 = objectArray == null ? new GridCell(0, 0, 0, 0) : objectArray;
        Object[] objectArray3 = (GridCell[])ArraysKt.getOrNull((Object[])((Object[])this.grid), (int)(x + 1));
        objectArray2 = objectArray3 == null ? null : (GridCell)ArraysKt.getOrNull((Object[])objectArray3, (int)y);
        Object c3 = objectArray2 == null ? new GridCell(0, 0, 0, 0) : objectArray2;
        int n = c1.getX();
        int n2 = ((GridCell)c2).getX();
        int n3 = ((GridCell)c3).getX();
        int n4 = 0;
        n2 = Math.min(n2, n3);
        n3 = 0;
        int cx = Math.min(n, n2) + 1;
        n2 = c1.getY();
        n3 = ((GridCell)c2).getY();
        n4 = ((GridCell)c3).getY();
        boolean bl = false;
        n3 = Math.min(n3, n4);
        n4 = 0;
        int cy = Math.min(n2, n3) + 1;
        cell.setX(cx);
        cell.setY(cy);
    }

    public final void place(int x, int y, int sx, int sy) {
        Iterable $this$forEach$iv = (Iterable)RangesKt.until((int)y, (int)(y + sy));
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            int element$iv;
            int gy = element$iv = ((IntIterator)iterator).nextInt();
            boolean bl = false;
            Iterable $this$forEach$iv2 = (Iterable)RangesKt.until((int)x, (int)(x + sx));
            boolean $i$f$forEach2 = false;
            Iterator iterator2 = $this$forEach$iv2.iterator();
            while (iterator2.hasNext()) {
                int element$iv2;
                int gx = element$iv2 = ((IntIterator)iterator2).nextInt();
                boolean bl2 = false;
                this.getGrid()[gx][gy] = null;
            }
        }
        this.recalculate(x + sx, y + sy);
    }

    /*
     * WARNING - void declaration
     */
    private final void recalculate(int x, int y) {
        Iterable $this$forEach$iv = (Iterable)RangesKt.downTo((int)y, (int)0);
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            int element$iv;
            int yn = element$iv = ((IntIterator)iterator).nextInt();
            boolean bl = false;
            Iterable $this$forEachIndexed$iv = (Iterable)RangesKt.downTo((int)x, (int)0);
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            Iterator iterator2 = $this$forEachIndexed$iv.iterator();
            while (iterator2.hasNext()) {
                void xn;
                int item$iv = ((IntIterator)iterator2).nextInt();
                int n = index$iv++;
                boolean bl2 = false;
                if (n < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                int n2 = item$iv;
                int index = n;
                boolean bl3 = false;
                GridCell gridCell = this.getGrid()[xn][yn];
                if (gridCell == null) continue;
                this.calculateAreaForCell((int)xn, yn);
            }
        }
    }

    @NotNull
    public final List<GridCell> getAreasThatCanFitSizeOf(int sx, int sy) {
        boolean bl = false;
        List places = new ArrayList();
        Iterable $this$forEach$iv = (Iterable)new IntRange(0, this.sizeY);
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            int element$iv;
            int y = element$iv = ((IntIterator)iterator).nextInt();
            boolean bl2 = false;
            Iterable $this$forEach$iv2 = (Iterable)new IntRange(0, this.getSizeX());
            boolean $i$f$forEach2 = false;
            Iterator iterator2 = $this$forEach$iv2.iterator();
            while (iterator2.hasNext()) {
                int element$iv2;
                int x = element$iv2 = ((IntIterator)iterator2).nextInt();
                boolean bl3 = false;
                GridCell gridCell = this.getGrid()[x][y];
                if (gridCell == null || gridCell.getX() <= sx || gridCell.getY() <= sy) continue;
                places.add(gridCell);
            }
        }
        return places;
    }
}

