/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.module;

import com.badlogic.ashley.core.Component;
import com.badlogic.ashley.core.Engine;
import com.badlogic.ashley.core.Entity;
import com.badlogic.ashley.core.EntitySystem;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.math.Vector2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import ktx.graphics.ShapeRendererKt;
import org.jetbrains.annotations.NotNull;
import org.veiset.kgame.engine.GameModule;
import org.veiset.kgame.engine.Log;
import org.veiset.kgame.engine.TBEngineKt;
import org.veiset.kgame.engine.asset.AssetManager;
import org.veiset.kgame.engine.asset.AssetRef;
import org.veiset.kgame.engine.ecs.component.PositionComponent;
import org.veiset.kgame.engine.ecs.component.draw.SpriteGfxComponent;
import org.veiset.kgame.engine.ecs.system.graphics.DrawSystem;
import org.veiset.kgame.engine.math.Bezier;
import org.veiset.kgame.engine.math.Vector2Kt;
import org.veiset.kgame.engine.values.Asset;
import org.veiset.kgame.module.GameWorldModule;
import org.veiset.kgame.module.LevelSelectModuleKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0018\u001a\u00020\u0001H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u001aH\u0016J\u0010\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\bH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\n\"\u0004\b\u0017\u0010\f\u00a8\u0006\u001e"}, d2={"Lorg/veiset/kgame/module/SplashScreenModule;", "Lorg/veiset/kgame/engine/GameModule;", "engine", "Lcom/badlogic/ashley/core/Engine;", "(Lcom/badlogic/ashley/core/Engine;)V", "am", "Lorg/veiset/kgame/engine/asset/AssetManager;", "beizerTime", "", "getBeizerTime", "()F", "setBeizerTime", "(F)V", "bezier", "Lorg/veiset/kgame/engine/math/Bezier;", "getBezier", "()Lorg/veiset/kgame/engine/math/Bezier;", "camera", "Lcom/badlogic/gdx/graphics/OrthographicCamera;", "getEngine", "()Lcom/badlogic/ashley/core/Engine;", "time", "getTime", "setTime", "nextState", "setup", "", "teardown", "update", "delta", "kgame2"})
public final class SplashScreenModule
implements GameModule {
    @NotNull
    private final Engine engine;
    @NotNull
    private final AssetManager am;
    @NotNull
    private final OrthographicCamera camera;
    @NotNull
    private final Bezier bezier;
    private float time;
    private float beizerTime;

    public SplashScreenModule(@NotNull Engine engine) {
        Intrinsics.checkNotNullParameter((Object)engine, (String)"engine");
        this.engine = engine;
        this.am = TBEngineKt.getGlobals().getAssetManager();
        this.camera = TBEngineKt.getGlobals().getDrawGfx().getCamera();
        this.bezier = new Bezier(Vector2Kt.x(0.0f, 0.0f), Vector2Kt.x(0.0f, 1.0f), Vector2Kt.x(1.2f, 0.7f), Vector2Kt.x(2.0f, 2.0f));
    }

    @Override
    @NotNull
    public Engine getEngine() {
        return this.engine;
    }

    @NotNull
    public final Bezier getBezier() {
        return this.bezier;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setup() {
        TextureRegion textureRegion;
        void assetRef$iv;
        this.camera.position.x = 0.0f;
        this.camera.position.y = 0.0f;
        this.getEngine().addSystem((EntitySystem)new DrawSystem(null, 1, null));
        AssetManager assetManager = this.am;
        AssetRef assetRef = Asset.Texture.INSTANCE.getAttackBall();
        Entity entity = new Entity();
        Engine engine = this.getEngine();
        boolean $i$f$get = false;
        try {
            void this_$iv;
            Object object = this_$iv.getAssets().get(assetRef$iv);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.badlogic.gdx.graphics.g2d.TextureRegion");
            }
            textureRegion = (TextureRegion)object;
        }
        catch (Exception ex$iv) {
            Log.INSTANCE.critical("AssetRef " + assetRef$iv + " not loaded");
            throw ex$iv;
        }
        TextureRegion textureRegion2 = textureRegion;
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n = 28;
        float f = 0.0f;
        float f2 = 0.0f;
        int n2 = 0;
        Vector2 vector2 = Vector2Kt.x(0.2f, 0.2f);
        TextureRegion textureRegion3 = textureRegion2;
        engine.addEntity(entity.add((Component)new SpriteGfxComponent(textureRegion3, vector2, n2, f2, f, n, defaultConstructorMarker)).add((Component)new PositionComponent(Vector2Kt.x(1.0f, 1.0f))));
    }

    @Override
    public void teardown() {
    }

    public final float getTime() {
        return this.time;
    }

    public final void setTime(float f) {
        this.time = f;
    }

    public final float getBeizerTime() {
        return this.beizerTime;
    }

    public final void setBeizerTime(float f) {
        this.beizerTime = f;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void update(float delta) {
        void $this$mapIndexedTo$iv$iv;
        Unit unit;
        Collection<Unit> collection;
        Object current$iv;
        BitmapFont bitmapFont;
        BitmapFont bitmapFont2;
        BitmapFont bitmapFont3;
        AssetManager this_$iv;
        SplashScreenModule splashScreenModule = this;
        splashScreenModule.time += delta;
        splashScreenModule = this;
        splashScreenModule.beizerTime += delta;
        LevelSelectModuleKt.getSpriteBatch().begin();
        this.camera.update();
        LevelSelectModuleKt.getShapeRenderer().setProjectionMatrix(this.camera.combined);
        LevelSelectModuleKt.getSpriteBatch().setProjectionMatrix(this.camera.combined);
        float f = this.time * 1.0f;
        boolean bl = false;
        TBEngineKt.getGlobals().getDrawGfx().getCamera().position.x = (float)Math.sin(f) * 50.0f;
        AssetManager assetManager = this.am;
        AssetRef assetRef$iv = Asset.Font.INSTANCE.getJbt110();
        boolean $i$f$get = false;
        try {
            Object object = this_$iv.getAssets().get(assetRef$iv);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.badlogic.gdx.graphics.g2d.BitmapFont");
            }
            bitmapFont3 = (BitmapFont)object;
        }
        catch (Exception ex$iv) {
            Log.INSTANCE.critical("AssetRef " + assetRef$iv + " not loaded");
            throw ex$iv;
        }
        bitmapFont3.draw((Batch)LevelSelectModuleKt.getSpriteBatch(), (CharSequence)"Bleak Aether", -600.0f, 100.0f);
        this_$iv = this.am;
        assetRef$iv = Asset.Font.INSTANCE.getJbt12();
        $i$f$get = false;
        try {
            Object object = this_$iv.getAssets().get(assetRef$iv);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.badlogic.gdx.graphics.g2d.BitmapFont");
            }
            bitmapFont2 = (BitmapFont)object;
        }
        catch (Exception ex$iv) {
            Log.INSTANCE.critical("AssetRef " + assetRef$iv + " not loaded");
            throw ex$iv;
        }
        bitmapFont2.draw((Batch)LevelSelectModuleKt.getSpriteBatch(), (CharSequence)"v0.16a", 100.0f, 10.0f);
        this_$iv = this.am;
        assetRef$iv = Asset.Font.INSTANCE.getJbt16();
        $i$f$get = false;
        try {
            Object object = this_$iv.getAssets().get(assetRef$iv);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.badlogic.gdx.graphics.g2d.BitmapFont");
            }
            bitmapFont = (BitmapFont)object;
        }
        catch (Exception ex$iv) {
            Log.INSTANCE.critical("AssetRef " + assetRef$iv + " not loaded");
            throw ex$iv;
        }
        bitmapFont.draw((Batch)LevelSelectModuleKt.getSpriteBatch(), (CharSequence)"Music by Karl Casey @ White Bat Audio", 500.0f, -500.0f);
        LevelSelectModuleKt.getSpriteBatch().end();
        this.getEngine().update(delta);
        Vector2 pos = this.bezier.point(this.beizerTime - 1.0f);
        List debug = Bezier.debugline$default(this.bezier, 0, 1, null);
        if (this.beizerTime > 3.0f) {
            this.beizerTime = 0.0f;
        }
        LevelSelectModuleKt.getShapeRenderer().begin(ShapeRenderer.ShapeType.Line);
        LevelSelectModuleKt.getShapeRenderer().setColor(Color.WHITE);
        Iterable $this$zipWithNext$iv = debug;
        boolean $i$f$zipWithNext = false;
        Iterator iterator$iv = $this$zipWithNext$iv.iterator();
        if (!iterator$iv.hasNext()) {
            CollectionsKt.emptyList();
        } else {
            boolean bl2 = false;
            List result$iv = new ArrayList();
            current$iv = iterator$iv.next();
            while (iterator$iv.hasNext()) {
                void p1;
                void p0;
                Object next$iv = iterator$iv.next();
                Vector2 vector2 = (Vector2)next$iv;
                Vector2 vector22 = (Vector2)current$iv;
                collection = result$iv;
                boolean bl3 = false;
                LevelSelectModuleKt.getShapeRenderer().line(Vector2Kt.dw((Vector2)p0), Vector2Kt.dw((Vector2)p1));
                unit = Unit.INSTANCE;
                collection.add(unit);
                current$iv = next$iv;
            }
        }
        List<Vector2> debugPoints = this.bezier.debugPoints();
        Iterable $this$mapIndexed$iv = debugPoints;
        boolean $i$f$mapIndexed = false;
        current$iv = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void i;
            int n = index$iv$iv++;
            boolean bl4 = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Vector2 vector2 = (Vector2)item$iv$iv;
            int n2 = n;
            collection = destination$iv$iv;
            boolean bl5 = false;
            switch (i) {
                case 0: 
                case 3: {
                    break;
                }
                default: {
                    void p;
                    Color color;
                    void var18_36 = i;
                    switch (var18_36) {
                        case 0: {
                            color = Color.RED;
                            break;
                        }
                        case 1: {
                            color = Color.BLUE;
                            break;
                        }
                        case 2: {
                            color = Color.GREEN;
                            break;
                        }
                        case 3: {
                            color = Color.YELLOW;
                            break;
                        }
                        default: {
                            color = Color.WHITE;
                        }
                    }
                    Color color2 = color;
                    LevelSelectModuleKt.getShapeRenderer().setColor(color2);
                    Vector2 vector23 = Vector2Kt.dw((Vector2)p);
                    float x = Vector2Kt.component1(vector23);
                    float y = Vector2Kt.component2(vector23);
                    LevelSelectModuleKt.getShapeRenderer().circle(x, y, 5.0f);
                }
            }
            unit = Unit.INSTANCE;
            collection.add(unit);
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
        Vector2 vector2 = Vector2Kt.dw(pos);
        float px = Vector2Kt.component1(vector2);
        float py = Vector2Kt.component2(vector2);
        LevelSelectModuleKt.getShapeRenderer().setColor(Color.ORANGE);
        LevelSelectModuleKt.getShapeRenderer().end();
        LevelSelectModuleKt.getShapeRenderer().begin(ShapeRenderer.ShapeType.Filled);
        LevelSelectModuleKt.getShapeRenderer().circle(px, py, 5.0f);
        ShapeRendererKt.circle((ShapeRenderer)LevelSelectModuleKt.getShapeRenderer(), (Vector2)Vector2Kt.dw(debugPoints.get(0)), (float)5.0f);
        ShapeRendererKt.circle((ShapeRenderer)LevelSelectModuleKt.getShapeRenderer(), (Vector2)Vector2Kt.dw(debugPoints.get(3)), (float)5.0f);
        LevelSelectModuleKt.getShapeRenderer().end();
    }

    @Override
    @NotNull
    public GameModule nextState() {
        if (Gdx.input.isKeyJustPressed(46)) {
            return new SplashScreenModule(new Engine());
        }
        if (Gdx.input.isKeyJustPressed(-1) || Gdx.input.isButtonJustPressed(0)) {
            return new GameWorldModule(null, null, null, 7, null);
        }
        return this;
    }
}

