/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.engine;

import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.veiset.kgame.engine.Drawing;
import org.veiset.kgame.engine.GameFilesKt;
import org.veiset.kgame.engine.TBEngineKt;
import org.veiset.kgame.engine.asset.AssetManager;
import org.veiset.kgame.engine.input.GlobalKeyMapper;
import org.veiset.kgame.engine.sound.SoundPlayer;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\bH\u00c6\u0003J\t\u0010\u0019\u001a\u00020\nH\u00c6\u0003J;\u0010\u001a\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\nH\u00c6\u0001J\u0013\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001J\t\u0010 \u001a\u00020!H\u00d6\u0001J\u0006\u0010\"\u001a\u00020#R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006$"}, d2={"Lorg/veiset/kgame/engine/Globals;", "", "drawGfx", "Lorg/veiset/kgame/engine/Drawing;", "drawUi", "soundPlayer", "Lorg/veiset/kgame/engine/sound/SoundPlayer;", "assetManager", "Lorg/veiset/kgame/engine/asset/AssetManager;", "keyMapper", "Lorg/veiset/kgame/engine/input/GlobalKeyMapper;", "(Lorg/veiset/kgame/engine/Drawing;Lorg/veiset/kgame/engine/Drawing;Lorg/veiset/kgame/engine/sound/SoundPlayer;Lorg/veiset/kgame/engine/asset/AssetManager;Lorg/veiset/kgame/engine/input/GlobalKeyMapper;)V", "getAssetManager", "()Lorg/veiset/kgame/engine/asset/AssetManager;", "getDrawGfx", "()Lorg/veiset/kgame/engine/Drawing;", "getDrawUi", "getKeyMapper", "()Lorg/veiset/kgame/engine/input/GlobalKeyMapper;", "getSoundPlayer", "()Lorg/veiset/kgame/engine/sound/SoundPlayer;", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "", "toString", "", "updateDrawMatrix", "", "kgame2"})
public final class Globals {
    @NotNull
    private final Drawing drawGfx;
    @NotNull
    private final Drawing drawUi;
    @NotNull
    private final SoundPlayer soundPlayer;
    @NotNull
    private final AssetManager assetManager;
    @NotNull
    private final GlobalKeyMapper keyMapper;

    public Globals(@NotNull Drawing drawGfx, @NotNull Drawing drawUi, @NotNull SoundPlayer soundPlayer, @NotNull AssetManager assetManager, @NotNull GlobalKeyMapper keyMapper) {
        Intrinsics.checkNotNullParameter((Object)drawGfx, (String)"drawGfx");
        Intrinsics.checkNotNullParameter((Object)drawUi, (String)"drawUi");
        Intrinsics.checkNotNullParameter((Object)soundPlayer, (String)"soundPlayer");
        Intrinsics.checkNotNullParameter((Object)assetManager, (String)"assetManager");
        Intrinsics.checkNotNullParameter((Object)keyMapper, (String)"keyMapper");
        this.drawGfx = drawGfx;
        this.drawUi = drawUi;
        this.soundPlayer = soundPlayer;
        this.assetManager = assetManager;
        this.keyMapper = keyMapper;
    }

    public /* synthetic */ Globals(Drawing drawing, Drawing drawing2, SoundPlayer soundPlayer, AssetManager assetManager, GlobalKeyMapper globalKeyMapper, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            soundPlayer = new SoundPlayer(false, 1, null);
        }
        if ((n & 8) != 0) {
            assetManager = new AssetManager();
        }
        this(drawing, drawing2, soundPlayer, assetManager, globalKeyMapper);
    }

    @NotNull
    public final Drawing getDrawGfx() {
        return this.drawGfx;
    }

    @NotNull
    public final Drawing getDrawUi() {
        return this.drawUi;
    }

    @NotNull
    public final SoundPlayer getSoundPlayer() {
        return this.soundPlayer;
    }

    @NotNull
    public final AssetManager getAssetManager() {
        return this.assetManager;
    }

    @NotNull
    public final GlobalKeyMapper getKeyMapper() {
        return this.keyMapper;
    }

    public final void updateDrawMatrix() {
        OrthographicCamera camera = this.drawGfx.getCamera();
        ShapeRenderer shapeRenderer = this.drawGfx.getShapeRenderer();
        SpriteBatch spriteBatch = this.drawGfx.getSpriteBatch();
        camera.update();
        shapeRenderer.setProjectionMatrix(camera.combined);
        spriteBatch.setProjectionMatrix(camera.combined);
        TBEngineKt.getGlobals().drawGfx.getViewport().update(GameFilesKt.getGameConfig().getScreenWidth(), GameFilesKt.getGameConfig().getScreenHeight());
    }

    @NotNull
    public final Drawing component1() {
        return this.drawGfx;
    }

    @NotNull
    public final Drawing component2() {
        return this.drawUi;
    }

    @NotNull
    public final SoundPlayer component3() {
        return this.soundPlayer;
    }

    @NotNull
    public final AssetManager component4() {
        return this.assetManager;
    }

    @NotNull
    public final GlobalKeyMapper component5() {
        return this.keyMapper;
    }

    @NotNull
    public final Globals copy(@NotNull Drawing drawGfx, @NotNull Drawing drawUi, @NotNull SoundPlayer soundPlayer, @NotNull AssetManager assetManager, @NotNull GlobalKeyMapper keyMapper) {
        Intrinsics.checkNotNullParameter((Object)drawGfx, (String)"drawGfx");
        Intrinsics.checkNotNullParameter((Object)drawUi, (String)"drawUi");
        Intrinsics.checkNotNullParameter((Object)soundPlayer, (String)"soundPlayer");
        Intrinsics.checkNotNullParameter((Object)assetManager, (String)"assetManager");
        Intrinsics.checkNotNullParameter((Object)keyMapper, (String)"keyMapper");
        return new Globals(drawGfx, drawUi, soundPlayer, assetManager, keyMapper);
    }

    public static /* synthetic */ Globals copy$default(Globals globals, Drawing drawing, Drawing drawing2, SoundPlayer soundPlayer, AssetManager assetManager, GlobalKeyMapper globalKeyMapper, int n, Object object) {
        if ((n & 1) != 0) {
            drawing = globals.drawGfx;
        }
        if ((n & 2) != 0) {
            drawing2 = globals.drawUi;
        }
        if ((n & 4) != 0) {
            soundPlayer = globals.soundPlayer;
        }
        if ((n & 8) != 0) {
            assetManager = globals.assetManager;
        }
        if ((n & 0x10) != 0) {
            globalKeyMapper = globals.keyMapper;
        }
        return globals.copy(drawing, drawing2, soundPlayer, assetManager, globalKeyMapper);
    }

    @NotNull
    public String toString() {
        return "Globals(drawGfx=" + this.drawGfx + ", drawUi=" + this.drawUi + ", soundPlayer=" + this.soundPlayer + ", assetManager=" + this.assetManager + ", keyMapper=" + this.keyMapper + ')';
    }

    public int hashCode() {
        int result = this.drawGfx.hashCode();
        result = result * 31 + this.drawUi.hashCode();
        result = result * 31 + this.soundPlayer.hashCode();
        result = result * 31 + this.assetManager.hashCode();
        result = result * 31 + this.keyMapper.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Globals)) {
            return false;
        }
        Globals globals = (Globals)other;
        if (!Intrinsics.areEqual((Object)this.drawGfx, (Object)globals.drawGfx)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.drawUi, (Object)globals.drawUi)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.soundPlayer, (Object)globals.soundPlayer)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.assetManager, (Object)globals.assetManager)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.keyMapper, (Object)globals.keyMapper);
    }
}

