/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.engine.asset.assetloader;

import com.badlogic.gdx.graphics.g2d.Animation;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.veiset.kgame.engine.asset.AssetLoader;
import org.veiset.kgame.engine.asset.AssetRef;
import org.veiset.kgame.engine.util.TextureUtilsKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u001a\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0004\u0012\u00020\u00050\u0001B\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u0005H\u0016J#\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\u000bJ\u0016\u0010\f\u001a\u00020\u00022\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0016\u00a8\u0006\u000e"}, d2={"Lorg/veiset/kgame/engine/asset/assetloader/AnimationLoader;", "Lorg/veiset/kgame/engine/asset/AssetLoader;", "", "Lcom/badlogic/gdx/graphics/g2d/Animation;", "Lcom/badlogic/gdx/graphics/g2d/TextureRegion;", "Lorg/veiset/kgame/engine/asset/AssetRef$AnimationRef;", "()V", "loadAsync", "ref", "loadSync", "preloaded", "(Lorg/veiset/kgame/engine/asset/AssetRef$AnimationRef;Lkotlin/Unit;)Lcom/badlogic/gdx/graphics/g2d/Animation;", "unload", "asset", "kgame2"})
public final class AnimationLoader
implements AssetLoader<Unit, Animation<TextureRegion>, AssetRef.AnimationRef> {
    @Override
    public void loadAsync(@NotNull AssetRef.AnimationRef ref) {
        Intrinsics.checkNotNullParameter((Object)ref, (String)"ref");
    }

    @Override
    @NotNull
    public Animation<TextureRegion> loadSync(@NotNull AssetRef.AnimationRef ref, @NotNull Unit preloaded) {
        Intrinsics.checkNotNullParameter((Object)ref, (String)"ref");
        Intrinsics.checkNotNullParameter((Object)preloaded, (String)"preloaded");
        Pair<Integer, Integer> pair = ref.getSize();
        int sizeX = ((Number)pair.component1()).intValue();
        int sizeY = ((Number)pair.component2()).intValue();
        List<TextureRegion> textureRegion = TextureUtilsKt.allTextureFromRegion(ref.getPath(), sizeX, sizeY);
        return new Animation(ref.getSpeed(), TextureUtilsKt.toGdxArray(textureRegion));
    }

    @Override
    public void unload(@NotNull Animation<TextureRegion> asset) {
        Intrinsics.checkNotNullParameter(asset, (String)"asset");
    }
}

