/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.engine.behaviour;

import com.badlogic.ashley.core.Engine;
import com.badlogic.ashley.core.Entity;
import com.badlogic.gdx.audio.Sound;
import com.badlogic.gdx.controllers.Controller;
import com.badlogic.gdx.controllers.Controllers;
import com.badlogic.gdx.graphics.g2d.Animation;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.Body;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.veiset.kgame.engine.GameFilesKt;
import org.veiset.kgame.engine.Log;
import org.veiset.kgame.engine.TBEngineKt;
import org.veiset.kgame.engine.asset.AssetManager;
import org.veiset.kgame.engine.asset.AssetRef;
import org.veiset.kgame.engine.behaviour.ActionType;
import org.veiset.kgame.engine.behaviour.AnimationSpeedModifier;
import org.veiset.kgame.engine.behaviour.BehaviourStateChange;
import org.veiset.kgame.engine.behaviour.DynamicAnimation;
import org.veiset.kgame.engine.ecs.component.PositionComponent;
import org.veiset.kgame.engine.ecs.component.draw.Direction;
import org.veiset.kgame.engine.ecs.component.physics.DynamicBodyComponent;
import org.veiset.kgame.engine.ecs.component.physics.DynamicBodyComponentKt;
import org.veiset.kgame.engine.ecs.component.physics.VelocityComponent;
import org.veiset.kgame.engine.ecs.component.player.InventoryComponent;
import org.veiset.kgame.engine.ecs.entity.PlayerEntity;
import org.veiset.kgame.engine.ecs.entity.attack.PlayerAttackEntity;
import org.veiset.kgame.engine.ecs.entity.effect.PermaEffectAnimationEntity;
import org.veiset.kgame.engine.ecs.system.Mapper;
import org.veiset.kgame.engine.ecs.system.physics.CollisionGroup;
import org.veiset.kgame.engine.input.InputKey;
import org.veiset.kgame.engine.input.InputKeyKt;
import org.veiset.kgame.engine.input.MouseKt;
import org.veiset.kgame.engine.math.Vector2Kt;
import org.veiset.kgame.engine.values.Asset;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001e\u0010/\u001a\u0002002\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u00020\u00102\u0006\u00104\u001a\u00020\bJ\u0010\u00105\u001a\u0002002\u0006\u00106\u001a\u000207H\u0016J \u00108\u001a\u0002002\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u00020\u00102\u0006\u00104\u001a\u00020\bH\u0002J \u00109\u001a\u0002002\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u00020\u00102\u0006\u00104\u001a\u00020\bH\u0002J\u0010\u0010:\u001a\u0002002\u0006\u0010;\u001a\u000207H\u0016J \u0010<\u001a\u0002002\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u00020\u00102\u0006\u00104\u001a\u00020\bH\u0016R\u001c\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u0010X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u001b\u001a\u00020\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u001e\u0010\u001f\u001a\u0004\u0018\u00010 X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010%\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u0011\u0010&\u001a\u00020'\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u0019\u0010*\u001a\n ,*\u0004\u0018\u00010+0+\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.\u00a8\u0006="}, d2={"Lorg/veiset/kgame/engine/behaviour/PlayerBehaviour;", "Lorg/veiset/kgame/engine/behaviour/BehaviourStateChange;", "engine", "Lcom/badlogic/ashley/core/Engine;", "player", "Lorg/veiset/kgame/engine/ecs/entity/PlayerEntity;", "(Lcom/badlogic/ashley/core/Engine;Lorg/veiset/kgame/engine/ecs/entity/PlayerEntity;)V", "_speed", "Lorg/veiset/kgame/engine/behaviour/AnimationSpeedModifier;", "get_speed", "()Lorg/veiset/kgame/engine/behaviour/AnimationSpeedModifier;", "set_speed", "(Lorg/veiset/kgame/engine/behaviour/AnimationSpeedModifier;)V", "am", "Lorg/veiset/kgame/engine/asset/AssetManager;", "currentDodgeCooldown", "", "getCurrentDodgeCooldown", "()F", "setCurrentDodgeCooldown", "(F)V", "dodgeCooldown", "getDodgeCooldown", "getEngine", "()Lcom/badlogic/ashley/core/Engine;", "getPlayer", "()Lorg/veiset/kgame/engine/ecs/entity/PlayerEntity;", "runningSound", "Lcom/badlogic/gdx/audio/Sound;", "getRunningSound", "()Lcom/badlogic/gdx/audio/Sound;", "runningSoundId", "", "getRunningSoundId", "()Ljava/lang/Long;", "setRunningSoundId", "(Ljava/lang/Long;)V", "Ljava/lang/Long;", "targetEntity", "Lorg/veiset/kgame/engine/ecs/entity/effect/PermaEffectAnimationEntity;", "getTargetEntity", "()Lorg/veiset/kgame/engine/ecs/entity/effect/PermaEffectAnimationEntity;", "targetEntityPos", "Lorg/veiset/kgame/engine/ecs/component/PositionComponent;", "kotlin.jvm.PlatformType", "getTargetEntityPos", "()Lorg/veiset/kgame/engine/ecs/component/PositionComponent;", "calc", "", "dynamicAnimation", "Lorg/veiset/kgame/engine/behaviour/DynamicAnimation;", "delta", "speed", "completedState", "completedAction", "Lorg/veiset/kgame/engine/behaviour/ActionType;", "gamepadControl", "keyboardControl", "newState", "newAction", "update", "kgame2"})
public final class PlayerBehaviour
implements BehaviourStateChange {
    @NotNull
    private final Engine engine;
    @NotNull
    private final PlayerEntity player;
    @NotNull
    private final AssetManager am;
    @NotNull
    private final Sound runningSound;
    @Nullable
    private Long runningSoundId;
    @NotNull
    private final PermaEffectAnimationEntity targetEntity;
    private final PositionComponent targetEntityPos;
    private final float dodgeCooldown;
    private float currentDodgeCooldown;
    @Nullable
    private AnimationSpeedModifier _speed;

    public PlayerBehaviour(@NotNull Engine engine, @NotNull PlayerEntity player) {
        Animation animation;
        Sound sound;
        AssetRef assetRef$iv;
        AssetManager this_$iv;
        Intrinsics.checkNotNullParameter((Object)engine, (String)"engine");
        Intrinsics.checkNotNullParameter((Object)((Object)player), (String)"player");
        this.engine = engine;
        this.player = player;
        AssetManager assetManager = this.am = TBEngineKt.getGlobals().getAssetManager();
        AssetRef assetRef = Asset.Sound.INSTANCE.getRunning();
        PlayerBehaviour playerBehaviour = this;
        boolean $i$f$get = false;
        try {
            Object object = this_$iv.getAssets().get(assetRef$iv);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.badlogic.gdx.audio.Sound");
            }
            sound = (Sound)object;
        }
        catch (Exception ex$iv) {
            Log.INSTANCE.critical("AssetRef " + assetRef$iv + " not loaded");
            throw ex$iv;
        }
        playerBehaviour.runningSound = sound;
        this_$iv = this.am;
        assetRef$iv = Asset.Animation.INSTANCE.getMouseClick();
        playerBehaviour = this;
        $i$f$get = false;
        try {
            Object object = this_$iv.getAssets().get(assetRef$iv);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.badlogic.gdx.graphics.g2d.Animation<com.badlogic.gdx.graphics.g2d.TextureRegion>");
            }
            animation = (Animation)object;
        }
        catch (Exception ex$iv) {
            Log.INSTANCE.critical("AssetRef " + assetRef$iv + " not loaded");
            throw ex$iv;
        }
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n = 8;
        int n2 = 10;
        Direction direction = null;
        Vector2 vector2 = Vector2Kt.x(0.18f, 0.18f);
        Vector2 vector22 = MouseKt.scaledPointer();
        Animation animation2 = animation;
        playerBehaviour.targetEntity = new PermaEffectAnimationEntity(animation2, vector22, vector2, direction, n2, n, defaultConstructorMarker);
        this.targetEntityPos = (PositionComponent)Mapper.INSTANCE.getPosition().get((Entity)this.targetEntity);
        this.dodgeCooldown = 0.5f;
        this.engine.addEntity((Entity)this.targetEntity);
    }

    @NotNull
    public final Engine getEngine() {
        return this.engine;
    }

    @NotNull
    public final PlayerEntity getPlayer() {
        return this.player;
    }

    @NotNull
    public final Sound getRunningSound() {
        return this.runningSound;
    }

    @Nullable
    public final Long getRunningSoundId() {
        return this.runningSoundId;
    }

    public final void setRunningSoundId(@Nullable Long l) {
        this.runningSoundId = l;
    }

    @NotNull
    public final PermaEffectAnimationEntity getTargetEntity() {
        return this.targetEntity;
    }

    public final PositionComponent getTargetEntityPos() {
        return this.targetEntityPos;
    }

    public final float getDodgeCooldown() {
        return this.dodgeCooldown;
    }

    public final float getCurrentDodgeCooldown() {
        return this.currentDodgeCooldown;
    }

    public final void setCurrentDodgeCooldown(float f) {
        this.currentDodgeCooldown = f;
    }

    @Nullable
    public final AnimationSpeedModifier get_speed() {
        return this._speed;
    }

    public final void set_speed(@Nullable AnimationSpeedModifier animationSpeedModifier) {
        this._speed = animationSpeedModifier;
    }

    @Override
    public void update(@NotNull DynamicAnimation dynamicAnimation, float delta, @NotNull AnimationSpeedModifier speed) {
        Intrinsics.checkNotNullParameter((Object)dynamicAnimation, (String)"dynamicAnimation");
        Intrinsics.checkNotNullParameter((Object)speed, (String)"speed");
        if (GameFilesKt.getGameConfig().getInputUseController() && Controllers.getCurrent() != null) {
            this.gamepadControl(dynamicAnimation, delta, speed);
        } else {
            this.keyboardControl(dynamicAnimation, delta, speed);
        }
        this.calc(dynamicAnimation, delta, speed);
    }

    private final void gamepadControl(DynamicAnimation dynamicAnimation, float delta, AnimationSpeedModifier speed) {
        Controller controller = Controllers.getCurrent();
        if (controller == null) {
            return;
        }
        Controller controller2 = controller;
        this.currentDodgeCooldown -= delta;
        float leftX = controller2.getAxis(controller2.getMapping().axisLeftX);
        float leftY = controller2.getAxis(controller2.getMapping().axisLeftY);
        float rightX = controller2.getAxis(controller2.getMapping().axisRightX);
        float rightY = controller2.getAxis(controller2.getMapping().axisRightY);
        boolean r2 = controller2.getButton(controller2.getMapping().buttonR1);
        controller2.getButton(controller2.getMapping().buttonA);
        Vector2 position = ((PositionComponent)Mapper.INSTANCE.getPosition().get((Entity)this.player)).getPos();
        VelocityComponent velocity = (VelocityComponent)Mapper.INSTANCE.getVelocity().get((Entity)this.player);
        if (r2 && this.currentDodgeCooldown <= 0.0f) {
            this.currentDodgeCooldown = this.dodgeCooldown;
            velocity.setSpeed(Vector2Kt.x(0.0f, 0.0f));
            Vector2 vector2 = new Vector2(leftX, -leftY).scl(2.0f);
            Intrinsics.checkNotNullExpressionValue((Object)vector2, (String)"Vector2(leftX, -leftY).scl(2f)");
            Vector2 target = Vector2Kt.plus(position, vector2);
            dynamicAnimation.queueAction(new ActionType.Dodge(target));
        } else if ((double)Math.abs(rightX) > 0.8 || (double)Math.abs(rightY) > 0.8) {
            Vector2 vector2 = new Vector2(rightX, -rightY).scl(3.0f);
            Intrinsics.checkNotNullExpressionValue((Object)vector2, (String)"Vector2(rightX, -rightY).scl(3f)");
            Vector2 target = Vector2Kt.plus(position, vector2);
            velocity.setSpeed(Vector2Kt.x(0.0f, 0.0f));
            dynamicAnimation.queueAction(new ActionType.Attack(target));
        } else if ((double)Math.abs(leftX) > 0.1 || (double)Math.abs(leftY) > 0.1) {
            Vector2 vector2 = new Vector2(leftX, -leftY).scl(2.0f);
            Intrinsics.checkNotNullExpressionValue((Object)vector2, (String)"Vector2(leftX, -leftY).scl(2f)");
            Vector2 target = Vector2Kt.plus(position, vector2);
            this.targetEntityPos.setPos(Vector2Kt.copy(target));
            dynamicAnimation.queueAction(new ActionType.Moving(target));
        } else {
            dynamicAnimation.queueAction(ActionType.Idle.INSTANCE);
        }
    }

    private final void keyboardControl(DynamicAnimation dynamicAnimation, float delta, AnimationSpeedModifier speed) {
        this._speed = speed;
        ActionType currentAction = dynamicAnimation.action();
        Vector2 position = ((PositionComponent)Mapper.INSTANCE.getPosition().get((Entity)this.player)).getPos();
        VelocityComponent velocity = (VelocityComponent)Mapper.INSTANCE.getVelocity().get((Entity)this.player);
        this.currentDodgeCooldown -= delta;
        if (velocity.getSpeed().x == 0.0f && velocity.getSpeed().y == 0.0f) {
            dynamicAnimation.queueAction(ActionType.Idle.INSTANCE);
        }
        if (InputKeyKt.clicked(InputKey.DODGE) && this.currentDodgeCooldown <= 0.0f) {
            this.currentDodgeCooldown = this.dodgeCooldown;
            velocity.setSpeed(Vector2Kt.x(0.0f, 0.0f));
            Vector2 t = Vector2Kt.minus(MouseKt.scaledPointer(), position).scl(100.0f);
            Intrinsics.checkNotNullExpressionValue((Object)t, (String)"t");
            dynamicAnimation.queueAction(new ActionType.Dodge(t));
        } else if (InputKeyKt.pressed(InputKey.ATTACK)) {
            velocity.setSpeed(Vector2Kt.x(0.0f, 0.0f));
            dynamicAnimation.queueAction(new ActionType.Attack(MouseKt.scaledPointer()));
        } else if (InputKeyKt.pressed(InputKey.MOVE)) {
            Vector2 target = MouseKt.scaledPointer();
            this.targetEntityPos.setPos(Vector2Kt.copy(target));
            if (target.dst(position) >= 0.2f) {
                dynamicAnimation.queueAction(new ActionType.Moving(target));
            }
        }
    }

    public final void calc(@NotNull DynamicAnimation dynamicAnimation, float delta, @NotNull AnimationSpeedModifier speed) {
        Vector2 vector2;
        Vector2 targetPos;
        Intrinsics.checkNotNullParameter((Object)dynamicAnimation, (String)"dynamicAnimation");
        Intrinsics.checkNotNullParameter((Object)speed, (String)"speed");
        Vector2 position = ((PositionComponent)Mapper.INSTANCE.getPosition().get((Entity)this.player)).getPos();
        VelocityComponent velocity = (VelocityComponent)Mapper.INSTANCE.getVelocity().get((Entity)this.player);
        ActionType currentAction = dynamicAnimation.action();
        if (currentAction instanceof ActionType.Dodge) {
            targetPos = ((ActionType.Dodge)currentAction).getTarget();
            vector2 = Vector2Kt.minus(targetPos, position).nor().scl(5.0f);
            Intrinsics.checkNotNullExpressionValue((Object)vector2, (String)"targetPos - position).nor().scl(5f)");
            velocity.setSpeed(vector2);
            if (targetPos.dst(position) <= 0.2f) {
                dynamicAnimation.queueAction(ActionType.Idle.INSTANCE);
                velocity.setSpeed(Vector2Kt.x(0.0f, 0.0f));
            }
        }
        if (currentAction instanceof ActionType.Moving) {
            targetPos = ((ActionType.Moving)currentAction).getTarget();
            this.targetEntityPos.setPos(Vector2Kt.copy(targetPos));
            vector2 = Vector2Kt.minus(targetPos, position).nor().scl(speed.getMove());
            Intrinsics.checkNotNullExpressionValue((Object)vector2, (String)"targetPos - position).nor().scl(speed.move)");
            velocity.setSpeed(vector2);
            if (targetPos.dst(position) <= 0.2f) {
                dynamicAnimation.queueAction(ActionType.Idle.INSTANCE);
                velocity.setSpeed(Vector2Kt.x(0.0f, 0.0f));
            }
        }
    }

    @Override
    public void completedState(@NotNull ActionType completedAction) {
        Intrinsics.checkNotNullParameter((Object)completedAction, (String)"completedAction");
        DynamicBodyComponent dynamicBodyComponent = (DynamicBodyComponent)Mapper.INSTANCE.getDynamicBody().get((Entity)this.player);
        Object object = dynamicBodyComponent == null ? null : dynamicBodyComponent.getBody();
        if (object == null) {
            throw new IllegalStateException("No body");
        }
        Body body = object;
        InventoryComponent inventoryComponent = (InventoryComponent)Mapper.INSTANCE.getInventory().get((Entity)this.player);
        if (inventoryComponent == null) {
            throw new IllegalStateException("No inventory");
        }
        InventoryComponent inventory = inventoryComponent;
        Vector2 position = ((PositionComponent)Mapper.INSTANCE.getPosition().get((Entity)this.player)).getPos();
        VelocityComponent velocity = (VelocityComponent)Mapper.INSTANCE.getVelocity().get((Entity)this.player);
        ActionType actionType = completedAction;
        if (actionType instanceof ActionType.Attack) {
            velocity.setSpeed(Vector2Kt.x(0.0f, 0.0f));
            this.engine.addEntity((Entity)new PlayerAttackEntity(inventory.allMods(), position, ((ActionType.Attack)completedAction).getTarget()));
        } else if (actionType instanceof ActionType.Moving) {
            if (this.runningSoundId != null) {
                this.runningSound.stop();
                this.runningSoundId = null;
            }
            this.targetEntity.disable();
        } else if (actionType instanceof ActionType.Dodge) {
            DynamicBodyComponentKt.updateCollision(body, CollisionGroup.INSTANCE.getPLAYER());
        }
        Log.INSTANCE.debug(Intrinsics.stringPlus((String)"Completed state: ", (Object)completedAction));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void newState(@NotNull ActionType newAction) {
        Intrinsics.checkNotNullParameter((Object)newAction, (String)"newAction");
        DynamicBodyComponent dynamicBodyComponent = (DynamicBodyComponent)Mapper.INSTANCE.getDynamicBody().get((Entity)this.player);
        Body body = dynamicBodyComponent == null ? null : dynamicBodyComponent.getBody();
        VelocityComponent velocity = (VelocityComponent)Mapper.INSTANCE.getVelocity().get((Entity)this.player);
        ActionType actionType = newAction;
        if (actionType instanceof ActionType.Moving) {
            float f;
            AnimationSpeedModifier animationSpeedModifier = this._speed;
            float pitch = animationSpeedModifier == null ? 1.5f : (f = animationSpeedModifier.getMove());
            this.runningSoundId = this.runningSound.loop(1.3f * GameFilesKt.getGameConfig().getVolumeEffect() * GameFilesKt.getGameConfig().getVolumeMaster(), Math.min(pitch / 3.0f, 1.6f), 0.0f);
            this.targetEntity.enable();
        } else if (actionType instanceof ActionType.Attack) {
            Sound sound;
            AssetManager pitch = this.am;
            AssetRef assetRef$iv = Asset.Sound.INSTANCE.getAttack1();
            boolean $i$f$get = false;
            try {
                void this_$iv;
                Object object = this_$iv.getAssets().get(assetRef$iv);
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type com.badlogic.gdx.audio.Sound");
                }
                sound = (Sound)object;
            }
            catch (Exception ex$iv) {
                Log.INSTANCE.critical("AssetRef " + assetRef$iv + " not loaded");
                throw ex$iv;
            }
            sound.play(GameFilesKt.getGameConfig().getVolumeEffect() * GameFilesKt.getGameConfig().getVolumeMaster(), Vector2Kt.lerp(Random.Default.nextFloat(), 0.8f, 1.2f), 0.0f);
        } else if (actionType instanceof ActionType.Dodge) {
            Sound sound;
            AssetManager this_$iv = this.am;
            AssetRef assetRef$iv = Asset.Sound.INSTANCE.getDodge();
            boolean $i$f$get = false;
            try {
                Object object = this_$iv.getAssets().get(assetRef$iv);
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type com.badlogic.gdx.audio.Sound");
                }
                sound = (Sound)object;
            }
            catch (Exception ex$iv) {
                Log.INSTANCE.critical("AssetRef " + assetRef$iv + " not loaded");
                throw ex$iv;
            }
            sound.play(GameFilesKt.getGameConfig().getVolumeEffect() * GameFilesKt.getGameConfig().getVolumeMaster(), Vector2Kt.lerp(Random.Default.nextFloat(), 0.7f, 0.8f), 0.0f);
            Body body2 = body;
            if (body2 != null) {
                DynamicBodyComponentKt.updateCollision(body2, CollisionGroup.INSTANCE.getPLAYER_DODGE());
            }
        } else if (actionType instanceof ActionType.Idle) {
            velocity.setSpeed(Vector2Kt.x(0.0f, 0.0f));
        }
        Log.INSTANCE.debug(Intrinsics.stringPlus((String)"New State: ", (Object)newAction));
    }
}

