/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.engine.ecs.component.camera;

import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.math.Vector2;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.veiset.kgame.engine.ecs.component.camera.CameraMovementI;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0006H\u00c6\u0003J'\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\u0010\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u0006H\u0016J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u0006X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\t\"\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000f\u00a8\u0006\u001f"}, d2={"Lorg/veiset/kgame/engine/ecs/component/camera/LinearCameraMove;", "Lorg/veiset/kgame/engine/ecs/component/camera/CameraMovementI;", "v1", "Lcom/badlogic/gdx/math/Vector2;", "v2", "duration", "", "(Lcom/badlogic/gdx/math/Vector2;Lcom/badlogic/gdx/math/Vector2;F)V", "getDuration", "()F", "elapsed", "getElapsed", "setElapsed", "(F)V", "getV1", "()Lcom/badlogic/gdx/math/Vector2;", "getV2", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "offset", "delta", "toString", "", "kgame2"})
public final class LinearCameraMove
implements CameraMovementI {
    @NotNull
    private final Vector2 v1;
    @NotNull
    private final Vector2 v2;
    private final float duration;
    private float elapsed;

    public LinearCameraMove(@NotNull Vector2 v1, @NotNull Vector2 v2, float duration2) {
        Intrinsics.checkNotNullParameter((Object)v1, (String)"v1");
        Intrinsics.checkNotNullParameter((Object)v2, (String)"v2");
        this.v1 = v1;
        this.v2 = v2;
        this.duration = duration2;
    }

    @NotNull
    public final Vector2 getV1() {
        return this.v1;
    }

    @NotNull
    public final Vector2 getV2() {
        return this.v2;
    }

    @Override
    public float getDuration() {
        return this.duration;
    }

    @Override
    public float getElapsed() {
        return this.elapsed;
    }

    @Override
    public void setElapsed(float f) {
        this.elapsed = f;
    }

    @Override
    @NotNull
    public Vector2 offset(float delta) {
        this.setElapsed(Math.min(this.getElapsed() + delta, this.getDuration()));
        Vector2 vector2 = new Vector2(this.v1.x, this.v1.y).interpolate(this.v2, this.getElapsed() / this.getDuration(), Interpolation.linear);
        Intrinsics.checkNotNullExpressionValue((Object)vector2, (String)"Vector2(v1.x, v1.y).inte\u2026on, Interpolation.linear)");
        return vector2;
    }

    @NotNull
    public final Vector2 component1() {
        return this.v1;
    }

    @NotNull
    public final Vector2 component2() {
        return this.v2;
    }

    public final float component3() {
        return this.getDuration();
    }

    @NotNull
    public final LinearCameraMove copy(@NotNull Vector2 v1, @NotNull Vector2 v2, float duration2) {
        Intrinsics.checkNotNullParameter((Object)v1, (String)"v1");
        Intrinsics.checkNotNullParameter((Object)v2, (String)"v2");
        return new LinearCameraMove(v1, v2, duration2);
    }

    public static /* synthetic */ LinearCameraMove copy$default(LinearCameraMove linearCameraMove, Vector2 vector2, Vector2 vector22, float f, int n, Object object) {
        if ((n & 1) != 0) {
            vector2 = linearCameraMove.v1;
        }
        if ((n & 2) != 0) {
            vector22 = linearCameraMove.v2;
        }
        if ((n & 4) != 0) {
            f = linearCameraMove.getDuration();
        }
        return linearCameraMove.copy(vector2, vector22, f);
    }

    @NotNull
    public String toString() {
        return "LinearCameraMove(v1=" + this.v1 + ", v2=" + this.v2 + ", duration=" + this.getDuration() + ')';
    }

    public int hashCode() {
        int result = this.v1.hashCode();
        result = result * 31 + this.v2.hashCode();
        result = result * 31 + Float.hashCode(this.getDuration());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof LinearCameraMove)) {
            return false;
        }
        LinearCameraMove linearCameraMove = (LinearCameraMove)other;
        if (!Intrinsics.areEqual((Object)this.v1, (Object)linearCameraMove.v1)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.v2, (Object)linearCameraMove.v2)) {
            return false;
        }
        return Intrinsics.areEqual((Object)Float.valueOf(this.getDuration()), (Object)Float.valueOf(linearCameraMove.getDuration()));
    }
}

