/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.engine.ecs.component.enemy;

import com.badlogic.ashley.core.Component;
import com.badlogic.ashley.core.Entity;
import com.badlogic.ashley.core.EntityListener;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.math.Vector2;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.veiset.kgame.engine.Log;
import org.veiset.kgame.engine.TBEngineKt;
import org.veiset.kgame.engine.asset.AssetManager;
import org.veiset.kgame.engine.asset.AssetRef;
import org.veiset.kgame.engine.ecs.component.draw.MonsterStatsLabelComponent;
import org.veiset.kgame.engine.ecs.component.enemy.ModifiersComponent;
import org.veiset.kgame.engine.ecs.component.enemy.MonsterComponent;
import org.veiset.kgame.engine.ecs.component.stats.HealthComponent;
import org.veiset.kgame.engine.ecs.system.MapperNullable;
import org.veiset.kgame.engine.math.Vector2Kt;
import org.veiset.kgame.engine.modifier.Modifier;
import org.veiset.kgame.engine.modifier.ModifierEngine;
import org.veiset.kgame.engine.util.FontUtilsKt;
import org.veiset.kgame.engine.values.Asset;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/veiset/kgame/engine/ecs/component/enemy/ModifiersComponentEvent;", "Lcom/badlogic/ashley/core/EntityListener;", "()V", "am", "Lorg/veiset/kgame/engine/asset/AssetManager;", "font", "Lcom/badlogic/gdx/graphics/g2d/BitmapFont;", "entityAdded", "", "entity", "Lcom/badlogic/ashley/core/Entity;", "entityRemoved", "kgame2"})
public final class ModifiersComponentEvent
implements EntityListener {
    @NotNull
    private final AssetManager am;
    @NotNull
    private final BitmapFont font;

    /*
     * WARNING - void declaration
     */
    public ModifiersComponentEvent() {
        BitmapFont bitmapFont;
        void assetRef$iv;
        AssetManager assetManager = this.am = TBEngineKt.getGlobals().getAssetManager();
        AssetRef assetRef = Asset.Font.INSTANCE.getRetron14();
        ModifiersComponentEvent modifiersComponentEvent = this;
        boolean $i$f$get = false;
        try {
            void this_$iv;
            Object object = this_$iv.getAssets().get(assetRef$iv);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.badlogic.gdx.graphics.g2d.BitmapFont");
            }
            bitmapFont = (BitmapFont)object;
        }
        catch (Exception ex$iv) {
            Log.INSTANCE.critical("AssetRef " + assetRef$iv + " not loaded");
            throw ex$iv;
        }
        modifiersComponentEvent.font = bitmapFont;
    }

    public void entityAdded(@NotNull Entity entity) {
        Vector2 textOffset;
        ModifiersComponent m;
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        ModifiersComponent modifiersComponent = m = (ModifiersComponent)MapperNullable.INSTANCE.getModifiers().get(entity);
        List<Modifier> modifiers = modifiersComponent == null ? null : modifiersComponent.getModifiers();
        ModifiersComponent modifiersComponent2 = m;
        Object object = textOffset = modifiersComponent2 == null ? null : modifiersComponent2.getTextOffset();
        if (modifiers == null || textOffset == null || modifiers.isEmpty()) {
            return;
        }
        HealthComponent healthComponent = (HealthComponent)MapperNullable.INSTANCE.getHealth().get(entity);
        if (healthComponent != null) {
            HealthComponent health = healthComponent;
            boolean bl = false;
            float newHp = ModifierEngine.INSTANCE.hp(modifiers, health.getMaxHealth());
            health.setCurrentHealth(newHp - (health.getMaxHealth() - health.getCurrentHealth()));
            health.setMaxHealth(newHp);
        }
        MonsterComponent monsterComponent = (MonsterComponent)MapperNullable.INSTANCE.getMonster().get(entity);
        if (monsterComponent != null) {
            MonsterComponent monster = monsterComponent;
            boolean bl = false;
            String text = "Healthy";
            float x = FontUtilsKt.sizeX(this.font, text) / 2.0f;
            Vector2 vector2 = Vector2Kt.minus(textOffset, Vector2Kt.x(x, 0.0f));
            Color color = Color.ORANGE;
            Intrinsics.checkNotNullExpressionValue((Object)color, (String)"ORANGE");
            entity.add((Component)new MonsterStatsLabelComponent(text, vector2, color, null, 0, 24, null));
        }
    }

    public void entityRemoved(@NotNull Entity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
    }
}

