/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.engine.ecs.entity.attack;

import com.badlogic.ashley.core.Entity;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.World;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.veiset.kgame.engine.Log;
import org.veiset.kgame.engine.TBEngineKt;
import org.veiset.kgame.engine.asset.AssetManager;
import org.veiset.kgame.engine.asset.AssetRef;
import org.veiset.kgame.engine.ecs.component.FixedDurationComponent;
import org.veiset.kgame.engine.ecs.component.PositionComponent;
import org.veiset.kgame.engine.ecs.component.attack.DamageComponent;
import org.veiset.kgame.engine.ecs.component.attack.ProjectileComponent;
import org.veiset.kgame.engine.ecs.component.draw.LightFollowComponent;
import org.veiset.kgame.engine.ecs.component.draw.ShadowComponent;
import org.veiset.kgame.engine.ecs.component.draw.SpriteGfxComponent;
import org.veiset.kgame.engine.ecs.component.physics.DynamicBodyComponent;
import org.veiset.kgame.engine.ecs.component.physics.VelocityComponent;
import org.veiset.kgame.engine.ecs.system.physics.CollisionGroup;
import org.veiset.kgame.engine.math.Vector2Kt;
import org.veiset.kgame.engine.values.Asset;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\b\u0012\b\b\u0002\u0010\n\u001a\u00020\b\u00a2\u0006\u0002\u0010\u000bR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lorg/veiset/kgame/engine/ecs/entity/attack/SimpleAttackEntity;", "Lcom/badlogic/ashley/core/Entity;", "world", "Lcom/badlogic/gdx/physics/box2d/World;", "startPosition", "Lcom/badlogic/gdx/math/Vector2;", "targetPosition", "duration", "", "damage", "speed", "(Lcom/badlogic/gdx/physics/box2d/World;Lcom/badlogic/gdx/math/Vector2;Lcom/badlogic/gdx/math/Vector2;FFF)V", "am", "Lorg/veiset/kgame/engine/asset/AssetManager;", "getAm", "()Lorg/veiset/kgame/engine/asset/AssetManager;", "size", "getSize", "()Lcom/badlogic/gdx/math/Vector2;", "kgame2"})
public final class SimpleAttackEntity
extends Entity {
    @NotNull
    private final Vector2 size;
    @NotNull
    private final AssetManager am;

    /*
     * WARNING - void declaration
     */
    public SimpleAttackEntity(@NotNull World world, @NotNull Vector2 startPosition, @NotNull Vector2 targetPosition, float duration2, float damage, float speed) {
        TextureRegion textureRegion;
        void assetRef$iv;
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)startPosition, (String)"startPosition");
        Intrinsics.checkNotNullParameter((Object)targetPosition, (String)"targetPosition");
        this.size = Vector2Kt.x(0.1f, 0.1f);
        this.am = TBEngineKt.getGlobals().getAssetManager();
        this.add(new DynamicBodyComponent(world, this, this.size, startPosition, CollisionGroup.INSTANCE.getNO_PLAYER_COLLISION(), 0.0f, 32, null));
        this.add(new PositionComponent(startPosition));
        this.add(new LightFollowComponent(10, new Color(0.1f, 0.1f, 0.2f, 0.1f), 0.5f, 0.0f, null, 24, null));
        Object object = Vector2Kt.minus(targetPosition, startPosition).nor().scl(speed);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"targetPosition - startPosition).nor().scl(speed)");
        this.add(new VelocityComponent((Vector2)object));
        this.add(new ProjectileComponent());
        this.add(new FixedDurationComponent(duration2));
        object = this.am;
        AssetRef assetRef = Asset.Texture.INSTANCE.getAttackBall();
        SimpleAttackEntity simpleAttackEntity = this;
        boolean $i$f$get = false;
        try {
            void this_$iv;
            Object object2 = this_$iv.getAssets().get(assetRef$iv);
            if (object2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.badlogic.gdx.graphics.g2d.TextureRegion");
            }
            textureRegion = (TextureRegion)object2;
        }
        catch (Exception ex$iv) {
            Log.INSTANCE.critical("AssetRef " + assetRef$iv + " not loaded");
            throw ex$iv;
        }
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n = 28;
        float f = 0.0f;
        float f2 = 0.0f;
        int n2 = 0;
        Vector2 vector2 = Vector2Kt.x(0.1f, 0.1f);
        TextureRegion textureRegion2 = textureRegion;
        simpleAttackEntity.add(new SpriteGfxComponent(textureRegion2, vector2, n2, f2, f, n, defaultConstructorMarker));
        object = Vector2Kt.x(0.0f, -0.2f);
        this.add(new ShadowComponent(0.1f, (Vector2)object, null, 0.0f, true, 12, null));
        this.add(new DamageComponent(damage));
    }

    public /* synthetic */ SimpleAttackEntity(World world, Vector2 vector2, Vector2 vector22, float f, float f2, float f3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            f2 = 35.0f;
        }
        if ((n & 0x20) != 0) {
            f3 = 5.0f;
        }
        this(world, vector2, vector22, f, f2, f3);
    }

    @NotNull
    public final Vector2 getSize() {
        return this.size;
    }

    @NotNull
    public final AssetManager getAm() {
        return this.am;
    }
}

