/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.engine.ecs.event;

import box2dLight.PointLight;
import box2dLight.RayHandler;
import com.badlogic.ashley.core.Entity;
import com.badlogic.ashley.core.EntityListener;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.veiset.kgame.engine.ecs.component.draw.LightFollowComponent;
import org.veiset.kgame.engine.ecs.component.draw.LightStaticComponent;
import org.veiset.kgame.engine.ecs.component.physics.DynamicBodyComponent;
import org.veiset.kgame.engine.ecs.system.Mapper;
import org.veiset.kgame.engine.ecs.system.physics.CollisionGroup;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/veiset/kgame/engine/ecs/event/LightListener;", "Lcom/badlogic/ashley/core/EntityListener;", "rayHandler", "Lbox2dLight/RayHandler;", "(Lbox2dLight/RayHandler;)V", "lights", "", "", "Lbox2dLight/PointLight;", "entityAdded", "", "entity", "Lcom/badlogic/ashley/core/Entity;", "entityRemoved", "kgame2"})
public final class LightListener
implements EntityListener {
    @NotNull
    private final RayHandler rayHandler;
    @NotNull
    private final Map<Integer, PointLight> lights;

    public LightListener(@NotNull RayHandler rayHandler) {
        Intrinsics.checkNotNullParameter((Object)rayHandler, (String)"rayHandler");
        this.rayHandler = rayHandler;
        this.lights = new LinkedHashMap();
    }

    public void entityAdded(@NotNull Entity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        LightFollowComponent lightFollow = (LightFollowComponent)Mapper.INSTANCE.getLightFollow().get(entity);
        LightStaticComponent lightStatic = (LightStaticComponent)Mapper.INSTANCE.getLightStatic().get(entity);
        DynamicBodyComponent body = (DynamicBodyComponent)Mapper.INSTANCE.getDynamicBody().get(entity);
        if (lightFollow != null && body != null) {
            PointLight light = new PointLight(this.rayHandler, lightFollow.getRays(), lightFollow.getColor(), lightFollow.getDistance(), 0.0f, 0.0f);
            Map<Integer, PointLight> map = this.lights;
            Integer n = entity.hashCode();
            map.put(n, light);
            light.setSoftnessLength(lightFollow.getSoftnessLength());
            light.setXray(true);
            light.attachToBody(body.getBody());
            light.setContactFilter(CollisionGroup.INSTANCE.getENVIRONMENT_AND_MONSTERS());
        } else if (lightStatic != null) {
            PointLight light = new PointLight(this.rayHandler, lightStatic.getRays(), lightStatic.getColor(), lightStatic.getDistance(), lightStatic.getPos().x, lightStatic.getPos().y);
            Map<Integer, PointLight> map = this.lights;
            Integer n = entity.hashCode();
            map.put(n, light);
            light.setSoftnessLength(lightStatic.getSoftnessLength());
            light.setXray(true);
            light.setContactFilter(CollisionGroup.INSTANCE.getENVIRONMENT_AND_MONSTERS());
        }
    }

    public void entityRemoved(@NotNull Entity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        PointLight pointLight = this.lights.get(entity.hashCode());
        if (pointLight != null) {
            pointLight.remove();
        }
        this.lights.remove(entity.hashCode());
    }
}

