/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.engine.ecs.system.ai;

import com.badlogic.ashley.core.Engine;
import com.badlogic.ashley.core.Entity;
import com.badlogic.ashley.core.EntitySystem;
import com.badlogic.ashley.core.Family;
import com.badlogic.ashley.utils.ImmutableArray;
import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.math.Vector2;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.veiset.kgame.engine.EngineConfig;
import org.veiset.kgame.engine.ecs.component.PositionComponent;
import org.veiset.kgame.engine.ecs.component.ai.LinearMoveAIComponent;
import org.veiset.kgame.engine.ecs.component.physics.VelocityComponent;
import org.veiset.kgame.engine.ecs.component.player.PlayerCharacterComponent;
import org.veiset.kgame.engine.ecs.system.Mapper;
import org.veiset.kgame.engine.ecs.system.ai.LinearMovementAISystemKt;
import org.veiset.kgame.engine.ecs.system.debug.ProfilerSystemKt;
import org.veiset.kgame.engine.math.Vector2Kt;
import org.veiset.kgame.engine.util.RunEveryN;
import org.veiset.kgame.engine.values.ProfilerName;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002J\u0010\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/veiset/kgame/engine/ecs/system/ai/LinearMovementAISystem;", "Lcom/badlogic/ashley/core/EntitySystem;", "()V", "aiAgents", "Lcom/badlogic/ashley/utils/ImmutableArray;", "Lcom/badlogic/ashley/core/Entity;", "aiTargets", "updateN", "Lorg/veiset/kgame/engine/util/RunEveryN;", "addedToEngine", "", "engine", "Lcom/badlogic/ashley/core/Engine;", "drawPath", "targetPos", "Lcom/badlogic/gdx/math/Vector2;", "position", "logic", "deltaTime", "", "update", "kgame2"})
public final class LinearMovementAISystem
extends EntitySystem {
    private ImmutableArray<Entity> aiTargets;
    private ImmutableArray<Entity> aiAgents;
    @NotNull
    private final RunEveryN updateN = new RunEveryN(5);

    public void addedToEngine(@NotNull Engine engine) {
        Intrinsics.checkNotNullParameter((Object)engine, (String)"engine");
        Class[] classArray = new Class[]{PlayerCharacterComponent.class, PositionComponent.class};
        ImmutableArray immutableArray = engine.getEntitiesFor(Family.all((Class[])classArray).get());
        Intrinsics.checkNotNullExpressionValue((Object)immutableArray, (String)"engine.getEntitiesFor(Fa\u2026onent::class.java).get())");
        this.aiTargets = immutableArray;
        classArray = new Class[]{PositionComponent.class, VelocityComponent.class, LinearMoveAIComponent.class};
        immutableArray = engine.getEntitiesFor(Family.all((Class[])classArray).get());
        Intrinsics.checkNotNullExpressionValue((Object)immutableArray, (String)"engine.getEntitiesFor(Fa\u2026onent::class.java).get())");
        this.aiAgents = immutableArray;
    }

    public void update(float deltaTime) {
        Engine engine = this.getEngine();
        Intrinsics.checkNotNullExpressionValue((Object)engine, (String)"engine");
        ProfilerSystemKt.profile(engine, ProfilerName.PATHFINDING, (Function0)new Function0<Unit>(this, deltaTime){
            final /* synthetic */ LinearMovementAISystem this$0;
            final /* synthetic */ float $deltaTime;
            {
                this.this$0 = $receiver;
                this.$deltaTime = $deltaTime;
                super(0);
            }

            public final void invoke() {
                LinearMovementAISystem.access$getUpdateN$p(this.this$0).update(this.$deltaTime, (Function1<? super Float, Unit>)((Function1)new Function1<Float, Unit>(this.this$0){
                    final /* synthetic */ LinearMovementAISystem this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(float it) {
                        LinearMovementAISystem.access$logic(this.this$0, it);
                    }
                }));
            }
        });
    }

    private final void logic(float deltaTime) {
        ImmutableArray<Entity> immutableArray = this.aiTargets;
        if (immutableArray == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"aiTargets");
            immutableArray = null;
        }
        Entity entity = (Entity)CollectionsKt.firstOrNull((Iterable)((Iterable)immutableArray));
        if (entity == null) {
            return;
        }
        Entity aiTarget = entity;
        Vector2 targetPos = ((PositionComponent)Mapper.INSTANCE.getPosition().get(aiTarget)).getPos();
        ImmutableArray<Entity> immutableArray2 = this.aiAgents;
        if (immutableArray2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"aiAgents");
            immutableArray2 = null;
        }
        Iterable $this$forEach$iv = (Iterable)immutableArray2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Entity entity2 = (Entity)element$iv;
            boolean bl = false;
            Vector2 position = ((PositionComponent)Mapper.INSTANCE.getPosition().get(entity2)).getPos();
            LinearMoveAIComponent ai = (LinearMoveAIComponent)Mapper.INSTANCE.getLinearMoveAI().get(entity2);
            VelocityComponent velocity = (VelocityComponent)Mapper.INSTANCE.getVelocity().get(entity2);
            if (ai.getTargetType().inRange(position, targetPos, (Camera)LinearMovementAISystemKt.access$getCamera$p())) {
                if (EngineConfig.Debug.INSTANCE.getDRAW_PATHFINDING_PATH()) {
                    this.drawPath(targetPos, position);
                }
                if (ai.getSpeed()) {
                    Vector2 speed = Vector2Kt.minus(targetPos, position).nor().scl(ai.getMaxSpeed());
                    ai.setSpeedup(ai.getSpeedup() + Math.max(0.1f * deltaTime, ai.getMaxSpeed() * 5.0f));
                    Vector2 vector2 = speed.scl(1.0f + ai.getSpeedup());
                    Intrinsics.checkNotNullExpressionValue((Object)vector2, (String)"speed.scl(1 + ai.speedup)");
                    velocity.setSpeed(vector2);
                    continue;
                }
                Vector2 vector2 = Vector2Kt.minus(targetPos, position).nor().scl(ai.getMaxSpeed());
                Intrinsics.checkNotNullExpressionValue((Object)vector2, (String)"targetPos - position).nor().scl(ai.maxSpeed)");
                velocity.setSpeed(vector2);
                continue;
            }
            velocity.setSpeed(Vector2Kt.x(0.0f, 0.0f));
        }
    }

    private final void drawPath(Vector2 targetPos, Vector2 position) {
        LinearMovementAISystemKt.access$getShapeRenderer$p().begin(ShapeRenderer.ShapeType.Line);
        LinearMovementAISystemKt.access$getShapeRenderer$p().setColor(Color.BLUE);
        LinearMovementAISystemKt.access$getShapeRenderer$p().line(Vector2Kt.dw(targetPos), Vector2Kt.dw(position));
        LinearMovementAISystemKt.access$getShapeRenderer$p().end();
    }

    public static final /* synthetic */ RunEveryN access$getUpdateN$p(LinearMovementAISystem $this) {
        return $this.updateN;
    }

    public static final /* synthetic */ void access$logic(LinearMovementAISystem $this, float deltaTime) {
        $this.logic(deltaTime);
    }
}

