/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.engine.ecs.system.attack;

import com.badlogic.ashley.core.Engine;
import com.badlogic.ashley.core.Entity;
import com.badlogic.ashley.core.EntitySystem;
import com.badlogic.ashley.core.Family;
import com.badlogic.ashley.utils.ImmutableArray;
import com.badlogic.gdx.audio.Sound;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.World;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import org.jetbrains.annotations.NotNull;
import org.veiset.kgame.engine.GameFilesKt;
import org.veiset.kgame.engine.Log;
import org.veiset.kgame.engine.TBEngineKt;
import org.veiset.kgame.engine.asset.AssetManager;
import org.veiset.kgame.engine.asset.AssetRef;
import org.veiset.kgame.engine.ecs.component.PositionComponent;
import org.veiset.kgame.engine.ecs.component.attack.AttackPlayerComponent;
import org.veiset.kgame.engine.ecs.component.attack.AttackType;
import org.veiset.kgame.engine.ecs.component.attack.AttackTypeComponent;
import org.veiset.kgame.engine.ecs.component.camera.CameraShake;
import org.veiset.kgame.engine.ecs.component.player.PlayerCharacterComponent;
import org.veiset.kgame.engine.ecs.component.stats.HealthComponent;
import org.veiset.kgame.engine.ecs.entity.attack.MovingFireAttackEntity;
import org.veiset.kgame.engine.ecs.entity.attack.PoisonCloudAttackEntity;
import org.veiset.kgame.engine.ecs.entity.attack.SelfExplodeAttackEntity;
import org.veiset.kgame.engine.ecs.entity.camera.CameraMoveEntity;
import org.veiset.kgame.engine.ecs.system.Mapper;
import org.veiset.kgame.engine.ecs.system.MapperNullable;
import org.veiset.kgame.engine.ecs.system.debug.ProfilerSystemKt;
import org.veiset.kgame.engine.math.Vector2Kt;
import org.veiset.kgame.engine.util.RunEveryN;
import org.veiset.kgame.engine.values.Asset;
import org.veiset.kgame.engine.values.ProfilerName;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/veiset/kgame/engine/ecs/system/attack/AttackPlayerSystem;", "Lcom/badlogic/ashley/core/EntitySystem;", "world", "Lcom/badlogic/gdx/physics/box2d/World;", "(Lcom/badlogic/gdx/physics/box2d/World;)V", "am", "Lorg/veiset/kgame/engine/asset/AssetManager;", "attackingEnemies", "Lcom/badlogic/ashley/utils/ImmutableArray;", "Lcom/badlogic/ashley/core/Entity;", "players", "updateN", "Lorg/veiset/kgame/engine/util/RunEveryN;", "addedToEngine", "", "engine", "Lcom/badlogic/ashley/core/Engine;", "logic", "delta", "", "update", "kgame2"})
public final class AttackPlayerSystem
extends EntitySystem {
    @NotNull
    private final World world;
    @NotNull
    private final AssetManager am;
    private ImmutableArray<Entity> players;
    private ImmutableArray<Entity> attackingEnemies;
    @NotNull
    private final RunEveryN updateN;

    public AttackPlayerSystem(@NotNull World world) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        this.world = world;
        this.am = TBEngineKt.getGlobals().getAssetManager();
        this.updateN = new RunEveryN(3);
    }

    public void addedToEngine(@NotNull Engine engine) {
        Intrinsics.checkNotNullParameter((Object)engine, (String)"engine");
        Class[] classArray = new Class[]{PlayerCharacterComponent.class};
        ImmutableArray immutableArray = engine.getEntitiesFor(Family.one((Class[])classArray).get());
        Intrinsics.checkNotNullExpressionValue((Object)immutableArray, (String)"engine.getEntitiesFor(Fa\u2026onent::class.java).get())");
        this.players = immutableArray;
        classArray = new Class[]{AttackPlayerComponent.class, AttackTypeComponent.class, PositionComponent.class};
        immutableArray = engine.getEntitiesFor(Family.all((Class[])classArray).get());
        Intrinsics.checkNotNullExpressionValue((Object)immutableArray, (String)"engine.getEntitiesFor(Fa\u2026onent::class.java).get())");
        this.attackingEnemies = immutableArray;
    }

    public void update(float delta) {
        Engine engine = this.getEngine();
        Intrinsics.checkNotNullExpressionValue((Object)engine, (String)"engine");
        ProfilerSystemKt.profile(engine, ProfilerName.ATTACKING, (Function0)new Function0<Unit>(this, delta){
            final /* synthetic */ AttackPlayerSystem this$0;
            final /* synthetic */ float $delta;
            {
                this.this$0 = $receiver;
                this.$delta = $delta;
                super(0);
            }

            public final void invoke() {
                AttackPlayerSystem.access$getUpdateN$p(this.this$0).update(this.$delta, (Function1<? super Float, Unit>)((Function1)new Function1<Float, Unit>(this.this$0){
                    final /* synthetic */ AttackPlayerSystem this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(float deltaTime) {
                        AttackPlayerSystem.access$logic(this.this$0, deltaTime);
                    }
                }));
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final void logic(float delta) {
        ImmutableArray<Entity> immutableArray = this.players;
        if (immutableArray == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"players");
            immutableArray = null;
        }
        Entity entity = (Entity)CollectionsKt.firstOrNull((Iterable)((Iterable)immutableArray));
        if (entity == null) {
            return;
        }
        Entity player = entity;
        Vector2 playerPos = ((PositionComponent)Mapper.INSTANCE.getPosition().get(player)).getPos();
        ImmutableArray<Entity> immutableArray2 = this.attackingEnemies;
        if (immutableArray2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"attackingEnemies");
            immutableArray2 = null;
        }
        Iterable $this$forEach$iv = (Iterable)immutableArray2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Entity entity2 = (Entity)element$iv;
            boolean bl = false;
            Vector2 pos = ((PositionComponent)Mapper.INSTANCE.getPosition().get(entity2)).getPos();
            AttackPlayerComponent attackPlayer = (AttackPlayerComponent)Mapper.INSTANCE.getAttackPlayer().get(entity2);
            AttackTypeComponent attackType = (AttackTypeComponent)Mapper.INSTANCE.getAttackType().get(entity2);
            if (attackPlayer.getCurrentCooldown() <= 0.0f && pos.dst(playerPos) <= attackPlayer.getRange()) {
                attackPlayer.setCurrentCooldown(attackPlayer.getCooldown());
                if (attackType.getAttackType() instanceof AttackType.SelfExplode) {
                    Sound sound;
                    float size = ((AttackType.SelfExplode)attackType.getAttackType()).getSize();
                    HealthComponent enemyHealth = (HealthComponent)MapperNullable.INSTANCE.getHealth().get(entity2);
                    if (enemyHealth != null) {
                        enemyHealth.setCurrentHealth(enemyHealth.getCurrentHealth() - 35.0f);
                    }
                    AssetManager assetManager = this.am;
                    AssetRef assetRef$iv = Asset.Sound.INSTANCE.getExplosion();
                    boolean $i$f$get = false;
                    try {
                        void this_$iv;
                        Object object = this_$iv.getAssets().get(assetRef$iv);
                        if (object == null) {
                            throw new NullPointerException("null cannot be cast to non-null type com.badlogic.gdx.audio.Sound");
                        }
                        sound = (Sound)object;
                    }
                    catch (Exception ex$iv) {
                        Log.INSTANCE.critical("AssetRef " + assetRef$iv + " not loaded");
                        throw ex$iv;
                    }
                    sound.play(GameFilesKt.getGameConfig().getVolumeEffect() * GameFilesKt.getGameConfig().getVolumeMaster(), Vector2Kt.lerp(Random.Default.nextFloat(), 0.7f, 0.8f), 0.0f);
                    this.getEngine().addEntity((Entity)new SelfExplodeAttackEntity(this.world, Vector2Kt.copy(pos), size));
                    this.getEngine().addEntity((Entity)new CameraMoveEntity(new CameraShake(Vector2Kt.x(0.5f - Random.Default.nextFloat(), 0.5f - Random.Default.nextFloat()), 0.4f + size / 10.0f, 0.1f)));
                } else if (attackType.getAttackType() instanceof AttackType.FireAttack) {
                    Vector2 speed = Vector2Kt.minus(playerPos, pos).nor().scl(2.5f);
                    Engine engine = this.getEngine();
                    Vector2 vector2 = Vector2Kt.copy(pos);
                    Intrinsics.checkNotNullExpressionValue((Object)speed, (String)"speed");
                    engine.addEntity((Entity)new MovingFireAttackEntity(this.world, vector2, Vector2Kt.copy(speed), 0.0f, 8, null));
                } else if (attackType.getAttackType() instanceof AttackType.PoisonCloud) {
                    this.getEngine().addEntity((Entity)new PoisonCloudAttackEntity(this.world, Vector2Kt.copy(pos), ((AttackType.PoisonCloud)attackType.getAttackType()).getSize()));
                }
            }
            attackPlayer.setCurrentCooldown(attackPlayer.getCurrentCooldown() - delta);
        }
    }

    public static final /* synthetic */ RunEveryN access$getUpdateN$p(AttackPlayerSystem $this) {
        return $this.updateN;
    }

    public static final /* synthetic */ void access$logic(AttackPlayerSystem $this, float delta) {
        $this.logic(delta);
    }
}

