/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.engine.ecs.system.debug;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.math.Vector2;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.veiset.kgame.engine.TBEngineKt;
import org.veiset.kgame.engine.input.MouseKt;
import org.veiset.kgame.engine.math.Vector2Kt;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\r\u001a\u00020\u000e\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"camera", "Lcom/badlogic/gdx/graphics/OrthographicCamera;", "shapeRenderer", "Lcom/badlogic/gdx/graphics/glutils/ShapeRenderer;", "spriteBatch", "Lcom/badlogic/gdx/graphics/g2d/SpriteBatch;", "uiShapeRenderer", "uiSpriteBatch", "debugDrawMouseline", "", "playerPos", "Lcom/badlogic/gdx/math/Vector2;", "pos2", "textFont", "Lcom/badlogic/gdx/graphics/g2d/BitmapFont;", "kgame2"})
public final class DebugControlSystemKt {
    @NotNull
    private static final OrthographicCamera camera = TBEngineKt.getGlobals().getDrawGfx().getCamera();
    @NotNull
    private static final ShapeRenderer shapeRenderer = TBEngineKt.getGlobals().getDrawGfx().getShapeRenderer();
    @NotNull
    private static final SpriteBatch spriteBatch = TBEngineKt.getGlobals().getDrawGfx().getSpriteBatch();
    @NotNull
    private static final ShapeRenderer uiShapeRenderer = TBEngineKt.getGlobals().getDrawUi().getShapeRenderer();
    @NotNull
    private static final SpriteBatch uiSpriteBatch = TBEngineKt.getGlobals().getDrawUi().getSpriteBatch();

    public static final void debugDrawMouseline(@NotNull Vector2 playerPos, @Nullable Vector2 pos2, @NotNull BitmapFont textFont) {
        Intrinsics.checkNotNullParameter((Object)playerPos, (String)"playerPos");
        Intrinsics.checkNotNullParameter((Object)textFont, (String)"textFont");
        shapeRenderer.begin(ShapeRenderer.ShapeType.Line);
        shapeRenderer.setColor(Color.ORANGE);
        shapeRenderer.line(Vector2Kt.dw(playerPos), Vector2Kt.dw(MouseKt.scaledPointer()));
        if (pos2 != null) {
            shapeRenderer.setColor(Color.TEAL);
            shapeRenderer.line(Vector2Kt.dw(playerPos), Vector2Kt.dw(pos2));
        }
        shapeRenderer.end();
        if (pos2 != null) {
            float x = Vector2Kt.component1(pos2);
            float y = Vector2Kt.component2(pos2);
            spriteBatch.begin();
            textFont.draw((Batch)spriteBatch, (CharSequence)("" + '(' + x + ", " + y + ')'), x * 120.0f, y * 120.0f);
            textFont.draw((Batch)spriteBatch, (CharSequence)("" + '(' + x * 120.0f + ", " + y * 120.0f + ')'), x * 120.0f, y * 120.0f - 22.0f);
            spriteBatch.end();
        }
    }

    public static final /* synthetic */ OrthographicCamera access$getCamera$p() {
        return camera;
    }

    public static final /* synthetic */ ShapeRenderer access$getShapeRenderer$p() {
        return shapeRenderer;
    }

    public static final /* synthetic */ ShapeRenderer access$getUiShapeRenderer$p() {
        return uiShapeRenderer;
    }

    public static final /* synthetic */ SpriteBatch access$getUiSpriteBatch$p() {
        return uiSpriteBatch;
    }
}

