/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.engine.ecs.system.enemy;

import com.badlogic.ashley.core.Component;
import com.badlogic.ashley.core.Engine;
import com.badlogic.ashley.core.Entity;
import com.badlogic.ashley.core.EntitySystem;
import com.badlogic.ashley.core.Family;
import com.badlogic.ashley.utils.ImmutableArray;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.math.Vector2;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.veiset.kgame.engine.Log;
import org.veiset.kgame.engine.TBEngineKt;
import org.veiset.kgame.engine.asset.AssetManager;
import org.veiset.kgame.engine.asset.AssetRef;
import org.veiset.kgame.engine.ecs.component.PositionComponent;
import org.veiset.kgame.engine.ecs.component.enemy.ArrowMarkerComponent;
import org.veiset.kgame.engine.ecs.component.enemy.MonsterComponent;
import org.veiset.kgame.engine.ecs.component.player.PlayerCharacterComponent;
import org.veiset.kgame.engine.ecs.entity.WorldPortalEntity;
import org.veiset.kgame.engine.ecs.system.Mapper;
import org.veiset.kgame.engine.ecs.system.MapperNullable;
import org.veiset.kgame.engine.math.Vector2Kt;
import org.veiset.kgame.engine.util.FontUtilsKt;
import org.veiset.kgame.engine.values.Asset;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0006\u0010\u001f\u001a\u00020\u001cJ\u0010\u0010 \u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\u0010H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0015\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0016\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001a\u00a8\u0006\""}, d2={"Lorg/veiset/kgame/engine/ecs/system/enemy/EnemyRemindingSystem;", "Lcom/badlogic/ashley/core/EntitySystem;", "()V", "am", "Lorg/veiset/kgame/engine/asset/AssetManager;", "cleared", "", "getCleared", "()Z", "setCleared", "(Z)V", "enemies", "Lcom/badlogic/ashley/utils/ImmutableArray;", "Lcom/badlogic/ashley/core/Entity;", "players", "score", "", "getScore", "()Ljava/lang/Float;", "setScore", "(Ljava/lang/Float;)V", "Ljava/lang/Float;", "time", "getTime", "()F", "setTime", "(F)V", "addedToEngine", "", "engine", "Lcom/badlogic/ashley/core/Engine;", "draw", "update", "deltaTime", "kgame2"})
public final class EnemyRemindingSystem
extends EntitySystem {
    @NotNull
    private final AssetManager am = TBEngineKt.getGlobals().getAssetManager();
    private ImmutableArray<Entity> enemies;
    private ImmutableArray<Entity> players;
    private float time;
    @Nullable
    private Float score;
    private boolean cleared;

    public void addedToEngine(@NotNull Engine engine) {
        Intrinsics.checkNotNullParameter((Object)engine, (String)"engine");
        Class[] classArray = new Class[]{MonsterComponent.class};
        ImmutableArray immutableArray = engine.getEntitiesFor(Family.all((Class[])classArray).get());
        Intrinsics.checkNotNullExpressionValue((Object)immutableArray, (String)"engine.getEntitiesFor(Fa\u2026onent::class.java).get())");
        this.enemies = immutableArray;
        classArray = new Class[]{PlayerCharacterComponent.class, PositionComponent.class};
        immutableArray = engine.getEntitiesFor(Family.all((Class[])classArray).get());
        Intrinsics.checkNotNullExpressionValue((Object)immutableArray, (String)"engine.getEntitiesFor(Fa\u2026onent::class.java).get())");
        this.players = immutableArray;
    }

    public final float getTime() {
        return this.time;
    }

    public final void setTime(float f) {
        this.time = f;
    }

    @Nullable
    public final Float getScore() {
        return this.score;
    }

    public final void setScore(@Nullable Float f) {
        this.score = f;
    }

    public final boolean getCleared() {
        return this.cleared;
    }

    public final void setCleared(boolean bl) {
        this.cleared = bl;
    }

    public void update(float deltaTime) {
        ImmutableArray<Entity> immutableArray;
        this.time += deltaTime;
        ImmutableArray<Entity> immutableArray2 = this.players;
        if (immutableArray2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"players");
            immutableArray2 = null;
        }
        Entity entity = (Entity)CollectionsKt.firstOrNull((Iterable)((Iterable)immutableArray2));
        if (entity == null) {
            return;
        }
        Entity player = entity;
        ImmutableArray<Entity> immutableArray3 = this.enemies;
        if (immutableArray3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"enemies");
            immutableArray3 = null;
        }
        if (immutableArray3.size() <= 3) {
            ImmutableArray<Entity> immutableArray4 = this.enemies;
            if (immutableArray4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"enemies");
                immutableArray4 = null;
            }
            Iterable $this$forEach$iv = (Iterable)immutableArray4;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Entity it = (Entity)element$iv;
                boolean bl = false;
                if (MapperNullable.INSTANCE.getArrowMarker().get(it) != null) continue;
                Color color = Color.RED;
                Intrinsics.checkNotNullExpressionValue((Object)color, (String)"RED");
                it.add((Component)new ArrowMarkerComponent(color, 0.7f));
            }
        }
        if (!this.cleared) {
            ImmutableArray<Entity> immutableArray5 = this.enemies;
            if (immutableArray5 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"enemies");
                immutableArray5 = null;
            }
            if (immutableArray5.size() == 0) {
                this.cleared = true;
                this.getEngine().addEntity((Entity)new WorldPortalEntity(Vector2Kt.plus(Vector2Kt.copy(((PositionComponent)Mapper.INSTANCE.getPosition().get(player)).getPos()), new Vector2(0.0f, 2.0f))));
            }
        }
        if ((immutableArray = this.enemies) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"enemies");
            immutableArray = null;
        }
        if (immutableArray.size() == 0 && this.time >= 1.0f) {
            if (this.score == null) {
                this.score = Float.valueOf(this.time);
            }
            this.draw();
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void draw() {
        int n;
        BitmapFont bitmapFont;
        AssetManager assetManager = this.am;
        AssetRef assetRef$iv = Asset.Font.INSTANCE.getRetron46();
        boolean $i$f$get = false;
        try {
            void this_$iv;
            Object object = this_$iv.getAssets().get(assetRef$iv);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.badlogic.gdx.graphics.g2d.BitmapFont");
            }
            bitmapFont = (BitmapFont)object;
        }
        catch (Exception ex$iv) {
            Log.INSTANCE.critical("AssetRef " + assetRef$iv + " not loaded");
            throw ex$iv;
        }
        BitmapFont font = bitmapFont;
        SpriteBatch sb = TBEngineKt.getGlobals().getDrawUi().getSpriteBatch();
        Float f = this.score;
        String text = "Level cleared! Score: " + Math.max(100 - (f == null ? 0 : (n = (int)f.floatValue())), 0) + " - [R] to restart";
        Vector2 textpos = FontUtilsKt.middle(font, text);
        sb.begin();
        font.draw((Batch)sb, (CharSequence)text, textpos.x * 120.0f, (textpos.y - 1.0f) * 120.0f);
        sb.end();
    }
}

