/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.engine.ecs.system.graphics;

import com.badlogic.ashley.core.Engine;
import com.badlogic.ashley.core.Entity;
import com.badlogic.ashley.core.EntitySystem;
import com.badlogic.ashley.core.Family;
import com.badlogic.ashley.utils.ImmutableArray;
import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11;
import org.veiset.kgame.engine.ecs.component.PositionComponent;
import org.veiset.kgame.engine.ecs.component.draw.AnimationGfxComponent;
import org.veiset.kgame.engine.ecs.component.draw.BackgroundGfxComponent;
import org.veiset.kgame.engine.ecs.component.draw.DynamicAnimationComponent;
import org.veiset.kgame.engine.ecs.component.draw.MonsterStatsLabelComponent;
import org.veiset.kgame.engine.ecs.component.draw.ShadowComponent;
import org.veiset.kgame.engine.ecs.component.draw.ShapeCircleGfxComponent;
import org.veiset.kgame.engine.ecs.component.draw.ShapeGfxComponent;
import org.veiset.kgame.engine.ecs.component.draw.SpriteGfxComponent;
import org.veiset.kgame.engine.ecs.component.draw.TextLabelComponent;
import org.veiset.kgame.engine.ecs.component.stats.HealthBarComponent;
import org.veiset.kgame.engine.ecs.component.stats.HealthComponent;
import org.veiset.kgame.engine.ecs.system.GamePauseSystem;
import org.veiset.kgame.engine.ecs.system.Mapper;
import org.veiset.kgame.engine.ecs.system.debug.ProfilerSystemKt;
import org.veiset.kgame.engine.ecs.system.graphics.DrawInstruction;
import org.veiset.kgame.engine.ecs.system.graphics.DrawSystem;
import org.veiset.kgame.engine.ecs.system.graphics.DrawSystemKt;
import org.veiset.kgame.engine.math.Vector2Kt;
import org.veiset.kgame.engine.values.ProfilerName;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0011\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u000e\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0018J\u0010\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0018\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00070\u001b*\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/veiset/kgame/engine/ecs/system/graphics/DrawSystem;", "Lcom/badlogic/ashley/core/EntitySystem;", "gamePauseSystem", "Lorg/veiset/kgame/engine/ecs/system/GamePauseSystem;", "(Lorg/veiset/kgame/engine/ecs/system/GamePauseSystem;)V", "animations", "Lcom/badlogic/ashley/utils/ImmutableArray;", "Lcom/badlogic/ashley/core/Entity;", "circleShapes", "dynamicAnimations", "getGamePauseSystem", "()Lorg/veiset/kgame/engine/ecs/system/GamePauseSystem;", "healthBars", "shadows", "shapes", "sprites", "statsLabels", "textLabels", "addedToEngine", "", "engine", "Lcom/badlogic/ashley/core/Engine;", "draw", "deltaTime", "", "update", "removeOutsideScreen", "Lkotlin/sequences/Sequence;", "kgame2"})
public final class DrawSystem
extends EntitySystem {
    @Nullable
    private final GamePauseSystem gamePauseSystem;
    private ImmutableArray<Entity> sprites;
    private ImmutableArray<Entity> shapes;
    private ImmutableArray<Entity> circleShapes;
    private ImmutableArray<Entity> healthBars;
    private ImmutableArray<Entity> textLabels;
    private ImmutableArray<Entity> statsLabels;
    private ImmutableArray<Entity> animations;
    private ImmutableArray<Entity> shadows;
    private ImmutableArray<Entity> dynamicAnimations;

    public DrawSystem(@Nullable GamePauseSystem gamePauseSystem) {
        this.gamePauseSystem = gamePauseSystem;
    }

    public /* synthetic */ DrawSystem(GamePauseSystem gamePauseSystem, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            gamePauseSystem = null;
        }
        this(gamePauseSystem);
    }

    @Nullable
    public final GamePauseSystem getGamePauseSystem() {
        return this.gamePauseSystem;
    }

    public void addedToEngine(@NotNull Engine engine) {
        Intrinsics.checkNotNullParameter((Object)engine, (String)"engine");
        Class[] classArray = new Class[]{SpriteGfxComponent.class, PositionComponent.class};
        Family.Builder builder = Family.all((Class[])classArray);
        classArray = new Class[]{BackgroundGfxComponent.class};
        ImmutableArray immutableArray = engine.getEntitiesFor(builder.exclude(classArray).get());
        Intrinsics.checkNotNullExpressionValue((Object)immutableArray, (String)"engine.getEntitiesFor(\n \u2026java).get()\n            )");
        this.sprites = immutableArray;
        classArray = new Class[]{ShapeGfxComponent.class, PositionComponent.class};
        immutableArray = engine.getEntitiesFor(Family.all((Class[])classArray).get());
        Intrinsics.checkNotNullExpressionValue((Object)immutableArray, (String)"engine.getEntitiesFor(Fa\u2026onent::class.java).get())");
        this.shapes = immutableArray;
        classArray = new Class[]{ShapeCircleGfxComponent.class, PositionComponent.class};
        immutableArray = engine.getEntitiesFor(Family.all((Class[])classArray).get());
        Intrinsics.checkNotNullExpressionValue((Object)immutableArray, (String)"engine.getEntitiesFor(Fa\u2026onent::class.java).get())");
        this.circleShapes = immutableArray;
        classArray = new Class[]{HealthBarComponent.class, HealthComponent.class, PositionComponent.class};
        immutableArray = engine.getEntitiesFor(Family.all((Class[])classArray).get());
        Intrinsics.checkNotNullExpressionValue((Object)immutableArray, (String)"engine.getEntitiesFor(\n \u2026        ).get()\n        )");
        this.healthBars = immutableArray;
        classArray = new Class[]{TextLabelComponent.class, PositionComponent.class};
        immutableArray = engine.getEntitiesFor(Family.all((Class[])classArray).get());
        Intrinsics.checkNotNullExpressionValue((Object)immutableArray, (String)"engine.getEntitiesFor(Fa\u2026onent::class.java).get())");
        this.textLabels = immutableArray;
        classArray = new Class[]{MonsterStatsLabelComponent.class, PositionComponent.class};
        immutableArray = engine.getEntitiesFor(Family.all((Class[])classArray).get());
        Intrinsics.checkNotNullExpressionValue((Object)immutableArray, (String)"engine.getEntitiesFor(\n \u2026ass.java).get()\n        )");
        this.statsLabels = immutableArray;
        classArray = new Class[]{PositionComponent.class, AnimationGfxComponent.class};
        immutableArray = engine.getEntitiesFor(Family.all((Class[])classArray).get());
        Intrinsics.checkNotNullExpressionValue((Object)immutableArray, (String)"engine.getEntitiesFor(Fa\u2026onent::class.java).get())");
        this.animations = immutableArray;
        classArray = new Class[]{ShadowComponent.class, PositionComponent.class};
        Family.Builder builder2 = Family.all((Class[])classArray);
        classArray = new Class[]{SpriteGfxComponent.class, AnimationGfxComponent.class, DynamicAnimationComponent.class};
        immutableArray = engine.getEntitiesFor(builder2.one(classArray).get());
        Intrinsics.checkNotNullExpressionValue((Object)immutableArray, (String)"engine.getEntitiesFor(\n \u2026        ).get()\n        )");
        this.shadows = immutableArray;
        classArray = new Class[]{DynamicAnimationComponent.class};
        immutableArray = engine.getEntitiesFor(Family.all((Class[])classArray).get());
        Intrinsics.checkNotNullExpressionValue((Object)immutableArray, (String)"engine.getEntitiesFor(Fa\u2026onent::class.java).get())");
        this.dynamicAnimations = immutableArray;
    }

    public void update(float deltaTime) {
        Engine engine = this.getEngine();
        Intrinsics.checkNotNullExpressionValue((Object)engine, (String)"engine");
        ProfilerSystemKt.profile(engine, ProfilerName.DRAW, (Function0)new Function0<Unit>(this, deltaTime){
            final /* synthetic */ DrawSystem this$0;
            final /* synthetic */ float $deltaTime;
            {
                this.this$0 = $receiver;
                this.$deltaTime = $deltaTime;
                super(0);
            }

            public final void invoke() {
                GamePauseSystem gamePauseSystem = this.this$0.getGamePauseSystem();
                this.this$0.draw((gamePauseSystem == null ? false : gamePauseSystem.isPaused()) ? 0.0f : this.$deltaTime);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final Sequence<Entity> removeOutsideScreen(ImmutableArray<Entity> $this$removeOutsideScreen) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = (Iterable)$this$removeOutsideScreen;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Entity it = (Entity)element$iv$iv;
            boolean bl = false;
            PositionComponent position = (PositionComponent)Mapper.INSTANCE.getPosition().get(it);
            if (!DrawSystemKt.shouldRender((Camera)DrawSystemKt.access$getCamera$p(), position.getPos(), Vector2Kt.x(6.0f, 6.0f))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.asSequence((Iterable)((List)destination$iv$iv));
    }

    public final void draw(float deltaTime) {
        ImmutableArray<Entity> immutableArray = this.sprites;
        if (immutableArray == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"sprites");
            immutableArray = null;
        }
        Sequence<DrawInstruction> drawSprites = DrawSystemKt.spriteDrawInstructions(this.removeOutsideScreen(immutableArray));
        ImmutableArray<Entity> immutableArray2 = this.animations;
        if (immutableArray2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"animations");
            immutableArray2 = null;
        }
        Sequence<DrawInstruction> drawAnimations = DrawSystemKt.animationDrawInstruction(this.removeOutsideScreen(immutableArray2));
        ImmutableArray<Entity> immutableArray3 = this.shadows;
        if (immutableArray3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"shadows");
            immutableArray3 = null;
        }
        Sequence<DrawInstruction> shadows = DrawSystemKt.textureShadowDrawInstructions(this.removeOutsideScreen(immutableArray3));
        ImmutableArray<Entity> immutableArray4 = this.textLabels;
        if (immutableArray4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"textLabels");
            immutableArray4 = null;
        }
        Sequence<DrawInstruction> text = DrawSystemKt.textLabelsDrawInstructions(this.removeOutsideScreen(immutableArray4));
        ImmutableArray<Entity> immutableArray5 = this.statsLabels;
        if (immutableArray5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"statsLabels");
            immutableArray5 = null;
        }
        Sequence<DrawInstruction> statsLabels = DrawSystemKt.statsLabelsDrawInstructions(this.removeOutsideScreen(immutableArray5));
        ImmutableArray<Entity> immutableArray6 = this.dynamicAnimations;
        if (immutableArray6 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"dynamicAnimations");
            immutableArray6 = null;
        }
        Sequence<DrawInstruction> dynamicAni = DrawSystemKt.drawAnimationFrameInstruction(this.removeOutsideScreen(immutableArray6));
        Sequence spritesToBeDrawn = SequencesKt.plus((Sequence)SequencesKt.plus((Sequence)SequencesKt.plus((Sequence)SequencesKt.plus((Sequence)SequencesKt.plus(drawSprites, drawAnimations), shadows), text), statsLabels), dynamicAni);
        GL11.glDisable((int)3024);
        GL11.glDisable((int)2832);
        GL11.glDisable((int)2848);
        DrawSystemKt.access$getSpriteBatch$p().begin();
        Function1[] function1Array = new Function1[]{draw.1.INSTANCE, draw.2.INSTANCE};
        Sequence $this$forEach$iv = SequencesKt.sortedWith((Sequence)spritesToBeDrawn, (Comparator)ComparisonsKt.compareBy((Function1[])function1Array));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DrawInstruction it = (DrawInstruction)element$iv;
            boolean bl = false;
            it.draw(deltaTime);
        }
        DrawSystemKt.access$getSpriteBatch$p().end();
        DrawSystemKt.access$getShapeRenderer$p().begin(ShapeRenderer.ShapeType.Filled);
        ImmutableArray<Entity> immutableArray7 = this.shapes;
        if (immutableArray7 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"shapes");
            immutableArray7 = null;
        }
        DrawSystemKt.drawShapes(this.removeOutsideScreen(immutableArray7));
        ImmutableArray<Entity> immutableArray8 = this.circleShapes;
        if (immutableArray8 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"circleShapes");
            immutableArray8 = null;
        }
        DrawSystemKt.drawCircleShape(this.removeOutsideScreen(immutableArray8));
        DrawSystemKt.access$getShapeRenderer$p().end();
        ImmutableArray<Entity> immutableArray9 = this.healthBars;
        if (immutableArray9 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"healthBars");
            immutableArray9 = null;
        }
        DrawSystemKt.drawHealthBars(this.removeOutsideScreen(immutableArray9));
    }

    public DrawSystem() {
        this(null, 1, null);
    }
}

