/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.engine.ecs.system.graphics;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.math.Vector2;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.veiset.kgame.engine.ecs.system.graphics.DrawInstruction;
import org.veiset.kgame.engine.ecs.system.graphics.DrawSystemKt;
import org.veiset.kgame.engine.math.Vector2Kt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\t\u0010\u001b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\tH\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u000bH\u00c6\u0003J\t\u0010 \u001a\u00020\rH\u00c6\u0003JE\u0010!\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\rH\u00c6\u0001J\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0003H\u0016J\u0013\u0010%\u001a\u00020&2\b\u0010'\u001a\u0004\u0018\u00010(H\u00d6\u0003J\t\u0010)\u001a\u00020\u0005H\u00d6\u0001J\t\u0010*\u001a\u00020\tH\u00d6\u0001R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006+"}, d2={"Lorg/veiset/kgame/engine/ecs/system/graphics/DrawText;", "Lorg/veiset/kgame/engine/ecs/system/graphics/DrawInstruction;", "y", "", "layer", "", "position", "Lcom/badlogic/gdx/math/Vector2;", "text", "", "font", "Lcom/badlogic/gdx/graphics/g2d/BitmapFont;", "color", "Lcom/badlogic/gdx/graphics/Color;", "(FILcom/badlogic/gdx/math/Vector2;Ljava/lang/String;Lcom/badlogic/gdx/graphics/g2d/BitmapFont;Lcom/badlogic/gdx/graphics/Color;)V", "getColor", "()Lcom/badlogic/gdx/graphics/Color;", "getFont", "()Lcom/badlogic/gdx/graphics/g2d/BitmapFont;", "getLayer", "()I", "getPosition", "()Lcom/badlogic/gdx/math/Vector2;", "getText", "()Ljava/lang/String;", "getY", "()F", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "draw", "", "delta", "equals", "", "other", "", "hashCode", "toString", "kgame2"})
public final class DrawText
implements DrawInstruction {
    private final float y;
    private final int layer;
    @NotNull
    private final Vector2 position;
    @NotNull
    private final String text;
    @NotNull
    private final BitmapFont font;
    @NotNull
    private final Color color;

    public DrawText(float y, int layer, @NotNull Vector2 position, @NotNull String text, @NotNull BitmapFont font, @NotNull Color color) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)font, (String)"font");
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        this.y = y;
        this.layer = layer;
        this.position = position;
        this.text = text;
        this.font = font;
        this.color = color;
    }

    public /* synthetic */ DrawText(float f, int n, Vector2 vector2, String string, BitmapFont bitmapFont, Color color, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 0x20) != 0) {
            Color color2 = Color.WHITE;
            Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"WHITE");
            color = color2;
        }
        this(f, n, vector2, string, bitmapFont, color);
    }

    @Override
    public float getY() {
        return this.y;
    }

    @Override
    public int getLayer() {
        return this.layer;
    }

    @NotNull
    public final Vector2 getPosition() {
        return this.position;
    }

    @NotNull
    public final String getText() {
        return this.text;
    }

    @NotNull
    public final BitmapFont getFont() {
        return this.font;
    }

    @NotNull
    public final Color getColor() {
        return this.color;
    }

    @Override
    public void draw(float delta) {
        Vector2 vector2 = this.position;
        float x = Vector2Kt.component1(vector2);
        float y = Vector2Kt.component2(vector2);
        this.font.setColor(this.color);
        this.font.draw((Batch)DrawSystemKt.access$getSpriteBatch$p(), (CharSequence)this.text, x * 120.0f, y * 120.0f);
    }

    public final float component1() {
        return this.getY();
    }

    public final int component2() {
        return this.getLayer();
    }

    @NotNull
    public final Vector2 component3() {
        return this.position;
    }

    @NotNull
    public final String component4() {
        return this.text;
    }

    @NotNull
    public final BitmapFont component5() {
        return this.font;
    }

    @NotNull
    public final Color component6() {
        return this.color;
    }

    @NotNull
    public final DrawText copy(float y, int layer, @NotNull Vector2 position, @NotNull String text, @NotNull BitmapFont font, @NotNull Color color) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)font, (String)"font");
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        return new DrawText(y, layer, position, text, font, color);
    }

    public static /* synthetic */ DrawText copy$default(DrawText drawText, float f, int n, Vector2 vector2, String string, BitmapFont bitmapFont, Color color, int n2, Object object) {
        if ((n2 & 1) != 0) {
            f = drawText.getY();
        }
        if ((n2 & 2) != 0) {
            n = drawText.getLayer();
        }
        if ((n2 & 4) != 0) {
            vector2 = drawText.position;
        }
        if ((n2 & 8) != 0) {
            string = drawText.text;
        }
        if ((n2 & 0x10) != 0) {
            bitmapFont = drawText.font;
        }
        if ((n2 & 0x20) != 0) {
            color = drawText.color;
        }
        return drawText.copy(f, n, vector2, string, bitmapFont, color);
    }

    @NotNull
    public String toString() {
        return "DrawText(y=" + this.getY() + ", layer=" + this.getLayer() + ", position=" + this.position + ", text=" + this.text + ", font=" + this.font + ", color=" + this.color + ')';
    }

    public int hashCode() {
        int result = Float.hashCode(this.getY());
        result = result * 31 + Integer.hashCode(this.getLayer());
        result = result * 31 + this.position.hashCode();
        result = result * 31 + this.text.hashCode();
        result = result * 31 + this.font.hashCode();
        result = result * 31 + this.color.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DrawText)) {
            return false;
        }
        DrawText drawText = (DrawText)other;
        if (!Intrinsics.areEqual((Object)Float.valueOf(this.getY()), (Object)Float.valueOf(drawText.getY()))) {
            return false;
        }
        if (this.getLayer() != drawText.getLayer()) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.position, (Object)drawText.position)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.text, (Object)drawText.text)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.font, (Object)drawText.font)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.color, (Object)drawText.color);
    }
}

