/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.engine.ecs.system.graphics;

import com.badlogic.ashley.core.Engine;
import com.badlogic.ashley.core.Entity;
import com.badlogic.ashley.core.EntitySystem;
import com.badlogic.ashley.core.Family;
import com.badlogic.ashley.utils.ImmutableArray;
import com.badlogic.gdx.math.Vector2;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.veiset.kgame.engine.ecs.component.draw.ShadowComponent;
import org.veiset.kgame.engine.ecs.system.Mapper;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0007H\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000b\u00a8\u0006\u0012"}, d2={"Lorg/veiset/kgame/engine/ecs/system/graphics/DynamicShadowSystem;", "Lcom/badlogic/ashley/core/EntitySystem;", "()V", "entities", "Lcom/badlogic/ashley/utils/ImmutableArray;", "Lcom/badlogic/ashley/core/Entity;", "time", "", "getTime", "()F", "setTime", "(F)V", "addedToEngine", "", "engine", "Lcom/badlogic/ashley/core/Engine;", "update", "deltaTime", "kgame2"})
public final class DynamicShadowSystem
extends EntitySystem {
    private float time;
    private ImmutableArray<Entity> entities;

    public final float getTime() {
        return this.time;
    }

    public final void setTime(float f) {
        this.time = f;
    }

    public void addedToEngine(@NotNull Engine engine) {
        Intrinsics.checkNotNullParameter((Object)engine, (String)"engine");
        Class[] classArray = new Class[]{ShadowComponent.class};
        ImmutableArray immutableArray = engine.getEntitiesFor(Family.all((Class[])classArray).get());
        Intrinsics.checkNotNullExpressionValue((Object)immutableArray, (String)"engine.getEntitiesFor(Fa\u2026onent::class.java).get())");
        this.entities = immutableArray;
    }

    public void update(float deltaTime) {
        this.time += deltaTime;
        ImmutableArray<Entity> immutableArray = this.entities;
        if (immutableArray == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"entities");
            immutableArray = null;
        }
        Iterable $this$forEach$iv = (Iterable)immutableArray;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Entity entity = (Entity)element$iv;
            boolean bl = false;
            ShadowComponent shadow = (ShadowComponent)Mapper.INSTANCE.getShadow().get(entity);
            if (!shadow.getDynamic()) continue;
            Vector2 vector2 = shadow.getOffset();
            vector2.y += (float)Math.sin(this.getTime() * 7.0f) * 0.5f * deltaTime;
        }
    }
}

