/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.engine.ecs.system.graphics.effect;

import com.badlogic.ashley.core.Engine;
import com.badlogic.ashley.core.Entity;
import com.badlogic.ashley.core.EntitySystem;
import com.badlogic.ashley.core.Family;
import com.badlogic.ashley.utils.ImmutableArray;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Animation;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import org.jetbrains.annotations.NotNull;
import org.veiset.kgame.engine.Log;
import org.veiset.kgame.engine.TBEngineKt;
import org.veiset.kgame.engine.asset.AssetManager;
import org.veiset.kgame.engine.asset.AssetRef;
import org.veiset.kgame.engine.ecs.component.PositionComponent;
import org.veiset.kgame.engine.ecs.component.draw.Direction;
import org.veiset.kgame.engine.ecs.component.player.PlayerCharacterComponent;
import org.veiset.kgame.engine.ecs.entity.effect.SingleEffectAnimationEntity;
import org.veiset.kgame.engine.ecs.system.debug.ProfilerSystemKt;
import org.veiset.kgame.engine.ecs.system.graphics.effect.WeatherSystemKt;
import org.veiset.kgame.engine.ecs.system.loot.BlindSystemKt;
import org.veiset.kgame.engine.math.Vector2Kt;
import org.veiset.kgame.engine.util.GdxUtilsKt;
import org.veiset.kgame.engine.util.Particle;
import org.veiset.kgame.engine.util.ParticleKt;
import org.veiset.kgame.engine.values.Asset;
import org.veiset.kgame.engine.values.ProfilerName;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\tH\u0002J\u0006\u0010\u000e\u001a\u00020\u001aJ\u0010\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\tH\u0002J\u0010\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\tH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/veiset/kgame/engine/ecs/system/graphics/effect/WeatherSystem;", "Lcom/badlogic/ashley/core/EntitySystem;", "()V", "am", "Lorg/veiset/kgame/engine/asset/AssetManager;", "leaves", "", "Lorg/veiset/kgame/engine/util/Particle;", "nextLeafDuration", "", "nextRainDuration", "players", "Lcom/badlogic/ashley/utils/ImmutableArray;", "Lcom/badlogic/ashley/core/Entity;", "rain", "rainShader", "Lcom/badlogic/gdx/graphics/glutils/ShaderProgram;", "spriteBatch", "Lcom/badlogic/gdx/graphics/g2d/SpriteBatch;", "time", "getTime", "()F", "setTime", "(F)V", "uiSpriteBatch", "leaf", "", "deltaTime", "rainEffect", "update", "kgame2"})
public final class WeatherSystem
extends EntitySystem {
    @NotNull
    private final SpriteBatch uiSpriteBatch = TBEngineKt.getGlobals().getDrawUi().getSpriteBatch();
    @NotNull
    private final SpriteBatch spriteBatch = TBEngineKt.getGlobals().getDrawGfx().getSpriteBatch();
    @NotNull
    private final AssetManager am = TBEngineKt.getGlobals().getAssetManager();
    @NotNull
    private final ShaderProgram rainShader;
    private float time;
    private ImmutableArray<Entity> players;
    private float nextLeafDuration;
    private float nextRainDuration;
    @NotNull
    private List<Particle> leaves;
    @NotNull
    private List<Particle> rain;

    /*
     * WARNING - void declaration
     */
    public WeatherSystem() {
        void it;
        ShaderProgram shaderProgram;
        ShaderProgram shaderProgram2 = shaderProgram = new ShaderProgram(Gdx.files.internal("shader/rain/rain.vert"), Gdx.files.internal("shader/rain/rain.frag"));
        WeatherSystem weatherSystem = this;
        boolean bl = false;
        ShaderProgram.pedantic = false;
        if (!it.isCompiled()) {
            String string = it.getLog();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.log");
            Log.INSTANCE.error(string);
        } else {
            Log.INSTANCE.debug("Rain Shader loaded.");
        }
        weatherSystem.rainShader = shaderProgram;
        this.leaves = new ArrayList();
        this.rain = new ArrayList();
    }

    public final float getTime() {
        return this.time;
    }

    public final void setTime(float f) {
        this.time = f;
    }

    public void update(float deltaTime) {
        if (Gdx.input.isKeyJustPressed(37)) {
            WeatherSystemKt.access$setWeatherEffectLeaf$p(!WeatherSystemKt.access$getWeatherEffectLeaf$p());
        }
        if (Gdx.input.isKeyJustPressed(43)) {
            WeatherSystemKt.access$setWeatherEffectRain$p(!WeatherSystemKt.access$getWeatherEffectRain$p());
        }
        Engine engine = this.getEngine();
        Intrinsics.checkNotNullExpressionValue((Object)engine, (String)"engine");
        ProfilerSystemKt.profile(engine, ProfilerName.WEATHER, (Function0)new Function0<Unit>(this, deltaTime){
            final /* synthetic */ WeatherSystem this$0;
            final /* synthetic */ float $deltaTime;
            {
                this.this$0 = $receiver;
                this.$deltaTime = $deltaTime;
                super(0);
            }

            public final void invoke() {
                Class[] classArray = new Class[]{PlayerCharacterComponent.class, PositionComponent.class};
                Object object = this.this$0.getEngine().getEntitiesFor(Family.all((Class[])classArray).get());
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"engine.getEntitiesFor(\n \u2026java).get()\n            )");
                WeatherSystem.access$setPlayers$p(this.this$0, (ImmutableArray)object);
                object = this.this$0;
                ((WeatherSystem)((Object)object)).setTime(((WeatherSystem)((Object)object)).getTime() + this.$deltaTime);
                if (WeatherSystemKt.access$getWeatherEffectLeaf$p()) {
                    WeatherSystem.access$leaf(this.this$0, this.$deltaTime);
                }
                if (WeatherSystemKt.access$getWeatherEffectRain$p()) {
                    WeatherSystem.access$rainEffect(this.this$0, this.$deltaTime);
                }
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final void rainEffect(float deltaTime) {
        Iterable $this$filterTo$iv$iv;
        Vector2 vector2;
        if (this.nextRainDuration <= 0.0f) {
            Vector3 vector3 = TBEngineKt.getGlobals().getDrawGfx().getCamera().position;
            Intrinsics.checkNotNullExpressionValue((Object)vector3, (String)"globals.drawGfx.camera.position");
            Vector2 vector22 = Vector2Kt.gfxToWorld(Vector2Kt.v2(vector3));
            float x = Vector2Kt.component1(vector22);
            float y = Vector2Kt.component2(vector22);
            float w = 9.0f;
            int n = 20;
            int n2 = 0;
            while (n2 < n) {
                TextureRegion textureRegion;
                int n3;
                int it = n3 = n2++;
                boolean bl = false;
                AssetManager assetManager = this.am;
                AssetRef assetRef$iv = Asset.Texture.INSTANCE.getWhiteRect();
                boolean $i$f$get = false;
                try {
                    void this_$iv;
                    Object object = this_$iv.getAssets().get(assetRef$iv);
                    if (object == null) {
                        throw new NullPointerException("null cannot be cast to non-null type com.badlogic.gdx.graphics.g2d.TextureRegion");
                    }
                    textureRegion = (TextureRegion)object;
                }
                catch (Exception ex$iv) {
                    Log.INSTANCE.critical("AssetRef " + assetRef$iv + " not loaded");
                    throw ex$iv;
                }
                TextureRegion textureRegion2 = textureRegion;
                float this_$iv = Vector2Kt.lerp(Random.Default.nextFloat(), 0.1f, 1.6f);
                Vector2 vector23 = Vector2Kt.x(Vector2Kt.lerp(Random.Default.nextFloat(), x - w, x + w), y + Vector2Kt.lerp(Random.Default.nextFloat(), 4.0f, 5.0f));
                vector2 = Vector2Kt.x(0.012f, Vector2Kt.lerp(Random.Default.nextFloat(), 0.2f, 1.0f));
                Color ex$iv = Color.BLUE;
                Function2<Particle, Float, Unit> function2 = ParticleKt.getUpdateRain();
                Intrinsics.checkNotNullExpressionValue((Object)ex$iv, (String)"BLUE");
                Particle drop = new Particle(textureRegion2, this_$iv, vector23, vector2, 0.0f, ex$iv, function2);
                ((Collection)this.rain).add(drop);
            }
            this.nextRainDuration = 0.03f;
        }
        Iterable $this$filter$iv = this.rain;
        boolean $i$f$filter = false;
        Iterable w = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Particle it = (Particle)element$iv$iv;
            boolean bl = false;
            if (!(it.getDuration() <= 0.0f)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List splash = (List)destination$iv$iv;
        $this$filter$iv = this.rain;
        WeatherSystem weatherSystem = this;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Particle it = (Particle)element$iv$iv;
            boolean bl = false;
            if (!(it.getDuration() > 0.0f)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        weatherSystem.rain = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
        this.spriteBatch.setColor(new Color(0.8f, 0.9f, 1.0f, 0.2f));
        this.spriteBatch.begin();
        Iterable $this$forEach$iv = this.rain;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Particle drop = (Particle)element$iv;
            boolean bl = false;
            drop.update(deltaTime);
            GdxUtilsKt.draw(this.spriteBatch, drop.getGfx(), Vector2Kt.dw(drop.getPosition()), Vector2Kt.dw(drop.getSize()));
        }
        this.spriteBatch.end();
        this.spriteBatch.setColor(Color.WHITE);
        $this$forEach$iv = splash;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Animation animation;
            void assetRef$iv;
            Particle splash2 = (Particle)element$iv;
            boolean bl = false;
            AssetManager element$iv$iv = this.am;
            AssetRef it = Asset.Animation.INSTANCE.getSplash();
            vector2 = this.getEngine();
            boolean $i$f$get = false;
            try {
                void this_$iv;
                Object object = this_$iv.getAssets().get(assetRef$iv);
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type com.badlogic.gdx.graphics.g2d.Animation<com.badlogic.gdx.graphics.g2d.TextureRegion>");
                }
                animation = (Animation)object;
            }
            catch (Exception ex$iv) {
                Log.INSTANCE.critical("AssetRef " + assetRef$iv + " not loaded");
                throw ex$iv;
            }
            DefaultConstructorMarker defaultConstructorMarker = null;
            int n = 24;
            int n4 = 0;
            Direction direction = null;
            Vector2 vector24 = Vector2Kt.x(0.1f, 0.1f);
            Vector2 vector25 = Vector2Kt.plus(splash2.getPosition(), new Vector2(-0.05f, 0.0f));
            Animation animation2 = animation;
            vector2.addEntity((Entity)new SingleEffectAnimationEntity(animation2, vector25, vector24, direction, n4, n, defaultConstructorMarker));
        }
        this.nextRainDuration -= deltaTime;
    }

    /*
     * WARNING - void declaration
     */
    private final void leaf(float deltaTime) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Iterable iterable;
        if (this.nextLeafDuration <= 0.0f) {
            TextureRegion textureRegion;
            Vector3 vector3 = TBEngineKt.getGlobals().getDrawGfx().getCamera().position;
            Intrinsics.checkNotNullExpressionValue((Object)vector3, (String)"globals.drawGfx.camera.position");
            iterable = Vector2Kt.gfxToWorld(Vector2Kt.v2(vector3));
            float x = Vector2Kt.component1((Vector2)iterable);
            float y = Vector2Kt.component2((Vector2)iterable);
            float w = 15.0f;
            AssetManager assetManager = TBEngineKt.getGlobals().getAssetManager();
            AssetRef assetRef$iv = Asset.Texture.INSTANCE.getLeaf();
            boolean $i$f$get = false;
            try {
                Iterator this_$iv;
                Object object = ((AssetManager)((Object)this_$iv)).getAssets().get(assetRef$iv);
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type com.badlogic.gdx.graphics.g2d.TextureRegion");
                }
                textureRegion = (TextureRegion)object;
            }
            catch (Exception ex$iv) {
                Log.INSTANCE.critical("AssetRef " + assetRef$iv + " not loaded");
                throw ex$iv;
            }
            DefaultConstructorMarker defaultConstructorMarker = null;
            int n = 48;
            Function2<Particle, Float, Unit> function2 = ParticleKt.getUpdateLeaf();
            Color color = null;
            float f = 0.0f;
            Vector2 vector2 = Vector2Kt.x(0.2f, 0.2f);
            Vector2 vector22 = Vector2Kt.x(Vector2Kt.lerp(Random.Default.nextFloat(), x - w, x + w), y + 6.0f);
            float f2 = 16.0f;
            TextureRegion textureRegion2 = textureRegion;
            Particle leaf = new Particle(textureRegion2, f2, vector22, vector2, f, color, function2, n, defaultConstructorMarker);
            ((Collection)this.leaves).add(leaf);
            this.nextLeafDuration = 0.3f;
        }
        this.nextLeafDuration -= deltaTime;
        iterable = this.leaves;
        WeatherSystem weatherSystem = this;
        boolean $i$f$filter = false;
        void y = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Particle it = (Particle)element$iv$iv;
            boolean bl = false;
            if (!(it.getDuration() > 0.0f)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        weatherSystem.leaves = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
        Iterable $this$forEach$iv = this.leaves;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Particle leaf = (Particle)element$iv;
            boolean bl = false;
            this.spriteBatch.setColor(leaf.getColor());
            this.spriteBatch.begin();
            leaf.update(deltaTime);
            GdxUtilsKt.draw(this.spriteBatch, leaf.getGfx(), Vector2Kt.dw(leaf.getPosition()), Vector2Kt.dw(leaf.getSize()), leaf.getRotation());
            this.spriteBatch.end();
        }
        this.spriteBatch.setColor(Color.WHITE);
    }

    /*
     * WARNING - void declaration
     */
    public final void rain() {
        TextureRegion textureRegion;
        void assetRef$iv;
        Gdx.gl.glEnable(3042);
        Gdx.gl.glBlendFunc(770, 771);
        this.uiSpriteBatch.begin();
        this.uiSpriteBatch.setShader(this.rainShader);
        Object object = new Pair[]{TuplesKt.to((Object)"time", (Object)Float.valueOf(this.time)), TuplesKt.to((Object)"hue", (Object)Float.valueOf(0.5f)), TuplesKt.to((Object)"fadef", (Object)Float.valueOf(0.4f)), TuplesKt.to((Object)"slow", (Object)Float.valueOf(4.0f)), TuplesKt.to((Object)"gray", (Object)Float.valueOf(1.0f)), TuplesKt.to((Object)"u_resolution", (Object)new Vector2(1000.0f, 1000.0f))};
        BlindSystemKt.setVars(this.rainShader, object);
        object = this.am;
        AssetRef assetRef = Asset.Texture.INSTANCE.getBlackSquare();
        SpriteBatch spriteBatch = this.uiSpriteBatch;
        boolean $i$f$get = false;
        try {
            void this_$iv;
            Object object2 = this_$iv.getAssets().get(assetRef$iv);
            if (object2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.badlogic.gdx.graphics.g2d.TextureRegion");
            }
            textureRegion = (TextureRegion)object2;
        }
        catch (Exception ex$iv) {
            Log.INSTANCE.critical("AssetRef " + assetRef$iv + " not loaded");
            throw ex$iv;
        }
        spriteBatch.draw(textureRegion, 0.0f, 0.0f, 1920.0f, 1080.0f);
        this.uiSpriteBatch.end();
        this.uiSpriteBatch.setShader(null);
        Gdx.gl.glDisable(3042);
    }

    public static final /* synthetic */ void access$setPlayers$p(WeatherSystem $this, ImmutableArray immutableArray) {
        $this.players = immutableArray;
    }

    public static final /* synthetic */ void access$leaf(WeatherSystem $this, float deltaTime) {
        $this.leaf(deltaTime);
    }

    public static final /* synthetic */ void access$rainEffect(WeatherSystem $this, float deltaTime) {
        $this.rainEffect(deltaTime);
    }
}

