/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.engine.ecs.system.loot;

import com.badlogic.ashley.core.Component;
import com.badlogic.ashley.core.Engine;
import com.badlogic.ashley.core.Entity;
import com.badlogic.ashley.core.EntitySystem;
import com.badlogic.ashley.core.Family;
import com.badlogic.ashley.utils.ImmutableArray;
import com.badlogic.gdx.math.Vector2;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import org.jetbrains.annotations.NotNull;
import org.veiset.kgame.engine.ecs.component.PositionComponent;
import org.veiset.kgame.engine.ecs.component.ai.LinearMoveAIComponent;
import org.veiset.kgame.engine.ecs.component.loot.AutoPickupLootComponent;
import org.veiset.kgame.engine.ecs.component.loot.SpawnedItemComponent;
import org.veiset.kgame.engine.ecs.component.physics.VelocityComponent;
import org.veiset.kgame.engine.ecs.component.player.InventoryComponent;
import org.veiset.kgame.engine.ecs.component.player.PlayerCharacterComponent;
import org.veiset.kgame.engine.ecs.system.Mapper;
import org.veiset.kgame.engine.ecs.system.MapperNullable;
import org.veiset.kgame.engine.math.Vector2Kt;
import org.veiset.kgame.engine.util.TargetType;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/veiset/kgame/engine/ecs/system/loot/AutoPickupLootSystem;", "Lcom/badlogic/ashley/core/EntitySystem;", "()V", "inventories", "Lcom/badlogic/ashley/utils/ImmutableArray;", "Lcom/badlogic/ashley/core/Entity;", "loot", "players", "addedToEngine", "", "engine", "Lcom/badlogic/ashley/core/Engine;", "update", "deltaTime", "", "kgame2"})
public final class AutoPickupLootSystem
extends EntitySystem {
    private ImmutableArray<Entity> players;
    private ImmutableArray<Entity> inventories;
    private ImmutableArray<Entity> loot;

    public void addedToEngine(@NotNull Engine engine) {
        Intrinsics.checkNotNullParameter((Object)engine, (String)"engine");
        Class[] classArray = new Class[]{PlayerCharacterComponent.class};
        ImmutableArray immutableArray = engine.getEntitiesFor(Family.one((Class[])classArray).get());
        Intrinsics.checkNotNullExpressionValue((Object)immutableArray, (String)"engine.getEntitiesFor(Fa\u2026onent::class.java).get())");
        this.players = immutableArray;
        classArray = new Class[]{InventoryComponent.class};
        immutableArray = engine.getEntitiesFor(Family.one((Class[])classArray).get());
        Intrinsics.checkNotNullExpressionValue((Object)immutableArray, (String)"engine.getEntitiesFor(Fa\u2026onent::class.java).get())");
        this.inventories = immutableArray;
        classArray = new Class[]{AutoPickupLootComponent.class, PositionComponent.class};
        Family.Builder builder = Family.all((Class[])classArray);
        classArray = new Class[]{SpawnedItemComponent.class};
        immutableArray = engine.getEntitiesFor(builder.exclude(classArray).get());
        Intrinsics.checkNotNullExpressionValue((Object)immutableArray, (String)"engine.getEntitiesFor(Fa\u2026onent::class.java).get())");
        this.loot = immutableArray;
    }

    public void update(float deltaTime) {
        ImmutableArray<Entity> immutableArray = this.players;
        if (immutableArray == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"players");
            immutableArray = null;
        }
        Entity entity = (Entity)CollectionsKt.firstOrNull((Iterable)((Iterable)immutableArray));
        if (entity == null) {
            return;
        }
        Entity player = entity;
        ImmutableArray<Entity> immutableArray2 = this.inventories;
        if (immutableArray2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"inventories");
            immutableArray2 = null;
        }
        Entity entity2 = (Entity)CollectionsKt.firstOrNull((Iterable)((Iterable)immutableArray2));
        if (entity2 == null) {
            return;
        }
        Entity inventoryEntity = entity2;
        InventoryComponent inventoryComponent = (InventoryComponent)Mapper.INSTANCE.getInventory().get(inventoryEntity);
        if (inventoryComponent == null) {
            return;
        }
        InventoryComponent inventory = inventoryComponent;
        ImmutableArray<Entity> immutableArray3 = this.loot;
        if (immutableArray3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"loot");
            immutableArray3 = null;
        }
        Iterable $this$forEach$iv = (Iterable)immutableArray3;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Entity entity3 = (Entity)element$iv;
            boolean bl = false;
            PositionComponent position = (PositionComponent)Mapper.INSTANCE.getPosition().get(entity3);
            Vector2 playerPos = ((PositionComponent)Mapper.INSTANCE.getPosition().get(player)).getPos();
            if (MapperNullable.INSTANCE.getLinearMoveAI().get(entity3) == null) {
                entity3.add((Component)new VelocityComponent(Vector2Kt.x(0.0f, 0.0f)));
                entity3.add((Component)new LinearMoveAIComponent(TargetType.OnScreen.INSTANCE, 0.3f * Random.Default.nextFloat() + 0.1f, true));
            }
            if (!(playerPos.dst(position.getPos()) <= 0.3f)) continue;
            this.getEngine().removeEntity(entity3);
            inventory.setCurrency(inventory.getCurrency() + 1);
        }
    }
}

