/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.engine.ecs.system.loot;

import com.badlogic.ashley.core.Component;
import com.badlogic.ashley.core.Engine;
import com.badlogic.ashley.core.Entity;
import com.badlogic.ashley.core.EntitySystem;
import com.badlogic.ashley.core.Family;
import com.badlogic.ashley.utils.ImmutableArray;
import com.badlogic.gdx.math.Vector2;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import org.jetbrains.annotations.NotNull;
import org.veiset.kgame.engine.ecs.component.PositionComponent;
import org.veiset.kgame.engine.ecs.component.draw.SpriteGfxComponent;
import org.veiset.kgame.engine.ecs.component.loot.AutoPickupLootComponent;
import org.veiset.kgame.engine.ecs.component.loot.ItemComponent;
import org.veiset.kgame.engine.ecs.component.loot.PickableLootComponent;
import org.veiset.kgame.engine.ecs.component.loot.SpawnedItemComponent;
import org.veiset.kgame.engine.ecs.component.physics.VelocityComponent;
import org.veiset.kgame.engine.ecs.system.Mapper;
import org.veiset.kgame.engine.ecs.system.MapperNullable;
import org.veiset.kgame.engine.item.Coin;
import org.veiset.kgame.engine.math.Vector2Kt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/veiset/kgame/engine/ecs/system/loot/ItemSpawnLocationSystem;", "Lcom/badlogic/ashley/core/EntitySystem;", "()V", "loot", "Lcom/badlogic/ashley/utils/ImmutableArray;", "Lcom/badlogic/ashley/core/Entity;", "addedToEngine", "", "engine", "Lcom/badlogic/ashley/core/Engine;", "update", "deltaTime", "", "kgame2"})
public final class ItemSpawnLocationSystem
extends EntitySystem {
    private ImmutableArray<Entity> loot;

    public void addedToEngine(@NotNull Engine engine) {
        Intrinsics.checkNotNullParameter((Object)engine, (String)"engine");
        Class[] classArray = new Class[]{SpawnedItemComponent.class, ItemComponent.class, PositionComponent.class};
        ImmutableArray immutableArray = engine.getEntitiesFor(Family.all((Class[])classArray).get());
        Intrinsics.checkNotNullExpressionValue((Object)immutableArray, (String)"engine.getEntitiesFor(Fa\u2026onent::class.java).get())");
        this.loot = immutableArray;
    }

    public void update(float deltaTime) {
        ImmutableArray<Entity> immutableArray = this.loot;
        if (immutableArray == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"loot");
            immutableArray = null;
        }
        Iterable $this$forEach$iv = (Iterable)immutableArray;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Entity entity = (Entity)element$iv;
            boolean bl = false;
            SpawnedItemComponent spawnedItem = (SpawnedItemComponent)Mapper.INSTANCE.getSpawnedItem().get(entity);
            VelocityComponent velocity = (VelocityComponent)MapperNullable.INSTANCE.getVelocity().get(entity);
            SpriteGfxComponent gfx = (SpriteGfxComponent)Mapper.INSTANCE.getSpriteGfx().get(entity);
            if (velocity == null) {
                float xr = Vector2Kt.lerp(Random.Default.nextFloat(), -0.5f, 0.5f);
                float xy = Vector2Kt.lerp(Random.Default.nextFloat(), -0.5f, 0.5f);
                Vector2 vector2 = new Vector2(xr, xy).nor().scl(0.1f);
                Intrinsics.checkNotNullExpressionValue((Object)vector2, (String)"Vector2(xr, xy).nor().scl(0.1f)");
                entity.add((Component)new VelocityComponent(vector2));
            } else {
                velocity.getSpeed().scl(0.9f);
            }
            gfx.setOpacity(1.0f - spawnedItem.getPlacementTime() / spawnedItem.getTotalTime());
            spawnedItem.setPlacementTime(spawnedItem.getPlacementTime() - deltaTime);
            if (!(spawnedItem.getPlacementTime() <= 0.0f)) continue;
            ItemComponent item = (ItemComponent)Mapper.INSTANCE.getItem().get(entity);
            if (item.getItem() instanceof Coin) {
                entity.add((Component)new AutoPickupLootComponent());
            } else {
                entity.add((Component)new PickableLootComponent(false, 1, null));
            }
            entity.remove(VelocityComponent.class);
            entity.remove(SpawnedItemComponent.class);
        }
    }
}

