/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.engine.ecs.system.physics;

import com.badlogic.ashley.core.Component;
import com.badlogic.ashley.core.Engine;
import com.badlogic.ashley.core.Entity;
import com.badlogic.gdx.physics.box2d.Contact;
import com.badlogic.gdx.physics.box2d.ContactImpulse;
import com.badlogic.gdx.physics.box2d.ContactListener;
import com.badlogic.gdx.physics.box2d.Fixture;
import com.badlogic.gdx.physics.box2d.Manifold;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.veiset.kgame.engine.Log;
import org.veiset.kgame.engine.ecs.component.physics.CollisionComponent;
import org.veiset.kgame.engine.ecs.component.physics.SensorCollisionComponent;
import org.veiset.kgame.engine.ecs.entity.PlayerEntity;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0012"}, d2={"Lorg/veiset/kgame/engine/ecs/system/physics/CollisionHandler;", "Lcom/badlogic/gdx/physics/box2d/ContactListener;", "engine", "Lcom/badlogic/ashley/core/Engine;", "(Lcom/badlogic/ashley/core/Engine;)V", "getEngine", "()Lcom/badlogic/ashley/core/Engine;", "beginContact", "", "contact", "Lcom/badlogic/gdx/physics/box2d/Contact;", "endContact", "postSolve", "impulse", "Lcom/badlogic/gdx/physics/box2d/ContactImpulse;", "preSolve", "oldManifold", "Lcom/badlogic/gdx/physics/box2d/Manifold;", "kgame2"})
public final class CollisionHandler
implements ContactListener {
    @NotNull
    private final Engine engine;

    public CollisionHandler(@NotNull Engine engine) {
        Intrinsics.checkNotNullParameter((Object)engine, (String)"engine");
        this.engine = engine;
    }

    @NotNull
    public final Engine getEngine() {
        return this.engine;
    }

    public void endContact(@NotNull Contact contact) {
        Intrinsics.checkNotNullParameter((Object)contact, (String)"contact");
    }

    public void beginContact(@NotNull Contact contact) {
        Intrinsics.checkNotNullParameter((Object)contact, (String)"contact");
        Fixture f2 = contact.getFixtureA();
        Fixture f1 = contact.getFixtureB();
        if (f1 == null || f2 == null) {
            Log.INSTANCE.warn("No fixture");
            return;
        }
        if (f1.getBody().getUserData() == null || f2.getBody().getUserData() == null) {
            Log.INSTANCE.warn("No data");
            return;
        }
        Object entity1 = f1.getBody().getUserData();
        Object entity2 = f2.getBody().getUserData();
        if (!(entity1 instanceof Entity) || !(entity2 instanceof Entity)) {
            return;
        }
        if (f1.isSensor()) {
            if (f2.getBody().getUserData() instanceof PlayerEntity) {
                ((Entity)entity1).add((Component)new SensorCollisionComponent((Entity)entity2));
            }
        } else if (f2.isSensor()) {
            if (f1.getBody().getUserData() instanceof PlayerEntity) {
                ((Entity)entity2).add((Component)new SensorCollisionComponent((Entity)entity1));
            }
        } else {
            ((Entity)entity1).add((Component)new CollisionComponent((Entity)entity2));
        }
    }

    public void preSolve(@NotNull Contact contact, @NotNull Manifold oldManifold) {
        Intrinsics.checkNotNullParameter((Object)contact, (String)"contact");
        Intrinsics.checkNotNullParameter((Object)oldManifold, (String)"oldManifold");
    }

    public void postSolve(@NotNull Contact contact, @NotNull ContactImpulse impulse) {
        Intrinsics.checkNotNullParameter((Object)contact, (String)"contact");
        Intrinsics.checkNotNullParameter((Object)impulse, (String)"impulse");
    }
}

