/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.engine.ecs.system.ui;

import com.badlogic.ashley.core.Engine;
import com.badlogic.ashley.core.Entity;
import com.badlogic.ashley.core.EntitySystem;
import com.badlogic.ashley.core.Family;
import com.badlogic.ashley.utils.ImmutableArray;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.math.Vector2;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.veiset.kgame.engine.TBEngineKt;
import org.veiset.kgame.engine.ecs.component.ui.UiTextComponent;
import org.veiset.kgame.engine.ecs.system.Mapper;
import org.veiset.kgame.engine.math.Vector2Kt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/veiset/kgame/engine/ecs/system/ui/DrawUiTextSystem;", "Lcom/badlogic/ashley/core/EntitySystem;", "()V", "spriteBatch", "Lcom/badlogic/gdx/graphics/g2d/SpriteBatch;", "uiTexts", "Lcom/badlogic/ashley/utils/ImmutableArray;", "Lcom/badlogic/ashley/core/Entity;", "addedToEngine", "", "engine", "Lcom/badlogic/ashley/core/Engine;", "update", "deltaTime", "", "kgame2"})
public final class DrawUiTextSystem
extends EntitySystem {
    @NotNull
    private final SpriteBatch spriteBatch = TBEngineKt.getGlobals().getDrawUi().getSpriteBatch();
    private ImmutableArray<Entity> uiTexts;

    public void addedToEngine(@NotNull Engine engine) {
        Intrinsics.checkNotNullParameter((Object)engine, (String)"engine");
        Class[] classArray = new Class[]{UiTextComponent.class};
        ImmutableArray immutableArray = engine.getEntitiesFor(Family.all((Class[])classArray).get());
        Intrinsics.checkNotNullExpressionValue((Object)immutableArray, (String)"engine.getEntitiesFor(Fa\u2026onent::class.java).get())");
        this.uiTexts = immutableArray;
    }

    public void update(float deltaTime) {
        this.spriteBatch.begin();
        ImmutableArray<Entity> immutableArray = this.uiTexts;
        if (immutableArray == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"uiTexts");
            immutableArray = null;
        }
        Iterable $this$forEach$iv = (Iterable)immutableArray;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Entity entity = (Entity)element$iv;
            boolean bl = false;
            UiTextComponent uiText = (UiTextComponent)Mapper.INSTANCE.getUiText().get(entity);
            Vector2 vector2 = uiText.getPosition();
            float x = Vector2Kt.component1(vector2);
            float y = Vector2Kt.component2(vector2);
            uiText.getFont().setColor(uiText.getColor());
            uiText.getFont().draw((Batch)this.spriteBatch, (CharSequence)uiText.getText(), x * 120.0f, y * 120.0f);
        }
        this.spriteBatch.end();
    }
}

