/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.engine.input;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.math.Vector2;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;
import org.veiset.kgame.engine.EngineConfig;
import org.veiset.kgame.engine.GameFilesKt;
import org.veiset.kgame.engine.TBEngineKt;
import org.veiset.kgame.engine.math.Vector2Kt;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\u0010\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\u001a\u0012\u0010\u0000\u001a\u00020\u00012\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0006\u0010\u0004\u001a\u00020\u0001\u001a\u0006\u0010\u0005\u001a\u00020\u0001\u00a8\u0006\u0006"}, d2={"basePointer", "Lcom/badlogic/gdx/math/Vector2;", "zoom", "", "scaledPointer", "uiPointer", "kgame2"})
public final class MouseKt {
    @NotNull
    public static final Vector2 scaledPointer() {
        OrthographicCamera camera = TBEngineKt.getGlobals().getDrawGfx().getCamera();
        float cx = camera.position.x;
        float cy = camera.position.y;
        float gameWidth = 1920.0f;
        float gameHeight = 1080.0f;
        Vector2 vector2 = MouseKt.basePointer(camera.zoom);
        float x = Vector2Kt.component1(vector2);
        float y = Vector2Kt.component2(vector2);
        float rx = x + cx - gameWidth / 2.0f * camera.zoom;
        float ry = y + cy - gameHeight / 2.0f * camera.zoom;
        return Vector2Kt.gfxToWorld(Vector2Kt.x(rx, ry));
    }

    @NotNull
    public static final Vector2 uiPointer() {
        return Vector2Kt.gfxToWorld(MouseKt.basePointer$default(0.0f, 1, null));
    }

    private static final Vector2 basePointer(float zoom) {
        int gutterWidth = EngineConfig.Window.INSTANCE.getGutterWidth();
        int gutterHeight = EngineConfig.Window.INSTANCE.getGutterHeight();
        int screenWidth = GameFilesKt.getGameConfig().getScreenWidth();
        int screenHeight = GameFilesKt.getGameConfig().getScreenHeight();
        float gameWidth = 1920.0f;
        float gameHeight = 1080.0f;
        float x = (float)(Gdx.input.getX() - gutterWidth / 2) * (gameWidth / (float)(screenWidth - gutterWidth) * zoom);
        float y = (float)(screenHeight - Gdx.input.getY() - gutterHeight / 2) * (gameHeight / (float)(screenHeight - gutterHeight) * zoom);
        return new Vector2(x, y);
    }

    static /* synthetic */ Vector2 basePointer$default(float f, int n, Object object) {
        if ((n & 1) != 0) {
            f = 1.0f;
        }
        return MouseKt.basePointer(f);
    }
}

