/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.engine.storage;

import com.badlogic.gdx.graphics.g2d.TextureRegion;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.veiset.kgame.engine.Log;
import org.veiset.kgame.engine.storage.TextureMetaStore;
import org.veiset.kgame.engine.values.Tag;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0011B\u0019\u0012\u0012\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\"\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J2\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u0007\"\u0004\b\u0000\u0010\u000e*\b\u0012\u0004\u0012\u00020\u00040\u00072\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u0002H\u000e0\u0010H\u0002R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00040\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0012"}, d2={"Lorg/veiset/kgame/engine/storage/TextureMetaStore;", "", "textureMetas", "", "Lorg/veiset/kgame/engine/storage/TextureMetaStore$TextureMeta;", "([Lorg/veiset/kgame/engine/storage/TextureMetaStore$TextureMeta;)V", "meta", "", "textures", "", "", "getTextures", "()Ljava/util/Map;", "duplicates", "T", "prop", "Lkotlin/Function1;", "TextureMeta", "kgame2"})
public final class TextureMetaStore {
    @NotNull
    private final List<TextureMeta> meta;
    @NotNull
    private final Map<String, TextureMeta> textures;

    /*
     * WARNING - void declaration
     */
    public TextureMetaStore(TextureMeta ... textureMetas) {
        void $this$associateByTo$iv$iv;
        void $this$associateBy$iv;
        List duplicateTexutres2;
        Intrinsics.checkNotNullParameter((Object)textureMetas, (String)"textureMetas");
        this.meta = ArraysKt.toList((Object[])textureMetas);
        Iterable<Object> duplicates2 = this.duplicates(this.meta, duplicates.3.INSTANCE);
        if (!((Collection)duplicates2).isEmpty()) {
            Log.INSTANCE.error("TextureMetaStore " + duplicates2.size() + " duplicate keys detected: " + duplicates2);
        }
        if (!((Collection)(duplicateTexutres2 = this.duplicates(this.meta, duplicateTexutres.1.INSTANCE))).isEmpty()) {
            Log.INSTANCE.warn("TextureMetaStore " + duplicateTexutres2.size() + " duplicate textures detected!");
        }
        duplicates2 = this.meta;
        TextureMetaStore textureMetaStore = this;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        void var5_7 = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            TextureMeta textureMeta = (TextureMeta)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            map.put(it.getName(), element$iv$iv);
        }
        textureMetaStore.textures = destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final <T> List<T> duplicates(List<TextureMeta> $this$duplicates, Function1<? super TextureMeta, ? extends T> prop) {
        void $this$fold$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = $this$duplicates;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            TextureMeta textureMeta = (TextureMeta)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(prop.invoke((Object)it));
        }
        $this$map$iv = (List)destination$iv$iv;
        Pair initial$iv = new Pair((Object)new ArrayList(), (Object)new ArrayList());
        boolean $i$f$fold = false;
        Pair accumulator$iv = initial$iv;
        Iterator iterator = $this$fold$iv.iterator();
        while (iterator.hasNext()) {
            void next;
            Object element$iv;
            Object item$iv$iv;
            item$iv$iv = element$iv = iterator.next();
            Pair $dstr$all$dupes = accumulator$iv;
            boolean bl = false;
            List all2 = (List)$dstr$all$dupes.component1();
            List dupes = (List)$dstr$all$dupes.component2();
            if (all2.contains(next)) {
                dupes.add(next);
            } else {
                all2.add(next);
            }
            accumulator$iv = new Pair((Object)all2, (Object)dupes);
        }
        return (List)accumulator$iv.getSecond();
    }

    @NotNull
    public final Map<String, TextureMeta> getTextures() {
        return this.textures;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00c6\u0003J\u000f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0003J-\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001d\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00120\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001e"}, d2={"Lorg/veiset/kgame/engine/storage/TextureMetaStore$TextureMeta;", "", "name", "", "texture", "Lcom/badlogic/gdx/graphics/g2d/TextureRegion;", "tags", "", "Lorg/veiset/kgame/engine/values/Tag;", "(Ljava/lang/String;Lcom/badlogic/gdx/graphics/g2d/TextureRegion;Ljava/util/List;)V", "getName", "()Ljava/lang/String;", "getTags", "()Ljava/util/List;", "getTexture", "()Lcom/badlogic/gdx/graphics/g2d/TextureRegion;", "textureSize", "Lkotlin/Pair;", "", "getTextureSize", "()Lkotlin/Pair;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "kgame2"})
    public static final class TextureMeta {
        @NotNull
        private final String name;
        @NotNull
        private final TextureRegion texture;
        @NotNull
        private final List<Tag> tags;
        @NotNull
        private final Pair<Integer, Integer> textureSize;

        public TextureMeta(@NotNull String name, @NotNull TextureRegion texture, @NotNull List<? extends Tag> tags) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)texture, (String)"texture");
            Intrinsics.checkNotNullParameter(tags, (String)"tags");
            this.name = name;
            this.texture = texture;
            this.tags = tags;
            this.textureSize = new Pair((Object)this.texture.getRegionWidth(), (Object)this.texture.getRegionHeight());
        }

        public /* synthetic */ TextureMeta(String string, TextureRegion textureRegion, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                list = CollectionsKt.emptyList();
            }
            this(string, textureRegion, list);
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final TextureRegion getTexture() {
            return this.texture;
        }

        @NotNull
        public final List<Tag> getTags() {
            return this.tags;
        }

        @NotNull
        public final Pair<Integer, Integer> getTextureSize() {
            return this.textureSize;
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        @NotNull
        public final TextureRegion component2() {
            return this.texture;
        }

        @NotNull
        public final List<Tag> component3() {
            return this.tags;
        }

        @NotNull
        public final TextureMeta copy(@NotNull String name, @NotNull TextureRegion texture, @NotNull List<? extends Tag> tags) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)texture, (String)"texture");
            Intrinsics.checkNotNullParameter(tags, (String)"tags");
            return new TextureMeta(name, texture, tags);
        }

        public static /* synthetic */ TextureMeta copy$default(TextureMeta textureMeta, String string, TextureRegion textureRegion, List list, int n, Object object) {
            if ((n & 1) != 0) {
                string = textureMeta.name;
            }
            if ((n & 2) != 0) {
                textureRegion = textureMeta.texture;
            }
            if ((n & 4) != 0) {
                list = textureMeta.tags;
            }
            return textureMeta.copy(string, textureRegion, list);
        }

        @NotNull
        public String toString() {
            return "TextureMeta(name=" + this.name + ", texture=" + this.texture + ", tags=" + this.tags + ')';
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = result * 31 + this.texture.hashCode();
            result = result * 31 + ((Object)this.tags).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TextureMeta)) {
                return false;
            }
            TextureMeta textureMeta = (TextureMeta)other;
            if (!Intrinsics.areEqual((Object)this.name, (Object)textureMeta.name)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.texture, (Object)textureMeta.texture)) {
                return false;
            }
            return Intrinsics.areEqual(this.tags, textureMeta.tags);
        }
    }
}

