/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.engine.tools.editor.area;

import com.badlogic.gdx.math.Vector2;
import java.io.File;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.veiset.kgame.engine.EngineConfig;
import org.veiset.kgame.engine.Log;
import org.veiset.kgame.engine.tools.editor.area.AreaData;
import org.veiset.kgame.engine.tools.editor.area.AreaEntityData;
import org.veiset.kgame.engine.tools.editor.area.AreaEntityKt;
import org.veiset.kgame.engine.tools.editor.area.AreaResource;
import org.veiset.kgame.engine.tools.editor.area.AreaResourceKt;
import org.veiset.kgame.engine.tools.editor.area.CollisionEntityData;
import org.veiset.kgame.engine.tools.editor.area.GraphicEntityData;
import org.veiset.kgame.engine.tools.editor.area.components.AreaMetaInfo;
import org.veiset.kgame.engine.tools.editor.area.components.SceneContainer;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0003J\u0013\u0010\u0015\u001a\u00020\u00132\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0014\u001a\u00020\u0003J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u001b\u001a\u00020\u0003H\u0002J\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u001d\u001a\u00020\u0003J.\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0014\u001a\u00020\u00032\u000e\b\u0002\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00030\u000e2\u0006\u0010#\u001a\u00020$J\t\u0010%\u001a\u00020\u0003H\u00d6\u0001J\b\u0010&\u001a\u00020\u001fH\u0002R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\f\u001a\n \u0007*\u0004\u0018\u00010\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lorg/veiset/kgame/engine/tools/editor/area/AreaResource;", "", "folder", "", "(Ljava/lang/String;)V", "classLoader", "Ljava/lang/ClassLoader;", "kotlin.jvm.PlatformType", "directory", "Ljava/io/File;", "getFolder", "()Ljava/lang/String;", "projectPath", "all", "", "Lorg/veiset/kgame/engine/tools/editor/area/AreaData;", "component1", "copy", "delete", "", "name", "equals", "other", "hashCode", "", "load", "loadDataFromText", "data", "loadResource", "resourcePath", "save", "", "scene", "Lorg/veiset/kgame/engine/tools/editor/area/components/SceneContainer;", "tags", "areaMetaInfo", "Lorg/veiset/kgame/engine/tools/editor/area/components/AreaMetaInfo;", "toString", "writeResourceFile", "kgame2"})
public final class AreaResource {
    @NotNull
    private final String folder;
    private final String projectPath;
    @NotNull
    private final File directory;
    private final ClassLoader classLoader;

    public AreaResource(@NotNull String folder) {
        Intrinsics.checkNotNullParameter((Object)folder, (String)"folder");
        this.folder = folder;
        this.projectPath = new File("").getAbsolutePath();
        this.directory = new File(this.projectPath + "/src/main/resources/" + this.folder);
        this.classLoader = this.getClass().getClassLoader();
    }

    @NotNull
    public final String getFolder() {
        return this.folder;
    }

    public final void save(@NotNull SceneContainer scene, @NotNull String name, @NotNull List<String> tags, @NotNull AreaMetaInfo areaMetaInfo) {
        Intrinsics.checkNotNullParameter((Object)scene, (String)"scene");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(tags, (String)"tags");
        Intrinsics.checkNotNullParameter((Object)areaMetaInfo, (String)"areaMetaInfo");
        if (((CharSequence)name).length() == 0) {
            Log.INSTANCE.warn("Empty filename when saving. Aborting");
            return;
        }
        String saveString = AreaResourceKt.access$generateSaveString(scene, name, tags, areaMetaInfo);
        File file = new File(this.directory + '/' + name + ".area");
        if (file.exists()) {
            Log.INSTANCE.warn("Overwriting file: '" + name + ".area'");
        } else {
            file.createNewFile();
        }
        SceneContainer.BoundingBox gridbox = SceneContainer.gridBox$default(scene, 0.0f, 1, null);
        Log.INSTANCE.info("Writing Area to '" + name + ".area' with " + scene.getItems().size() + " entities, gridbox: " + gridbox.getSize().x + ", " + gridbox.getSize().y);
        FilesKt.writeText$default((File)file, (String)saveString, null, (int)2, null);
        this.writeResourceFile();
    }

    public static /* synthetic */ void save$default(AreaResource areaResource, SceneContainer sceneContainer, String string, List list, AreaMetaInfo areaMetaInfo, int n, Object object) {
        if ((n & 4) != 0) {
            list = CollectionsKt.emptyList();
        }
        areaResource.save(sceneContainer, string, list, areaMetaInfo);
    }

    private final void writeResourceFile() {
        List areas2 = SequencesKt.toList((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.filter((Sequence)((Sequence)FilesKt.walkTopDown((File)this.directory)), (Function1)writeResourceFile.areas.1.INSTANCE), (Function1)writeResourceFile.areas.2.INSTANCE));
        File file = new File(this.directory + "/area.resource");
        if (file.exists()) {
            Log.INSTANCE.warn("Overwriting file: 'area.resource'");
        } else {
            file.createNewFile();
        }
        Log.INSTANCE.info("Writing area resource file with " + areas2.size() + " areas");
        FilesKt.writeText$default((File)file, (String)CollectionsKt.joinToString$default((Iterable)areas2, (CharSequence)"\n", null, null, (int)0, null, (Function1)((Function1)new Function1<String, CharSequence>(this){
            final /* synthetic */ AreaResource this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return this.this$0.getFolder() + '/' + it;
            }
        }), (int)30, null), null, (int)2, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<AreaData> all() {
        List list;
        if (EngineConfig.Engine.INSTANCE.getPRODUCTION_MODE()) {
            List list2;
            List areas2;
            Object object;
            List list3;
            String[] stringArray = this.classLoader.getResource(Intrinsics.stringPlus((String)this.folder, (Object)"/area.resource"));
            if (stringArray == null) {
                list3 = null;
            } else {
                String[] stringArray2 = stringArray;
                Charset charset = Charsets.UTF_8;
                object = TextStreamsKt.readBytes((URL)stringArray2);
                String string = new String((byte[])object, charset);
                stringArray2 = new String[]{"\n"};
                list3 = StringsKt.split$default((CharSequence)string, (String[])stringArray2, (boolean)false, (int)0, (int)6, null);
            }
            List list4 = areas2 = list3;
            if (list4 == null) {
                list2 = null;
            } else {
                void $this$mapNotNullTo$iv$iv;
                Iterable $this$mapNotNull$iv = list4;
                boolean $i$f$mapNotNull = false;
                object = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    AreaData it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl = false;
                    String it = (String)element$iv$iv;
                    boolean bl2 = false;
                    if (this.loadResource(it) == null) continue;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                list2 = (List)destination$iv$iv;
            }
            List list5 = list2;
            list = list5 == null ? CollectionsKt.emptyList() : list5;
        } else {
            list = SequencesKt.toList((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.filter((Sequence)((Sequence)FilesKt.walkTopDown((File)this.directory)), (Function1)all.2.INSTANCE), (Function1)((Function1)new Function1<File, AreaData>(this){
                final /* synthetic */ AreaResource this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @Nullable
                public final AreaData invoke(@NotNull File it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    String string = it.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.name");
                    return this.this$0.load(StringsKt.dropLast((String)string, (int)5));
                }
            })));
        }
        return list;
    }

    @Nullable
    public final AreaData loadResource(@NotNull String resourcePath) {
        Intrinsics.checkNotNullParameter((Object)resourcePath, (String)"resourcePath");
        URL resource = this.classLoader.getResource(resourcePath);
        Log.INSTANCE.info("Loading resource: '" + resourcePath + '\'');
        Intrinsics.checkNotNullExpressionValue((Object)resource, (String)"resource");
        URL uRL = resource;
        Charset charset = Charsets.UTF_8;
        byte[] byArray = TextStreamsKt.readBytes((URL)uRL);
        String data = new String(byArray, charset);
        return this.loadDataFromText(data);
    }

    @Nullable
    public final AreaData load(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        File file = new File(this.directory + '/' + name + ".area");
        if (!file.exists()) {
            Log.INSTANCE.warn("No such file, cannot load: '" + name + ".area'");
            return null;
        }
        String data = FilesKt.readText$default((File)file, null, (int)1, null);
        return this.loadDataFromText(data);
    }

    public final boolean delete(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Log.INSTANCE.info("Deleting '" + name + ".area'");
        File file = new File(this.directory + '/' + name + ".area");
        if (!file.exists()) {
            Log.INSTANCE.warn("No such file, cannot delete: '" + name + ".area'");
            return false;
        }
        return file.delete();
    }

    /*
     * WARNING - void declaration
     */
    private final AreaData loadDataFromText(String data) {
        List list;
        void $this$mapTo$iv$iv;
        if (((CharSequence)data).length() == 0) {
            return null;
        }
        String[] stringArray = new String[]{"\n"};
        List lines = StringsKt.split$default((CharSequence)data, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        Map<String, String> metadata2 = AreaEntityKt.dataMapFromStr((String)CollectionsKt.first((List)lines));
        Iterable $this$map$iv = CollectionsKt.drop((Iterable)lines, (int)1);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Object destination$iv$iv = (String[])new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            AreaEntityData areaEntityData;
            void it;
            String string = (String)item$iv$iv;
            String[] stringArray2 = destination$iv$iv;
            boolean bl = false;
            if (StringsKt.startsWith$default((String)it, (String)"gfx", (boolean)false, (int)2, null)) {
                areaEntityData = GraphicEntityData.Companion.fromString((String)it);
            } else if (StringsKt.startsWith$default((String)it, (String)"collision", (boolean)false, (int)2, null)) {
                areaEntityData = CollisionEntityData.Companion.fromString((String)it);
            } else {
                throw new Exception("Oof");
            }
            stringArray2.add(areaEntityData);
        }
        List entities2 = (List)destination$iv$iv;
        String string = metadata2.get("name");
        Intrinsics.checkNotNull((Object)string);
        String string2 = string;
        String string3 = metadata2.get("tags");
        if (string3 == null) {
            list = null;
        } else {
            destination$iv$iv = new String[]{","};
            List list2 = StringsKt.split$default((CharSequence)string3, (String[])destination$iv$iv, (boolean)false, (int)0, (int)6, null);
            if (list2 == null) {
                list = null;
            } else {
                void $this$mapTo$iv$iv2;
                void $this$map$iv2;
                destination$iv$iv = list2;
                String string4 = string2;
                boolean $i$f$map2 = false;
                Iterator iterator = $this$map$iv2;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                    void it;
                    String string5 = (String)item$iv$iv;
                    Collection collection = destination$iv$iv2;
                    boolean bl = false;
                    collection.add(((Object)StringsKt.trim((CharSequence)((CharSequence)it))).toString());
                }
                list = (List)destination$iv$iv2;
                string2 = string4;
            }
        }
        List list3 = list;
        if (list == null) {
            list3 = CollectionsKt.emptyList();
        }
        String string6 = metadata2.get("position");
        Intrinsics.checkNotNull((Object)string6);
        Vector2 vector2 = AreaResourceKt.toVector2(string6);
        Intrinsics.checkNotNull((Object)vector2);
        String string7 = metadata2.get("size");
        Intrinsics.checkNotNull((Object)string7);
        Vector2 vector22 = AreaResourceKt.toVector2(string7);
        Intrinsics.checkNotNull((Object)vector22);
        String string8 = metadata2.get("gridsize");
        Intrinsics.checkNotNull((Object)string8);
        Vector2 vector23 = AreaResourceKt.toVector2(string8);
        Intrinsics.checkNotNull((Object)vector23);
        String string9 = metadata2.get("weight");
        Intrinsics.checkNotNull((Object)string9);
        int n = Integer.parseInt(string9);
        String string10 = metadata2.get("maxOcc");
        Intrinsics.checkNotNull((Object)string10);
        int n2 = Integer.parseInt(string10);
        String string11 = metadata2.get("minMapTier");
        Intrinsics.checkNotNull((Object)string11);
        int n3 = Integer.parseInt(string11);
        String string12 = metadata2.get("maxMapTier");
        Intrinsics.checkNotNull((Object)string12);
        AreaMetaInfo areaMetaInfo = new AreaMetaInfo(n, n2, n3, Integer.parseInt(string12));
        List list4 = entities2;
        Vector2 vector24 = vector23;
        Vector2 vector25 = vector22;
        Vector2 vector26 = vector2;
        List list5 = list3;
        String string13 = string2;
        return new AreaData(string13, list5, vector26, vector25, vector24, list4, areaMetaInfo);
    }

    @NotNull
    public final String component1() {
        return this.folder;
    }

    @NotNull
    public final AreaResource copy(@NotNull String folder) {
        Intrinsics.checkNotNullParameter((Object)folder, (String)"folder");
        return new AreaResource(folder);
    }

    public static /* synthetic */ AreaResource copy$default(AreaResource areaResource, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = areaResource.folder;
        }
        return areaResource.copy(string);
    }

    @NotNull
    public String toString() {
        return "AreaResource(folder=" + this.folder + ')';
    }

    public int hashCode() {
        return this.folder.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AreaResource)) {
            return false;
        }
        AreaResource areaResource = (AreaResource)other;
        return Intrinsics.areEqual((Object)this.folder, (Object)areaResource.folder);
    }
}

