/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.engine.tools.editor.area;

import com.badlogic.gdx.math.Vector2;
import java.time.LocalDateTime;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.veiset.kgame.engine.math.MathUtilsKt;
import org.veiset.kgame.engine.tools.editor.area.AreaResourceKt;
import org.veiset.kgame.engine.tools.editor.area.components.AreaMetaInfo;
import org.veiset.kgame.engine.tools.editor.area.components.SceneContainer;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000J\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\u001a.\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\t2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a-\u0010\u0011\u001a\u00020\u0012\"\u0004\b\u0000\u0010\u0013*\u0004\u0018\u0001H\u00132\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u0002H\u0013\u0012\u0004\u0012\u00020\u00120\u0015H\u0000\u00a2\u0006\u0002\u0010\u0016\u001a\f\u0010\u0017\u001a\u00020\t*\u00020\u0018H\u0000\u001a\u0013\u0010\u0019\u001a\u0004\u0018\u00010\u001a*\u00020\tH\u0000\u00a2\u0006\u0002\u0010\u001b\u001a\u0013\u0010\u001c\u001a\u0004\u0018\u00010\u001d*\u00020\tH\u0000\u00a2\u0006\u0002\u0010\u001e\u001a\u000e\u0010\u001f\u001a\u0004\u0018\u00010\u0018*\u00020\tH\u0000\"\u0014\u0010\u0000\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u0014\u0010\u0004\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0003\"\u0014\u0010\u0006\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u0003\u00a8\u0006 "}, d2={"validFloat", "Lkotlin/text/Regex;", "getValidFloat", "()Lkotlin/text/Regex;", "validInt", "getValidInt", "validVector2Format", "getValidVector2Format", "generateSaveString", "", "scene", "Lorg/veiset/kgame/engine/tools/editor/area/components/SceneContainer;", "name", "tags", "", "areaMetaInfo", "Lorg/veiset/kgame/engine/tools/editor/area/components/AreaMetaInfo;", "ifNotNull", "", "T", "f", "Lkotlin/Function1;", "(Ljava/lang/Object;Lkotlin/jvm/functions/Function1;)V", "toEditStr", "Lcom/badlogic/gdx/math/Vector2;", "toValidFloat", "", "(Ljava/lang/String;)Ljava/lang/Float;", "toValidInt", "", "(Ljava/lang/String;)Ljava/lang/Integer;", "toVector2", "kgame2"})
public final class AreaResourceKt {
    @NotNull
    private static final Regex validVector2Format = new Regex("(-?\\d+(?:\\.\\d+)?),\\s?(-?\\d+(?:\\.\\d+)?)");
    @NotNull
    private static final Regex validFloat = new Regex("(\\d+(?:\\.\\d+)?)");
    @NotNull
    private static final Regex validInt = new Regex("(-?\\d+)");

    @NotNull
    public static final Regex getValidVector2Format() {
        return validVector2Format;
    }

    @NotNull
    public static final Regex getValidFloat() {
        return validFloat;
    }

    @NotNull
    public static final Regex getValidInt() {
        return validInt;
    }

    @NotNull
    public static final String toEditStr(@NotNull Vector2 $this$toEditStr) {
        Intrinsics.checkNotNullParameter((Object)$this$toEditStr, (String)"<this>");
        return MathUtilsKt.round($this$toEditStr.x, 3) + ", " + MathUtilsKt.round($this$toEditStr.y, 3);
    }

    @Nullable
    public static final Vector2 toVector2(@NotNull String $this$toVector2) {
        Intrinsics.checkNotNullParameter((Object)$this$toVector2, (String)"<this>");
        MatchResult matchResult = Regex.find$default((Regex)validVector2Format, (CharSequence)$this$toVector2, (int)0, (int)2, null);
        if (matchResult == null) {
            return null;
        }
        MatchResult match = matchResult;
        MatchResult.Destructured destructured = match.getDestructured();
        String x = (String)destructured.getMatch().getGroupValues().get(1);
        String y = (String)destructured.getMatch().getGroupValues().get(2);
        return new Vector2(Float.parseFloat(x), Float.parseFloat(y));
    }

    @Nullable
    public static final Integer toValidInt(@NotNull String $this$toValidInt) {
        Intrinsics.checkNotNullParameter((Object)$this$toValidInt, (String)"<this>");
        MatchResult matchResult = Regex.find$default((Regex)validInt, (CharSequence)$this$toValidInt, (int)0, (int)2, null);
        if (matchResult == null) {
            return null;
        }
        MatchResult match = matchResult;
        return Integer.parseInt((String)match.getGroupValues().get(0));
    }

    @Nullable
    public static final Float toValidFloat(@NotNull String $this$toValidFloat) {
        Intrinsics.checkNotNullParameter((Object)$this$toValidFloat, (String)"<this>");
        MatchResult matchResult = Regex.find$default((Regex)validFloat, (CharSequence)$this$toValidFloat, (int)0, (int)2, null);
        if (matchResult == null) {
            return null;
        }
        MatchResult match = matchResult;
        return Float.valueOf(Float.parseFloat((String)match.getGroupValues().get(0)));
    }

    public static final <T> void ifNotNull(@Nullable T $this$ifNotNull, @NotNull Function1<? super T, Unit> f) {
        Intrinsics.checkNotNullParameter(f, (String)"f");
        T t = $this$ifNotNull;
        if (t == null) {
            return;
        }
        f.invoke(t);
    }

    private static final String generateSaveString(SceneContainer scene, String name, List<String> tags, AreaMetaInfo areaMetaInfo) {
        SceneContainer.BoundingBox boundingBox = scene.boundingBox();
        SceneContainer.BoundingBox gridBox = SceneContainer.gridBox$default(scene, 0.0f, 1, null);
        String[] stringArray = new StringBuilder();
        stringArray.append("\n            meta\n            |engine.gridsize=0.53333336\n            |name=").append(name).append("\n            |tags=").append(CollectionsKt.joinToString$default((Iterable)tags, (CharSequence)",", null, null, (int)0, null, (Function1)generateSaveString.metadata.1.INSTANCE, (int)30, null)).append("\n            |position=").append(boundingBox.getPos().x).append(',').append(boundingBox.getPos().y).append("\n            |size=").append(boundingBox.getSize().x).append(',').append(boundingBox.getSize().y).append("\n            |gridsize=").append(gridBox.getSize().x).append(',').append(gridBox.getSize().y).append("\n            |modified=").append(LocalDateTime.now()).append("\n            |weight=").append(areaMetaInfo.getWeight()).append("\n            |maxOcc=").append(areaMetaInfo.getMaxOcc()).append("\n            |minMapTier=");
        stringArray.append(areaMetaInfo.getMinMapTier()).append("\n            |maxMapTier=").append(areaMetaInfo.getMaxMapTier()).append("\n        ");
        CharSequence charSequence = StringsKt.trimIndent((String)stringArray.toString());
        stringArray = new String[]{"\n"};
        String metadata2 = CollectionsKt.joinToString$default((Iterable)StringsKt.split$default((CharSequence)charSequence, (String[])stringArray, (boolean)false, (int)0, (int)6, null), (CharSequence)"", null, null, (int)0, null, (Function1)generateSaveString.metadata.2.INSTANCE, (int)30, null);
        String entities2 = CollectionsKt.joinToString$default((Iterable)scene.getItems(), (CharSequence)"\n", null, null, (int)0, null, (Function1)generateSaveString.entities.1.INSTANCE, (int)30, null);
        return metadata2 + '\n' + entities2;
    }

    public static final /* synthetic */ String access$generateSaveString(SceneContainer scene, String name, List tags, AreaMetaInfo areaMetaInfo) {
        return AreaResourceKt.generateSaveString(scene, name, tags, areaMetaInfo);
    }
}

