/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.engine.tools.editor.area;

import com.badlogic.gdx.math.Vector2;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.veiset.kgame.engine.math.Vector2Kt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0017\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\bH\u00c6\u0003J1\u0010\u001a\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u000e\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u0006J\u0013\u0010\u001d\u001a\u00020\u00062\b\u0010\u001e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001f\u001a\u00020 H\u00d6\u0001J\t\u0010!\u001a\u00020\bH\u00d6\u0001R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0011\"\u0004\b\u0015\u0010\u0013\u00a8\u0006\""}, d2={"Lorg/veiset/kgame/engine/tools/editor/area/BaseEntityData;", "", "position", "Lcom/badlogic/gdx/math/Vector2;", "size", "boundingBox", "", "id", "", "(Lcom/badlogic/gdx/math/Vector2;Lcom/badlogic/gdx/math/Vector2;ZLjava/lang/String;)V", "getBoundingBox", "()Z", "setBoundingBox", "(Z)V", "getId", "()Ljava/lang/String;", "getPosition", "()Lcom/badlogic/gdx/math/Vector2;", "setPosition", "(Lcom/badlogic/gdx/math/Vector2;)V", "getSize", "setSize", "component1", "component2", "component3", "component4", "copy", "deepCopy", "newId", "equals", "other", "hashCode", "", "toString", "kgame2"})
public final class BaseEntityData {
    @NotNull
    private Vector2 position;
    @NotNull
    private Vector2 size;
    private boolean boundingBox;
    @NotNull
    private final String id;

    public BaseEntityData(@NotNull Vector2 position, @NotNull Vector2 size, boolean boundingBox, @NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Intrinsics.checkNotNullParameter((Object)size, (String)"size");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this.position = position;
        this.size = size;
        this.boundingBox = boundingBox;
        this.id = id;
    }

    public /* synthetic */ BaseEntityData(Vector2 vector2, Vector2 vector22, boolean bl, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            String string2 = UUID.randomUUID().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"randomUUID().toString()");
            string = Intrinsics.stringPlus((String)"entity_", (Object)StringsKt.drop((String)string2, (int)15));
        }
        this(vector2, vector22, bl, string);
    }

    @NotNull
    public final Vector2 getPosition() {
        return this.position;
    }

    public final void setPosition(@NotNull Vector2 vector2) {
        Intrinsics.checkNotNullParameter((Object)vector2, (String)"<set-?>");
        this.position = vector2;
    }

    @NotNull
    public final Vector2 getSize() {
        return this.size;
    }

    public final void setSize(@NotNull Vector2 vector2) {
        Intrinsics.checkNotNullParameter((Object)vector2, (String)"<set-?>");
        this.size = vector2;
    }

    public final boolean getBoundingBox() {
        return this.boundingBox;
    }

    public final void setBoundingBox(boolean bl) {
        this.boundingBox = bl;
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    @NotNull
    public final BaseEntityData deepCopy(boolean newId) {
        String string;
        Vector2 vector2 = Vector2Kt.copy(this.position);
        Vector2 vector22 = Vector2Kt.copy(this.size);
        if (newId) {
            String string2 = UUID.randomUUID().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"randomUUID().toString()");
            string = StringsKt.drop((String)string2, (int)10);
        } else {
            string = this.id;
        }
        return new BaseEntityData(vector2, vector22, this.boundingBox, string);
    }

    @NotNull
    public final Vector2 component1() {
        return this.position;
    }

    @NotNull
    public final Vector2 component2() {
        return this.size;
    }

    public final boolean component3() {
        return this.boundingBox;
    }

    @NotNull
    public final String component4() {
        return this.id;
    }

    @NotNull
    public final BaseEntityData copy(@NotNull Vector2 position, @NotNull Vector2 size, boolean boundingBox, @NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Intrinsics.checkNotNullParameter((Object)size, (String)"size");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return new BaseEntityData(position, size, boundingBox, id);
    }

    public static /* synthetic */ BaseEntityData copy$default(BaseEntityData baseEntityData, Vector2 vector2, Vector2 vector22, boolean bl, String string, int n, Object object) {
        if ((n & 1) != 0) {
            vector2 = baseEntityData.position;
        }
        if ((n & 2) != 0) {
            vector22 = baseEntityData.size;
        }
        if ((n & 4) != 0) {
            bl = baseEntityData.boundingBox;
        }
        if ((n & 8) != 0) {
            string = baseEntityData.id;
        }
        return baseEntityData.copy(vector2, vector22, bl, string);
    }

    @NotNull
    public String toString() {
        return "BaseEntityData(position=" + this.position + ", size=" + this.size + ", boundingBox=" + this.boundingBox + ", id=" + this.id + ')';
    }

    public int hashCode() {
        int result = this.position.hashCode();
        result = result * 31 + this.size.hashCode();
        int n = this.boundingBox ? 1 : 0;
        if (n != 0) {
            n = 1;
        }
        result = result * 31 + n;
        result = result * 31 + this.id.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof BaseEntityData)) {
            return false;
        }
        BaseEntityData baseEntityData = (BaseEntityData)other;
        if (!Intrinsics.areEqual((Object)this.position, (Object)baseEntityData.position)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.size, (Object)baseEntityData.size)) {
            return false;
        }
        if (this.boundingBox != baseEntityData.boundingBox) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.id, (Object)baseEntityData.id);
    }
}

