/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.engine.tools.editor.area;

import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Vector2;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.veiset.kgame.engine.Log;
import org.veiset.kgame.engine.TBEngineKt;
import org.veiset.kgame.engine.asset.AssetManager;
import org.veiset.kgame.engine.math.Vector2Kt;
import org.veiset.kgame.engine.storage.TextureMetaStore;
import org.veiset.kgame.engine.tools.editor.area.AreaEntityData;
import org.veiset.kgame.engine.tools.editor.area.AreaEntityKt;
import org.veiset.kgame.engine.tools.editor.area.AreaResourceKt;
import org.veiset.kgame.engine.tools.editor.area.BaseEntityData;
import org.veiset.kgame.engine.tools.editor.area.GraphicEntity;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b.\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\b\u0018\u0000 H2\u00020\u0001:\u0001HB_\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000b\u0012\u0006\u0010\u000f\u001a\u00020\u000b\u0012\u0006\u0010\u0010\u001a\u00020\u0006\u0012\u0006\u0010\u0011\u001a\u00020\r\u00a2\u0006\u0002\u0010\u0012J\t\u00104\u001a\u00020\u0003H\u00c6\u0003J\t\u00105\u001a\u00020\u0006H\u00c6\u0003J\t\u00106\u001a\u00020\rH\u00c6\u0003J\t\u00107\u001a\u00020\u0003H\u00c6\u0003J\t\u00108\u001a\u00020\u0006H\u00c6\u0003J\t\u00109\u001a\u00020\u0006H\u00c6\u0003J\t\u0010:\u001a\u00020\tH\u00c6\u0003J\t\u0010;\u001a\u00020\u000bH\u00c6\u0003J\t\u0010<\u001a\u00020\rH\u00c6\u0003J\t\u0010=\u001a\u00020\u000bH\u00c6\u0003J\t\u0010>\u001a\u00020\u000bH\u00c6\u0003Jw\u0010?\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000b2\b\b\u0002\u0010\u000f\u001a\u00020\u000b2\b\b\u0002\u0010\u0010\u001a\u00020\u00062\b\b\u0002\u0010\u0011\u001a\u00020\rH\u00c6\u0001J\u0010\u0010@\u001a\u00020\u00002\b\b\u0002\u0010\u0005\u001a\u00020\u0006J\u0013\u0010A\u001a\u00020\r2\b\u0010B\u001a\u0004\u0018\u00010CH\u00d6\u0003J\t\u0010D\u001a\u00020\tH\u00d6\u0001J\u0006\u0010E\u001a\u00020FJ\t\u0010G\u001a\u00020\u0003H\u00d6\u0001R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010\u0016\"\u0004\b(\u0010\u0018R\u001a\u0010\u0010\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010$\"\u0004\b*\u0010&R\u001a\u0010\u000e\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010 \"\u0004\b,\u0010\"R\u001a\u0010\u000f\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010 \"\u0004\b.\u0010\"R\u001a\u0010\u0007\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u0010$\"\u0004\b0\u0010&R\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u0010\u001a\"\u0004\b2\u00103\u00a8\u0006I"}, d2={"Lorg/veiset/kgame/engine/tools/editor/area/GraphicEntityData;", "Lorg/veiset/kgame/engine/tools/editor/area/AreaEntityData;", "id", "", "textureId", "position", "Lcom/badlogic/gdx/math/Vector2;", "size", "layer", "", "opacity", "", "shadow", "", "shadowOpacity", "shadowSize", "shadowOffset", "boundingBox", "(Ljava/lang/String;Ljava/lang/String;Lcom/badlogic/gdx/math/Vector2;Lcom/badlogic/gdx/math/Vector2;IFZFFLcom/badlogic/gdx/math/Vector2;Z)V", "am", "Lorg/veiset/kgame/engine/asset/AssetManager;", "getBoundingBox", "()Z", "setBoundingBox", "(Z)V", "getId", "()Ljava/lang/String;", "getLayer", "()I", "setLayer", "(I)V", "getOpacity", "()F", "setOpacity", "(F)V", "getPosition", "()Lcom/badlogic/gdx/math/Vector2;", "setPosition", "(Lcom/badlogic/gdx/math/Vector2;)V", "getShadow", "setShadow", "getShadowOffset", "setShadowOffset", "getShadowOpacity", "setShadowOpacity", "getShadowSize", "setShadowSize", "getSize", "setSize", "getTextureId", "setTextureId", "(Ljava/lang/String;)V", "component1", "component10", "component11", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "deepCopy", "equals", "other", "", "hashCode", "toGraphicalEntity", "Lorg/veiset/kgame/engine/tools/editor/area/GraphicEntity;", "toString", "Companion", "kgame2"})
public final class GraphicEntityData
extends AreaEntityData {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String id;
    @NotNull
    private String textureId;
    @NotNull
    private Vector2 position;
    @NotNull
    private Vector2 size;
    private int layer;
    private float opacity;
    private boolean shadow;
    private float shadowOpacity;
    private float shadowSize;
    @NotNull
    private Vector2 shadowOffset;
    private boolean boundingBox;
    @NotNull
    private final AssetManager am;

    public GraphicEntityData(@NotNull String id, @NotNull String textureId, @NotNull Vector2 position, @NotNull Vector2 size, int layer, float opacity, boolean shadow, float shadowOpacity, float shadowSize, @NotNull Vector2 shadowOffset, boolean boundingBox) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)textureId, (String)"textureId");
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Intrinsics.checkNotNullParameter((Object)size, (String)"size");
        Intrinsics.checkNotNullParameter((Object)shadowOffset, (String)"shadowOffset");
        super(null);
        this.id = id;
        this.textureId = textureId;
        this.position = position;
        this.size = size;
        this.layer = layer;
        this.opacity = opacity;
        this.shadow = shadow;
        this.shadowOpacity = shadowOpacity;
        this.shadowSize = shadowSize;
        this.shadowOffset = shadowOffset;
        this.boundingBox = boundingBox;
        this.am = TBEngineKt.getGlobals().getAssetManager();
    }

    public /* synthetic */ GraphicEntityData(String string, String string2, Vector2 vector2, Vector2 vector22, int n, float f, boolean bl, float f2, float f3, Vector2 vector23, boolean bl2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            String string3 = UUID.randomUUID().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"randomUUID().toString()");
            string = Intrinsics.stringPlus((String)"entity_", (Object)StringsKt.drop((String)string3, (int)15));
        }
        this(string, string2, vector2, vector22, n, f, bl, f2, f3, vector23, bl2);
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    @NotNull
    public final String getTextureId() {
        return this.textureId;
    }

    public final void setTextureId(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.textureId = string;
    }

    @NotNull
    public final Vector2 getPosition() {
        return this.position;
    }

    public final void setPosition(@NotNull Vector2 vector2) {
        Intrinsics.checkNotNullParameter((Object)vector2, (String)"<set-?>");
        this.position = vector2;
    }

    @NotNull
    public final Vector2 getSize() {
        return this.size;
    }

    public final void setSize(@NotNull Vector2 vector2) {
        Intrinsics.checkNotNullParameter((Object)vector2, (String)"<set-?>");
        this.size = vector2;
    }

    public final int getLayer() {
        return this.layer;
    }

    public final void setLayer(int n) {
        this.layer = n;
    }

    public final float getOpacity() {
        return this.opacity;
    }

    public final void setOpacity(float f) {
        this.opacity = f;
    }

    public final boolean getShadow() {
        return this.shadow;
    }

    public final void setShadow(boolean bl) {
        this.shadow = bl;
    }

    public final float getShadowOpacity() {
        return this.shadowOpacity;
    }

    public final void setShadowOpacity(float f) {
        this.shadowOpacity = f;
    }

    public final float getShadowSize() {
        return this.shadowSize;
    }

    public final void setShadowSize(float f) {
        this.shadowSize = f;
    }

    @NotNull
    public final Vector2 getShadowOffset() {
        return this.shadowOffset;
    }

    public final void setShadowOffset(@NotNull Vector2 vector2) {
        Intrinsics.checkNotNullParameter((Object)vector2, (String)"<set-?>");
        this.shadowOffset = vector2;
    }

    public final boolean getBoundingBox() {
        return this.boundingBox;
    }

    public final void setBoundingBox(boolean bl) {
        this.boundingBox = bl;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final GraphicEntity toGraphicalEntity() {
        TextureRegion textureRegion;
        void id$iv;
        Object object = Vector2Kt.copy(this.position);
        Object object2 = Vector2Kt.copy(this.size);
        String string = this.id;
        boolean bl = this.boundingBox;
        BaseEntityData baseEntityData = new BaseEntityData((Vector2)object, (Vector2)object2, bl, string);
        object = this.am;
        object2 = this.textureId;
        String string2 = this.textureId;
        BaseEntityData baseEntityData2 = baseEntityData;
        boolean $i$f$getById = false;
        try {
            void this_$iv;
            Object object3 = this_$iv.getAssetsIdMap().get(id$iv);
            if (object3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.badlogic.gdx.graphics.g2d.TextureRegion");
            }
            textureRegion = (TextureRegion)object3;
        }
        catch (Exception ex$iv) {
            Log.INSTANCE.critical("AssetRef id '" + (String)id$iv + "' not loaded");
            throw ex$iv;
        }
        TextureRegion textureRegion2 = textureRegion;
        List list = CollectionsKt.emptyList();
        TextureRegion textureRegion3 = textureRegion2;
        String string3 = string2;
        GraphicEntityData graphicEntityData = this;
        TextureMetaStore.TextureMeta textureMeta = new TextureMetaStore.TextureMeta(string3, textureRegion3, list);
        BaseEntityData baseEntityData3 = baseEntityData2;
        return new GraphicEntity(baseEntityData3, textureMeta, graphicEntityData);
    }

    @NotNull
    public final GraphicEntityData deepCopy(@NotNull Vector2 position) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        return new GraphicEntityData(this.id, this.textureId, Vector2Kt.copy(position), Vector2Kt.copy(this.size), this.layer, this.opacity, this.shadow, this.shadowOpacity, this.shadowSize, Vector2Kt.copy(this.shadowOffset), this.boundingBox);
    }

    public static /* synthetic */ GraphicEntityData deepCopy$default(GraphicEntityData graphicEntityData, Vector2 vector2, int n, Object object) {
        if ((n & 1) != 0) {
            vector2 = graphicEntityData.position;
        }
        return graphicEntityData.deepCopy(vector2);
    }

    @NotNull
    public final String component1() {
        return this.id;
    }

    @NotNull
    public final String component2() {
        return this.textureId;
    }

    @NotNull
    public final Vector2 component3() {
        return this.position;
    }

    @NotNull
    public final Vector2 component4() {
        return this.size;
    }

    public final int component5() {
        return this.layer;
    }

    public final float component6() {
        return this.opacity;
    }

    public final boolean component7() {
        return this.shadow;
    }

    public final float component8() {
        return this.shadowOpacity;
    }

    public final float component9() {
        return this.shadowSize;
    }

    @NotNull
    public final Vector2 component10() {
        return this.shadowOffset;
    }

    public final boolean component11() {
        return this.boundingBox;
    }

    @NotNull
    public final GraphicEntityData copy(@NotNull String id, @NotNull String textureId, @NotNull Vector2 position, @NotNull Vector2 size, int layer, float opacity, boolean shadow, float shadowOpacity, float shadowSize, @NotNull Vector2 shadowOffset, boolean boundingBox) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)textureId, (String)"textureId");
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Intrinsics.checkNotNullParameter((Object)size, (String)"size");
        Intrinsics.checkNotNullParameter((Object)shadowOffset, (String)"shadowOffset");
        return new GraphicEntityData(id, textureId, position, size, layer, opacity, shadow, shadowOpacity, shadowSize, shadowOffset, boundingBox);
    }

    public static /* synthetic */ GraphicEntityData copy$default(GraphicEntityData graphicEntityData, String string, String string2, Vector2 vector2, Vector2 vector22, int n, float f, boolean bl, float f2, float f3, Vector2 vector23, boolean bl2, int n2, Object object) {
        if ((n2 & 1) != 0) {
            string = graphicEntityData.id;
        }
        if ((n2 & 2) != 0) {
            string2 = graphicEntityData.textureId;
        }
        if ((n2 & 4) != 0) {
            vector2 = graphicEntityData.position;
        }
        if ((n2 & 8) != 0) {
            vector22 = graphicEntityData.size;
        }
        if ((n2 & 0x10) != 0) {
            n = graphicEntityData.layer;
        }
        if ((n2 & 0x20) != 0) {
            f = graphicEntityData.opacity;
        }
        if ((n2 & 0x40) != 0) {
            bl = graphicEntityData.shadow;
        }
        if ((n2 & 0x80) != 0) {
            f2 = graphicEntityData.shadowOpacity;
        }
        if ((n2 & 0x100) != 0) {
            f3 = graphicEntityData.shadowSize;
        }
        if ((n2 & 0x200) != 0) {
            vector23 = graphicEntityData.shadowOffset;
        }
        if ((n2 & 0x400) != 0) {
            bl2 = graphicEntityData.boundingBox;
        }
        return graphicEntityData.copy(string, string2, vector2, vector22, n, f, bl, f2, f3, vector23, bl2);
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("GraphicEntityData(id=").append(this.id).append(", textureId=").append(this.textureId).append(", position=").append(this.position).append(", size=").append(this.size).append(", layer=").append(this.layer).append(", opacity=").append(this.opacity).append(", shadow=").append(this.shadow).append(", shadowOpacity=").append(this.shadowOpacity).append(", shadowSize=").append(this.shadowSize).append(", shadowOffset=").append(this.shadowOffset).append(", boundingBox=").append(this.boundingBox).append(')');
        return stringBuilder.toString();
    }

    public int hashCode() {
        int result = this.id.hashCode();
        result = result * 31 + this.textureId.hashCode();
        result = result * 31 + this.position.hashCode();
        result = result * 31 + this.size.hashCode();
        result = result * 31 + Integer.hashCode(this.layer);
        result = result * 31 + Float.hashCode(this.opacity);
        int n = this.shadow ? 1 : 0;
        if (n != 0) {
            n = 1;
        }
        result = result * 31 + n;
        result = result * 31 + Float.hashCode(this.shadowOpacity);
        result = result * 31 + Float.hashCode(this.shadowSize);
        result = result * 31 + this.shadowOffset.hashCode();
        int n2 = this.boundingBox ? 1 : 0;
        if (n2 != 0) {
            n2 = 1;
        }
        result = result * 31 + n2;
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof GraphicEntityData)) {
            return false;
        }
        GraphicEntityData graphicEntityData = (GraphicEntityData)other;
        if (!Intrinsics.areEqual((Object)this.id, (Object)graphicEntityData.id)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.textureId, (Object)graphicEntityData.textureId)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.position, (Object)graphicEntityData.position)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.size, (Object)graphicEntityData.size)) {
            return false;
        }
        if (this.layer != graphicEntityData.layer) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)Float.valueOf(this.opacity), (Object)Float.valueOf(graphicEntityData.opacity))) {
            return false;
        }
        if (this.shadow != graphicEntityData.shadow) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)Float.valueOf(this.shadowOpacity), (Object)Float.valueOf(graphicEntityData.shadowOpacity))) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)Float.valueOf(this.shadowSize), (Object)Float.valueOf(graphicEntityData.shadowSize))) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.shadowOffset, (Object)graphicEntityData.shadowOffset)) {
            return false;
        }
        return this.boundingBox == graphicEntityData.boundingBox;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lorg/veiset/kgame/engine/tools/editor/area/GraphicEntityData$Companion;", "", "()V", "fromString", "Lorg/veiset/kgame/engine/tools/editor/area/GraphicEntityData;", "data", "", "kgame2"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final GraphicEntityData fromString(@NotNull String data) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            Map<String, String> attr = AreaEntityKt.dataMapFromStr(data);
            String string = attr.get("id");
            Intrinsics.checkNotNull((Object)string);
            String string2 = attr.get("textureId");
            Intrinsics.checkNotNull((Object)string2);
            String string3 = attr.get("position");
            Intrinsics.checkNotNull((Object)string3);
            Vector2 vector2 = AreaResourceKt.toVector2(string3);
            Intrinsics.checkNotNull((Object)vector2);
            String string4 = attr.get("size");
            Intrinsics.checkNotNull((Object)string4);
            Vector2 vector22 = AreaResourceKt.toVector2(string4);
            Intrinsics.checkNotNull((Object)vector22);
            String string5 = attr.get("layer");
            Intrinsics.checkNotNull((Object)string5);
            Integer n = AreaResourceKt.toValidInt(string5);
            Intrinsics.checkNotNull((Object)n);
            int n2 = n;
            String string6 = attr.getOrDefault("opacity", "1f");
            Intrinsics.checkNotNull((Object)string6);
            float f = Float.parseFloat(string6);
            boolean bl = Boolean.parseBoolean(attr.getOrDefault("shadow", "false"));
            String string7 = attr.getOrDefault("shadowOpacity", "0.5f");
            Intrinsics.checkNotNull((Object)string7);
            float f2 = Float.parseFloat(string7);
            String string8 = attr.getOrDefault("shadowSize", "0.5f");
            Intrinsics.checkNotNull((Object)string8);
            float f3 = Float.parseFloat(string8);
            String string9 = attr.getOrDefault("shadowOffset", "0,0");
            Intrinsics.checkNotNull((Object)string9);
            Vector2 vector23 = AreaResourceKt.toVector2(string9);
            Intrinsics.checkNotNull((Object)vector23);
            return new GraphicEntityData(string, string2, vector2, vector22, n2, f, bl, f2, f3, vector23, Boolean.parseBoolean(attr.getOrDefault("boundingBox", "true")));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

