/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.engine.tools.editor.area;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputProcessor;
import com.badlogic.gdx.math.Vector2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.veiset.kgame.engine.input.MouseKt;
import org.veiset.kgame.engine.math.Vector2Kt;
import org.veiset.kgame.engine.tools.editor.area.AreaEditorKt;
import org.veiset.kgame.engine.tools.editor.area.AreaEntity;
import org.veiset.kgame.engine.tools.editor.area.BaseEntityData;
import org.veiset.kgame.engine.tools.ui.UiComponentsKt;
import org.veiset.kgame.engine.tools.ui.components.CheckBox;
import org.veiset.kgame.engine.tools.ui.components.IconList;
import org.veiset.kgame.engine.tools.ui.components.InputField;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0014\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B7\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u000f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0006H\u00c6\u0003J\u000b\u0010\u001c\u001a\u0004\u0018\u00010\bH\u00c6\u0003J\t\u0010\u001d\u001a\u00020\nH\u00c6\u0003J\t\u0010\u001e\u001a\u00020\fH\u00c6\u0003JC\u0010\u001f\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\fH\u00c6\u0001J\u0013\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010#\u001a\u00020$H\u00d6\u0001J\t\u0010%\u001a\u00020&H\u00d6\u0001R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001c\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019\u00a8\u0006'"}, d2={"Lorg/veiset/kgame/engine/tools/editor/area/TextInputHandler;", "", "inputFields", "", "Lorg/veiset/kgame/engine/tools/ui/components/InputField;", "iconList", "Lorg/veiset/kgame/engine/tools/ui/components/IconList;", "sceneSelected", "Lorg/veiset/kgame/engine/tools/editor/area/AreaEntity;", "displayGrid", "Lorg/veiset/kgame/engine/tools/ui/components/CheckBox;", "gridSize", "", "(Ljava/util/List;Lorg/veiset/kgame/engine/tools/ui/components/IconList;Lorg/veiset/kgame/engine/tools/editor/area/AreaEntity;Lorg/veiset/kgame/engine/tools/ui/components/CheckBox;F)V", "getDisplayGrid", "()Lorg/veiset/kgame/engine/tools/ui/components/CheckBox;", "getGridSize", "()F", "getIconList", "()Lorg/veiset/kgame/engine/tools/ui/components/IconList;", "getInputFields", "()Ljava/util/List;", "getSceneSelected", "()Lorg/veiset/kgame/engine/tools/editor/area/AreaEntity;", "setSceneSelected", "(Lorg/veiset/kgame/engine/tools/editor/area/AreaEntity;)V", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "", "toString", "", "kgame2"})
public final class TextInputHandler {
    @NotNull
    private final List<InputField> inputFields;
    @NotNull
    private final IconList iconList;
    @Nullable
    private AreaEntity sceneSelected;
    @NotNull
    private final CheckBox displayGrid;
    private final float gridSize;

    public TextInputHandler(@NotNull List<InputField> inputFields, @NotNull IconList iconList, @Nullable AreaEntity sceneSelected, @NotNull CheckBox displayGrid, float gridSize) {
        Intrinsics.checkNotNullParameter(inputFields, (String)"inputFields");
        Intrinsics.checkNotNullParameter((Object)iconList, (String)"iconList");
        Intrinsics.checkNotNullParameter((Object)displayGrid, (String)"displayGrid");
        this.inputFields = inputFields;
        this.iconList = iconList;
        this.sceneSelected = sceneSelected;
        this.displayGrid = displayGrid;
        this.gridSize = gridSize;
        Gdx.input.setInputProcessor(new InputProcessor(){
            @Nullable
            private Vector2 clickPosOffset;
            @Nullable
            private AreaEntity draggingEntity;

            public boolean keyDown(int keycode) {
                return true;
            }

            public boolean keyUp(int keycode) {
                return true;
            }

            /*
             * WARNING - void declaration
             */
            public boolean keyTyped(char character) {
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv = this.getInputFields();
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    InputField it = (InputField)element$iv$iv;
                    boolean bl = false;
                    if (!it.getSelected()) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                Iterable $this$forEach$iv = (List)destination$iv$iv;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    InputField it = (InputField)element$iv;
                    boolean bl = false;
                    if (character == '\b') {
                        if (UiComponentsKt.controlDown()) {
                            it.setText("");
                            continue;
                        }
                        it.setText(StringsKt.dropLast((String)it.getText(), (int)1));
                        continue;
                    }
                    if (Character.isISOControl(character)) continue;
                    it.setText(Intrinsics.stringPlus((String)it.getText(), (Object)Character.valueOf(character)));
                }
                return true;
            }

            @Nullable
            public final Vector2 getClickPosOffset() {
                return this.clickPosOffset;
            }

            public final void setClickPosOffset(@Nullable Vector2 vector2) {
                this.clickPosOffset = vector2;
            }

            @Nullable
            public final AreaEntity getDraggingEntity() {
                return this.draggingEntity;
            }

            public final void setDraggingEntity(@Nullable AreaEntity areaEntity) {
                this.draggingEntity = areaEntity;
            }

            public boolean touchDown(int screenX, int screenY, int pointer, int button) {
                this.draggingEntity = null;
                return true;
            }

            public boolean touchUp(int screenX, int screenY, int pointer, int button) {
                this.clickPosOffset = null;
                this.draggingEntity = null;
                return true;
            }

            public boolean touchDragged(int screenX, int screenY, int pointer) {
                if (this.getSceneSelected() != null && AreaEditorKt.isInsideScene() && !UiComponentsKt.leftClick() && Gdx.input.isButtonPressed(0)) {
                    if (this.draggingEntity == null || !Intrinsics.areEqual((Object)this.draggingEntity, (Object)this.getSceneSelected()) || this.clickPosOffset == null) {
                        this.draggingEntity = this.getSceneSelected();
                        Vector2 pointer2 = MouseKt.scaledPointer();
                        AreaEntity areaEntity = this.getSceneSelected();
                        Intrinsics.checkNotNull((Object)areaEntity);
                        float offsetX = areaEntity.getBase().getPosition().x - pointer2.x;
                        AreaEntity areaEntity2 = this.getSceneSelected();
                        Intrinsics.checkNotNull((Object)areaEntity2);
                        float offsetY = areaEntity2.getBase().getPosition().y - pointer2.y;
                        this.clickPosOffset = new Vector2(offsetX, offsetY);
                    }
                    this.getIconList().setSelected(null);
                    Vector2 vector2 = MouseKt.scaledPointer();
                    Vector2 vector22 = this.clickPosOffset;
                    Intrinsics.checkNotNull((Object)vector22);
                    Vector2 newPos = Vector2Kt.plus(vector2, vector22);
                    if (this.getDisplayGrid().getChecked()) {
                        float snapX = (float)((int)(newPos.x / this.getGridSize())) * this.getGridSize();
                        float snapY = (float)((int)(newPos.y / this.getGridSize())) * this.getGridSize();
                        AreaEntity areaEntity = this.getSceneSelected();
                        Intrinsics.checkNotNull((Object)areaEntity);
                        areaEntity.getBase().setPosition(Vector2Kt.x(snapX, snapY));
                        AreaEntity areaEntity3 = this.getSceneSelected();
                        Intrinsics.checkNotNull((Object)areaEntity3);
                        areaEntity3.update();
                    } else {
                        AreaEntity areaEntity = this.getSceneSelected();
                        Intrinsics.checkNotNull((Object)areaEntity);
                        areaEntity.getBase().setPosition(newPos);
                        AreaEntity areaEntity4 = this.getSceneSelected();
                        Intrinsics.checkNotNull((Object)areaEntity4);
                        areaEntity4.update();
                    }
                }
                return true;
            }

            public boolean mouseMoved(int screenX, int screenY) {
                return true;
            }

            public boolean scrolled(float amountX, float amountY) {
                AreaEntity entity = this.getSceneSelected();
                float minSize = 0.05f;
                if (entity != null) {
                    this.getIconList().setSelected(null);
                    Vector2 vector2 = entity.getBase().getSize();
                    float x = Vector2Kt.component1(vector2);
                    float y = Vector2Kt.component2(vector2);
                    float increase = 0.05f * amountY * -1.0f;
                    if (UiComponentsKt.controlDown()) {
                        entity.getBase().getSize().y = Math.max(entity.getBase().getSize().y + increase, minSize);
                    } else if (UiComponentsKt.shiftDown()) {
                        entity.getBase().getSize().x = Math.max(entity.getBase().getSize().x + increase, minSize);
                    } else {
                        Vector2 sizeIncrease = new Vector2(0.02f * amountY * 8.0f * x, 0.02f * amountY * 8.0f * y);
                        BaseEntityData baseEntityData = entity.getBase();
                        baseEntityData.setSize(Vector2Kt.minus(baseEntityData.getSize(), sizeIncrease));
                        if (entity.getBase().getSize().x < minSize) {
                            entity.getBase().getSize().x = minSize;
                        }
                        if (entity.getBase().getSize().y < minSize) {
                            entity.getBase().getSize().y = minSize;
                        }
                    }
                    entity.update();
                }
                return true;
            }
        });
    }

    public /* synthetic */ TextInputHandler(List list, IconList iconList, AreaEntity areaEntity, CheckBox checkBox, float f, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            areaEntity = null;
        }
        this(list, iconList, areaEntity, checkBox, f);
    }

    @NotNull
    public final List<InputField> getInputFields() {
        return this.inputFields;
    }

    @NotNull
    public final IconList getIconList() {
        return this.iconList;
    }

    @Nullable
    public final AreaEntity getSceneSelected() {
        return this.sceneSelected;
    }

    public final void setSceneSelected(@Nullable AreaEntity areaEntity) {
        this.sceneSelected = areaEntity;
    }

    @NotNull
    public final CheckBox getDisplayGrid() {
        return this.displayGrid;
    }

    public final float getGridSize() {
        return this.gridSize;
    }

    @NotNull
    public final List<InputField> component1() {
        return this.inputFields;
    }

    @NotNull
    public final IconList component2() {
        return this.iconList;
    }

    @Nullable
    public final AreaEntity component3() {
        return this.sceneSelected;
    }

    @NotNull
    public final CheckBox component4() {
        return this.displayGrid;
    }

    public final float component5() {
        return this.gridSize;
    }

    @NotNull
    public final TextInputHandler copy(@NotNull List<InputField> inputFields, @NotNull IconList iconList, @Nullable AreaEntity sceneSelected, @NotNull CheckBox displayGrid, float gridSize) {
        Intrinsics.checkNotNullParameter(inputFields, (String)"inputFields");
        Intrinsics.checkNotNullParameter((Object)iconList, (String)"iconList");
        Intrinsics.checkNotNullParameter((Object)displayGrid, (String)"displayGrid");
        return new TextInputHandler(inputFields, iconList, sceneSelected, displayGrid, gridSize);
    }

    public static /* synthetic */ TextInputHandler copy$default(TextInputHandler textInputHandler, List list, IconList iconList, AreaEntity areaEntity, CheckBox checkBox, float f, int n, Object object) {
        if ((n & 1) != 0) {
            list = textInputHandler.inputFields;
        }
        if ((n & 2) != 0) {
            iconList = textInputHandler.iconList;
        }
        if ((n & 4) != 0) {
            areaEntity = textInputHandler.sceneSelected;
        }
        if ((n & 8) != 0) {
            checkBox = textInputHandler.displayGrid;
        }
        if ((n & 0x10) != 0) {
            f = textInputHandler.gridSize;
        }
        return textInputHandler.copy(list, iconList, areaEntity, checkBox, f);
    }

    @NotNull
    public String toString() {
        return "TextInputHandler(inputFields=" + this.inputFields + ", iconList=" + this.iconList + ", sceneSelected=" + this.sceneSelected + ", displayGrid=" + this.displayGrid + ", gridSize=" + this.gridSize + ')';
    }

    public int hashCode() {
        int result = ((Object)this.inputFields).hashCode();
        result = result * 31 + this.iconList.hashCode();
        result = result * 31 + (this.sceneSelected == null ? 0 : this.sceneSelected.hashCode());
        result = result * 31 + this.displayGrid.hashCode();
        result = result * 31 + Float.hashCode(this.gridSize);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TextInputHandler)) {
            return false;
        }
        TextInputHandler textInputHandler = (TextInputHandler)other;
        if (!Intrinsics.areEqual(this.inputFields, textInputHandler.inputFields)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.iconList, (Object)textInputHandler.iconList)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.sceneSelected, (Object)textInputHandler.sceneSelected)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.displayGrid, (Object)textInputHandler.displayGrid)) {
            return false;
        }
        return Intrinsics.areEqual((Object)Float.valueOf(this.gridSize), (Object)Float.valueOf(textInputHandler.gridSize));
    }
}

