/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.engine.tools.ui.components;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.math.Vector2;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import ktx.graphics.ColorKt;
import ktx.graphics.ShapeRendererKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.veiset.kgame.engine.Log;
import org.veiset.kgame.engine.math.Vector2Kt;
import org.veiset.kgame.engine.tools.ui.UiComponent;
import org.veiset.kgame.engine.tools.ui.UiComponentsKt;
import org.veiset.kgame.engine.util.FontUtilsKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0013\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u001a\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\u0013\u0010\u001d\u001a\u00020\b2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u00d6\u0003J\t\u0010 \u001a\u00020!H\u00d6\u0001J\t\u0010\"\u001a\u00020\u0005H\u00d6\u0001J\b\u0010#\u001a\u00020\u001cH\u0016R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\n\"\u0004\b\u000f\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0011\u00a8\u0006$"}, d2={"Lorg/veiset/kgame/engine/tools/ui/components/Button;", "Lorg/veiset/kgame/engine/tools/ui/UiComponent;", "position", "Lcom/badlogic/gdx/math/Vector2;", "text", "", "(Lcom/badlogic/gdx/math/Vector2;Ljava/lang/String;)V", "clicked", "", "getClicked", "()Z", "setClicked", "(Z)V", "hovered", "getHovered", "setHovered", "getPosition", "()Lcom/badlogic/gdx/math/Vector2;", "size", "getSize", "getText", "()Ljava/lang/String;", "tp", "getTp", "component1", "component2", "copy", "draw", "", "equals", "other", "", "hashCode", "", "toString", "update", "kgame2"})
public final class Button
implements UiComponent {
    @NotNull
    private final Vector2 position;
    @NotNull
    private final String text;
    @NotNull
    private final Vector2 tp;
    @NotNull
    private final Vector2 size;
    private boolean hovered;
    private boolean clicked;

    public Button(@NotNull Vector2 position, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.position = position;
        this.text = text;
        this.tp = Vector2Kt.dw(Vector2Kt.plus(this.position, new Vector2(0.1f, 0.19f)));
        this.size = Vector2Kt.plus(FontUtilsKt.gameWorldSize(UiComponentsKt.getFont(), this.text), new Vector2(0.2f, 0.15f));
    }

    @NotNull
    public final Vector2 getPosition() {
        return this.position;
    }

    @NotNull
    public final String getText() {
        return this.text;
    }

    @NotNull
    public final Vector2 getTp() {
        return this.tp;
    }

    @NotNull
    public final Vector2 getSize() {
        return this.size;
    }

    public final boolean getHovered() {
        return this.hovered;
    }

    public final void setHovered(boolean bl) {
        this.hovered = bl;
    }

    public final boolean getClicked() {
        return this.clicked;
    }

    public final void setClicked(boolean bl) {
        this.clicked = bl;
    }

    @Override
    public void draw() {
        Color hoverColor = this.hovered ? ColorKt.color((float)0.35f, (float)0.35f, (float)0.35f, (float)1.0f) : Color.DARK_GRAY;
        UiComponentsKt.getShapeRenderer().begin(ShapeRenderer.ShapeType.Filled);
        UiComponentsKt.getShapeRenderer().setColor(hoverColor);
        ShapeRendererKt.rect((ShapeRenderer)UiComponentsKt.getShapeRenderer(), (Vector2)Vector2Kt.dw(this.position), (Vector2)Vector2Kt.dw(this.size));
        UiComponentsKt.getShapeRenderer().end();
        UiComponentsKt.getShapeRenderer().begin(ShapeRenderer.ShapeType.Line);
        UiComponentsKt.getShapeRenderer().setColor(Color.DARK_GRAY);
        ShapeRendererKt.rect((ShapeRenderer)UiComponentsKt.getShapeRenderer(), (Vector2)Vector2Kt.dw(this.position), (Vector2)Vector2Kt.dw(this.size));
        UiComponentsKt.getShapeRenderer().setColor(Color.WHITE);
        UiComponentsKt.getShapeRenderer().line(Vector2Kt.plus(Vector2Kt.dw(this.position), Vector2Kt.dw(Vector2Kt.x(0.0f, this.size.y))), Vector2Kt.plus(Vector2Kt.dw(this.position), Vector2Kt.dw(this.size)));
        UiComponentsKt.getShapeRenderer().setColor(Color.LIGHT_GRAY);
        UiComponentsKt.getShapeRenderer().line(Vector2Kt.dw(this.position), Vector2Kt.plus(Vector2Kt.dw(this.position), Vector2Kt.dw(Vector2Kt.x(this.size.x, 0.0f))));
        UiComponentsKt.getShapeRenderer().end();
        UiComponentsKt.getSpriteBatch().begin();
        UiComponentsKt.getFont().setColor(Color.WHITE);
        UiComponentsKt.getFont().draw((Batch)UiComponentsKt.getSpriteBatch(), (CharSequence)this.text, this.tp.x, this.tp.y);
        UiComponentsKt.getSpriteBatch().end();
    }

    @Override
    public void update() {
        this.clicked = false;
        this.hovered = false;
        boolean click = Vector2Kt.uiPointerWithinSquare(this.position, this.size);
        if (Gdx.input.isButtonJustPressed(0)) {
            this.clicked = click;
            if (this.clicked) {
                Log.INSTANCE.info(Intrinsics.stringPlus((String)"Button clicked: ", (Object)this.text));
            }
        }
        if (click) {
            this.hovered = true;
        }
    }

    @NotNull
    public final Vector2 component1() {
        return this.position;
    }

    @NotNull
    public final String component2() {
        return this.text;
    }

    @NotNull
    public final Button copy(@NotNull Vector2 position, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return new Button(position, text);
    }

    public static /* synthetic */ Button copy$default(Button button, Vector2 vector2, String string, int n, Object object) {
        if ((n & 1) != 0) {
            vector2 = button.position;
        }
        if ((n & 2) != 0) {
            string = button.text;
        }
        return button.copy(vector2, string);
    }

    @NotNull
    public String toString() {
        return "Button(position=" + this.position + ", text=" + this.text + ')';
    }

    public int hashCode() {
        int result = this.position.hashCode();
        result = result * 31 + this.text.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Button)) {
            return false;
        }
        Button button = (Button)other;
        if (!Intrinsics.areEqual((Object)this.position, (Object)button.position)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.text, (Object)button.text);
    }
}

