/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.engine.tools.ui.components;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.math.Vector2;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import ktx.graphics.ShapeRendererKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.veiset.kgame.engine.math.Vector2Kt;
import org.veiset.kgame.engine.tools.ui.UiComponent;
import org.veiset.kgame.engine.tools.ui.UiComponentsKt;
import org.veiset.kgame.engine.util.FontUtilsKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0013\u0010\u0019\u001a\u00020\u00072\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001J\t\u0010\u001e\u001a\u00020\u0005H\u00d6\u0001J\b\u0010\u001f\u001a\u00020\u0018H\u0016R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/veiset/kgame/engine/tools/ui/components/CheckBox;", "Lorg/veiset/kgame/engine/tools/ui/UiComponent;", "position", "Lcom/badlogic/gdx/math/Vector2;", "text", "", "checked", "", "(Lcom/badlogic/gdx/math/Vector2;Ljava/lang/String;Z)V", "getChecked", "()Z", "setChecked", "(Z)V", "getPosition", "()Lcom/badlogic/gdx/math/Vector2;", "getText", "()Ljava/lang/String;", "textLength", "", "component1", "component2", "component3", "copy", "draw", "", "equals", "other", "", "hashCode", "", "toString", "update", "kgame2"})
public final class CheckBox
implements UiComponent {
    @NotNull
    private final Vector2 position;
    @NotNull
    private final String text;
    private boolean checked;
    private final float textLength;

    public CheckBox(@NotNull Vector2 position, @NotNull String text, boolean checked) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.position = position;
        this.text = text;
        this.checked = checked;
        this.textLength = FontUtilsKt.sizeX(UiComponentsKt.getFont(), this.text);
    }

    @NotNull
    public final Vector2 getPosition() {
        return this.position;
    }

    @NotNull
    public final String getText() {
        return this.text;
    }

    public final boolean getChecked() {
        return this.checked;
    }

    public final void setChecked(boolean bl) {
        this.checked = bl;
    }

    @Override
    public void draw() {
        if (this.checked) {
            UiComponentsKt.getShapeRenderer().begin(ShapeRenderer.ShapeType.Filled);
        } else {
            UiComponentsKt.getShapeRenderer().begin(ShapeRenderer.ShapeType.Line);
        }
        UiComponentsKt.getShapeRenderer().setColor(Color.GRAY);
        ShapeRendererKt.rect((ShapeRenderer)UiComponentsKt.getShapeRenderer(), (Vector2)Vector2Kt.dw(this.position), (Vector2)Vector2Kt.dw(Vector2Kt.x(0.2f, 0.2f)));
        UiComponentsKt.getShapeRenderer().end();
        UiComponentsKt.getSpriteBatch().begin();
        UiComponentsKt.getFont().setColor(Color.WHITE);
        UiComponentsKt.getFont().draw((Batch)UiComponentsKt.getSpriteBatch(), (CharSequence)this.text, (this.position.x + 0.25f) * 120.0f, (this.position.y + 0.15f) * 120.0f);
        UiComponentsKt.getSpriteBatch().end();
    }

    @Override
    public void update() {
        boolean clicked;
        if (Gdx.input.isButtonJustPressed(0) && (clicked = Vector2Kt.uiPointerWithinSquare(this.position, Vector2Kt.x(0.2f + this.textLength, 0.2f)))) {
            this.checked = !this.checked;
        }
    }

    @NotNull
    public final Vector2 component1() {
        return this.position;
    }

    @NotNull
    public final String component2() {
        return this.text;
    }

    public final boolean component3() {
        return this.checked;
    }

    @NotNull
    public final CheckBox copy(@NotNull Vector2 position, @NotNull String text, boolean checked) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return new CheckBox(position, text, checked);
    }

    public static /* synthetic */ CheckBox copy$default(CheckBox checkBox, Vector2 vector2, String string, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            vector2 = checkBox.position;
        }
        if ((n & 2) != 0) {
            string = checkBox.text;
        }
        if ((n & 4) != 0) {
            bl = checkBox.checked;
        }
        return checkBox.copy(vector2, string, bl);
    }

    @NotNull
    public String toString() {
        return "CheckBox(position=" + this.position + ", text=" + this.text + ", checked=" + this.checked + ')';
    }

    public int hashCode() {
        int result = this.position.hashCode();
        result = result * 31 + this.text.hashCode();
        int n = this.checked ? 1 : 0;
        if (n != 0) {
            n = 1;
        }
        result = result * 31 + n;
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CheckBox)) {
            return false;
        }
        CheckBox checkBox = (CheckBox)other;
        if (!Intrinsics.areEqual((Object)this.position, (Object)checkBox.position)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.text, (Object)checkBox.text)) {
            return false;
        }
        return this.checked == checkBox.checked;
    }
}

