/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.engine.tools.ui.components;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.math.Vector2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.veiset.kgame.engine.Log;
import org.veiset.kgame.engine.input.MouseKt;
import org.veiset.kgame.engine.math.Vector2Kt;
import org.veiset.kgame.engine.storage.TextureMetaStore;
import org.veiset.kgame.engine.tools.ui.UiComponent;
import org.veiset.kgame.engine.tools.ui.UiComponentsKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0017\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u001b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0006H\u00c6\u0003J\u000f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u00c6\u0003JA\u0010 \u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00062\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u00c6\u0001J\b\u0010!\u001a\u00020\"H\u0016J\u0013\u0010#\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010&H\u00d6\u0003J\t\u0010'\u001a\u00020\u0006H\u00d6\u0001J\u0006\u0010(\u001a\u00020$J\t\u0010)\u001a\u00020*H\u00d6\u0001J\b\u0010+\u001a\u00020\"H\u0016R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR \u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\rR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0013R\u001c\u0010\u0016\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001a\u00a8\u0006,"}, d2={"Lorg/veiset/kgame/engine/tools/ui/components/IconList;", "Lorg/veiset/kgame/engine/tools/ui/UiComponent;", "position", "Lcom/badlogic/gdx/math/Vector2;", "itemSize", "rowItems", "", "maxRows", "items", "", "Lorg/veiset/kgame/engine/storage/TextureMetaStore$TextureMeta;", "(Lcom/badlogic/gdx/math/Vector2;Lcom/badlogic/gdx/math/Vector2;IILjava/util/List;)V", "getItemSize", "()Lcom/badlogic/gdx/math/Vector2;", "getItems", "()Ljava/util/List;", "setItems", "(Ljava/util/List;)V", "getMaxRows", "()I", "getPosition", "getRowItems", "selected", "getSelected", "()Lorg/veiset/kgame/engine/storage/TextureMetaStore$TextureMeta;", "setSelected", "(Lorg/veiset/kgame/engine/storage/TextureMetaStore$TextureMeta;)V", "component1", "component2", "component3", "component4", "component5", "copy", "draw", "", "equals", "", "other", "", "hashCode", "justClicked", "toString", "", "update", "kgame2"})
public final class IconList
implements UiComponent {
    @NotNull
    private final Vector2 position;
    @NotNull
    private final Vector2 itemSize;
    private final int rowItems;
    private final int maxRows;
    @NotNull
    private List<TextureMetaStore.TextureMeta> items;
    @Nullable
    private TextureMetaStore.TextureMeta selected;

    public IconList(@NotNull Vector2 position, @NotNull Vector2 itemSize, int rowItems, int maxRows, @NotNull List<TextureMetaStore.TextureMeta> items) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Intrinsics.checkNotNullParameter((Object)itemSize, (String)"itemSize");
        Intrinsics.checkNotNullParameter(items, (String)"items");
        this.position = position;
        this.itemSize = itemSize;
        this.rowItems = rowItems;
        this.maxRows = maxRows;
        this.items = items;
    }

    @NotNull
    public final Vector2 getPosition() {
        return this.position;
    }

    @NotNull
    public final Vector2 getItemSize() {
        return this.itemSize;
    }

    public final int getRowItems() {
        return this.rowItems;
    }

    public final int getMaxRows() {
        return this.maxRows;
    }

    @NotNull
    public final List<TextureMetaStore.TextureMeta> getItems() {
        return this.items;
    }

    public final void setItems(@NotNull List<TextureMetaStore.TextureMeta> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.items = list;
    }

    @Nullable
    public final TextureMetaStore.TextureMeta getSelected() {
        return this.selected;
    }

    public final void setSelected(@Nullable TextureMetaStore.TextureMeta textureMeta) {
        this.selected = textureMeta;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void draw() {
        void $this$mapIndexedTo$iv$iv;
        Vector2 vector2 = this.position;
        float sx = Vector2Kt.component1(vector2);
        float sy = Vector2Kt.component2(vector2);
        UiComponentsKt.getSpriteBatch().begin();
        UiComponentsKt.getShapeRenderer().begin(ShapeRenderer.ShapeType.Line);
        Iterable $this$mapIndexed$iv = CollectionsKt.chunked((Iterable)CollectionsKt.take((Iterable)this.items, (int)(this.rowItems * this.maxRows)), (int)this.rowItems);
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void $this$mapIndexedTo$iv$iv2;
            void textureInRow;
            void row;
            int n = index$iv$iv;
            index$iv$iv = n + 1;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            List list = (List)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            float y = (float)row * this.getItemSize().y;
            Iterable $this$mapIndexed$iv2 = (Iterable)textureInRow;
            boolean $i$f$mapIndexed2 = false;
            Iterable iterable2 = $this$mapIndexed$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv2, (int)10));
            boolean $i$f$mapIndexedTo2 = false;
            int index$iv$iv2 = 0;
            for (Object item$iv$iv2 : $this$mapIndexedTo$iv$iv2) {
                void meta;
                void col;
                int n3 = index$iv$iv2;
                index$iv$iv2 = n3 + 1;
                if (n3 < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                TextureMetaStore.TextureMeta textureMeta = (TextureMetaStore.TextureMeta)item$iv$iv2;
                int n4 = n3;
                Collection collection2 = destination$iv$iv2;
                boolean bl2 = false;
                float x = (float)col * this.getItemSize().x;
                UiComponentsKt.getSpriteBatch().draw(meta.getTexture(), sx + x * 120.0f, (sy - y) * 120.0f, this.getItemSize().x * 120.0f, this.getItemSize().y * 120.0f);
                if (Intrinsics.areEqual((Object)meta, (Object)this.getSelected())) {
                    UiComponentsKt.getShapeRenderer().setColor(Color.RED);
                    UiComponentsKt.getShapeRenderer().rect(sx + x * 120.0f, (sy - y) * 120.0f, this.getItemSize().x * 120.0f, this.getItemSize().y * 120.0f);
                }
                collection2.add(Unit.INSTANCE);
            }
            collection.add((List)destination$iv$iv2);
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
        UiComponentsKt.getSpriteBatch().end();
        UiComponentsKt.getShapeRenderer().end();
    }

    @Override
    public void update() {
        float x = (float)this.rowItems * this.itemSize.x;
        float y = (float)this.maxRows * this.itemSize.y;
        boolean clicked = Vector2Kt.uiPointerWithinSquare(Vector2Kt.minus(this.position, Vector2Kt.x(0.0f, y - this.itemSize.y)), Vector2Kt.x(x, y));
        if (clicked && Gdx.input.isButtonJustPressed(0)) {
            Vector2 vector2 = MouseKt.uiPointer();
            float px = Vector2Kt.component1(vector2);
            float py = Vector2Kt.component2(vector2);
            int col = (int)((px - this.position.x) / this.itemSize.x);
            int row = (int)((this.position.y - py + this.itemSize.y) / this.itemSize.y);
            int itemPos = col + row * this.rowItems;
            if (this.items.size() > itemPos) {
                TextureMetaStore.TextureMeta textureMeta = this.selected = this.items.get(itemPos);
                Log.INSTANCE.info(Intrinsics.stringPlus((String)"IconList selected: ", (Object)(textureMeta == null ? null : textureMeta.getName())));
            }
        } else if (Gdx.input.isButtonJustPressed(1)) {
            this.selected = null;
        }
    }

    public final boolean justClicked() {
        float x = (float)this.rowItems * this.itemSize.x;
        float y = (float)this.maxRows * this.itemSize.y;
        boolean clicked = Vector2Kt.uiPointerWithinSquare(Vector2Kt.minus(this.position, Vector2Kt.x(0.0f, y - this.itemSize.y)), Vector2Kt.x(x, y));
        return clicked && Gdx.input.isButtonJustPressed(0);
    }

    @NotNull
    public final Vector2 component1() {
        return this.position;
    }

    @NotNull
    public final Vector2 component2() {
        return this.itemSize;
    }

    public final int component3() {
        return this.rowItems;
    }

    public final int component4() {
        return this.maxRows;
    }

    @NotNull
    public final List<TextureMetaStore.TextureMeta> component5() {
        return this.items;
    }

    @NotNull
    public final IconList copy(@NotNull Vector2 position, @NotNull Vector2 itemSize, int rowItems, int maxRows, @NotNull List<TextureMetaStore.TextureMeta> items) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Intrinsics.checkNotNullParameter((Object)itemSize, (String)"itemSize");
        Intrinsics.checkNotNullParameter(items, (String)"items");
        return new IconList(position, itemSize, rowItems, maxRows, items);
    }

    public static /* synthetic */ IconList copy$default(IconList iconList, Vector2 vector2, Vector2 vector22, int n, int n2, List list, int n3, Object object) {
        if ((n3 & 1) != 0) {
            vector2 = iconList.position;
        }
        if ((n3 & 2) != 0) {
            vector22 = iconList.itemSize;
        }
        if ((n3 & 4) != 0) {
            n = iconList.rowItems;
        }
        if ((n3 & 8) != 0) {
            n2 = iconList.maxRows;
        }
        if ((n3 & 0x10) != 0) {
            list = iconList.items;
        }
        return iconList.copy(vector2, vector22, n, n2, list);
    }

    @NotNull
    public String toString() {
        return "IconList(position=" + this.position + ", itemSize=" + this.itemSize + ", rowItems=" + this.rowItems + ", maxRows=" + this.maxRows + ", items=" + this.items + ')';
    }

    public int hashCode() {
        int result = this.position.hashCode();
        result = result * 31 + this.itemSize.hashCode();
        result = result * 31 + Integer.hashCode(this.rowItems);
        result = result * 31 + Integer.hashCode(this.maxRows);
        result = result * 31 + ((Object)this.items).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof IconList)) {
            return false;
        }
        IconList iconList = (IconList)other;
        if (!Intrinsics.areEqual((Object)this.position, (Object)iconList.position)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.itemSize, (Object)iconList.itemSize)) {
            return false;
        }
        if (this.rowItems != iconList.rowItems) {
            return false;
        }
        if (this.maxRows != iconList.maxRows) {
            return false;
        }
        return Intrinsics.areEqual(this.items, iconList.items);
    }
}

