/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.engine.ui;

import com.badlogic.gdx.InputAdapter;
import com.badlogic.gdx.audio.Sound;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Vector2;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import ktx.graphics.ColorKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.veiset.kgame.engine.GameFilesKt;
import org.veiset.kgame.engine.Log;
import org.veiset.kgame.engine.TBEngineKt;
import org.veiset.kgame.engine.asset.AssetManager;
import org.veiset.kgame.engine.asset.AssetRef;
import org.veiset.kgame.engine.math.Vector2Kt;
import org.veiset.kgame.engine.sound.SoundPlayer;
import org.veiset.kgame.engine.util.FontUtilsKt;
import org.veiset.kgame.engine.values.Asset;
import org.veiset.kgame.presentation.PresTrondheimMarsKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u001b\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000b\b\u0086\b\u0018\u0000 62\u00020\u0001:\u00016B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\u000bJ\t\u0010!\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\"\u001a\u00020\u0005H\u00c6\u0003J\t\u0010#\u001a\u00020\u0007H\u00c6\u0003J\u000f\u0010$\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u00c6\u0003J7\u0010%\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u00c6\u0001J\u0006\u0010&\u001a\u00020\nJ\u0013\u0010'\u001a\u00020\r2\b\u0010(\u001a\u0004\u0018\u00010)H\u00d6\u0003J\b\u0010*\u001a\u00020\nH\u0002J\t\u0010+\u001a\u00020,H\u00d6\u0001J\b\u0010\u0017\u001a\u00020\rH\u0002J\u0018\u0010-\u001a\u00020\r2\u0006\u0010.\u001a\u00020,2\u0006\u0010/\u001a\u00020,H\u0016J\t\u00100\u001a\u00020\u0003H\u00d6\u0001J(\u00101\u001a\u00020\r2\u0006\u0010.\u001a\u00020,2\u0006\u0010/\u001a\u00020,2\u0006\u00102\u001a\u00020,2\u0006\u00103\u001a\u00020,H\u0016J \u00104\u001a\u00020\r2\u0006\u0010.\u001a\u00020,2\u0006\u0010/\u001a\u00020,2\u0006\u00102\u001a\u00020,H\u0016J(\u00105\u001a\u00020\r2\u0006\u0010.\u001a\u00020,2\u0006\u0010/\u001a\u00020,2\u0006\u00102\u001a\u00020,2\u0006\u00103\u001a\u00020,H\u0016R\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0017\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u000f\"\u0004\b\u0019\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u000e\u0010 \u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lorg/veiset/kgame/engine/ui/UIButton;", "Lcom/badlogic/gdx/InputAdapter;", "text", "", "position", "Lcom/badlogic/gdx/math/Vector2;", "scale", "", "f", "Lkotlin/Function0;", "", "(Ljava/lang/String;Lcom/badlogic/gdx/math/Vector2;FLkotlin/jvm/functions/Function0;)V", "clicked", "", "getClicked", "()Z", "setClicked", "(Z)V", "getF", "()Lkotlin/jvm/functions/Function0;", "fontSize", "fontXOffset", "height", "hovered", "getHovered", "setHovered", "getPosition", "()Lcom/badlogic/gdx/math/Vector2;", "getScale", "()F", "getText", "()Ljava/lang/String;", "width", "component1", "component2", "component3", "component4", "copy", "draw", "equals", "other", "", "handleMove", "hashCode", "", "mouseMoved", "screenX", "screenY", "toString", "touchDown", "pointer", "button", "touchDragged", "touchUp", "Companion", "kgame2"})
public final class UIButton
extends InputAdapter {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final String text;
    @NotNull
    private final Vector2 position;
    private final float scale;
    @NotNull
    private final Function0<Unit> f;
    @NotNull
    private final Vector2 fontSize;
    private final float width;
    private final float height;
    private final float fontXOffset;
    private boolean hovered;
    private boolean clicked;
    @NotNull
    private static final BitmapFont font;
    @NotNull
    private static final TextureRegion buttonDefault;
    @NotNull
    private static final TextureRegion buttonPressed;
    @NotNull
    private static final TextureRegion buttonHovered;
    @NotNull
    private static final Sound clickSound;
    @NotNull
    private static final Sound hoverSound;

    public UIButton(@NotNull String text, @NotNull Vector2 position, float scale, @NotNull Function0<Unit> f) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Intrinsics.checkNotNullParameter(f, (String)"f");
        this.text = text;
        this.position = position;
        this.scale = scale;
        this.f = f;
        this.fontSize = FontUtilsKt.gameWorldSize(font, this.text);
        this.width = (float)buttonPressed.getRegionWidth() * this.scale;
        this.height = (float)buttonPressed.getRegionHeight() * this.scale;
        this.fontXOffset = this.width / 2.0f - this.fontSize.x * 120.0f / 2.0f;
    }

    public /* synthetic */ UIButton(String string, Vector2 vector2, float f, Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            f = 3.0f;
        }
        if ((n & 8) != 0) {
            function0 = 1.INSTANCE;
        }
        this(string, vector2, f, (Function0<Unit>)function0);
    }

    @NotNull
    public final String getText() {
        return this.text;
    }

    @NotNull
    public final Vector2 getPosition() {
        return this.position;
    }

    public final float getScale() {
        return this.scale;
    }

    @NotNull
    public final Function0<Unit> getF() {
        return this.f;
    }

    public final boolean getHovered() {
        return this.hovered;
    }

    public final void setHovered(boolean bl) {
        this.hovered = bl;
    }

    public final boolean getClicked() {
        return this.clicked;
    }

    public final void setClicked(boolean bl) {
        this.clicked = bl;
    }

    public final void draw() {
        Vector2 vector2 = Vector2Kt.dw(this.position);
        float x = Vector2Kt.component1(vector2);
        float y = Vector2Kt.component2(vector2);
        SpriteBatch sb = TBEngineKt.getGlobals().getDrawGfx().getSpriteBatch();
        TextureRegion graphic = this.clicked ? buttonPressed : (this.hovered ? buttonHovered : buttonDefault);
        float fontYOffset = this.clicked ? this.height / 1.65f : this.height / 1.55f;
        sb.begin();
        sb.draw(graphic, x, y, this.width, this.height);
        font.setColor(ColorKt.color((float)0.835f, (float)0.949f, (float)0.984f, (float)1.0f));
        font.draw((Batch)sb, (CharSequence)this.text, x + this.fontXOffset, y + fontYOffset);
        sb.end();
    }

    private final boolean hovered() {
        return Vector2Kt.pointerWithinSquare(this.position, Vector2Kt.gfxToWorld(Vector2Kt.x(this.width, this.height)));
    }

    private final void handleMove() {
        boolean _hovered = this.hovered();
        if (this.clicked && !_hovered) {
            this.clicked = false;
        }
        if (_hovered && !this.hovered) {
            SoundPlayer.playEffect$default(TBEngineKt.getGlobals().getSoundPlayer(), hoverSound, GameFilesKt.getGameConfig().getVolumeUi(), 0.0f, 0.0f, 12, null);
            Log.INSTANCE.debug("Button [" + this.text + "] hovered");
        }
        this.hovered = _hovered;
    }

    public boolean mouseMoved(int screenX, int screenY) {
        this.handleMove();
        return false;
    }

    public boolean touchDragged(int screenX, int screenY, int pointer) {
        this.handleMove();
        return false;
    }

    public boolean touchDown(int screenX, int screenY, int pointer, int button) {
        this.hovered = this.hovered();
        if (this.hovered && button == 0) {
            Log.INSTANCE.debug("Button [" + this.text + "] pressed");
            hoverSound.stop();
            SoundPlayer.playEffect$default(TBEngineKt.getGlobals().getSoundPlayer(), clickSound, GameFilesKt.getGameConfig().getVolumeUi(), 0.0f, 0.0f, 12, null);
            this.clicked = true;
        }
        return false;
    }

    public boolean touchUp(int screenX, int screenY, int pointer, int button) {
        this.hovered = this.hovered();
        if (this.hovered && this.clicked && button == 0) {
            Log.INSTANCE.debug("Button [" + this.text + "] clicked");
            this.f.invoke();
            this.clicked = false;
        } else if (button == 0) {
            this.clicked = false;
        }
        return false;
    }

    @NotNull
    public final String component1() {
        return this.text;
    }

    @NotNull
    public final Vector2 component2() {
        return this.position;
    }

    public final float component3() {
        return this.scale;
    }

    @NotNull
    public final Function0<Unit> component4() {
        return this.f;
    }

    @NotNull
    public final UIButton copy(@NotNull String text, @NotNull Vector2 position, float scale, @NotNull Function0<Unit> f) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Intrinsics.checkNotNullParameter(f, (String)"f");
        return new UIButton(text, position, scale, f);
    }

    public static /* synthetic */ UIButton copy$default(UIButton uIButton, String string, Vector2 vector2, float f, Function0 function0, int n, Object object) {
        if ((n & 1) != 0) {
            string = uIButton.text;
        }
        if ((n & 2) != 0) {
            vector2 = uIButton.position;
        }
        if ((n & 4) != 0) {
            f = uIButton.scale;
        }
        if ((n & 8) != 0) {
            function0 = uIButton.f;
        }
        return uIButton.copy(string, vector2, f, function0);
    }

    @NotNull
    public String toString() {
        return "UIButton(text=" + this.text + ", position=" + this.position + ", scale=" + this.scale + ", f=" + this.f + ')';
    }

    public int hashCode() {
        int result = this.text.hashCode();
        result = result * 31 + this.position.hashCode();
        result = result * 31 + Float.hashCode(this.scale);
        result = result * 31 + this.f.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof UIButton)) {
            return false;
        }
        UIButton uIButton = (UIButton)((Object)other);
        if (!Intrinsics.areEqual((Object)this.text, (Object)uIButton.text)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.position, (Object)uIButton.position)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)Float.valueOf(this.scale), (Object)Float.valueOf(uIButton.scale))) {
            return false;
        }
        return Intrinsics.areEqual(this.f, uIButton.f);
    }

    static {
        Sound sound;
        Sound sound2;
        TextureRegion textureRegion;
        TextureRegion textureRegion2;
        TextureRegion textureRegion3;
        BitmapFont bitmapFont;
        AssetManager this_$iv;
        Companion = new Companion(null);
        AssetManager assetManager = PresTrondheimMarsKt.getAm();
        AssetRef assetRef$iv = Asset.Font.INSTANCE.getJbr20();
        boolean $i$f$get = false;
        try {
            Object object = this_$iv.getAssets().get(assetRef$iv);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.badlogic.gdx.graphics.g2d.BitmapFont");
            }
            bitmapFont = (BitmapFont)object;
        }
        catch (Exception ex$iv) {
            Log.INSTANCE.critical("AssetRef " + assetRef$iv + " not loaded");
            throw ex$iv;
        }
        font = bitmapFont;
        this_$iv = PresTrondheimMarsKt.getAm();
        assetRef$iv = Asset.UI.INSTANCE.getButtonDefault();
        $i$f$get = false;
        try {
            Object object = this_$iv.getAssets().get(assetRef$iv);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.badlogic.gdx.graphics.g2d.TextureRegion");
            }
            textureRegion3 = (TextureRegion)object;
        }
        catch (Exception ex$iv) {
            Log.INSTANCE.critical("AssetRef " + assetRef$iv + " not loaded");
            throw ex$iv;
        }
        buttonDefault = textureRegion3;
        this_$iv = PresTrondheimMarsKt.getAm();
        assetRef$iv = Asset.UI.INSTANCE.getButtonPressed();
        $i$f$get = false;
        try {
            Object object = this_$iv.getAssets().get(assetRef$iv);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.badlogic.gdx.graphics.g2d.TextureRegion");
            }
            textureRegion2 = (TextureRegion)object;
        }
        catch (Exception ex$iv) {
            Log.INSTANCE.critical("AssetRef " + assetRef$iv + " not loaded");
            throw ex$iv;
        }
        buttonPressed = textureRegion2;
        this_$iv = PresTrondheimMarsKt.getAm();
        assetRef$iv = Asset.UI.INSTANCE.getButtonHover();
        $i$f$get = false;
        try {
            Object object = this_$iv.getAssets().get(assetRef$iv);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.badlogic.gdx.graphics.g2d.TextureRegion");
            }
            textureRegion = (TextureRegion)object;
        }
        catch (Exception ex$iv) {
            Log.INSTANCE.critical("AssetRef " + assetRef$iv + " not loaded");
            throw ex$iv;
        }
        buttonHovered = textureRegion;
        this_$iv = PresTrondheimMarsKt.getAm();
        assetRef$iv = Asset.Sound.INSTANCE.getButtonClick();
        $i$f$get = false;
        try {
            Object object = this_$iv.getAssets().get(assetRef$iv);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.badlogic.gdx.audio.Sound");
            }
            sound2 = (Sound)object;
        }
        catch (Exception ex$iv) {
            Log.INSTANCE.critical("AssetRef " + assetRef$iv + " not loaded");
            throw ex$iv;
        }
        clickSound = sound2;
        this_$iv = PresTrondheimMarsKt.getAm();
        assetRef$iv = Asset.Sound.INSTANCE.getHover();
        $i$f$get = false;
        try {
            Object object = this_$iv.getAssets().get(assetRef$iv);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.badlogic.gdx.audio.Sound");
            }
            sound = (Sound)object;
        }
        catch (Exception ex$iv) {
            Log.INSTANCE.critical("AssetRef " + assetRef$iv + " not loaded");
            throw ex$iv;
        }
        hoverSound = sound;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000e\u00a8\u0006\u0015"}, d2={"Lorg/veiset/kgame/engine/ui/UIButton$Companion;", "", "()V", "buttonDefault", "Lcom/badlogic/gdx/graphics/g2d/TextureRegion;", "getButtonDefault", "()Lcom/badlogic/gdx/graphics/g2d/TextureRegion;", "buttonHovered", "getButtonHovered", "buttonPressed", "getButtonPressed", "clickSound", "Lcom/badlogic/gdx/audio/Sound;", "getClickSound", "()Lcom/badlogic/gdx/audio/Sound;", "font", "Lcom/badlogic/gdx/graphics/g2d/BitmapFont;", "getFont", "()Lcom/badlogic/gdx/graphics/g2d/BitmapFont;", "hoverSound", "getHoverSound", "kgame2"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final BitmapFont getFont() {
            return font;
        }

        @NotNull
        public final TextureRegion getButtonDefault() {
            return buttonDefault;
        }

        @NotNull
        public final TextureRegion getButtonPressed() {
            return buttonPressed;
        }

        @NotNull
        public final TextureRegion getButtonHovered() {
            return buttonHovered;
        }

        @NotNull
        public final Sound getClickSound() {
            return clickSound;
        }

        @NotNull
        public final Sound getHoverSound() {
            return hoverSound;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

