/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.game;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import kotlin.random.RandomKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.veiset.kgame.engine.Log;
import org.veiset.kgame.engine.SaveGame;
import org.veiset.kgame.engine.math.Hex;
import org.veiset.kgame.engine.math.HexagonKt;
import org.veiset.kgame.game.AtlasGenerator;
import org.veiset.kgame.game.AtlasTile;
import org.veiset.kgame.game.AtlasTileInfo;
import org.veiset.kgame.game.Tileset;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0006\u0010\u0010\u001a\u00020\u0011J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\b\u0010\u001a\u001a\u00020\u0019H\u0002J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\u000e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u0016H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001f"}, d2={"Lorg/veiset/kgame/game/AtlasGenerator;", "", "saveGame", "Lorg/veiset/kgame/engine/SaveGame;", "seed", "", "(Lorg/veiset/kgame/engine/SaveGame;J)V", "rng", "Lkotlin/random/Random;", "getSaveGame", "()Lorg/veiset/kgame/engine/SaveGame;", "getSeed", "()J", "component1", "component2", "copy", "debugPrint", "", "equals", "", "other", "generateTiles", "", "Lorg/veiset/kgame/game/AtlasTile;", "hashCode", "", "numberOfTiles", "toString", "", "unlockedTilesets", "Lorg/veiset/kgame/game/Tileset;", "kgame2"})
public final class AtlasGenerator {
    @NotNull
    private final SaveGame saveGame;
    private final long seed;
    @NotNull
    private final Random rng;

    public AtlasGenerator(@NotNull SaveGame saveGame, long seed) {
        Intrinsics.checkNotNullParameter((Object)saveGame, (String)"saveGame");
        this.saveGame = saveGame;
        this.seed = seed;
        this.rng = RandomKt.Random((long)this.seed);
    }

    public /* synthetic */ AtlasGenerator(SaveGame saveGame, long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            l = Random.Default.nextLong();
        }
        this(saveGame, l);
    }

    @NotNull
    public final SaveGame getSaveGame() {
        return this.saveGame;
    }

    public final long getSeed() {
        return this.seed;
    }

    private final int numberOfTiles() {
        int n;
        int baseTiers;
        block1: {
            int n2;
            block0: {
                baseTiers = 1;
                n2 = this.saveGame.getVictories();
                boolean bl = 0 <= n2 ? n2 < 3 : false;
                if (!bl) break block0;
                n = 2;
                break block1;
            }
            n = (3 <= n2 ? n2 < 5 : false) ? 3 : ((4 <= n2 ? n2 < 6 : false) ? 4 : 6);
        }
        int tiersFromVictories = n;
        return baseTiers + tiersFromVictories;
    }

    private final List<Tileset> unlockedTilesets() {
        List tilesets = new ArrayList();
        tilesets.add(Tileset.PureForestTiles);
        if (this.saveGame.getDefeatedFirstBoss()) {
            tilesets.add(Tileset.HeavyForest);
        }
        if (this.saveGame.getVictories() > 2) {
            tilesets.add(Tileset.MixedForestTiles);
        }
        if (this.saveGame.getVictories() > 4) {
            tilesets.add(Tileset.BleakForestTiles);
        }
        return tilesets;
    }

    public final void debugPrint() {
        String tilesets = CollectionsKt.joinToString$default((Iterable)this.unlockedTilesets(), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
        Log.INSTANCE.info("Atlas Generator result - seed: " + this.seed + ", save: " + this.saveGame);
        Log.INSTANCE.info(Intrinsics.stringPlus((String)" - numberOfTiles: ", (Object)this.numberOfTiles()));
        Log.INSTANCE.info(Intrinsics.stringPlus((String)" - tilesets: ", (Object)tilesets));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<AtlasTile> generateTiles() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = HexagonKt.generateHexCircle(this.numberOfTiles());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Hex hex = (Hex)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new AtlasTile((Hex)it, null));
        }
        List hexes = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
        AtlasTile startArea2 = AtlasGenerator.generateTiles$updateRandomEmpty(hexes, (Function1<? super AtlasTile, AtlasTile>)((Function1)generateTiles.startArea.1.INSTANCE));
        Iterable $this$sortedByDescending$iv = CollectionsKt.shuffled((Iterable)hexes);
        boolean $i$f$sortedByDescending = false;
        AtlasTile f = (AtlasTile)CollectionsKt.first((List)CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(startArea2){
            final /* synthetic */ AtlasTile $startArea$inlined;
            {
                this.$startArea$inlined = atlasTile;
            }

            public final int compare(T a, T b) {
                AtlasTile it = (AtlasTile)b;
                boolean bl = false;
                Hex hex = it.getHex();
                AtlasTile atlasTile = this.$startArea$inlined;
                Intrinsics.checkNotNull((Object)atlasTile);
                it = (AtlasTile)a;
                Comparable comparable = Integer.valueOf(hex.distance(atlasTile.getHex()));
                bl = false;
                Hex hex2 = it.getHex();
                AtlasTile atlasTile2 = this.$startArea$inlined;
                Intrinsics.checkNotNull((Object)atlasTile2);
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)Integer.valueOf(hex2.distance(atlasTile2.getHex())));
            }
        }));
        hexes.set(hexes.indexOf(f), AtlasTile.copy$default(f, null, new AtlasTileInfo(Tileset.Boss, 3), 1, null));
        List<Tileset> tilesets = this.unlockedTilesets();
        while (AtlasGenerator.generateTiles$hasEmpty(hexes)) {
            AtlasGenerator.generateTiles$updateRandomEmpty(hexes, (Function1<? super AtlasTile, AtlasTile>)((Function1)new Function1<AtlasTile, AtlasTile>(tilesets){
                final /* synthetic */ List<Tileset> $tilesets;
                {
                    this.$tilesets = $tilesets;
                    super(1);
                }

                @NotNull
                public final AtlasTile invoke(@NotNull AtlasTile it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return new AtlasTile(it.getHex(), new AtlasTileInfo((Tileset)((Object)CollectionsKt.random((Collection)this.$tilesets, (Random)((Random)Random.Default))), 1));
                }
            }));
        }
        System.out.println(hexes);
        return hexes;
    }

    @NotNull
    public final SaveGame component1() {
        return this.saveGame;
    }

    public final long component2() {
        return this.seed;
    }

    @NotNull
    public final AtlasGenerator copy(@NotNull SaveGame saveGame, long seed) {
        Intrinsics.checkNotNullParameter((Object)saveGame, (String)"saveGame");
        return new AtlasGenerator(saveGame, seed);
    }

    public static /* synthetic */ AtlasGenerator copy$default(AtlasGenerator atlasGenerator, SaveGame saveGame, long l, int n, Object object) {
        if ((n & 1) != 0) {
            saveGame = atlasGenerator.saveGame;
        }
        if ((n & 2) != 0) {
            l = atlasGenerator.seed;
        }
        return atlasGenerator.copy(saveGame, l);
    }

    @NotNull
    public String toString() {
        return "AtlasGenerator(saveGame=" + this.saveGame + ", seed=" + this.seed + ')';
    }

    public int hashCode() {
        int result = this.saveGame.hashCode();
        result = result * 31 + Long.hashCode(this.seed);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AtlasGenerator)) {
            return false;
        }
        AtlasGenerator atlasGenerator = (AtlasGenerator)other;
        if (!Intrinsics.areEqual((Object)this.saveGame, (Object)atlasGenerator.saveGame)) {
            return false;
        }
        return this.seed == atlasGenerator.seed;
    }

    /*
     * WARNING - void declaration
     */
    private static final AtlasTile generateTiles$updateRandomEmpty(List<AtlasTile> $this$generateTiles_u24updateRandomEmpty, Function1<? super AtlasTile, AtlasTile> result) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = $this$generateTiles_u24updateRandomEmpty;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            AtlasTile it = (AtlasTile)element$iv$iv;
            boolean bl = false;
            if (!(it.getAtlasTileInfo() == null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List emptyTiles = (List)destination$iv$iv;
        AtlasTile atlasTile = (AtlasTile)CollectionsKt.randomOrNull((Collection)emptyTiles, (Random)((Random)Random.Default));
        if (atlasTile == null) {
            return null;
        }
        AtlasTile randomTile = atlasTile;
        int index = $this$generateTiles_u24updateRandomEmpty.indexOf(randomTile);
        AtlasTile newTile = (AtlasTile)result.invoke((Object)randomTile);
        $this$generateTiles_u24updateRandomEmpty.set(index, newTile);
        return newTile;
    }

    private static final boolean generateTiles$hasEmpty(List<AtlasTile> $this$generateTiles_u24hasEmpty) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = $this$generateTiles_u24hasEmpty;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    AtlasTile it = (AtlasTile)element$iv;
                    boolean bl2 = false;
                    if (!(it.getAtlasTileInfo() == null)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }
}

