/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.module;

import com.badlogic.ashley.core.Engine;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.veiset.kgame.engine.GameModule;
import org.veiset.kgame.engine.Log;
import org.veiset.kgame.engine.TBEngineKt;
import org.veiset.kgame.engine.asset.AssetManager;
import org.veiset.kgame.engine.asset.AssetRef;
import org.veiset.kgame.engine.math.Vector2Kt;
import org.veiset.kgame.engine.util.GdxUtilsKt;
import org.veiset.kgame.engine.values.Asset;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\t\u0018\u00002\u00020\u0001BH\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005\u0012!\u0010\u0006\u001a\u001d\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0004\u0012\u00020\f0\u0007\u0012\b\b\u0002\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\b\u0010\u001a\u001a\u00020\u0001H\u0016J\b\u0010\u001b\u001a\u00020\fH\u0016J\u0010\u0010\u001c\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\u0015H\u0016R\u000e\u0010\u000b\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R)\u0010\u0006\u001a\u001d\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0004\u0012\u00020\f0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001e"}, d2={"Lorg/veiset/kgame/module/AssetLoadModule;", "Lorg/veiset/kgame/engine/GameModule;", "engine", "Lcom/badlogic/ashley/core/Engine;", "nextModule", "Lkotlin/Function0;", "assetsToLoad", "Lkotlin/Function1;", "Lorg/veiset/kgame/engine/asset/AssetManager;", "Lkotlin/ParameterName;", "name", "am", "", "autoNextModule", "", "(Lcom/badlogic/ashley/core/Engine;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function1;Z)V", "getEngine", "()Lcom/badlogic/ashley/core/Engine;", "spriteBatch", "Lcom/badlogic/gdx/graphics/g2d/SpriteBatch;", "t", "", "getT", "()F", "setT", "(F)V", "nextState", "teardown", "update", "delta", "kgame2"})
public final class AssetLoadModule
implements GameModule {
    @NotNull
    private final Engine engine;
    @NotNull
    private final Function0<GameModule> nextModule;
    @NotNull
    private final Function1<AssetManager, Unit> assetsToLoad;
    private final boolean autoNextModule;
    @NotNull
    private final AssetManager am;
    @NotNull
    private final SpriteBatch spriteBatch;
    private float t;

    public AssetLoadModule(@NotNull Engine engine, @NotNull Function0<? extends GameModule> nextModule, @NotNull Function1<? super AssetManager, Unit> assetsToLoad, boolean autoNextModule) {
        Intrinsics.checkNotNullParameter((Object)engine, (String)"engine");
        Intrinsics.checkNotNullParameter(nextModule, (String)"nextModule");
        Intrinsics.checkNotNullParameter(assetsToLoad, (String)"assetsToLoad");
        this.engine = engine;
        this.nextModule = nextModule;
        this.assetsToLoad = assetsToLoad;
        this.autoNextModule = autoNextModule;
        this.am = TBEngineKt.getGlobals().getAssetManager();
        this.spriteBatch = TBEngineKt.getGlobals().getDrawUi().getSpriteBatch();
        this.assetsToLoad.invoke((Object)this.am);
        this.am.preprocess();
        TBEngineKt.getGlobals().getDrawUi().getCamera();
    }

    public /* synthetic */ AssetLoadModule(Engine engine, Function0 function0, Function1 function1, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            bl = false;
        }
        this(engine, (Function0<? extends GameModule>)function0, (Function1<? super AssetManager, Unit>)function1, bl);
    }

    @Override
    @NotNull
    public Engine getEngine() {
        return this.engine;
    }

    public final float getT() {
        return this.t;
    }

    public final void setT(float f) {
        this.t = f;
    }

    @Override
    public void teardown() {
    }

    @Override
    public void update(float delta) {
        boolean $i$f$get;
        AssetManager this_$iv;
        this.t += delta;
        if (this.am.needsSyncProcess()) {
            this.am.processSync();
        }
        this.spriteBatch.begin();
        AssetManager assetManager = this.am;
        AssetRef assetRef$iv = Asset.Texture.INSTANCE.getAttackBall();
        boolean $i$f$contains = false;
        if (this_$iv.getAssets().containsKey(assetRef$iv)) {
            TextureRegion textureRegion;
            this_$iv = this.am;
            assetRef$iv = Asset.Texture.INSTANCE.getAttackBall();
            SpriteBatch spriteBatch = this.spriteBatch;
            $i$f$get = false;
            try {
                Object object = this_$iv.getAssets().get(assetRef$iv);
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type com.badlogic.gdx.graphics.g2d.TextureRegion");
                }
                textureRegion = (TextureRegion)object;
            }
            catch (Exception ex$iv) {
                Log.INSTANCE.critical("AssetRef " + assetRef$iv + " not loaded");
                throw ex$iv;
            }
            GdxUtilsKt.draw(spriteBatch, textureRegion, Vector2Kt.dw(Vector2Kt.x(4.0f + this.t, 4.3f)));
        }
        this_$iv = this.am;
        assetRef$iv = Asset.Font.INSTANCE.getJbt26();
        $i$f$contains = false;
        if (this_$iv.getAssets().containsKey(assetRef$iv)) {
            BitmapFont bitmapFont;
            this_$iv = this.am;
            assetRef$iv = Asset.Font.INSTANCE.getJbt26();
            $i$f$get = false;
            try {
                Object object = this_$iv.getAssets().get(assetRef$iv);
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type com.badlogic.gdx.graphics.g2d.BitmapFont");
                }
                bitmapFont = (BitmapFont)object;
            }
            catch (Exception ex$iv) {
                Log.INSTANCE.critical("AssetRef " + assetRef$iv + " not loaded");
                throw ex$iv;
            }
            bitmapFont.draw((Batch)this.spriteBatch, (CharSequence)("Loading: " + StringsKt.padStart$default((String)String.valueOf(this.am.getLoaded()), (int)3, (char)'\u0000', (int)2, null) + " / " + StringsKt.padStart$default((String)String.valueOf(this.am.getTotal()), (int)3, (char)'\u0000', (int)2, null)), 500.0f, 500.0f);
        }
        this.spriteBatch.end();
    }

    @Override
    @NotNull
    public GameModule nextState() {
        boolean anyKeyPressed;
        boolean bl = anyKeyPressed = Gdx.input.isKeyJustPressed(-1) || Gdx.input.isButtonJustPressed(0);
        if (!this.am.getProcessing() && !this.am.needsSyncProcess() && (anyKeyPressed || this.autoNextModule)) {
            return (GameModule)this.nextModule.invoke();
        }
        return this;
    }
}

