/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.module.transition;

import com.badlogic.ashley.core.Engine;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.graphics.glutils.FrameBuffer;
import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.ScreenUtils;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.veiset.kgame.engine.GameFilesKt;
import org.veiset.kgame.engine.GameModule;
import org.veiset.kgame.engine.TBEngineKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\bJ\t\u0010%\u001a\u00020\u0001H\u00c6\u0003J\t\u0010&\u001a\u00020\u0004H\u00c6\u0003J\t\u0010'\u001a\u00020\u0006H\u00c6\u0003J\t\u0010(\u001a\u00020\u0001H\u00c6\u0003J1\u0010)\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00012\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u0001H\u00c6\u0001J\u0018\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\u00182\b\b\u0002\u0010-\u001a\u00020\u0004J\u0013\u0010.\u001a\u00020/2\b\u00100\u001a\u0004\u0018\u000101H\u00d6\u0003J \u00102\u001a\u00020+2\u0006\u00103\u001a\u00020\u00012\u0006\u00104\u001a\u00020\u00182\b\b\u0002\u00105\u001a\u00020\u0004J\t\u00106\u001a\u000207H\u00d6\u0001J\b\u00108\u001a\u00020\u0001H\u0016J\b\u00109\u001a\u00020+H\u0016J\t\u0010:\u001a\u00020;H\u00d6\u0001J\u0010\u0010<\u001a\u00020+2\u0006\u00105\u001a\u00020\u0004H\u0016R\u001a\u0010\t\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000bR\u0011\u0010\u0011\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u000bR\u001a\u0010\u0017\u001a\u00020\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0014R\u001a\u0010\u001e\u001a\u00020\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u001a\"\u0004\b \u0010\u001cR\u0014\u0010!\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u000bR\u0014\u0010#\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u000b\u00a8\u0006="}, d2={"Lorg/veiset/kgame/module/transition/FadeModuleLoader;", "Lorg/veiset/kgame/engine/GameModule;", "previous", "fadeDuration", "", "engine", "Lcom/badlogic/ashley/core/Engine;", "next", "(Lorg/veiset/kgame/engine/GameModule;FLcom/badlogic/ashley/core/Engine;Lorg/veiset/kgame/engine/GameModule;)V", "currentTime", "getCurrentTime", "()F", "setCurrentTime", "(F)V", "getEngine", "()Lcom/badlogic/ashley/core/Engine;", "getFadeDuration", "firstDuration", "getFirstDuration", "getNext", "()Lorg/veiset/kgame/engine/GameModule;", "nextDuration", "getNextDuration", "nextModuleFbo", "Lcom/badlogic/gdx/graphics/glutils/FrameBuffer;", "getNextModuleFbo", "()Lcom/badlogic/gdx/graphics/glutils/FrameBuffer;", "setNextModuleFbo", "(Lcom/badlogic/gdx/graphics/glutils/FrameBuffer;)V", "getPrevious", "previousModuleFbo", "getPreviousModuleFbo", "setPreviousModuleFbo", "viewportHeight", "getViewportHeight", "viewportWidth", "getViewportWidth", "component1", "component2", "component3", "component4", "copy", "drawModule", "", "frame", "opacity", "equals", "", "other", "", "getFrame", "gameModule", "fbo", "delta", "hashCode", "", "nextState", "teardown", "toString", "", "update", "kgame2"})
public final class FadeModuleLoader
implements GameModule {
    @NotNull
    private final GameModule previous;
    private final float fadeDuration;
    @NotNull
    private final Engine engine;
    @NotNull
    private final GameModule next;
    private float currentTime;
    private final float viewportWidth;
    private final float viewportHeight;
    @NotNull
    private FrameBuffer previousModuleFbo;
    @NotNull
    private FrameBuffer nextModuleFbo;
    private final float firstDuration;
    private final float nextDuration;

    public FadeModuleLoader(@NotNull GameModule previous, float fadeDuration, @NotNull Engine engine, @NotNull GameModule next) {
        Intrinsics.checkNotNullParameter((Object)previous, (String)"previous");
        Intrinsics.checkNotNullParameter((Object)engine, (String)"engine");
        Intrinsics.checkNotNullParameter((Object)next, (String)"next");
        this.previous = previous;
        this.fadeDuration = fadeDuration;
        this.engine = engine;
        this.next = next;
        this.viewportWidth = 1920.0f;
        this.viewportHeight = 1080.0f;
        this.previousModuleFbo = new FrameBuffer(Pixmap.Format.RGBA8888, (int)this.viewportWidth, (int)this.viewportHeight, false, true);
        this.nextModuleFbo = new FrameBuffer(Pixmap.Format.RGBA8888, (int)this.viewportWidth, (int)this.viewportHeight, false, false);
        this.firstDuration = this.fadeDuration / 3.0f;
        this.nextDuration = this.fadeDuration - this.firstDuration;
        FadeModuleLoader.getFrame$default(this, this.previous, this.previousModuleFbo, 0.0f, 4, null);
        FadeModuleLoader.getFrame$default(this, this.next, this.nextModuleFbo, 0.0f, 4, null);
    }

    public /* synthetic */ FadeModuleLoader(GameModule gameModule, float f, Engine engine, GameModule gameModule2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            f = 0.0f;
        }
        if ((n & 4) != 0) {
            engine = gameModule.getEngine();
        }
        this(gameModule, f, engine, gameModule2);
    }

    @NotNull
    public final GameModule getPrevious() {
        return this.previous;
    }

    public final float getFadeDuration() {
        return this.fadeDuration;
    }

    @Override
    @NotNull
    public Engine getEngine() {
        return this.engine;
    }

    @NotNull
    public final GameModule getNext() {
        return this.next;
    }

    public final float getCurrentTime() {
        return this.currentTime;
    }

    public final void setCurrentTime(float f) {
        this.currentTime = f;
    }

    public final float getViewportWidth() {
        return this.viewportWidth;
    }

    public final float getViewportHeight() {
        return this.viewportHeight;
    }

    @NotNull
    public final FrameBuffer getPreviousModuleFbo() {
        return this.previousModuleFbo;
    }

    public final void setPreviousModuleFbo(@NotNull FrameBuffer frameBuffer) {
        Intrinsics.checkNotNullParameter((Object)frameBuffer, (String)"<set-?>");
        this.previousModuleFbo = frameBuffer;
    }

    @NotNull
    public final FrameBuffer getNextModuleFbo() {
        return this.nextModuleFbo;
    }

    public final void setNextModuleFbo(@NotNull FrameBuffer frameBuffer) {
        Intrinsics.checkNotNullParameter((Object)frameBuffer, (String)"<set-?>");
        this.nextModuleFbo = frameBuffer;
    }

    public final float getFirstDuration() {
        return this.firstDuration;
    }

    public final float getNextDuration() {
        return this.nextDuration;
    }

    @Override
    public void teardown() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void update(float delta) {
        void blue$iv;
        void green$iv;
        void red$iv;
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float alpha$iv = 1.0f;
        boolean clearDepth$iv = true;
        boolean $i$f$clearScreen = false;
        ScreenUtils.clear((float)red$iv, (float)green$iv, (float)blue$iv, (float)alpha$iv, (boolean)clearDepth$iv);
        this.currentTime += delta;
        Gdx.gl.glEnable(3042);
        Gdx.gl.glBlendFunc(770, 771);
        if (this.currentTime < this.firstDuration) {
            this.drawModule(this.previousModuleFbo, (this.firstDuration - this.currentTime) / this.firstDuration);
        } else {
            float elapsed = (this.currentTime - this.firstDuration) / (this.nextDuration * 1.5f);
            this.drawModule(this.nextModuleFbo, Interpolation.exp10Out.apply(elapsed));
            FadeModuleLoader.getFrame$default(this, this.next, this.nextModuleFbo, 0.0f, 4, null);
        }
        Gdx.gl.glDisable(3042);
    }

    public final void getFrame(@NotNull GameModule gameModule, @NotNull FrameBuffer fbo, float delta) {
        Intrinsics.checkNotNullParameter((Object)gameModule, (String)"gameModule");
        Intrinsics.checkNotNullParameter((Object)fbo, (String)"fbo");
        fbo.begin();
        gameModule.update(delta);
        fbo.end();
        TBEngineKt.getGlobals().getDrawGfx().getViewport().update(GameFilesKt.getGameConfig().getScreenWidth(), GameFilesKt.getGameConfig().getScreenHeight());
    }

    public static /* synthetic */ void getFrame$default(FadeModuleLoader fadeModuleLoader, GameModule gameModule, FrameBuffer frameBuffer, float f, int n, Object object) {
        if ((n & 4) != 0) {
            f = 0.0f;
        }
        fadeModuleLoader.getFrame(gameModule, frameBuffer, f);
    }

    public final void drawModule(@NotNull FrameBuffer frame, float opacity) {
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        OrthographicCamera camera = TBEngineKt.getGlobals().getDrawGfx().getCamera();
        SpriteBatch spriteBatch = TBEngineKt.getGlobals().getDrawGfx().getSpriteBatch();
        float x = this.viewportWidth / 2.0f;
        float y = this.viewportHeight / 2.0f;
        spriteBatch.begin();
        spriteBatch.setColor(1.0f, 1.0f, 1.0f, opacity);
        Array array = frame.getTextureAttachments();
        Intrinsics.checkNotNullExpressionValue((Object)array, (String)"frame.textureAttachments");
        Iterable $this$forEach$iv = (Iterable)array;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TextureRegion textureRegion;
            Texture it = (Texture)element$iv;
            boolean bl = false;
            TextureRegion it2 = textureRegion = new TextureRegion(it);
            boolean bl2 = false;
            it2.flip(false, true);
            TextureRegion textureRegion2 = textureRegion;
            spriteBatch.draw(textureRegion2, camera.position.x - x, camera.position.y - y, this.getViewportWidth(), this.getViewportHeight());
        }
        spriteBatch.end();
        TBEngineKt.getGlobals().getDrawGfx().getViewport().update(GameFilesKt.getGameConfig().getScreenWidth(), GameFilesKt.getGameConfig().getScreenHeight());
    }

    public static /* synthetic */ void drawModule$default(FadeModuleLoader fadeModuleLoader, FrameBuffer frameBuffer, float f, int n, Object object) {
        if ((n & 2) != 0) {
            f = 1.0f;
        }
        fadeModuleLoader.drawModule(frameBuffer, f);
    }

    @Override
    @NotNull
    public GameModule nextState() {
        GameModule gameModule;
        if (this.currentTime * 1.3f < this.fadeDuration) {
            gameModule = this;
        } else {
            this.previousModuleFbo.dispose();
            this.nextModuleFbo.dispose();
            gameModule = this.next;
        }
        return gameModule;
    }

    @NotNull
    public final GameModule component1() {
        return this.previous;
    }

    public final float component2() {
        return this.fadeDuration;
    }

    @NotNull
    public final Engine component3() {
        return this.getEngine();
    }

    @NotNull
    public final GameModule component4() {
        return this.next;
    }

    @NotNull
    public final FadeModuleLoader copy(@NotNull GameModule previous, float fadeDuration, @NotNull Engine engine, @NotNull GameModule next) {
        Intrinsics.checkNotNullParameter((Object)previous, (String)"previous");
        Intrinsics.checkNotNullParameter((Object)engine, (String)"engine");
        Intrinsics.checkNotNullParameter((Object)next, (String)"next");
        return new FadeModuleLoader(previous, fadeDuration, engine, next);
    }

    public static /* synthetic */ FadeModuleLoader copy$default(FadeModuleLoader fadeModuleLoader, GameModule gameModule, float f, Engine engine, GameModule gameModule2, int n, Object object) {
        if ((n & 1) != 0) {
            gameModule = fadeModuleLoader.previous;
        }
        if ((n & 2) != 0) {
            f = fadeModuleLoader.fadeDuration;
        }
        if ((n & 4) != 0) {
            engine = fadeModuleLoader.getEngine();
        }
        if ((n & 8) != 0) {
            gameModule2 = fadeModuleLoader.next;
        }
        return fadeModuleLoader.copy(gameModule, f, engine, gameModule2);
    }

    @NotNull
    public String toString() {
        return "FadeModuleLoader(previous=" + this.previous + ", fadeDuration=" + this.fadeDuration + ", engine=" + this.getEngine() + ", next=" + this.next + ')';
    }

    public int hashCode() {
        int result = this.previous.hashCode();
        result = result * 31 + Float.hashCode(this.fadeDuration);
        result = result * 31 + this.getEngine().hashCode();
        result = result * 31 + this.next.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof FadeModuleLoader)) {
            return false;
        }
        FadeModuleLoader fadeModuleLoader = (FadeModuleLoader)other;
        if (!Intrinsics.areEqual((Object)this.previous, (Object)fadeModuleLoader.previous)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)Float.valueOf(this.fadeDuration), (Object)Float.valueOf(fadeModuleLoader.fadeDuration))) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getEngine(), (Object)fadeModuleLoader.getEngine())) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.next, (Object)fadeModuleLoader.next);
    }
}

