/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.Null;
import com.badlogic.gdx.utils.Pool;
import com.badlogic.gdx.utils.reflect.ClassReflection;
import com.badlogic.gdx.utils.reflect.Constructor;
import com.badlogic.gdx.utils.reflect.ReflectionException;

public class ReflectionPool<T>
extends Pool<T> {
    private final Constructor constructor;

    public ReflectionPool(Class<T> type2) {
        this(type2, 16, Integer.MAX_VALUE);
    }

    public ReflectionPool(Class<T> type2, int initialCapacity) {
        this(type2, initialCapacity, Integer.MAX_VALUE);
    }

    public ReflectionPool(Class<T> type2, int initialCapacity, int max) {
        super(initialCapacity, max);
        this.constructor = this.findConstructor(type2);
        if (this.constructor == null) {
            throw new RuntimeException("Class cannot be created (missing no-arg constructor): " + type2.getName());
        }
    }

    @Null
    private Constructor findConstructor(Class<T> type2) {
        try {
            return ClassReflection.getConstructor(type2, null);
        }
        catch (Exception ex1) {
            try {
                Constructor constructor = ClassReflection.getDeclaredConstructor(type2, null);
                constructor.setAccessible(true);
                return constructor;
            }
            catch (ReflectionException ex2) {
                return null;
            }
        }
    }

    @Override
    protected T newObject() {
        try {
            return (T)this.constructor.newInstance(null);
        }
        catch (Exception ex) {
            throw new GdxRuntimeException("Unable to create new instance: " + this.constructor.getDeclaringClass().getName(), ex);
        }
    }
}

