/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.java.lazy;

import java.util.Collection;
import java.util.List;
import kotlin.LazyKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageFragmentDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageFragmentProviderOptimized;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.JavaResolverComponents;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.LazyJavaResolverContext;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.TypeParameterResolver;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.descriptors.LazyJavaPackageFragment;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaPackage;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.storage.CacheWithNotNullValues;
import kotlin.reflect.jvm.internal.impl.utils.CollectionsKt;
import org.jetbrains.annotations.NotNull;

public final class LazyJavaPackageFragmentProvider
implements PackageFragmentProviderOptimized {
    @NotNull
    private final LazyJavaResolverContext c;
    @NotNull
    private final CacheWithNotNullValues<FqName, LazyJavaPackageFragment> packageFragments;

    public LazyJavaPackageFragmentProvider(@NotNull JavaResolverComponents components2) {
        Intrinsics.checkNotNullParameter(components2, "components");
        this.c = new LazyJavaResolverContext(components2, TypeParameterResolver.EMPTY.INSTANCE, LazyKt.lazyOf(null));
        this.packageFragments = this.c.getStorageManager().createCacheWithNotNullValues();
    }

    private final LazyJavaPackageFragment getPackageFragment(FqName fqName2) {
        JavaPackage javaPackage = this.c.getComponents().getFinder().findPackage(fqName2);
        if (javaPackage == null) {
            return null;
        }
        JavaPackage jPackage = javaPackage;
        return this.packageFragments.computeIfAbsent(fqName2, new Function0<LazyJavaPackageFragment>(this, jPackage){
            final /* synthetic */ LazyJavaPackageFragmentProvider this$0;
            final /* synthetic */ JavaPackage $jPackage;
            {
                this.this$0 = $receiver;
                this.$jPackage = $jPackage;
                super(0);
            }

            @NotNull
            public final LazyJavaPackageFragment invoke() {
                return new LazyJavaPackageFragment(LazyJavaPackageFragmentProvider.access$getC$p(this.this$0), this.$jPackage);
            }
        });
    }

    @NotNull
    public List<LazyJavaPackageFragment> getPackageFragments(@NotNull FqName fqName2) {
        Intrinsics.checkNotNullParameter(fqName2, "fqName");
        return kotlin.collections.CollectionsKt.listOfNotNull(this.getPackageFragment(fqName2));
    }

    @Override
    public void collectPackageFragments(@NotNull FqName fqName2, @NotNull Collection<PackageFragmentDescriptor> packageFragments2) {
        Intrinsics.checkNotNullParameter(fqName2, "fqName");
        Intrinsics.checkNotNullParameter(packageFragments2, "packageFragments");
        CollectionsKt.addIfNotNull(packageFragments2, this.getPackageFragment(fqName2));
    }

    @Override
    public boolean isEmpty(@NotNull FqName fqName2) {
        Intrinsics.checkNotNullParameter(fqName2, "fqName");
        return this.c.getComponents().getFinder().findPackage(fqName2) == null;
    }

    @NotNull
    public List<FqName> getSubPackagesOf(@NotNull FqName fqName2, @NotNull Function1<? super Name, Boolean> nameFilter) {
        Intrinsics.checkNotNullParameter(fqName2, "fqName");
        Intrinsics.checkNotNullParameter(nameFilter, "nameFilter");
        LazyJavaPackageFragment lazyJavaPackageFragment = this.getPackageFragment(fqName2);
        List<FqName> list = lazyJavaPackageFragment == null ? null : lazyJavaPackageFragment.getSubPackageFqNames$descriptors_jvm();
        return list == null ? kotlin.collections.CollectionsKt.emptyList() : list;
    }

    @NotNull
    public String toString() {
        return Intrinsics.stringPlus("LazyJavaPackageFragmentProvider of module ", this.c.getComponents().getModule());
    }

    public static final /* synthetic */ LazyJavaResolverContext access$getC$p(LazyJavaPackageFragmentProvider $this) {
        return $this.c;
    }
}

