/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.engine.asset.assetloader;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.veiset.kgame.engine.asset.AnimationData;
import org.veiset.kgame.engine.asset.AssetLoader;
import org.veiset.kgame.engine.asset.AssetRef;
import org.veiset.kgame.engine.behaviour.Animation;
import org.veiset.kgame.engine.behaviour.AnimationSet;
import org.veiset.kgame.engine.util.TextureUtilsKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001B\u0005\u00a2\u0006\u0002\u0010\u0005J)\u0010\u0006\u001a\u00020\u00072\u0012\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\t2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0004H\u0016J\u001d\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\u0012J\u0010\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u0003H\u0016\u00a8\u0006\u0015"}, d2={"Lorg/veiset/kgame/engine/asset/assetloader/AnimationSetLoader;", "Lorg/veiset/kgame/engine/asset/AssetLoader;", "", "Lorg/veiset/kgame/engine/behaviour/AnimationSet;", "Lorg/veiset/kgame/engine/asset/AssetRef$AnimationSetRef;", "()V", "getAnimation", "Lorg/veiset/kgame/engine/behaviour/Animation;", "textureArea", "", "Lcom/badlogic/gdx/graphics/g2d/TextureRegion;", "animationData", "Lorg/veiset/kgame/engine/asset/AnimationData;", "([[Lcom/badlogic/gdx/graphics/g2d/TextureRegion;Lorg/veiset/kgame/engine/asset/AnimationData;)Lorg/veiset/kgame/engine/behaviour/Animation;", "loadAsync", "ref", "loadSync", "preloaded", "(Lorg/veiset/kgame/engine/asset/AssetRef$AnimationSetRef;Lkotlin/Unit;)Lorg/veiset/kgame/engine/behaviour/AnimationSet;", "unload", "asset", "kgame2"})
public final class AnimationSetLoader
implements AssetLoader<Unit, AnimationSet, AssetRef.AnimationSetRef> {
    @Override
    public void loadAsync(@NotNull AssetRef.AnimationSetRef ref) {
        Intrinsics.checkNotNullParameter(ref, "ref");
    }

    @Override
    @NotNull
    public AnimationSet loadSync(@NotNull AssetRef.AnimationSetRef ref, @NotNull Unit preloaded) {
        Intrinsics.checkNotNullParameter(ref, "ref");
        Intrinsics.checkNotNullParameter(preloaded, "preloaded");
        Pair<Integer, Integer> pair = ref.getSize();
        int sizeX = ((Number)pair.component1()).intValue();
        int sizeY = ((Number)pair.component2()).intValue();
        TextureRegion[][] textureRegionArray = TextureRegion.split(new Texture(Gdx.files.internal(ref.getPath())), sizeX, sizeY);
        Intrinsics.checkNotNullExpressionValue(textureRegionArray, "split(Texture(Gdx.files.\u2026ref.path)), sizeX, sizeY)");
        TextureRegion[][] texture = textureRegionArray;
        return new AnimationSet(this.getAnimation(texture, ref.getIdle()), this.getAnimation(texture, ref.getMoving()), this.getAnimation(texture, ref.getAttack()), this.getAnimation(texture, ref.getDodge()), this.getAnimation(texture, ref.getStagger()), this.getAnimation(texture, ref.getDeath()));
    }

    @Override
    public void unload(@NotNull AnimationSet asset) {
        Intrinsics.checkNotNullParameter(asset, "asset");
    }

    private final Animation getAnimation(TextureRegion[][] textureArea, AnimationData animationData) {
        List frames = CollectionsKt.toList((Iterable)TextureUtilsKt.texture(animationData.getFrames(), textureArea[animationData.getTextureId()]));
        return new Animation(frames, animationData.getDuration(), animationData.getRepeating(), 0.0f, 8, null);
    }
}

