/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.engine.behaviour;

import com.badlogic.ashley.core.Entity;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.veiset.kgame.engine.behaviour.ActionType;
import org.veiset.kgame.engine.behaviour.AnimationSpeedModifier;
import org.veiset.kgame.engine.behaviour.BehaviourStateChange;
import org.veiset.kgame.engine.behaviour.DynamicAnimation;
import org.veiset.kgame.engine.ecs.core.component.physics.VelocityComponent;
import org.veiset.kgame.engine.ecs.core.system.Mapper;
import org.veiset.kgame.engine.math.Vector2Kt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\nH\u0016J \u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0014"}, d2={"Lorg/veiset/kgame/engine/behaviour/ZombieBehaviour;", "Lorg/veiset/kgame/engine/behaviour/BehaviourStateChange;", "zombieEntity", "Lcom/badlogic/ashley/core/Entity;", "(Lcom/badlogic/ashley/core/Entity;)V", "getZombieEntity", "()Lcom/badlogic/ashley/core/Entity;", "completedState", "", "completedAction", "Lorg/veiset/kgame/engine/behaviour/ActionType;", "newState", "newAction", "update", "dynamicAnimation", "Lorg/veiset/kgame/engine/behaviour/DynamicAnimation;", "delta", "", "speed", "Lorg/veiset/kgame/engine/behaviour/AnimationSpeedModifier;", "kgame2"})
public final class ZombieBehaviour
implements BehaviourStateChange {
    @NotNull
    private final Entity zombieEntity;

    public ZombieBehaviour(@NotNull Entity zombieEntity) {
        Intrinsics.checkNotNullParameter(zombieEntity, "zombieEntity");
        this.zombieEntity = zombieEntity;
    }

    @NotNull
    public final Entity getZombieEntity() {
        return this.zombieEntity;
    }

    @Override
    public void update(@NotNull DynamicAnimation dynamicAnimation, float delta, @NotNull AnimationSpeedModifier speed) {
        Intrinsics.checkNotNullParameter(dynamicAnimation, "dynamicAnimation");
        Intrinsics.checkNotNullParameter(speed, "speed");
        VelocityComponent velocity = Mapper.INSTANCE.getVelocity().get(this.zombieEntity);
        if (velocity.getSpeed().x == 0.0f && velocity.getSpeed().y == 0.0f) {
            dynamicAnimation.queueAction(ActionType.Idle.INSTANCE);
        } else {
            dynamicAnimation.queueAction(new ActionType.Moving(Vector2Kt.x(10.0f, 1.0f)));
        }
    }

    @Override
    public void newState(@NotNull ActionType newAction) {
        Intrinsics.checkNotNullParameter(newAction, "newAction");
    }

    @Override
    public void completedState(@NotNull ActionType completedAction) {
        Intrinsics.checkNotNullParameter(completedAction, "completedAction");
    }
}

