/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.engine.ecs.attack.entity;

import com.badlogic.ashley.core.Entity;
import com.badlogic.gdx.audio.Sound;
import com.badlogic.gdx.graphics.g2d.Animation;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.World;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.veiset.kgame.engine.Log;
import org.veiset.kgame.engine.TBEngineKt;
import org.veiset.kgame.engine.asset.AssetManager;
import org.veiset.kgame.engine.asset.AssetRef;
import org.veiset.kgame.engine.ecs.attack.component.BaseAttackComponent;
import org.veiset.kgame.engine.ecs.attack.component.skills.AttackDirectComponent;
import org.veiset.kgame.engine.ecs.attack.component.skills.AttackImpactAnimationComponent;
import org.veiset.kgame.engine.ecs.attack.component.skills.AttackImpactSoundComponent;
import org.veiset.kgame.engine.ecs.attack.component.skills.ProjectileComponent;
import org.veiset.kgame.engine.ecs.collision.system.CollisionGroup;
import org.veiset.kgame.engine.ecs.core.component.FixedDurationComponent;
import org.veiset.kgame.engine.ecs.core.component.PositionComponent;
import org.veiset.kgame.engine.ecs.core.component.draw.Direction;
import org.veiset.kgame.engine.ecs.core.component.draw.SpriteGfxComponent;
import org.veiset.kgame.engine.ecs.core.component.physics.DynamicBodyComponent;
import org.veiset.kgame.engine.ecs.core.component.physics.VelocityComponent;
import org.veiset.kgame.engine.ecs.sound.component.SoundType;
import org.veiset.kgame.engine.math.Vector2Kt;
import org.veiset.kgame.engine.modifier.BaseAttack;
import org.veiset.kgame.engine.values.Asset;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/veiset/kgame/engine/ecs/attack/entity/BallAttackEntity;", "Lcom/badlogic/ashley/core/Entity;", "world", "Lcom/badlogic/gdx/physics/box2d/World;", "startPosition", "Lcom/badlogic/gdx/math/Vector2;", "target", "speed", "", "duration", "baseAttack", "Lorg/veiset/kgame/engine/modifier/BaseAttack;", "(Lcom/badlogic/gdx/physics/box2d/World;Lcom/badlogic/gdx/math/Vector2;Lcom/badlogic/gdx/math/Vector2;FFLorg/veiset/kgame/engine/modifier/BaseAttack;)V", "am", "Lorg/veiset/kgame/engine/asset/AssetManager;", "size", "kgame2"})
public final class BallAttackEntity
extends Entity {
    @NotNull
    private final Vector2 size;
    @NotNull
    private final AssetManager am;

    public BallAttackEntity(@NotNull World world, @NotNull Vector2 startPosition, @NotNull Vector2 target, float speed, float duration, @NotNull BaseAttack baseAttack) {
        Sound sound;
        Animation animation;
        TextureRegion textureRegion;
        AssetRef assetRef$iv;
        AssetManager this_$iv;
        Intrinsics.checkNotNullParameter(world, "world");
        Intrinsics.checkNotNullParameter(startPosition, "startPosition");
        Intrinsics.checkNotNullParameter(target, "target");
        Intrinsics.checkNotNullParameter(baseAttack, "baseAttack");
        this.size = Vector2Kt.x(0.1f, 0.1f);
        this.am = TBEngineKt.getGlobals().getAssetManager();
        Vector2 initialVelocity = Vector2Kt.minus(target, startPosition).nor().scl(speed);
        this.add(new DynamicBodyComponent(world, this, this.size, startPosition, CollisionGroup.INSTANCE.getNO_PLAYER_COLLISION(), 0.0f, 32, null));
        AssetManager assetManager = this.am;
        AssetRef assetRef = Asset.Texture.INSTANCE.getAttackBall();
        BallAttackEntity ballAttackEntity = this;
        boolean $i$f$get = false;
        try {
            Object object = this_$iv.getAssets().get(assetRef$iv);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.badlogic.gdx.graphics.g2d.TextureRegion");
            }
            textureRegion = (TextureRegion)object;
        }
        catch (Exception ex$iv) {
            Log.INSTANCE.critical("AssetRef " + assetRef$iv + " not loaded");
            throw ex$iv;
        }
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n = 28;
        float f = 0.0f;
        float f2 = 0.0f;
        int n2 = 0;
        Vector2 vector2 = Vector2Kt.x(0.1f, 0.1f);
        TextureRegion textureRegion2 = textureRegion;
        ballAttackEntity.add(new SpriteGfxComponent(textureRegion2, vector2, n2, f2, f, n, defaultConstructorMarker));
        this.add(new PositionComponent(startPosition));
        Intrinsics.checkNotNullExpressionValue(initialVelocity, "initialVelocity");
        this.add(new VelocityComponent(initialVelocity));
        this.add(new AttackDirectComponent(0.0f, 1, null));
        this.add(new BaseAttackComponent(baseAttack));
        this.add(new ProjectileComponent(initialVelocity, speed));
        this.add(new FixedDurationComponent(duration));
        this_$iv = this.am;
        assetRef$iv = Asset.Animation.INSTANCE.getExplosion();
        ballAttackEntity = this;
        $i$f$get = false;
        try {
            Object object = this_$iv.getAssets().get(assetRef$iv);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.badlogic.gdx.graphics.g2d.Animation<com.badlogic.gdx.graphics.g2d.TextureRegion>");
            }
            animation = (Animation)object;
        }
        catch (Exception ex$iv) {
            Log.INSTANCE.critical("AssetRef " + assetRef$iv + " not loaded");
            throw ex$iv;
        }
        DefaultConstructorMarker defaultConstructorMarker2 = null;
        int n3 = 12;
        int n4 = 0;
        Direction direction = null;
        Vector2 vector22 = Vector2Kt.x(0.5f, 0.5f);
        Animation animation2 = animation;
        ballAttackEntity.add(new AttackImpactAnimationComponent(animation2, vector22, direction, n4, n3, defaultConstructorMarker2));
        this_$iv = this.am;
        assetRef$iv = Asset.Sound.INSTANCE.getExplosion();
        ballAttackEntity = this;
        $i$f$get = false;
        try {
            Object object = this_$iv.getAssets().get(assetRef$iv);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.badlogic.gdx.audio.Sound");
            }
            sound = (Sound)object;
        }
        catch (Exception ex$iv) {
            Log.INSTANCE.critical("AssetRef " + assetRef$iv + " not loaded");
            throw ex$iv;
        }
        DefaultConstructorMarker defaultConstructorMarker3 = null;
        int n5 = 24;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 1.0f;
        SoundType soundType = SoundType.EFFECT;
        Sound sound2 = sound;
        ballAttackEntity.add(new AttackImpactSoundComponent(sound2, soundType, f5, f4, f3, n5, defaultConstructorMarker3));
    }

    public /* synthetic */ BallAttackEntity(World world, Vector2 vector2, Vector2 vector22, float f, float f2, BaseAttack baseAttack, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            f2 = 3.0f;
        }
        this(world, vector2, vector22, f, f2, baseAttack);
    }
}

