/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.engine.ecs.collision.system;

import com.badlogic.ashley.core.Component;
import com.badlogic.ashley.core.ComponentMapper;
import com.badlogic.ashley.core.Engine;
import com.badlogic.ashley.core.Entity;
import com.badlogic.ashley.core.Family;
import com.badlogic.ashley.systems.IteratingSystem;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.World;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import org.jetbrains.annotations.NotNull;
import org.veiset.kgame.engine.GameFilesKt;
import org.veiset.kgame.engine.Log;
import org.veiset.kgame.engine.LoggerKt;
import org.veiset.kgame.engine.TBEngineKt;
import org.veiset.kgame.engine.asset.AssetManager;
import org.veiset.kgame.engine.asset.AssetRef;
import org.veiset.kgame.engine.ecs.attack.component.BaseAttackComponent;
import org.veiset.kgame.engine.ecs.attack.component.skills.AttackImpactAnimationComponent;
import org.veiset.kgame.engine.ecs.attack.component.skills.AttackImpactSoundComponent;
import org.veiset.kgame.engine.ecs.attack.component.skills.ChainComponent;
import org.veiset.kgame.engine.ecs.attack.component.skills.HomingComponent;
import org.veiset.kgame.engine.ecs.attack.component.skills.ProjectileComponent;
import org.veiset.kgame.engine.ecs.attack.entity.BallAttackEntity;
import org.veiset.kgame.engine.ecs.collision.component.AttackCollisionComponent;
import org.veiset.kgame.engine.ecs.collision.system.AttackCollisionResolveSystem$chainAttack$;
import org.veiset.kgame.engine.ecs.collision.system.AttackCollisionResolveSystem$chainAttack$lambda-1$;
import org.veiset.kgame.engine.ecs.collision.system.AttackCollisionResolveSystem$chainAttack$lambda-3$;
import org.veiset.kgame.engine.ecs.collision.system.AttackCollisionResolveSystem$processEntity$;
import org.veiset.kgame.engine.ecs.core.component.FixedDurationComponent;
import org.veiset.kgame.engine.ecs.core.component.PositionComponent;
import org.veiset.kgame.engine.ecs.core.component.camera.CameraShake;
import org.veiset.kgame.engine.ecs.core.component.enemy.MonsterComponent;
import org.veiset.kgame.engine.ecs.core.component.physics.VelocityComponent;
import org.veiset.kgame.engine.ecs.core.component.stats.HealthComponent;
import org.veiset.kgame.engine.ecs.core.entity.camera.CameraMoveEntity;
import org.veiset.kgame.engine.ecs.core.entity.effect.SingleEffectAnimationEntity;
import org.veiset.kgame.engine.ecs.core.entity.effect.SingleEffectEntity;
import org.veiset.kgame.engine.ecs.core.entity.gameobjects.TextEffectEntity;
import org.veiset.kgame.engine.ecs.modifier.ModifiersComponent;
import org.veiset.kgame.engine.ecs.sound.component.SoundEffectComponent;
import org.veiset.kgame.engine.math.Vector2Kt;
import org.veiset.kgame.engine.modifier.BaseAttack;
import org.veiset.kgame.engine.modifier.DamageResult;
import org.veiset.kgame.engine.modifier.Modifier;
import org.veiset.kgame.engine.modifier.ModifierEngineKt;
import org.veiset.kgame.engine.util.EntityUtilsKt;
import org.veiset.kgame.engine.values.Asset;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J8\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0018\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u001aH\u0014R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001b"}, d2={"Lorg/veiset/kgame/engine/ecs/collision/system/AttackCollisionResolveSystem;", "Lcom/badlogic/ashley/systems/IteratingSystem;", "world", "Lcom/badlogic/gdx/physics/box2d/World;", "(Lcom/badlogic/gdx/physics/box2d/World;)V", "am", "Lorg/veiset/kgame/engine/asset/AssetManager;", "getAm", "()Lorg/veiset/kgame/engine/asset/AssetManager;", "getWorld", "()Lcom/badlogic/gdx/physics/box2d/World;", "chainAttack", "", "attacked", "Lcom/badlogic/ashley/core/Entity;", "position", "Lorg/veiset/kgame/engine/ecs/core/component/PositionComponent;", "projectile", "Lorg/veiset/kgame/engine/ecs/attack/component/skills/ProjectileComponent;", "chain", "Lorg/veiset/kgame/engine/ecs/attack/component/skills/ChainComponent;", "entity", "baseAttack", "Lorg/veiset/kgame/engine/modifier/BaseAttack;", "processEntity", "deltaTime", "", "kgame2"})
public final class AttackCollisionResolveSystem
extends IteratingSystem {
    @NotNull
    private final World world;
    @NotNull
    private final AssetManager am;

    public AttackCollisionResolveSystem(@NotNull World world) {
        Intrinsics.checkNotNullParameter(world, "world");
        Class[] classArray = new Class[]{AttackCollisionComponent.class, PositionComponent.class, BaseAttackComponent.class};
        super(Family.all(classArray).get());
        this.world = world;
        this.am = TBEngineKt.getGlobals().getAssetManager();
    }

    @NotNull
    public final World getWorld() {
        return this.world;
    }

    @NotNull
    public final AssetManager getAm() {
        return this.am;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void processEntity(@NotNull Entity entity, float deltaTime) {
        TextureRegion textureRegion;
        void assetRef$iv;
        Object hp;
        Intrinsics.checkNotNullParameter(entity, "entity");
        Entity $this$get$iv = entity;
        boolean $i$f$get = false;
        boolean $i$f$addMapperIfNone = false;
        if (!EntityUtilsKt.getMappers().containsKey(AttackCollisionComponent.class)) {
            LoggerKt.logTimed$default(Intrinsics.stringPlus("Added new mapper for ", AttackCollisionComponent.class), null, null, 0, processEntity$$inlined$get$1.INSTANCE, 14, null);
        }
        ComponentMapper<?> componentMapper = EntityUtilsKt.getMappers().get(AttackCollisionComponent.class);
        Intrinsics.checkNotNull(componentMapper);
        Object obj = componentMapper.get($this$get$iv);
        if (obj == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.veiset.kgame.engine.ecs.collision.component.AttackCollisionComponent");
        }
        AttackCollisionComponent attackCollision = (AttackCollisionComponent)((Component)((AttackCollisionComponent)obj));
        Entity attacked = attackCollision.getEntity();
        Entity $this$getOrNull$iv = entity;
        boolean $i$f$getOrNull = false;
        boolean $i$f$addMapperIfNone2 = false;
        if (!EntityUtilsKt.getMappers().containsKey(ChainComponent.class)) {
            LoggerKt.logTimed$default(Intrinsics.stringPlus("Added new mapper for ", ChainComponent.class), null, null, 0, processEntity$$inlined$getOrNull$1.INSTANCE, 14, null);
        }
        ComponentMapper<?> componentMapper2 = EntityUtilsKt.getMappers().get(ChainComponent.class);
        ChainComponent chain2 = (ChainComponent)((Component)(componentMapper2 == null ? null : componentMapper2.get($this$getOrNull$iv)));
        Entity $this$get$iv2 = entity;
        boolean $i$f$get2 = false;
        boolean $i$f$addMapperIfNone3 = false;
        if (!EntityUtilsKt.getMappers().containsKey(ProjectileComponent.class)) {
            LoggerKt.logTimed$default(Intrinsics.stringPlus("Added new mapper for ", ProjectileComponent.class), null, null, 0, processEntity$$inlined$get$2.INSTANCE, 14, null);
        }
        ComponentMapper<?> componentMapper3 = EntityUtilsKt.getMappers().get(ProjectileComponent.class);
        Intrinsics.checkNotNull(componentMapper3);
        Object obj2 = componentMapper3.get($this$get$iv2);
        if (obj2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.veiset.kgame.engine.ecs.attack.component.skills.ProjectileComponent");
        }
        ProjectileComponent projectile = (ProjectileComponent)((Component)((ProjectileComponent)obj2));
        Entity $this$get$iv3 = entity;
        boolean $i$f$get3 = false;
        boolean $i$f$addMapperIfNone4 = false;
        if (!EntityUtilsKt.getMappers().containsKey(PositionComponent.class)) {
            LoggerKt.logTimed$default(Intrinsics.stringPlus("Added new mapper for ", PositionComponent.class), null, null, 0, processEntity$$inlined$get$3.INSTANCE, 14, null);
        }
        ComponentMapper<?> componentMapper4 = EntityUtilsKt.getMappers().get(PositionComponent.class);
        Intrinsics.checkNotNull(componentMapper4);
        Object obj3 = componentMapper4.get($this$get$iv3);
        if (obj3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.veiset.kgame.engine.ecs.core.component.PositionComponent");
        }
        PositionComponent position = (PositionComponent)((Component)((PositionComponent)obj3));
        Entity $this$getOrNull$iv2 = entity;
        boolean $i$f$getOrNull2 = false;
        boolean $i$f$addMapperIfNone5 = false;
        if (!EntityUtilsKt.getMappers().containsKey(VelocityComponent.class)) {
            LoggerKt.logTimed$default(Intrinsics.stringPlus("Added new mapper for ", VelocityComponent.class), null, null, 0, processEntity$$inlined$getOrNull$2.INSTANCE, 14, null);
        }
        ComponentMapper<?> componentMapper5 = EntityUtilsKt.getMappers().get(VelocityComponent.class);
        VelocityComponent velocity = (VelocityComponent)((Component)(componentMapper5 == null ? null : componentMapper5.get($this$getOrNull$iv2)));
        Entity $this$getOrNull$iv3 = entity;
        boolean $i$f$getOrNull3 = false;
        boolean $i$f$addMapperIfNone6 = false;
        if (!EntityUtilsKt.getMappers().containsKey(AttackImpactAnimationComponent.class)) {
            LoggerKt.logTimed$default(Intrinsics.stringPlus("Added new mapper for ", AttackImpactAnimationComponent.class), null, null, 0, processEntity$$inlined$getOrNull$3.INSTANCE, 14, null);
        }
        ComponentMapper<?> componentMapper6 = EntityUtilsKt.getMappers().get(AttackImpactAnimationComponent.class);
        AttackImpactAnimationComponent impactAnimation = (AttackImpactAnimationComponent)((Component)(componentMapper6 == null ? null : componentMapper6.get($this$getOrNull$iv3)));
        Entity $this$getOrNull$iv4 = entity;
        boolean $i$f$getOrNull4 = false;
        boolean $i$f$addMapperIfNone7 = false;
        if (!EntityUtilsKt.getMappers().containsKey(AttackImpactSoundComponent.class)) {
            LoggerKt.logTimed$default(Intrinsics.stringPlus("Added new mapper for ", AttackImpactSoundComponent.class), null, null, 0, processEntity$$inlined$getOrNull$4.INSTANCE, 14, null);
        }
        ComponentMapper<?> componentMapper7 = EntityUtilsKt.getMappers().get(AttackImpactSoundComponent.class);
        AttackImpactSoundComponent impactSound = (AttackImpactSoundComponent)((Component)(componentMapper7 == null ? null : componentMapper7.get($this$getOrNull$iv4)));
        Entity $this$get$iv4 = entity;
        boolean $i$f$get4 = false;
        boolean $i$f$addMapperIfNone8 = false;
        if (!EntityUtilsKt.getMappers().containsKey(BaseAttackComponent.class)) {
            LoggerKt.logTimed$default(Intrinsics.stringPlus("Added new mapper for ", BaseAttackComponent.class), null, null, 0, processEntity$$inlined$get$4.INSTANCE, 14, null);
        }
        ComponentMapper<?> componentMapper8 = EntityUtilsKt.getMappers().get(BaseAttackComponent.class);
        Intrinsics.checkNotNull(componentMapper8);
        Object obj4 = componentMapper8.get($this$get$iv4);
        if (obj4 == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.veiset.kgame.engine.ecs.attack.component.BaseAttackComponent");
        }
        BaseAttack baseAttack = ((BaseAttackComponent)((Component)((BaseAttackComponent)obj4))).getAttack();
        Entity $this$getOrNull$iv5 = entity;
        boolean $i$f$getOrNull5 = false;
        boolean $i$f$addMapperIfNone9 = false;
        if (!EntityUtilsKt.getMappers().containsKey(ModifiersComponent.class)) {
            LoggerKt.logTimed$default(Intrinsics.stringPlus("Added new mapper for ", ModifiersComponent.class), null, null, 0, processEntity$$inlined$getOrNull$5.INSTANCE, 14, null);
        }
        ComponentMapper<?> componentMapper9 = EntityUtilsKt.getMappers().get(ModifiersComponent.class);
        ModifiersComponent modifiersComponent = (ModifiersComponent)((Component)(componentMapper9 == null ? null : componentMapper9.get($this$getOrNull$iv5)));
        List<Modifier> list = modifiersComponent == null ? null : modifiersComponent.all();
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        List<Modifier> attackingModifiers = list;
        Entity $this$getOrNull$iv6 = attacked;
        boolean $i$f$getOrNull6 = false;
        boolean $i$f$addMapperIfNone102 = false;
        if (!EntityUtilsKt.getMappers().containsKey(ModifiersComponent.class)) {
            LoggerKt.logTimed$default(Intrinsics.stringPlus("Added new mapper for ", ModifiersComponent.class), null, null, 0, processEntity$$inlined$getOrNull$6.INSTANCE, 14, null);
        }
        ComponentMapper<?> componentMapper10 = EntityUtilsKt.getMappers().get(ModifiersComponent.class);
        ModifiersComponent modifiersComponent2 = (ModifiersComponent)((Component)(componentMapper10 == null ? null : componentMapper10.get($this$getOrNull$iv6)));
        List<Modifier> list2 = modifiersComponent2 == null ? null : modifiersComponent2.all();
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        List<Modifier> defendingModifiers = list2;
        Entity $this$has$iv = attacked;
        boolean $i$f$has = false;
        boolean $i$f$addMapperIfNone11 = false;
        if (!EntityUtilsKt.getMappers().containsKey(MonsterComponent.class)) {
            LoggerKt.logTimed$default(Intrinsics.stringPlus("Added new mapper for ", MonsterComponent.class), null, null, 0, processEntity$$inlined$has$1.INSTANCE, 14, null);
        }
        ComponentMapper<?> componentMapper11 = EntityUtilsKt.getMappers().get(MonsterComponent.class);
        if (componentMapper11 == null ? false : ($i$f$getOrNull6 = componentMapper11.has($this$has$iv))) {
            Object finalDamage;
            $this$getOrNull$iv = attacked;
            $i$f$getOrNull = false;
            $i$f$addMapperIfNone9 = false;
            if (!EntityUtilsKt.getMappers().containsKey(HealthComponent.class)) {
                LoggerKt.logTimed$default(Intrinsics.stringPlus("Added new mapper for ", HealthComponent.class), null, null, 0, processEntity$$inlined$getOrNull$7.INSTANCE, 14, null);
            }
            ComponentMapper<?> componentMapper12 = EntityUtilsKt.getMappers().get(HealthComponent.class);
            hp = (HealthComponent)((Component)(componentMapper12 == null ? null : componentMapper12.get($this$getOrNull$iv)));
            if (hp != null) {
                Color color;
                finalDamage = ModifierEngineKt.calculateDirectDamage(baseAttack, CollectionsKt.plus((Collection)attackingModifiers, (Iterable)baseAttack.getModifiers()), defendingModifiers);
                Vector2 textPosition = Vector2Kt.copy(position.getPos());
                Vector2 textOffset = Vector2Kt.x(0.2f * Random.Default.nextFloat(), 0.3f * Random.Default.nextFloat());
                String[] $i$f$addMapperIfNone102 = finalDamage;
                if (Intrinsics.areEqual($i$f$addMapperIfNone102, DamageResult.BLOCK.INSTANCE)) {
                    Engine engine = this.getEngine();
                    color = Color.BLACK;
                    Intrinsics.checkNotNullExpressionValue(color, "BLACK");
                    engine.addEntity(new TextEffectEntity("BLOCK", textPosition, textOffset, color, 0.6f, 1));
                } else if (Intrinsics.areEqual($i$f$addMapperIfNone102, DamageResult.DODGE.INSTANCE)) {
                    Engine engine = this.getEngine();
                    color = Color.DARK_GRAY;
                    Intrinsics.checkNotNullExpressionValue(color, "DARK_GRAY");
                    engine.addEntity(new TextEffectEntity("DODGE", textPosition, textOffset, color, 0.6f, 1));
                } else if ($i$f$addMapperIfNone102 instanceof DamageResult.Critical) {
                    if (GameFilesKt.getGameConfig().getGameDisplayDamage()) {
                        Engine engine = this.getEngine();
                        String string2 = String.valueOf((int)((DamageResult.Critical)finalDamage).getDamage());
                        color = Color.ORANGE;
                        Intrinsics.checkNotNullExpressionValue(color, "ORANGE");
                        engine.addEntity(new TextEffectEntity(string2, textPosition, textOffset, color, 2.0f, 3));
                    }
                    ((HealthComponent)hp).setCurrentHealth(((HealthComponent)hp).getCurrentHealth() - ((DamageResult.Critical)finalDamage).getDamage());
                } else if ($i$f$addMapperIfNone102 instanceof DamageResult.Hit) {
                    if (GameFilesKt.getGameConfig().getGameDisplayDamage()) {
                        Engine engine = this.getEngine();
                        String string3 = String.valueOf((int)((DamageResult.Hit)finalDamage).getDamage());
                        color = Color.WHITE;
                        Intrinsics.checkNotNullExpressionValue(color, "WHITE");
                        engine.addEntity(new TextEffectEntity(string3, textPosition, textOffset, color, 1.3f, 2));
                    }
                    ((HealthComponent)hp).setCurrentHealth(((HealthComponent)hp).getCurrentHealth() - ((DamageResult.Hit)finalDamage).getDamage());
                }
            }
            if ((double)Random.Default.nextFloat() > 0.95) {
                Engine engine = this.getEngine();
                finalDamage = new String[]{"BLURGH", "RAURGHhh", "URRHGH"};
                String string4 = (String)CollectionsKt.random((Collection)CollectionsKt.listOf(finalDamage), Random.Default);
                Vector2 vector2 = Vector2Kt.copy(position.getPos());
                Vector2 vector22 = Vector2Kt.x(0.6f + -0.5f * Random.Default.nextFloat(), 0.5f + 0.3f * Random.Default.nextFloat());
                finalDamage = Color.BLACK;
                Intrinsics.checkNotNullExpressionValue(finalDamage, "BLACK");
                engine.addEntity(new TextEffectEntity(string4, vector2, vector22, (Color)finalDamage, 1.0f, 0, 32, null));
            }
            if (chain2 != null) {
                this.chainAttack(attacked, position, projectile, chain2, entity, baseAttack);
            }
        }
        if (impactAnimation != null) {
            this.getEngine().addEntity(new SingleEffectAnimationEntity(impactAnimation.getAnimation(), Vector2Kt.copy(position.getPos()), impactAnimation.getSize(), impactAnimation.getDirection(), impactAnimation.getLayer()));
        }
        if (impactSound != null) {
            this.getEngine().addEntity(new Entity().add(new SoundEffectComponent(impactSound.getSound(), impactSound.getType(), impactSound.getVolume(), impactSound.getPitch(), impactSound.getPan())));
        }
        if (velocity != null) {
            Engine engine = this.getEngine();
            hp = Vector2Kt.copy(velocity.getSpeed()).nor();
            Intrinsics.checkNotNullExpressionValue(hp, "velocity.speed.copy().nor()");
            engine.addEntity(new CameraMoveEntity(new CameraShake((Vector2)hp, 0.1f, 0.1f)));
        }
        Vector2 roffset = new Vector2(Vector2Kt.lerp(Random.Default.nextFloat(), -0.2f, 0.2f), Vector2Kt.lerp(Random.Default.nextFloat(), -0.3f, 0.3f));
        float rsize = Vector2Kt.lerp(Random.Default.nextFloat(), 0.3f, 0.8f);
        AssetManager textPosition = this.am;
        AssetRef textOffset = Asset.Texture.INSTANCE.getScorchMark();
        Engine engine = this.getEngine();
        boolean $i$f$get5 = false;
        try {
            void this_$iv;
            Object object = this_$iv.getAssets().get(assetRef$iv);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.badlogic.gdx.graphics.g2d.TextureRegion");
            }
            textureRegion = (TextureRegion)object;
        }
        catch (Exception ex$iv) {
            Log.INSTANCE.critical("AssetRef " + assetRef$iv + " not loaded");
            throw ex$iv;
        }
        float f = Vector2Kt.lerp(Random.Default.nextFloat(), 0.7f, 1.0f);
        float f2 = Vector2Kt.lerp(Random.Default.nextFloat(), 0.0f, 360.0f);
        int n = -2;
        Vector2 vector2 = Vector2Kt.x(rsize, rsize);
        Vector2 vector23 = Vector2Kt.plus(Vector2Kt.copy(position.getPos()), roffset);
        TextureRegion textureRegion2 = textureRegion;
        engine.addEntity(new SingleEffectEntity(textureRegion2, vector23, vector2, n, f2, f).add(new FixedDurationComponent(4.0f * Random.Default.nextFloat() * 3.0f)));
        entity.remove(AttackCollisionComponent.class);
        this.getEngine().removeEntity(entity);
    }

    /*
     * WARNING - void declaration
     */
    private final void chainAttack(Entity attacked, PositionComponent position, ProjectileComponent projectile, ChainComponent chain2, Entity entity, BaseAttack baseAttack) {
        Object v2;
        void $this$minByOrNull$iv;
        Object object;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Entity it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Class[] classArray = new Class[]{PositionComponent.class, MonsterComponent.class};
        Iterable<Entity> iterable = this.getEngine().getEntitiesFor(Family.all(classArray).get());
        Intrinsics.checkNotNullExpressionValue(iterable, "engine.getEntitiesFor(Fa\u2026onent::class.java).get())");
        iterable = iterable;
        boolean $i$f$filter = false;
        BallAttackEntity ballAttackEntity = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Entity)element$iv$iv;
            boolean bl = false;
            if (!(!Intrinsics.areEqual(it, attacked))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Entity)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue(it, "it");
            Entity $this$get$iv = it;
            boolean $i$f$get = false;
            boolean $i$f$addMapperIfNone = false;
            if (!EntityUtilsKt.getMappers().containsKey(PositionComponent.class)) {
                LoggerKt.logTimed$default(Intrinsics.stringPlus("Added new mapper for ", PositionComponent.class), null, null, 0, chainAttack$lambda-1$$inlined$get$1.INSTANCE, 14, null);
            }
            ComponentMapper<?> componentMapper = EntityUtilsKt.getMappers().get(PositionComponent.class);
            Intrinsics.checkNotNull(componentMapper);
            Object obj = componentMapper.get($this$get$iv);
            if (obj == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.veiset.kgame.engine.ecs.core.component.PositionComponent");
            }
            object.add((PositionComponent)((Component)((PositionComponent)obj)));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$minByOrNull = false;
        Iterator iterator$iv = $this$minByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v2 = null;
        } else {
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v2 = minElem$iv;
            } else {
                PositionComponent it2 = (PositionComponent)minElem$iv;
                boolean bl = false;
                float minValue$iv = it2.getPos().dst(position.getPos());
                do {
                    Object e$iv = iterator$iv.next();
                    PositionComponent it3 = (PositionComponent)e$iv;
                    $i$a$-minByOrNull-AttackCollisionResolveSystem$chainAttack$nextEnemyPos$3 = false;
                    float v$iv = it3.getPos().dst(position.getPos());
                    if (Float.compare(minValue$iv, v$iv) <= 0) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v2 = minElem$iv;
            }
        }
        PositionComponent nextEnemyPos = v2;
        if (nextEnemyPos != null) {
            void it4;
            Vector2 startPos = Vector2Kt.minus(nextEnemyPos.getPos(), position.getPos()).nor();
            Vector2 startoffset = startPos.scl(0.2f);
            Engine engine = this.getEngine();
            Vector2 vector2 = position.getPos();
            Intrinsics.checkNotNullExpressionValue(startoffset, "startoffset");
            Vector2 vector22 = Vector2Kt.plus(vector2, startoffset);
            Vector2 vector23 = Vector2Kt.copy(nextEnemyPos.getPos());
            float f = projectile.getSpeed();
            Entity $this$get$iv = entity;
            boolean $i$f$get22 = false;
            boolean $i$f$addMapperIfNone = false;
            if (!EntityUtilsKt.getMappers().containsKey(FixedDurationComponent.class)) {
                LoggerKt.logTimed$default(Intrinsics.stringPlus("Added new mapper for ", FixedDurationComponent.class), null, null, 0, chainAttack$$inlined$get$1.INSTANCE, 14, null);
            }
            ComponentMapper<?> componentMapper = EntityUtilsKt.getMappers().get(FixedDurationComponent.class);
            Intrinsics.checkNotNull(componentMapper);
            Object obj = componentMapper.get($this$get$iv);
            if (obj == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.veiset.kgame.engine.ecs.core.component.FixedDurationComponent");
            }
            BallAttackEntity $i$f$get22 = ballAttackEntity = new BallAttackEntity(this.world, vector22, vector23, f, ((FixedDurationComponent)((Component)((FixedDurationComponent)obj))).getReminding(), baseAttack);
            object = engine;
            boolean bl = false;
            if (chain2.getChains() > 1) {
                it4.add(new ChainComponent(chain2.getChains() - 1));
            }
            Entity $this$getOrNull$iv = entity;
            boolean $i$f$getOrNull = false;
            boolean $i$f$addMapperIfNone2 = false;
            if (!EntityUtilsKt.getMappers().containsKey(HomingComponent.class)) {
                LoggerKt.logTimed$default(Intrinsics.stringPlus("Added new mapper for ", HomingComponent.class), null, null, 0, chainAttack$lambda-3$$inlined$getOrNull$1.INSTANCE, 14, null);
            }
            ComponentMapper<?> componentMapper2 = EntityUtilsKt.getMappers().get(HomingComponent.class);
            if ((Component)(componentMapper2 == null ? null : componentMapper2.get($this$getOrNull$iv)) != null) {
                it4.add(new HomingComponent(nextEnemyPos.getPos(), 10.0f, 1.0f));
            }
            ((Engine)object).addEntity(ballAttackEntity);
        }
    }
}

