/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.engine.ecs.core.system;

import com.badlogic.ashley.core.Component;
import com.badlogic.ashley.core.ComponentMapper;
import com.badlogic.ashley.core.Engine;
import com.badlogic.ashley.core.Entity;
import com.badlogic.ashley.core.Family;
import com.badlogic.ashley.systems.IteratingSystem;
import com.badlogic.gdx.audio.Sound;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.World;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.veiset.kgame.engine.EngineConfig;
import org.veiset.kgame.engine.GameFilesKt;
import org.veiset.kgame.engine.Log;
import org.veiset.kgame.engine.LoggerKt;
import org.veiset.kgame.engine.TBEngineKt;
import org.veiset.kgame.engine.asset.AssetManager;
import org.veiset.kgame.engine.asset.AssetRef;
import org.veiset.kgame.engine.behaviour.Animation;
import org.veiset.kgame.engine.ecs.core.component.PositionComponent;
import org.veiset.kgame.engine.ecs.core.component.camera.CameraFollowComponent;
import org.veiset.kgame.engine.ecs.core.component.camera.CameraShake;
import org.veiset.kgame.engine.ecs.core.component.draw.Direction;
import org.veiset.kgame.engine.ecs.core.component.draw.DynamicAnimationComponent;
import org.veiset.kgame.engine.ecs.core.component.draw.LightStaticComponent;
import org.veiset.kgame.engine.ecs.core.component.draw.SpriteGfxComponent;
import org.veiset.kgame.engine.ecs.core.component.enemy.DebrisComponent;
import org.veiset.kgame.engine.ecs.core.component.enemy.MonsterComponent;
import org.veiset.kgame.engine.ecs.core.component.loot.LootTableComponent;
import org.veiset.kgame.engine.ecs.core.component.stats.HealthComponent;
import org.veiset.kgame.engine.ecs.core.entity.DelayAddEntity;
import org.veiset.kgame.engine.ecs.core.entity.ItemDropEntity;
import org.veiset.kgame.engine.ecs.core.entity.PlayerEntity;
import org.veiset.kgame.engine.ecs.core.entity.attack.SelfExplodeAttackEntity;
import org.veiset.kgame.engine.ecs.core.entity.camera.CameraMoveEntity;
import org.veiset.kgame.engine.ecs.core.entity.effect.SingleEffectAnimationEntity;
import org.veiset.kgame.engine.ecs.core.entity.effect.SingleEffectEntity;
import org.veiset.kgame.engine.ecs.core.entity.enemy.SpeedyDumbZombie;
import org.veiset.kgame.engine.ecs.core.system.DeathSystem$processEntity$;
import org.veiset.kgame.engine.ecs.core.system.Mapper;
import org.veiset.kgame.engine.ecs.core.system.MapperNullable;
import org.veiset.kgame.engine.ecs.core.system.PlayerDeathAnimationSystem;
import org.veiset.kgame.engine.item.Equipment;
import org.veiset.kgame.engine.item.Loot;
import org.veiset.kgame.engine.math.Vector2Kt;
import org.veiset.kgame.engine.util.EntityUtilsKt;
import org.veiset.kgame.engine.values.Asset;
import org.veiset.kgame.game.GameState;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0011"}, d2={"Lorg/veiset/kgame/engine/ecs/core/system/DeathSystem;", "Lcom/badlogic/ashley/systems/IteratingSystem;", "world", "Lcom/badlogic/gdx/physics/box2d/World;", "(Lcom/badlogic/gdx/physics/box2d/World;)V", "am", "Lorg/veiset/kgame/engine/asset/AssetManager;", "gameState", "Lorg/veiset/kgame/game/GameState;", "getWorld", "()Lcom/badlogic/gdx/physics/box2d/World;", "processEntity", "", "entity", "Lcom/badlogic/ashley/core/Entity;", "deltaTime", "", "kgame2"})
public final class DeathSystem
extends IteratingSystem {
    @NotNull
    private final World world;
    @NotNull
    private final AssetManager am;
    @NotNull
    private final GameState gameState;

    public DeathSystem(@NotNull World world) {
        Intrinsics.checkNotNullParameter(world, "world");
        Class[] classArray = new Class[]{HealthComponent.class};
        super(Family.all(classArray).get());
        this.world = world;
        this.am = TBEngineKt.getGlobals().getAssetManager();
        this.gameState = TBEngineKt.getGlobals().getState();
    }

    @NotNull
    public final World getWorld() {
        return this.world;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void processEntity(@NotNull Entity entity, float deltaTime) {
        Intrinsics.checkNotNullParameter(entity, "entity");
        HealthComponent health = Mapper.INSTANCE.getHealth().get(entity);
        if (entity instanceof PlayerEntity) {
            if (EngineConfig.Debug.INSTANCE.getUNKILLABLE()) {
                float f = 0.1f;
                float f2 = health.getCurrentHealth();
                health.setCurrentHealth(Math.max(f, f2));
            }
            if (health.getCurrentHealth() <= 0.0f) {
                Entity $this$get$iv = entity;
                boolean $i$f$get = false;
                boolean $i$f$addMapperIfNone = false;
                if (!EntityUtilsKt.getMappers().containsKey(PositionComponent.class)) {
                    LoggerKt.logTimed$default(Intrinsics.stringPlus("Added new mapper for ", PositionComponent.class), null, null, 0, processEntity$$inlined$get$1.INSTANCE, 14, null);
                }
                ComponentMapper<?> componentMapper = EntityUtilsKt.getMappers().get(PositionComponent.class);
                Intrinsics.checkNotNull(componentMapper);
                Object obj = componentMapper.get($this$get$iv);
                if (obj == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.veiset.kgame.engine.ecs.core.component.PositionComponent");
                }
                Vector2 deathPos = Vector2Kt.copy(((PositionComponent)((Component)((PositionComponent)obj))).getPos());
                this.getEngine().addEntity(new Entity().add(new PositionComponent(deathPos)).add(new CameraFollowComponent(0.0f, 0.0f, 0.0f, 0.0f, 15, null)).add(new LightStaticComponent(deathPos, new Color(1.0f, 0.0f, 0.0f, 1.0f), 50, 10.0f, 0.0f, null, 48, null)));
                Entity $this$get$iv2 = entity;
                boolean $i$f$get2 = false;
                boolean $i$f$addMapperIfNone22 = false;
                if (!EntityUtilsKt.getMappers().containsKey(DynamicAnimationComponent.class)) {
                    LoggerKt.logTimed$default(Intrinsics.stringPlus("Added new mapper for ", DynamicAnimationComponent.class), null, null, 0, processEntity$$inlined$get$2.INSTANCE, 14, null);
                }
                ComponentMapper<?> componentMapper2 = EntityUtilsKt.getMappers().get(DynamicAnimationComponent.class);
                Intrinsics.checkNotNull(componentMapper2);
                Object obj2 = componentMapper2.get($this$get$iv2);
                if (obj2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.veiset.kgame.engine.ecs.core.component.draw.DynamicAnimationComponent");
                }
                DynamicAnimationComponent animation = (DynamicAnimationComponent)((Component)((DynamicAnimationComponent)obj2));
                Animation deathAnimation = animation.getDynamicAnimation().getAnimationSet().getDeath();
                SpriteGfxComponent deathFrame = new SpriteGfxComponent(CollectionsKt.last(deathAnimation.getFrames()), animation.getSize(), -1, 0.0f, 0.0f, 24, null);
                System.out.println(deathFrame);
                Engine engine = this.getEngine();
                float f = deathAnimation.getBaseDuration() + deathAnimation.getBaseDuration() / (float)deathAnimation.getFrames().size();
                Entity $i$f$addMapperIfNone22 = new Entity().add(deathFrame).add(new PositionComponent(deathPos));
                Intrinsics.checkNotNullExpressionValue($i$f$addMapperIfNone22, "Entity()\n               \u2026itionComponent(deathPos))");
                engine.addEntity(new DelayAddEntity(f, $i$f$addMapperIfNone22));
                Iterable $this$forEach$iv = new IntRange(0, 35);
                boolean $i$f$forEach = false;
                Iterator iterator2 = $this$forEach$iv.iterator();
                while (iterator2.hasNext()) {
                    TextureRegion textureRegion;
                    void assetRef$iv;
                    int element$iv;
                    int delay = element$iv = ((IntIterator)iterator2).nextInt();
                    boolean bl = false;
                    Vector2 roffset = new Vector2(Vector2Kt.lerp(Random.Default.nextFloat(), -0.25f, 0.25f), Vector2Kt.lerp(Random.Default.nextFloat(), -0.3f, 0.1f));
                    float rsize = Vector2Kt.lerp(Random.Default.nextFloat(), 0.1f, 0.3f);
                    AssetManager assetManager = this.am;
                    AssetRef assetRef = Asset.Texture.INSTANCE.getBloodsplatter();
                    float f3 = (float)delay / 30.0f + (float)delay * (Random.Default.nextFloat() / 10.0f);
                    Engine engine2 = this.getEngine();
                    boolean $i$f$get3 = false;
                    try {
                        void this_$iv;
                        Object object = this_$iv.getAssets().get(assetRef$iv);
                        if (object == null) {
                            throw new NullPointerException("null cannot be cast to non-null type com.badlogic.gdx.graphics.g2d.TextureRegion");
                        }
                        textureRegion = (TextureRegion)object;
                    }
                    catch (Exception ex$iv) {
                        Log.INSTANCE.critical("AssetRef " + assetRef$iv + " not loaded");
                        throw ex$iv;
                    }
                    TextureRegion textureRegion2 = textureRegion;
                    float f4 = Vector2Kt.lerp(Random.Default.nextFloat(), 0.5f, 0.8f);
                    float f5 = Vector2Kt.lerp(Random.Default.nextFloat(), 0.0f, 360.0f);
                    int n = -2;
                    Vector2 vector2 = Vector2Kt.x(rsize, rsize);
                    Vector2 vector22 = Vector2Kt.plus(Vector2Kt.copy(deathPos), roffset);
                    TextureRegion textureRegion3 = textureRegion2;
                    Entity entity2 = new SingleEffectEntity(textureRegion3, vector22, vector2, n, f5, f4);
                    float f6 = f3;
                    engine2.addEntity(new DelayAddEntity(f6, entity2));
                }
                this.getEngine().addSystem(new PlayerDeathAnimationSystem());
            }
        }
        if (health.getCurrentHealth() <= 0.0f) {
            DynamicAnimationComponent animationSet;
            Object $this$getOrNull$iv = entity;
            boolean $i$f$getOrNull2 = false;
            boolean $i$f$addMapperIfNone = false;
            if (!EntityUtilsKt.getMappers().containsKey(MonsterComponent.class)) {
                LoggerKt.logTimed$default(Intrinsics.stringPlus("Added new mapper for ", MonsterComponent.class), null, null, 0, processEntity$$inlined$getOrNull$1.INSTANCE, 14, null);
            }
            ComponentMapper<?> componentMapper = EntityUtilsKt.getMappers().get(MonsterComponent.class);
            if ((Component)(componentMapper == null ? null : componentMapper.get((Entity)$this$getOrNull$iv)) != null) {
                $this$getOrNull$iv = this.gameState;
                ((GameState)$this$getOrNull$iv).setMonstersKilled(((GameState)$this$getOrNull$iv).getMonstersKilled() + 1);
            }
            if (entity instanceof SpeedyDumbZombie) {
                Sound sound;
                Vector2 pos = Mapper.INSTANCE.getPosition().get(entity).getPos();
                AssetManager $i$f$getOrNull2 = this.am;
                AssetRef assetRef$iv = Asset.Sound.INSTANCE.getExplosion();
                boolean $i$f$get = false;
                try {
                    void this_$iv;
                    Object object = this_$iv.getAssets().get(assetRef$iv);
                    if (object == null) {
                        throw new NullPointerException("null cannot be cast to non-null type com.badlogic.gdx.audio.Sound");
                    }
                    sound = (Sound)object;
                }
                catch (Exception ex$iv) {
                    Log.INSTANCE.critical("AssetRef " + assetRef$iv + " not loaded");
                    throw ex$iv;
                }
                sound.play(GameFilesKt.getGameConfig().getVolumeEffect() * GameFilesKt.getGameConfig().getVolumeMaster(), Vector2Kt.lerp(Random.Default.nextFloat(), 0.7f, 0.8f), 0.0f);
                this.getEngine().addEntity(new SelfExplodeAttackEntity(this.world, Vector2Kt.copy(pos), 1.0f));
                this.getEngine().addEntity(new CameraMoveEntity(new CameraShake(Vector2Kt.x(0.5f - Random.Default.nextFloat(), 0.5f - Random.Default.nextFloat()), 0.5f, 0.1f)));
            }
            if ((animationSet = MapperNullable.Gfx.INSTANCE.getDynamicAnimation().get(entity)) != null) {
                Vector2 pos = Mapper.INSTANCE.getPosition().get(entity).getPos();
                DynamicAnimationComponent animationSet2 = Mapper.INSTANCE.getDynamicAnimation().get(entity);
                LootTableComponent lootTable = Mapper.INSTANCE.getLootTable().get(entity);
                if (lootTable != null) {
                    List<Loot<Equipment>> loot = lootTable.getLootTable().generateItems();
                    Iterable $this$forEach$iv = loot;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        Loot loot2 = (Loot)element$iv;
                        boolean bl = false;
                        this.getEngine().addEntity(new ItemDropEntity((Equipment)loot2.getItem(), Vector2Kt.copy(pos)));
                    }
                }
                Animation deathAnimation = animationSet2.getDynamicAnimation().getAnimationSet().getDeath();
                this.getEngine().addEntity(new SingleEffectAnimationEntity(deathAnimation.toGdxAnimation(), Vector2Kt.copy(pos), animationSet2.getSize(), animationSet2.getDirection(), 0, 16, null));
                DebrisComponent debris = MapperNullable.INSTANCE.getDebris().get(entity);
                if (debris != null) {
                    float directionOffset = animationSet2.getDirection() == Direction.LEFT ? 0.0f : animationSet2.getSize().x / 4.0f;
                    Vector2 debrisPos = Vector2Kt.plus(Vector2Kt.copy(pos), new Vector2(directionOffset, -animationSet2.getSize().y / 3.0f));
                    Engine engine = this.getEngine();
                    float f = animationSet2.getDynamicAnimation().getAnimationSet().getDeath().getBaseDuration();
                    TextureRegion textureRegion = debris.getTexture();
                    Vector2 vector2 = Vector2Kt.copy(animationSet2.getSize()).scl(0.9f);
                    Intrinsics.checkNotNullExpressionValue(vector2, "animationSet.size.copy().scl(0.9f)");
                    engine.addEntity(new DelayAddEntity(f, new SingleEffectEntity(textureRegion, debrisPos, vector2, -3, Vector2Kt.lerp(Random.Default.nextFloat(), 0.0f, 360.0f), Vector2Kt.lerp(Random.Default.nextFloat(), 0.7f, 1.0f))));
                }
            }
            this.getEngine().removeEntity(entity);
        }
    }
}

