/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.engine.ecs.core.system.ai;

import com.badlogic.ashley.core.Engine;
import com.badlogic.ashley.core.Entity;
import com.badlogic.ashley.core.EntitySystem;
import com.badlogic.ashley.core.Family;
import com.badlogic.ashley.utils.ImmutableArray;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.BodyDef;
import com.badlogic.gdx.physics.box2d.Fixture;
import com.badlogic.gdx.physics.box2d.World;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import ktx.box2d.WorldsKt;
import ktx.graphics.ShapeRendererKt;
import org.jetbrains.annotations.NotNull;
import org.veiset.kgame.engine.EngineConfig;
import org.veiset.kgame.engine.TBEngineKt;
import org.veiset.kgame.engine.ecs.core.component.PositionComponent;
import org.veiset.kgame.engine.ecs.core.component.ai.PathfindingAIComponent;
import org.veiset.kgame.engine.ecs.core.component.physics.VelocityComponent;
import org.veiset.kgame.engine.ecs.core.component.player.PlayerCharacterComponent;
import org.veiset.kgame.engine.ecs.core.system.Mapper;
import org.veiset.kgame.engine.ecs.core.system.debug.ProfilerSystemKt;
import org.veiset.kgame.engine.math.Vector2Kt;
import org.veiset.kgame.engine.util.ANode;
import org.veiset.kgame.engine.util.AStar;
import org.veiset.kgame.engine.util.RunEveryN;
import org.veiset.kgame.engine.values.ProfilerName;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0007\n\u0002\b\u0002\u0018\u00002\u00020\u0001BC\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0014\b\u0002\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0016J\u001c\u0010$\u001a\u00020!2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010%\u001a\u00020\tJ\u001e\u0010&\u001a\u00020!2\u0006\u0010'\u001a\u00020\u000e2\u0006\u0010(\u001a\u00020\t2\u0006\u0010%\u001a\u00020\tJ\u000e\u0010)\u001a\u00020!2\u0006\u0010*\u001a\u00020+J\u0010\u0010,\u001a\u00020!2\u0006\u0010*\u001a\u00020+H\u0016R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00160\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u00150\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lorg/veiset/kgame/engine/ecs/core/system/ai/AStarPathfindingSystem;", "Lcom/badlogic/ashley/core/EntitySystem;", "world", "Lcom/badlogic/gdx/physics/box2d/World;", "area", "Lkotlin/Pair;", "", "offset", "resolution", "Lcom/badlogic/gdx/math/Vector2;", "(Lcom/badlogic/gdx/physics/box2d/World;Lkotlin/Pair;Lkotlin/Pair;Lcom/badlogic/gdx/math/Vector2;)V", "cachedResult", "", "", "Lorg/veiset/kgame/engine/util/AStar;", "camera", "Lcom/badlogic/gdx/graphics/OrthographicCamera;", "entites", "Lcom/badlogic/ashley/utils/ImmutableArray;", "Lcom/badlogic/ashley/core/Entity;", "flatSearchArea", "", "Lorg/veiset/kgame/engine/util/ANode;", "indexedNodes", "", "", "players", "searchArea", "shapeRenderer", "Lcom/badlogic/gdx/graphics/glutils/ShapeRenderer;", "updateN", "Lorg/veiset/kgame/engine/util/RunEveryN;", "addedToEngine", "", "engine", "Lcom/badlogic/ashley/core/Engine;", "drawArea", "size", "drawPath", "result", "playerPos", "logic", "delta", "", "update", "kgame2"})
public final class AStarPathfindingSystem
extends EntitySystem {
    @NotNull
    private final World world;
    @NotNull
    private final Pair<Integer, Integer> area;
    @NotNull
    private final Pair<Integer, Integer> offset;
    @NotNull
    private final Vector2 resolution;
    @NotNull
    private final OrthographicCamera camera;
    @NotNull
    private final ShapeRenderer shapeRenderer;
    @NotNull
    private Map<Long, AStar> cachedResult;
    @NotNull
    private List<? extends List<ANode>> searchArea;
    @NotNull
    private final Map<String, ANode> indexedNodes;
    @NotNull
    private final List<ANode> flatSearchArea;
    private ImmutableArray<Entity> players;
    private ImmutableArray<Entity> entites;
    @NotNull
    private final RunEveryN updateN;

    /*
     * WARNING - void declaration
     */
    public AStarPathfindingSystem(@NotNull World world, @NotNull Pair<Integer, Integer> area, @NotNull Pair<Integer, Integer> offset, @NotNull Vector2 resolution) {
        void $this$associateTo$iv$iv;
        void $this$associate$iv;
        void it;
        Object object;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Intrinsics.checkNotNullParameter(world, "world");
        Intrinsics.checkNotNullParameter(area, "area");
        Intrinsics.checkNotNullParameter(offset, "offset");
        Intrinsics.checkNotNullParameter(resolution, "resolution");
        this.world = world;
        this.area = area;
        this.offset = offset;
        this.resolution = resolution;
        this.camera = TBEngineKt.getGlobals().getDrawGfx().getCamera();
        this.shapeRenderer = TBEngineKt.getGlobals().getDrawGfx().getShapeRenderer();
        this.cachedResult = new LinkedHashMap();
        Iterable iterable = new IntRange(0, ((Number)this.area.getFirst()).intValue());
        AStarPathfindingSystem aStarPathfindingSystem = this;
        boolean $i$f$map22 = false;
        void var7_10 = $this$map$iv;
        Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void $this$mapTo$iv$iv2;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
            object = destination$iv$iv;
            boolean bl = false;
            Iterable $this$map$iv2 = new IntRange(0, ((Number)this.area.getSecond()).intValue());
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
            boolean $i$f$mapTo2 = false;
            Iterator iterator3 = $this$mapTo$iv$iv2.iterator();
            while (iterator3.hasNext()) {
                void row;
                void col;
                int item$iv$iv2;
                int n2 = item$iv$iv2 = ((IntIterator)iterator3).nextInt();
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add(new ANode((int)(col + ((Number)this.offset.getFirst()).intValue()), (int)(row + ((Number)this.offset.getSecond()).intValue()), false, null, 0, 0, 0, 124, null));
            }
            object.add((List)destination$iv$iv2);
        }
        List $i$f$map22 = $this$map$iv = (List)destination$iv$iv;
        boolean $i$a$-also-AStarPathfindingSystem$searchArea$32 = false;
        destination$iv$iv = this.resolution;
        float mx = Vector2Kt.component1((Vector2)destination$iv$iv);
        float my = Vector2Kt.component2((Vector2)destination$iv$iv);
        Iterable $this$forEach$iv = CollectionsKt.flatten((Iterable)it);
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            ANode node = (ANode)element$iv;
            boolean bl = false;
            Vector2 pos = Vector2Kt.x((float)node.getCol() * mx, (float)node.getRow() * my);
            WorldsKt.query(this.world, pos.x, pos.y, pos.x + mx, pos.y + my, (Function1<? super Fixture, Boolean>)new Function1<Fixture, Boolean>(node){
                final /* synthetic */ ANode $node;
                {
                    this.$node = $node;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull Fixture fixture2) {
                    boolean bl;
                    Intrinsics.checkNotNullParameter(fixture2, "fixture");
                    if (this.$node.getBlock()) {
                        bl = false;
                    } else if (fixture2.getBody().getType() == BodyDef.BodyType.StaticBody) {
                        this.$node.setBlock(true);
                        bl = false;
                    } else {
                        bl = true;
                    }
                    return bl;
                }
            });
        }
        aStarPathfindingSystem.searchArea = $this$map$iv;
        $this$map$iv = CollectionsKt.flatten((Iterable)this.searchArea);
        aStarPathfindingSystem = this;
        boolean $i$f$map = false;
        Iterable $i$a$-also-AStarPathfindingSystem$searchArea$32 = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void node;
            ANode $i$f$forEach2 = (ANode)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add(new Pair<String, void>("" + node.getCol() + ',' + node.getRow(), node));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associate$iv, 10)), 16);
        destination$iv$iv = $this$associate$iv;
        Map destination$iv$iv3 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map2 = destination$iv$iv3;
            Pair it2 = (Pair)element$iv$iv;
            boolean bl = false;
            Pair pair = it2;
            map2.put(pair.getFirst(), pair.getSecond());
        }
        aStarPathfindingSystem.indexedNodes = destination$iv$iv3;
        this.flatSearchArea = CollectionsKt.flatten((Iterable)this.searchArea);
        this.updateN = new RunEveryN(5);
    }

    public /* synthetic */ AStarPathfindingSystem(World world, Pair pair, Pair pair2, Vector2 vector2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            pair = new Pair<Integer, Integer>(50, 50);
        }
        if ((n & 4) != 0) {
            pair2 = new Pair<Integer, Integer>(0, 0);
        }
        if ((n & 8) != 0) {
            vector2 = new Vector2(0.53333336f, 0.53333336f);
        }
        this(world, pair, pair2, vector2);
    }

    @Override
    public void addedToEngine(@NotNull Engine engine) {
        Intrinsics.checkNotNullParameter(engine, "engine");
        Class[] classArray = new Class[]{PlayerCharacterComponent.class};
        ImmutableArray<Entity> immutableArray = engine.getEntitiesFor(Family.one(classArray).get());
        Intrinsics.checkNotNullExpressionValue(immutableArray, "engine.getEntitiesFor(Fa\u2026onent::class.java).get())");
        this.players = immutableArray;
        classArray = new Class[]{PathfindingAIComponent.class, PositionComponent.class, VelocityComponent.class};
        immutableArray = engine.getEntitiesFor(Family.all(classArray).get());
        Intrinsics.checkNotNullExpressionValue(immutableArray, "engine.getEntitiesFor(\n \u2026ass.java).get()\n        )");
        this.entites = immutableArray;
    }

    @Override
    public void update(float delta) {
        Engine engine = this.getEngine();
        Intrinsics.checkNotNullExpressionValue(engine, "engine");
        ProfilerSystemKt.profile(engine, ProfilerName.PATHFINDING_A, (Function0)new Function0<Unit>(this, delta){
            final /* synthetic */ AStarPathfindingSystem this$0;
            final /* synthetic */ float $delta;
            {
                this.this$0 = $receiver;
                this.$delta = $delta;
                super(0);
            }

            public final void invoke() {
                AStarPathfindingSystem.access$getUpdateN$p(this.this$0).update(this.$delta, (Function1<? super Float, Unit>)new Function1<Float, Unit>(this.this$0){
                    final /* synthetic */ AStarPathfindingSystem this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(float it) {
                        this.this$0.logic(it);
                    }
                });
            }
        });
    }

    public final void logic(float delta) {
        ImmutableArray<Entity> immutableArray = this.players;
        if (immutableArray == null) {
            Intrinsics.throwUninitializedPropertyAccessException("players");
            immutableArray = null;
        }
        Entity entity = (Entity)CollectionsKt.firstOrNull((Iterable)immutableArray);
        if (entity == null) {
            return;
        }
        Entity player = entity;
        Vector2 playerPos = Mapper.INSTANCE.getPosition().get(player).getPos();
        ImmutableArray<Entity> immutableArray2 = this.entites;
        if (immutableArray2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("entites");
            immutableArray2 = null;
        }
        Iterable $this$forEach$iv = immutableArray2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AStar result2;
            Object object;
            Object lastPos;
            float ty;
            float tx;
            ANode end;
            float my;
            Entity entity2 = (Entity)element$iv;
            boolean bl = false;
            PathfindingAIComponent ai = Mapper.INSTANCE.getPathfindingAI().get(entity2);
            VelocityComponent velocity = Mapper.INSTANCE.getVelocity().get(entity2);
            Vector2 position = Mapper.INSTANCE.getPosition().get(entity2).getPos();
            ai.setCacheRefresh(ai.getCacheRefresh() - delta);
            long entityId = ai.getId();
            boolean shouldTarget = ai.getTargetType().inRange(playerPos, position, this.camera);
            if (!shouldTarget) {
                velocity.setSpeed(new Vector2(0.0f, 0.0f));
                continue;
            }
            float sx = Vector2Kt.component1(position);
            float sy = Vector2Kt.component2(position);
            Vector2 vector2 = this.resolution;
            float mx = Vector2Kt.component1(vector2);
            ANode start = new ANode((int)(sx / mx), (int)(sy / (my = Vector2Kt.component2(vector2))), false, null, 0, 0, 0, 124, null);
            if (Intrinsics.areEqual(start, end = new ANode((int)((tx = Vector2Kt.component1(playerPos)) / mx), (int)((ty = Vector2Kt.component2(playerPos)) / my), false, null, 0, 0, 0, 124, null))) {
                int lx = end.component1();
                int ly = end.component2();
                lastPos = Vector2Kt.x((float)lx * mx + mx / 2.0f, (float)ly * my + my / 2.0f);
                object = Vector2Kt.minus(new Vector2(playerPos.x, playerPos.y), (Vector2)lastPos).nor().scl(ai.getSpeed());
                Intrinsics.checkNotNullExpressionValue(object, "Vector2(playerPos.x, pla\u2026tPos).nor().scl(ai.speed)");
                velocity.setSpeed((Vector2)object);
                continue;
            }
            if (this.cachedResult.get(entityId) == null || ai.getCacheRefresh() <= 0.0f) {
                ai.setCacheRefresh(ai.getCacheRefresh() + ai.getCacheTimer());
                Object ly = this.flatSearchArea;
                lastPos = this.indexedNodes;
                object = new AStar.Range(start.getCol() - ((Number)ai.getArea().getFirst()).intValue() / 2, start.getCol() + ((Number)ai.getArea().getFirst()).intValue() / 2);
                AStar.Range range = new AStar.Range(start.getRow() - ((Number)ai.getArea().getSecond()).intValue() / 2, start.getRow() + ((Number)ai.getArea().getFirst()).intValue() / 2);
                AStar result3 = new AStar((List)ly, (Map)lastPos, start, end, range, (AStar.Range)object, 0, 0, 192, null);
                ly = this.cachedResult;
                lastPos = entityId;
                ly.put(lastPos, result3);
            }
            Intrinsics.checkNotNull(this.cachedResult.get(entityId));
            ANode targetNode = CollectionsKt.getOrNull(result2.getPath(), 1);
            if (targetNode == null || result2.getPath().size() <= ai.getTargetDistance()) {
                velocity.setSpeed(new Vector2(0.0f, 0.0f));
                continue;
            }
            if (Intrinsics.areEqual(targetNode, start)) {
                result2.getPath().remove(targetNode);
                ANode aNode = CollectionsKt.getOrNull(result2.getPath(), 1);
                if (aNode == null) continue;
                targetNode = aNode;
            }
            Vector2 nextPos = new Vector2((float)targetNode.getCol() * this.resolution.x + this.resolution.x / 2.0f, (float)targetNode.getRow() * this.resolution.y + this.resolution.y / 2.0f);
            object = Vector2Kt.minus(new Vector2(nextPos.x, nextPos.y), position).nor().scl(ai.getSpeed());
            Intrinsics.checkNotNullExpressionValue(object, "Vector2(nextPos.x, nextP\u2026tion).nor().scl(ai.speed)");
            velocity.setSpeed((Vector2)object);
            if (!EngineConfig.Debug.INSTANCE.getDRAW_PATHFINDING_PATH()) continue;
            this.drawPath(result2, playerPos, this.resolution);
        }
        if (EngineConfig.Debug.INSTANCE.getDRAW_PATHFINDING_AREA()) {
            this.drawArea(this.flatSearchArea, this.resolution);
        }
    }

    public final void drawArea(@NotNull List<ANode> searchArea2, @NotNull Vector2 size) {
        Intrinsics.checkNotNullParameter(searchArea2, "searchArea");
        Intrinsics.checkNotNullParameter(size, "size");
        float mx = Vector2Kt.component1(size);
        float my = Vector2Kt.component2(size);
        this.shapeRenderer.begin(ShapeRenderer.ShapeType.Line);
        Iterable $this$forEach$iv = searchArea2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ANode node = (ANode)element$iv;
            boolean bl = false;
            if (node.getBlock()) {
                this.shapeRenderer.setColor(Color.RED);
            } else {
                this.shapeRenderer.setColor(Color.LIGHT_GRAY);
            }
            Vector2 pos = Vector2Kt.x((float)node.getCol() * mx, (float)node.getRow() * my);
            Vector2 size2 = Vector2Kt.x(mx, my);
            ShapeRendererKt.rect(this.shapeRenderer, Vector2Kt.dw(pos), Vector2Kt.dw(size2));
        }
        this.shapeRenderer.end();
    }

    /*
     * WARNING - void declaration
     */
    public final void drawPath(@NotNull AStar result2, @NotNull Vector2 playerPos, @NotNull Vector2 size) {
        Intrinsics.checkNotNullParameter(result2, "result");
        Intrinsics.checkNotNullParameter(playerPos, "playerPos");
        Intrinsics.checkNotNullParameter(size, "size");
        if (result2.getPath().isEmpty()) {
            return;
        }
        float mx = Vector2Kt.component1(size);
        float my = Vector2Kt.component2(size);
        this.shapeRenderer.begin(ShapeRenderer.ShapeType.Line);
        this.shapeRenderer.setColor(Color.ORANGE);
        Iterable $this$zipWithNext$iv = result2.getPath();
        boolean $i$f$zipWithNext = false;
        Iterator iterator$iv = $this$zipWithNext$iv.iterator();
        if (!iterator$iv.hasNext()) {
            CollectionsKt.emptyList();
        } else {
            List result$iv = new ArrayList();
            Object current$iv = iterator$iv.next();
            while (iterator$iv.hasNext()) {
                void n2;
                void n1;
                Object next$iv = iterator$iv.next();
                ANode aNode = (ANode)next$iv;
                ANode aNode2 = (ANode)current$iv;
                List list = result$iv;
                boolean bl = false;
                Vector2 pos1 = Vector2Kt.x((float)n1.getCol() * mx + mx / 2.0f, (float)n1.getRow() * my + my / 2.0f);
                Vector2 pos2 = Vector2Kt.x((float)n2.getCol() * mx + mx / 2.0f, (float)n2.getRow() * my + my / 2.0f);
                this.shapeRenderer.line(Vector2Kt.dw(pos1), Vector2Kt.dw(pos2));
                list.add(Unit.INSTANCE);
                current$iv = next$iv;
            }
        }
        ANode aNode = CollectionsKt.last(result2.getPath());
        int lx = aNode.component1();
        int ly = aNode.component2();
        Vector2 lastPos = Vector2Kt.x((float)lx * mx + mx / 2.0f, (float)ly * my + my / 2.0f);
        this.shapeRenderer.line(Vector2Kt.dw(playerPos), Vector2Kt.dw(lastPos));
        this.shapeRenderer.end();
    }

    public static final /* synthetic */ RunEveryN access$getUpdateN$p(AStarPathfindingSystem $this) {
        return $this.updateN;
    }
}

