/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.engine.ecs.core.system.attack;

import com.badlogic.ashley.core.Component;
import com.badlogic.ashley.core.ComponentMapper;
import com.badlogic.ashley.core.Engine;
import com.badlogic.ashley.core.Entity;
import com.badlogic.ashley.core.EntitySystem;
import com.badlogic.ashley.core.Family;
import com.badlogic.ashley.utils.ImmutableArray;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.World;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.veiset.kgame.engine.LoggerKt;
import org.veiset.kgame.engine.ecs.attack.component.BaseAttackComponent;
import org.veiset.kgame.engine.ecs.attack.component.PlayerAttackComponent;
import org.veiset.kgame.engine.ecs.attack.component.skills.ChainComponent;
import org.veiset.kgame.engine.ecs.attack.component.skills.HomingComponent;
import org.veiset.kgame.engine.ecs.attack.entity.BallAttackEntity;
import org.veiset.kgame.engine.ecs.core.system.Mapper;
import org.veiset.kgame.engine.ecs.core.system.attack.PlayerAttackSystem$update$lambda-5$;
import org.veiset.kgame.engine.ecs.core.system.attack.PlayerAttackSystemKt;
import org.veiset.kgame.engine.ecs.modifier.ModifiersComponent;
import org.veiset.kgame.engine.math.Vector2Kt;
import org.veiset.kgame.engine.modifier.BaseAttack;
import org.veiset.kgame.engine.modifier.Modifier;
import org.veiset.kgame.engine.modifier.ModifierEngine;
import org.veiset.kgame.engine.util.EntityUtilsKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/veiset/kgame/engine/ecs/core/system/attack/PlayerAttackSystem;", "Lcom/badlogic/ashley/core/EntitySystem;", "world", "Lcom/badlogic/gdx/physics/box2d/World;", "(Lcom/badlogic/gdx/physics/box2d/World;)V", "attacks", "Lcom/badlogic/ashley/utils/ImmutableArray;", "Lcom/badlogic/ashley/core/Entity;", "addedToEngine", "", "engine", "Lcom/badlogic/ashley/core/Engine;", "update", "deltaTime", "", "kgame2"})
public final class PlayerAttackSystem
extends EntitySystem {
    @NotNull
    private final World world;
    private ImmutableArray<Entity> attacks;

    public PlayerAttackSystem(@NotNull World world) {
        Intrinsics.checkNotNullParameter(world, "world");
        this.world = world;
    }

    @Override
    public void addedToEngine(@NotNull Engine engine) {
        Intrinsics.checkNotNullParameter(engine, "engine");
        Class[] classArray = new Class[]{PlayerAttackComponent.class, BaseAttackComponent.class};
        ImmutableArray<Entity> immutableArray = engine.getEntitiesFor(Family.all(classArray).get());
        Intrinsics.checkNotNullExpressionValue(immutableArray, "engine.getEntitiesFor(Fa\u2026onent::class.java).get())");
        this.attacks = immutableArray;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void update(float deltaTime) {
        ImmutableArray<Entity> immutableArray = this.attacks;
        if (immutableArray == null) {
            Intrinsics.throwUninitializedPropertyAccessException("attacks");
            immutableArray = null;
        }
        Iterable $this$forEach$iv = immutableArray;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$mapTo$iv$iv;
            Entity entity = (Entity)element$iv;
            boolean bl = false;
            PlayerAttackComponent attack = Mapper.INSTANCE.getPlayerAttack().get(entity);
            Intrinsics.checkNotNullExpressionValue(entity, "entity");
            Entity $this$get$iv = entity;
            boolean $i$f$get = false;
            boolean $i$f$addMapperIfNone = false;
            if (!EntityUtilsKt.getMappers().containsKey(BaseAttackComponent.class)) {
                LoggerKt.logTimed$default(Intrinsics.stringPlus("Added new mapper for ", BaseAttackComponent.class), null, null, 0, update$lambda-5$$inlined$get$1.INSTANCE, 14, null);
            }
            ComponentMapper<?> componentMapper = EntityUtilsKt.getMappers().get(BaseAttackComponent.class);
            Intrinsics.checkNotNull(componentMapper);
            Object obj = componentMapper.get($this$get$iv);
            if (obj == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.veiset.kgame.engine.ecs.attack.component.BaseAttackComponent");
            }
            BaseAttack baseAttack = ((BaseAttackComponent)((Component)((BaseAttackComponent)obj))).getAttack();
            List<Modifier> baseMods = baseAttack.getModifiers();
            Entity $this$getOrNull$iv = entity;
            boolean $i$f$getOrNull = false;
            boolean $i$f$addMapperIfNone2 = false;
            if (!EntityUtilsKt.getMappers().containsKey(ModifiersComponent.class)) {
                LoggerKt.logTimed$default(Intrinsics.stringPlus("Added new mapper for ", ModifiersComponent.class), null, null, 0, update$lambda-5$$inlined$getOrNull$1.INSTANCE, 14, null);
            }
            ComponentMapper<?> componentMapper2 = EntityUtilsKt.getMappers().get(ModifiersComponent.class);
            ModifiersComponent globalMods = (ModifiersComponent)((Component)(componentMapper2 == null ? null : componentMapper2.get($this$getOrNull$iv)));
            int projectiles2 = ModifierEngine.Attack.INSTANCE.projectiles(baseMods);
            float duration = ModifierEngine.Attack.INSTANCE.duration(baseMods);
            Vector2 direction = Vector2Kt.minus(attack.getTargetPos(), attack.getPlayerPos()).nor();
            float projectileSpeed2 = ModifierEngine.Attack.INSTANCE.projectileSpeed(baseMods);
            float spacing2 = ModifierEngine.Attack.INSTANCE.spacing(baseMods);
            float spread2 = ModifierEngine.Attack.INSTANCE.spread(baseMods);
            Iterable $this$map$iv = new IntRange(-projectiles2 / 2, projectiles2 / 2);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            Iterator iterator2 = $this$mapTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Object v7;
                Modifier.Attack.Homing mod;
                void $this$ifModifier$iv;
                Modifier mod$iv;
                Engine engine;
                Object object;
                Vector2 target;
                Collection collection;
                block13: {
                    Object v6;
                    boolean bl2;
                    Modifier it$iv$iv;
                    boolean $i$f$firstOrNull;
                    Iterable $this$firstOrNull$iv$iv$iv;
                    boolean $i$f$firstOrNull2;
                    ModifierEngine this_$iv$iv;
                    boolean $i$f$ifModifier;
                    block12: {
                        void i;
                        int item$iv$iv;
                        int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
                        collection = destination$iv$iv;
                        boolean bl3 = false;
                        float speed = Random.Default.nextFloat() * 0.5f;
                        target = attack.getTargetPos();
                        Vector2 startPos = attack.getPlayerPos();
                        Intrinsics.checkNotNullExpressionValue(direction, "direction");
                        object = Vector2Kt.copy(direction).nor();
                        Intrinsics.checkNotNullExpressionValue(object, "direction.copy().nor()");
                        Vector2 offset = Vector2Kt.perpendicular((Vector2)object).scl(spacing2 * (float)i);
                        Engine engine2 = this.getEngine();
                        Intrinsics.checkNotNullExpressionValue(offset, "offset");
                        Vector2 vector2 = Vector2Kt.plus(startPos, offset);
                        object = Vector2Kt.copy(offset).scl(spread2);
                        Intrinsics.checkNotNullExpressionValue(object, "offset.copy().scl(spread)");
                        object = new BallAttackEntity(this.world, vector2, Vector2Kt.plus(target, (Vector2)object), projectileSpeed2 + speed, duration, baseAttack);
                        engine = engine2;
                        $i$f$ifModifier = false;
                        this_$iv$iv = ModifierEngine.INSTANCE;
                        $i$f$firstOrNull2 = false;
                        $this$firstOrNull$iv$iv$iv = baseMods;
                        $i$f$firstOrNull = false;
                        for (Object element$iv$iv$iv : $this$firstOrNull$iv$iv$iv) {
                            it$iv$iv = (Modifier)element$iv$iv$iv;
                            bl2 = false;
                            if (!(it$iv$iv instanceof Modifier.Attack.Chain)) continue;
                            v6 = element$iv$iv$iv;
                            break block12;
                        }
                        v6 = null;
                    }
                    if ((mod$iv = (Modifier)v6) != null) {
                        Modifier.Attack.Chain chain2 = (Modifier.Attack.Chain)((Modifier)((Modifier.Attack.Chain)mod$iv));
                        void $this$update_u24lambda_u2d5_u24lambda_u2d4_u24lambda_u2d0 = $this$ifModifier$iv;
                        boolean bl4 = false;
                        $this$update_u24lambda_u2d5_u24lambda_u2d4_u24lambda_u2d0.add(new ChainComponent(((Modifier.Attack.Chain)((Object)mod)).getValue()));
                    }
                    $i$f$ifModifier = false;
                    this_$iv$iv = ModifierEngine.INSTANCE;
                    $i$f$firstOrNull2 = false;
                    $this$firstOrNull$iv$iv$iv = baseMods;
                    $i$f$firstOrNull = false;
                    for (Object element$iv$iv$iv : $this$firstOrNull$iv$iv$iv) {
                        it$iv$iv = (Modifier)element$iv$iv$iv;
                        bl2 = false;
                        if (!(it$iv$iv instanceof Modifier.Attack.Homing)) continue;
                        v7 = element$iv$iv$iv;
                        break block13;
                    }
                    v7 = null;
                }
                if ((mod$iv = (Modifier)v7) != null) {
                    mod = (Modifier.Attack.Homing)((Modifier)((Modifier.Attack.Homing)mod$iv));
                    void $this$update_u24lambda_u2d5_u24lambda_u2d4_u24lambda_u2d2 = $this$ifModifier$iv;
                    boolean bl5 = false;
                    Engine engine3 = this.getEngine();
                    Intrinsics.checkNotNullExpressionValue(engine3, "engine");
                    if (PlayerAttackSystemKt.closestMonsterPos(engine3, target) != null) {
                        Vector2 it;
                        boolean bl6 = false;
                        $this$update_u24lambda_u2d5_u24lambda_u2d4_u24lambda_u2d2.add(new HomingComponent(it, 10.0f, 1.0f));
                    }
                }
                Object $i$f$ifModifier = object = $this$ifModifier$iv;
                boolean bl7 = false;
                if (globalMods != null) {
                    void it;
                    System.out.println(globalMods);
                    it.add(globalMods);
                }
                engine.addEntity((Entity)object);
                collection.add(Unit.INSTANCE);
            }
            List cfr_ignored_0 = (List)destination$iv$iv;
            this.getEngine().removeEntity(entity);
        }
    }
}

