/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.engine.ecs.core.system.debug;

import com.badlogic.ashley.core.Engine;
import com.badlogic.ashley.core.Entity;
import com.badlogic.ashley.core.EntitySystem;
import com.badlogic.ashley.core.Family;
import com.badlogic.ashley.utils.ImmutableArray;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import ktx.graphics.ShapeRendererKt;
import org.jetbrains.annotations.NotNull;
import org.veiset.kgame.engine.EngineConfig;
import org.veiset.kgame.engine.TBEngineKt;
import org.veiset.kgame.engine.ecs.core.component.PositionComponent;
import org.veiset.kgame.engine.ecs.core.component.camera.CameraEffectComponent;
import org.veiset.kgame.engine.ecs.core.component.camera.CameraFollowComponent;
import org.veiset.kgame.engine.ecs.core.component.player.PlayerCharacterComponent;
import org.veiset.kgame.engine.ecs.core.system.Mapper;
import org.veiset.kgame.engine.math.Vector2Kt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u001e\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013J\u0010\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/veiset/kgame/engine/ecs/core/system/debug/CameraDebugSystem;", "Lcom/badlogic/ashley/core/EntitySystem;", "()V", "camera", "Lcom/badlogic/gdx/graphics/OrthographicCamera;", "cameraFollowEntities", "Lcom/badlogic/ashley/utils/ImmutableArray;", "Lcom/badlogic/ashley/core/Entity;", "cameraMovements", "playerCharacter", "addedToEngine", "", "engine", "Lcom/badlogic/ashley/core/Engine;", "debugDraw", "t", "Lcom/badlogic/gdx/math/Vector2;", "cm", "cameraFollow", "Lorg/veiset/kgame/engine/ecs/core/component/camera/CameraFollowComponent;", "update", "delta", "", "kgame2"})
public final class CameraDebugSystem
extends EntitySystem {
    @NotNull
    private final OrthographicCamera camera = TBEngineKt.getGlobals().getDrawGfx().getCamera();
    private ImmutableArray<Entity> cameraFollowEntities;
    private ImmutableArray<Entity> cameraMovements;
    private ImmutableArray<Entity> playerCharacter;

    @Override
    public void addedToEngine(@NotNull Engine engine) {
        Intrinsics.checkNotNullParameter(engine, "engine");
        Class[] classArray = new Class[]{PositionComponent.class, CameraFollowComponent.class};
        ImmutableArray<Entity> immutableArray = engine.getEntitiesFor(Family.all(classArray).get());
        Intrinsics.checkNotNullExpressionValue(immutableArray, "engine.getEntitiesFor(Fa\u2026onent::class.java).get())");
        this.cameraFollowEntities = immutableArray;
        classArray = new Class[]{CameraEffectComponent.class};
        immutableArray = engine.getEntitiesFor(Family.all(classArray).get());
        Intrinsics.checkNotNullExpressionValue(immutableArray, "engine.getEntitiesFor(Fa\u2026onent::class.java).get())");
        this.cameraMovements = immutableArray;
        classArray = new Class[]{PlayerCharacterComponent.class};
        immutableArray = engine.getEntitiesFor(Family.all(classArray).get());
        Intrinsics.checkNotNullExpressionValue(immutableArray, "engine.getEntitiesFor(Fa\u2026onent::class.java).get())");
        this.playerCharacter = immutableArray;
    }

    @Override
    public void update(float delta) {
        Entity cameraFollowEntity;
        if (!EngineConfig.Debug.INSTANCE.getDISPLAY_CAMERA_DEBUG()) {
            return;
        }
        ImmutableArray<Entity> immutableArray = this.cameraFollowEntities;
        if (immutableArray == null) {
            Intrinsics.throwUninitializedPropertyAccessException("cameraFollowEntities");
            immutableArray = null;
        }
        if ((cameraFollowEntity = (Entity)CollectionsKt.firstOrNull((Iterable)immutableArray)) == null) {
            ImmutableArray<Entity> immutableArray2 = this.playerCharacter;
            if (immutableArray2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("playerCharacter");
                immutableArray2 = null;
            }
            Entity entity = (Entity)CollectionsKt.firstOrNull((Iterable)immutableArray2);
            if ((entity == null ? null : entity.add(new CameraFollowComponent(0.0f, 0.0f, 0.0f, 0.0f, 15, null))) == null) {
                return;
            }
            return;
        }
        Vector2 targetPos = Mapper.INSTANCE.getPosition().get(cameraFollowEntity).getPos();
        CameraFollowComponent cameraFollow = Mapper.INSTANCE.getCameraFollow().get(cameraFollowEntity);
        Vector3 vector3 = this.camera.position;
        Intrinsics.checkNotNullExpressionValue(vector3, "camera.position");
        Vector2 cameraPos = Vector2Kt.gfxToWorld(Vector2Kt.v2(vector3));
        Intrinsics.checkNotNullExpressionValue(cameraFollow, "cameraFollow");
        this.debugDraw(targetPos, cameraPos, cameraFollow);
    }

    public final void debugDraw(@NotNull Vector2 t, @NotNull Vector2 cm, @NotNull CameraFollowComponent cameraFollow) {
        Intrinsics.checkNotNullParameter(t, "t");
        Intrinsics.checkNotNullParameter(cm, "cm");
        Intrinsics.checkNotNullParameter(cameraFollow, "cameraFollow");
        ShapeRenderer sr = TBEngineKt.getGlobals().getDrawGfx().getShapeRenderer();
        sr.begin(ShapeRenderer.ShapeType.Line);
        sr.setColor(Color.RED);
        sr.line(Vector2Kt.dw(cm), Vector2Kt.dw(t));
        sr.setColor(Color.WHITE);
        ShapeRendererKt.circle(sr, Vector2Kt.dw(cm), cameraFollow.getNoFollow() * 120.0f);
        sr.setColor(Color.ORANGE);
        ShapeRendererKt.circle(sr, Vector2Kt.dw(cm), cameraFollow.getSoftMaxDistance() * 120.0f);
        sr.setColor(Color.RED);
        ShapeRendererKt.circle(sr, Vector2Kt.dw(cm), cameraFollow.getMaxDistance() * 120.0f);
        sr.setColor(Color.BLUE);
        sr.line(Vector2Kt.dw(cm), Vector2Kt.dw(t));
        Vector2 vector2 = Vector2Kt.minus(t, cm).nor().scl(cameraFollow.getMaxDistance());
        Intrinsics.checkNotNullExpressionValue(vector2, "t - cm).nor().scl(cameraFollow.maxDistance)");
        Vector2 maxTarget = Vector2Kt.dw(Vector2Kt.plus(cm, vector2));
        ShapeRendererKt.circle(sr, maxTarget, 5.0f);
        sr.end();
    }
}

