/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.engine.ecs.core.system.debug;

import com.badlogic.ashley.core.Component;
import com.badlogic.ashley.core.ComponentMapper;
import com.badlogic.ashley.core.Engine;
import com.badlogic.ashley.core.Entity;
import com.badlogic.ashley.core.EntitySystem;
import com.badlogic.ashley.core.Family;
import com.badlogic.ashley.utils.ImmutableArray;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.veiset.kgame.engine.EngineConfig;
import org.veiset.kgame.engine.Log;
import org.veiset.kgame.engine.LoggerKt;
import org.veiset.kgame.engine.TBEngineKt;
import org.veiset.kgame.engine.asset.AssetManager;
import org.veiset.kgame.engine.asset.AssetRef;
import org.veiset.kgame.engine.ecs.core.component.enemy.MonsterComponent;
import org.veiset.kgame.engine.ecs.core.component.player.PlayerCharacterComponent;
import org.veiset.kgame.engine.ecs.core.component.stats.HealthComponent;
import org.veiset.kgame.engine.ecs.core.system.debug.CheatSystem$update$;
import org.veiset.kgame.engine.ecs.core.system.debug.CheatSystem$update$lambda-1$;
import org.veiset.kgame.engine.math.Vector2Kt;
import org.veiset.kgame.engine.util.EntityUtilsKt;
import org.veiset.kgame.engine.util.GdxUtilsKt;
import org.veiset.kgame.engine.values.Asset;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001aH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/veiset/kgame/engine/ecs/core/system/debug/CheatSystem;", "Lcom/badlogic/ashley/core/EntitySystem;", "()V", "am", "Lorg/veiset/kgame/engine/asset/AssetManager;", "cheatsEnabled", "", "getCheatsEnabled", "()Z", "setCheatsEnabled", "(Z)V", "font", "Lcom/badlogic/gdx/graphics/g2d/BitmapFont;", "monsters", "Lcom/badlogic/ashley/utils/ImmutableArray;", "Lcom/badlogic/ashley/core/Entity;", "playerCharacter", "sb", "Lcom/badlogic/gdx/graphics/g2d/SpriteBatch;", "smallFont", "addedToEngine", "", "engine", "Lcom/badlogic/ashley/core/Engine;", "update", "deltaTime", "", "kgame2"})
public final class CheatSystem
extends EntitySystem {
    @NotNull
    private final SpriteBatch sb = TBEngineKt.getGlobals().getDrawUi().getSpriteBatch();
    @NotNull
    private final AssetManager am;
    @NotNull
    private final BitmapFont font;
    @NotNull
    private final BitmapFont smallFont;
    private ImmutableArray<Entity> monsters;
    private ImmutableArray<Entity> playerCharacter;
    private boolean cheatsEnabled;

    public CheatSystem() {
        BitmapFont bitmapFont;
        BitmapFont bitmapFont2;
        AssetRef assetRef$iv;
        AssetManager this_$iv;
        AssetManager assetManager = this.am = TBEngineKt.getGlobals().getAssetManager();
        AssetRef assetRef = Asset.Font.INSTANCE.getJbb18();
        CheatSystem cheatSystem = this;
        boolean $i$f$get = false;
        try {
            Object object = this_$iv.getAssets().get(assetRef$iv);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.badlogic.gdx.graphics.g2d.BitmapFont");
            }
            bitmapFont2 = (BitmapFont)object;
        }
        catch (Exception ex$iv) {
            Log.INSTANCE.critical("AssetRef " + assetRef$iv + " not loaded");
            throw ex$iv;
        }
        cheatSystem.font = bitmapFont2;
        this_$iv = TBEngineKt.getGlobals().getAssetManager();
        assetRef$iv = Asset.Font.INSTANCE.getJbr16();
        cheatSystem = this;
        $i$f$get = false;
        try {
            Object object = this_$iv.getAssets().get(assetRef$iv);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.badlogic.gdx.graphics.g2d.BitmapFont");
            }
            bitmapFont = (BitmapFont)object;
        }
        catch (Exception ex$iv) {
            Log.INSTANCE.critical("AssetRef " + assetRef$iv + " not loaded");
            throw ex$iv;
        }
        cheatSystem.smallFont = bitmapFont;
    }

    public final boolean getCheatsEnabled() {
        return this.cheatsEnabled;
    }

    public final void setCheatsEnabled(boolean bl) {
        this.cheatsEnabled = bl;
    }

    @Override
    public void addedToEngine(@NotNull Engine engine) {
        Intrinsics.checkNotNullParameter(engine, "engine");
        Class[] classArray = new Class[]{MonsterComponent.class};
        ImmutableArray<Entity> immutableArray = engine.getEntitiesFor(Family.all(classArray).get());
        Intrinsics.checkNotNullExpressionValue(immutableArray, "engine.getEntitiesFor(Fa\u2026onent::class.java).get())");
        this.monsters = immutableArray;
        classArray = new Class[]{PlayerCharacterComponent.class};
        immutableArray = engine.getEntitiesFor(Family.all(classArray).get());
        Intrinsics.checkNotNullExpressionValue(immutableArray, "engine.getEntitiesFor(Fa\u2026onent::class.java).get())");
        this.playerCharacter = immutableArray;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void update(float deltaTime) {
        if (Gdx.input.isKeyJustPressed(57)) {
            boolean bl = this.cheatsEnabled = !this.cheatsEnabled;
        }
        if (this.cheatsEnabled) {
            Object $this$forEach$iv;
            this.sb.begin();
            GdxUtilsKt.draw(this.font, this.sb, "Cheats enabled", Vector2Kt.dw(Vector2Kt.x(0.01f, 5.0f)));
            String[] stringArray = new String[]{"[K] - Kill all monsters", "[U] - Toggle un-killable (" + EngineConfig.Debug.INSTANCE.getUNKILLABLE() + ')', "[B] - Suicide"};
            Iterable $this$forEachIndexed$iv = CollectionsKt.listOf(stringArray);
            boolean $i$f$forEachIndexed = false;
            int index$iv2 = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void s;
                int n = index$iv2;
                index$iv2 = n + 1;
                if (n < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                String string2 = (String)item$iv;
                int index = n;
                boolean bl = false;
                GdxUtilsKt.draw(this.smallFont, this.sb, (String)s, Vector2Kt.dw(Vector2Kt.x(0.04f, 4.8f - (float)index * 0.17f)));
            }
            this.sb.end();
            if (Gdx.input.isKeyJustPressed(39)) {
                ImmutableArray<Entity> immutableArray = this.monsters;
                if (immutableArray == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("monsters");
                    immutableArray = null;
                }
                $this$forEach$iv = immutableArray;
                boolean $i$f$forEach = false;
                Iterator index$iv2 = $this$forEach$iv.iterator();
                while (index$iv2.hasNext()) {
                    HealthComponent health;
                    Object element$iv = index$iv2.next();
                    Entity it = (Entity)element$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNullExpressionValue(it, "it");
                    Entity $this$getOrNull$iv = it;
                    boolean $i$f$getOrNull = false;
                    boolean $i$f$addMapperIfNone = false;
                    if (!EntityUtilsKt.getMappers().containsKey(HealthComponent.class)) {
                        LoggerKt.logTimed$default(Intrinsics.stringPlus("Added new mapper for ", HealthComponent.class), null, null, 0, update$lambda-1$$inlined$getOrNull$1.INSTANCE, 14, null);
                    }
                    ComponentMapper<?> componentMapper = EntityUtilsKt.getMappers().get(HealthComponent.class);
                    HealthComponent healthComponent = health = (HealthComponent)((Component)(componentMapper == null ? null : componentMapper.get($this$getOrNull$iv)));
                    if (healthComponent == null) continue;
                    healthComponent.setCurrentHealth(-1.0f);
                }
            }
            if (Gdx.input.isKeyJustPressed(49)) {
                EngineConfig.Debug.INSTANCE.setUNKILLABLE(!EngineConfig.Debug.INSTANCE.getUNKILLABLE());
            }
            if (Gdx.input.isKeyJustPressed(30)) {
                ImmutableArray<Entity> immutableArray = this.playerCharacter;
                if (immutableArray == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("playerCharacter");
                    immutableArray = null;
                }
                $this$forEach$iv = immutableArray.first();
                Intrinsics.checkNotNullExpressionValue($this$forEach$iv, "playerCharacter.first()");
                Entity $this$get$iv = (Entity)$this$forEach$iv;
                boolean $i$f$get = false;
                boolean $i$f$addMapperIfNone = false;
                if (!EntityUtilsKt.getMappers().containsKey(HealthComponent.class)) {
                    LoggerKt.logTimed$default(Intrinsics.stringPlus("Added new mapper for ", HealthComponent.class), null, null, 0, update$$inlined$get$1.INSTANCE, 14, null);
                }
                ComponentMapper<?> componentMapper = EntityUtilsKt.getMappers().get(HealthComponent.class);
                Intrinsics.checkNotNull(componentMapper);
                Object obj = componentMapper.get($this$get$iv);
                if (obj == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.veiset.kgame.engine.ecs.core.component.stats.HealthComponent");
                }
                ((HealthComponent)((Component)((HealthComponent)obj))).setCurrentHealth(0.0f);
            }
        }
    }
}

