/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.engine.ecs.core.system.debug;

import com.badlogic.ashley.core.EntitySystem;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.math.Vector2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import ktx.graphics.ShapeRendererKt;
import org.jetbrains.annotations.NotNull;
import org.veiset.kgame.engine.EngineConfig;
import org.veiset.kgame.engine.Log;
import org.veiset.kgame.engine.TBEngineKt;
import org.veiset.kgame.engine.asset.AssetManager;
import org.veiset.kgame.engine.asset.AssetRef;
import org.veiset.kgame.engine.ecs.core.system.debug.ProfilerSystemKt;
import org.veiset.kgame.engine.math.Vector2Kt;
import org.veiset.kgame.engine.values.Asset;
import org.veiset.kgame.engine.values.ProfilerName;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u000b2\b\b\u0002\u0010\u0011\u001a\u00020\u0012J\u0006\u0010\u0013\u001a\u00020\u0014J\u0006\u0010\u0015\u001a\u00020\u0014J8\u0010\u0016\u001a\u00020\u00142\u0018\u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u00060\n2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001bJ'\u0010\u001c\u001a\u0002H\u001d\"\u0004\b\u0000\u0010\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u0002H\u001d0!\u00a2\u0006\u0002\u0010\"J\u0016\u0010#\u001a\u00020\u00142\u0006\u0010$\u001a\u00020\u000b2\u0006\u0010#\u001a\u00020\fJ\u0010\u0010%\u001a\u00020\u00142\u0006\u0010&\u001a\u00020\u001bH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0005\u001a\u0010\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u00060\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lorg/veiset/kgame/engine/ecs/core/system/debug/ProfilerSystem;", "Lcom/badlogic/ashley/core/EntitySystem;", "()V", "am", "Lorg/veiset/kgame/engine/asset/AssetManager;", "colors", "", "Lcom/badlogic/gdx/graphics/Color;", "kotlin.jvm.PlatformType", "dataValues", "", "", "", "font18", "Lcom/badlogic/gdx/graphics/g2d/BitmapFont;", "color", "name", "index", "", "drawEntities", "", "drawMemoryUsage", "drawValues", "size", "Lcom/badlogic/gdx/math/Vector2;", "offset", "pointSize", "", "profile", "T", "key", "Lorg/veiset/kgame/engine/values/ProfilerName;", "block", "Lkotlin/Function0;", "(Lorg/veiset/kgame/engine/values/ProfilerName;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "time", "monitorName", "update", "delta", "kgame2"})
public final class ProfilerSystem
extends EntitySystem {
    @NotNull
    private final AssetManager am = TBEngineKt.getGlobals().getAssetManager();
    @NotNull
    private final BitmapFont font18;
    @NotNull
    private final Map<String, List<Long>> dataValues;
    @NotNull
    private final List<Color> colors;

    /*
     * WARNING - void declaration
     */
    public ProfilerSystem() {
        BitmapFont bitmapFont;
        void assetRef$iv;
        Color[] colorArray = this.am;
        AssetRef assetRef = Asset.Font.INSTANCE.getRetron18();
        ProfilerSystem profilerSystem = this;
        boolean $i$f$get = false;
        try {
            void this_$iv;
            Object object = this_$iv.getAssets().get(assetRef$iv);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.badlogic.gdx.graphics.g2d.BitmapFont");
            }
            bitmapFont = (BitmapFont)object;
        }
        catch (Exception ex$iv) {
            Log.INSTANCE.critical("AssetRef " + assetRef$iv + " not loaded");
            throw ex$iv;
        }
        profilerSystem.font18 = bitmapFont;
        this.dataValues = new LinkedHashMap();
        colorArray = new Color[]{Color.BLUE, Color.TEAL, Color.CHARTREUSE, Color.CYAN, Color.GREEN, Color.RED, Color.CORAL};
        this.colors = CollectionsKt.listOf(colorArray);
    }

    @Override
    public void update(float delta) {
        if (EngineConfig.Debug.INSTANCE.getPROFILER()) {
            this.profile(ProfilerName.PROFILER, (Function0)new Function0<Unit>(this){
                final /* synthetic */ ProfilerSystem this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                public final void invoke() {
                    if (EngineConfig.Debug.INSTANCE.getPROFILER_DETAILED()) {
                        this.this$0.drawValues(ProfilerSystem.access$getDataValues$p(this.this$0), Vector2Kt.x(3.0f, 2.0f), Vector2Kt.x(0.2f, 6.8f), 0.01f);
                        this.this$0.drawEntities();
                        this.this$0.drawMemoryUsage();
                    }
                }
            });
        }
    }

    public final void drawEntities() {
        this.font18.setColor(Color.WHITE);
        ProfilerSystemKt.access$getUiSpriteBatch$p().begin();
        int numberOfEntities = this.getEngine().getEntities().size();
        this.font18.draw((Batch)ProfilerSystemKt.access$getUiSpriteBatch$p(), String.valueOf(numberOfEntities), 25.800001f, 1050.0f);
        ProfilerSystemKt.access$getUiSpriteBatch$p().end();
    }

    /*
     * WARNING - void declaration
     */
    public final void drawValues(@NotNull Map<String, List<Long>> dataValues, @NotNull Vector2 size, @NotNull Vector2 offset, float pointSize) {
        void $this$mapIndexedTo$iv$iv;
        void $this$mapIndexed$iv;
        void $this$mapTo$iv$iv;
        List values2;
        Object key;
        void $this$mapIndexedTo$iv$iv2;
        Collection collection;
        void $this$mapTo$iv$iv2;
        Intrinsics.checkNotNullParameter(dataValues, "dataValues");
        Intrinsics.checkNotNullParameter(size, "size");
        Intrinsics.checkNotNullParameter(offset, "offset");
        float width = Vector2Kt.component1(size);
        float height = Vector2Kt.component2(size);
        float drawXOffset = Vector2Kt.component1(offset);
        float drawYOffset = Vector2Kt.component2(offset);
        Iterable $this$map$iv = dataValues.values();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            List list = (List)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Object t = CollectionsKt.maxOrNull((Iterable)it);
            Intrinsics.checkNotNull(t);
            collection.add(((Number)t).longValue());
        }
        List max = CollectionsKt.toList((List)destination$iv$iv);
        Number number = (Long)CollectionsKt.maxOrNull(max);
        if (number == null) {
            number = Float.valueOf(1.0f);
        }
        Long totalMax = number;
        Long l = (Long)CollectionsKt.maxOrNull(max);
        long highestMax = l == null ? 1L : l;
        ProfilerSystemKt.access$getUiShapeRenderer$p().begin(ShapeRenderer.ShapeType.Filled);
        ProfilerSystemKt.access$getUiShapeRenderer$p().setColor(Color.BLACK);
        ShapeRendererKt.rect(ProfilerSystemKt.access$getUiShapeRenderer$p(), Vector2Kt.dw(new Vector2(drawXOffset, drawYOffset)), Vector2Kt.dw(new Vector2(width, height)));
        ProfilerSystemKt.access$getUiShapeRenderer$p().end();
        ProfilerSystemKt.access$getUiShapeRenderer$p().begin(ShapeRenderer.ShapeType.Line);
        Iterable $this$mapIndexed$iv2 = MapsKt.toList(dataValues);
        boolean $i$f$mapIndexed = false;
        Iterable iterable2 = $this$mapIndexed$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$mapIndexed$iv2, 10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv22 = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv2) {
            void index;
            void $dstr$key$values;
            int n = index$iv$iv22;
            index$iv$iv22 = n + 1;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Pair pair = (Pair)item$iv$iv;
            int n2 = n;
            collection = destination$iv$iv2;
            boolean bl = false;
            key = (String)$dstr$key$values.component1();
            values2 = (List)$dstr$key$values.component2();
            ProfilerSystemKt.access$getUiShapeRenderer$p().setColor(this.color((String)key, (int)index));
            Iterable $this$forEachIndexed$iv = CollectionsKt.zipWithNext(values2);
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void $dstr$e1$e2;
                int n3 = index$iv;
                index$iv = n3 + 1;
                if (n3 < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Pair pair2 = (Pair)item$iv;
                int i = n3;
                boolean bl2 = false;
                long e1 = ((Number)$dstr$e1$e2.component1()).longValue();
                long e2 = ((Number)$dstr$e1$e2.component2()).longValue();
                Vector2 p1 = new Vector2(drawXOffset + (float)i * pointSize, drawYOffset + (float)e1 / ((float)highestMax + 0.01f) * height);
                Vector2 p2 = new Vector2(drawXOffset + (float)(i + 1) * pointSize, drawYOffset + (float)e2 / ((float)highestMax + 0.01f) * height);
                ProfilerSystemKt.access$getUiShapeRenderer$p().line(Vector2Kt.dw(p1), Vector2Kt.dw(p2));
            }
            collection.add(Unit.INSTANCE);
        }
        List cfr_ignored_0 = (List)destination$iv$iv2;
        ProfilerSystemKt.access$getUiShapeRenderer$p().setColor(Color.WHITE);
        ShapeRendererKt.rect(ProfilerSystemKt.access$getUiShapeRenderer$p(), Vector2Kt.dw(new Vector2(drawXOffset, drawYOffset)), Vector2Kt.dw(new Vector2(width, height)));
        ProfilerSystemKt.access$getUiShapeRenderer$p().end();
        ProfilerSystemKt.access$getUiSpriteBatch$p().begin();
        List sortedMaxValues = CollectionsKt.sortedDescending(max);
        long diffMax = ((Number)CollectionsKt.first(sortedMaxValues)).longValue() - CollectionsKt.sumOfLong(CollectionsKt.drop(sortedMaxValues, 1));
        Iterable $this$map$iv2 = MapsKt.toList(dataValues);
        boolean $i$f$map2 = false;
        Iterable index$iv$iv22 = $this$map$iv2;
        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void $dstr$key$values;
            Pair index = (Pair)item$iv$iv;
            collection = destination$iv$iv3;
            boolean bl = false;
            key = (String)$dstr$key$values.component1();
            values2 = (List)$dstr$key$values.component2();
            Long l2 = (Long)CollectionsKt.maxOrNull(values2);
            collection.add(new Pair<String, Long>((String)key, l2 == null ? 0L : l2));
        }
        $this$map$iv2 = CollectionsKt.plus((Collection)((List)destination$iv$iv3), new Pair<String, Long>("DiffMax", diffMax));
        boolean $i$f$mapIndexed2 = false;
        $this$mapTo$iv$iv = $this$mapIndexed$iv;
        destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$mapIndexed$iv, 10));
        boolean $i$f$mapIndexedTo2 = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void index;
            void $dstr$systemName$maxValue;
            int n = index$iv$iv;
            index$iv$iv = n + 1;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            key = (Pair)item$iv$iv;
            int values3 = n;
            collection = destination$iv$iv3;
            boolean bl = false;
            String systemName = (String)$dstr$systemName$maxValue.component1();
            long maxValue = ((Number)$dstr$systemName$maxValue.component2()).longValue();
            float ms = (float)maxValue / (float)1000000;
            float xPos = drawXOffset + width + 0.03f;
            float yPos = drawYOffset + height - 0.01f - (float)index * 0.16f;
            this.font18.setColor(this.color(systemName, (int)index));
            collection.add(this.font18.draw((Batch)ProfilerSystemKt.access$getUiSpriteBatch$p(), ProfilerSystemKt.access$getDec$p().format(Float.valueOf(ms)) + " -  " + systemName, xPos * 120.0f, yPos * 120.0f));
        }
        List cfr_ignored_1 = (List)destination$iv$iv3;
        this.font18.setColor(Color.WHITE);
        this.font18.draw((Batch)ProfilerSystemKt.access$getUiSpriteBatch$p(), String.valueOf(((Number)totalMax).floatValue() / (float)1000000), (drawXOffset + 0.015f) * 120.0f, (drawYOffset + 0.15f) * 120.0f);
        ProfilerSystemKt.access$getUiSpriteBatch$p().end();
    }

    public final void drawMemoryUsage() {
        long used = (ProfilerSystemKt.access$getRuntime$p().totalMemory() - ProfilerSystemKt.access$getRuntime$p().freeMemory()) / (long)0x100000;
        long free = ProfilerSystemKt.access$getRuntime$p().freeMemory() / (long)0x100000;
        long total = ProfilerSystemKt.access$getRuntime$p().totalMemory() / (long)0x100000;
        long max = ProfilerSystemKt.access$getRuntime$p().maxMemory() / (long)0x100000;
        float ypadding = 0.22f;
        float usedRect = (float)used / (float)total * 3.0f;
        float totalRect = 3.0f - usedRect;
        ProfilerSystemKt.access$getUiShapeRenderer$p().begin(ShapeRenderer.ShapeType.Filled);
        ProfilerSystemKt.access$getUiShapeRenderer$p().setColor(Color.RED);
        ShapeRendererKt.rect(ProfilerSystemKt.access$getUiShapeRenderer$p(), Vector2Kt.dw(new Vector2(0.2f, 6.8f - ypadding)), Vector2Kt.dw(new Vector2(usedRect, 0.2f)));
        ProfilerSystemKt.access$getUiShapeRenderer$p().setColor(Color.DARK_GRAY);
        ShapeRendererKt.rect(ProfilerSystemKt.access$getUiShapeRenderer$p(), Vector2Kt.dw(new Vector2(0.2f + usedRect, 6.8f - ypadding)), Vector2Kt.dw(new Vector2(totalRect, 0.2f)));
        ProfilerSystemKt.access$getUiShapeRenderer$p().end();
        ProfilerSystemKt.access$getUiSpriteBatch$p().begin();
        this.font18.draw((Batch)ProfilerSystemKt.access$getUiSpriteBatch$p(), "u:" + used + "  /  f: " + free + "  /  m: " + max + ' ', 27.6f, (6.8f - ypadding + 0.16f) * 120.0f);
        ProfilerSystemKt.access$getUiSpriteBatch$p().end();
    }

    public final <T> T profile(@NotNull ProfilerName key, @NotNull Function0<? extends T> block) {
        Intrinsics.checkNotNullParameter((Object)key, "key");
        Intrinsics.checkNotNullParameter(block, "block");
        T result2 = null;
        boolean $i$f$measureNanoTime = false;
        long start$iv = System.nanoTime();
        boolean bl = false;
        result2 = block.invoke();
        long time = System.nanoTime() - start$iv;
        this.time(key.getProfilerName(), time);
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    public final void time(@NotNull String monitorName, long time) {
        Collection<Long> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(monitorName, "monitorName");
        if (!EngineConfig.Debug.INSTANCE.getPROFILER()) {
            return;
        }
        Iterable iterable = new IntRange(0, 300);
        String string2 = monitorName;
        Map<String, List<Long>> map2 = this.dataValues;
        boolean $i$f$map = false;
        void var7_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(0L);
        }
        collection = (List)destination$iv$iv;
        List<Long> timing = map2.getOrDefault(string2, (List<Long>)collection);
        List<Long> newTiming = CollectionsKt.plus((Collection)timing.subList(1, timing.size()), Long.valueOf(time));
        this.dataValues.put(monitorName, newTiming);
    }

    @NotNull
    public final Color color(@NotNull String name, int index) {
        Color color;
        ProfilerName profilerName;
        block2: {
            Intrinsics.checkNotNullParameter(name, "name");
            ProfilerName[] $this$firstOrNull$iv = ProfilerName.values();
            boolean $i$f$firstOrNull = false;
            for (ProfilerName element$iv : $this$firstOrNull$iv) {
                ProfilerName it = element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getProfilerName(), name)) continue;
                profilerName = element$iv;
                break block2;
            }
            profilerName = null;
        }
        if ((color = profilerName == null ? null : profilerName.getColor()) == null) {
            Color color2 = this.colors.get(index % (this.colors.size() - 1));
            Intrinsics.checkNotNullExpressionValue(color2, "colors[index % (colors.size - 1)]");
            color = color2;
        }
        return color;
    }

    public static /* synthetic */ Color color$default(ProfilerSystem profilerSystem, String string2, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        return profilerSystem.color(string2, n);
    }

    public static final /* synthetic */ Map access$getDataValues$p(ProfilerSystem $this) {
        return $this.dataValues;
    }
}

