/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.engine.ecs.core.system.graphics;

import com.badlogic.ashley.core.Engine;
import com.badlogic.ashley.core.EntitySystem;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.veiset.kgame.engine.TBEngineKt;
import org.veiset.kgame.engine.ecs.core.system.debug.ProfilerSystemKt;
import org.veiset.kgame.engine.math.Vector2Kt;
import org.veiset.kgame.engine.values.ProfilerName;
import org.veiset.kgame.engine.world.Gridslot;
import org.veiset.kgame.engine.world.WorldMap;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0011\u001a\u00020\u0012J\u0010\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\nH\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/veiset/kgame/engine/ecs/core/system/graphics/BackgroundTilesSystem;", "Lcom/badlogic/ashley/core/EntitySystem;", "worldMap", "Lorg/veiset/kgame/engine/world/WorldMap;", "(Lorg/veiset/kgame/engine/world/WorldMap;)V", "camera", "Lcom/badlogic/gdx/graphics/OrthographicCamera;", "getCamera", "()Lcom/badlogic/gdx/graphics/OrthographicCamera;", "scale", "", "getScale", "()F", "spriteBatch", "Lcom/badlogic/gdx/graphics/g2d/SpriteBatch;", "getSpriteBatch", "()Lcom/badlogic/gdx/graphics/g2d/SpriteBatch;", "draw", "", "update", "deltaTime", "kgame2"})
public final class BackgroundTilesSystem
extends EntitySystem {
    @NotNull
    private final WorldMap worldMap;
    private final float scale;
    @NotNull
    private final SpriteBatch spriteBatch;
    @NotNull
    private final OrthographicCamera camera;

    public BackgroundTilesSystem(@NotNull WorldMap worldMap2) {
        Intrinsics.checkNotNullParameter(worldMap2, "worldMap");
        this.worldMap = worldMap2;
        this.scale = 0.53333336f;
        this.spriteBatch = TBEngineKt.getGlobals().getDrawGfx().getSpriteBatch();
        this.camera = TBEngineKt.getGlobals().getDrawGfx().getCamera();
    }

    public final float getScale() {
        return this.scale;
    }

    @NotNull
    public final SpriteBatch getSpriteBatch() {
        return this.spriteBatch;
    }

    @NotNull
    public final OrthographicCamera getCamera() {
        return this.camera;
    }

    @Override
    public void update(float deltaTime) {
        Engine engine = this.getEngine();
        Intrinsics.checkNotNullExpressionValue(engine, "engine");
        ProfilerSystemKt.profile(engine, ProfilerName.DRAWBG, (Function0)new Function0<Unit>(this){
            final /* synthetic */ BackgroundTilesSystem this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                this.this$0.draw();
            }
        });
    }

    public final void draw() {
        Vector3 vector3 = this.camera.position;
        Intrinsics.checkNotNullExpressionValue(vector3, "camera.position");
        Vector2 vector2 = Vector2Kt.gfxToWorld(Vector2Kt.v2(vector3));
        float camX = Vector2Kt.component1(vector2);
        float camY = Vector2Kt.component2(vector2);
        float gridsize = 0.53333336f;
        float scale = 1.0f / gridsize;
        int startX = (int)Math.floor((camX - 8.0f * this.camera.zoom) * scale);
        int endX = (int)Math.ceil((camX + 8.0f * this.camera.zoom) * scale);
        int startY = (int)Math.floor((camY - 4.5f * this.camera.zoom) * scale);
        int endY = (int)Math.ceil((camY + 4.5f * this.camera.zoom) * scale);
        this.spriteBatch.begin();
        Iterable $this$forEach$iv = new IntRange(startX, endX);
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            int element$iv;
            int x = element$iv = ((IntIterator)iterator2).nextInt();
            boolean bl = false;
            Iterable $this$forEach$iv2 = new IntRange(startY, endY);
            boolean $i$f$forEach2 = false;
            Iterator iterator3 = $this$forEach$iv2.iterator();
            while (iterator3.hasNext()) {
                int element$iv2;
                int y = element$iv2 = ((IntIterator)iterator3).nextInt();
                boolean bl2 = false;
                Gridslot tile = this.worldMap.getGrid().get("" + x + ',' + y);
                if (tile == null) continue;
                this.getSpriteBatch().draw(tile.getTexture(), (float)x * gridsize * 120.0f, (float)y * gridsize * 120.0f, 120.0f * gridsize + 1.0f, 120.0f * gridsize + 1.0f);
            }
        }
        this.spriteBatch.end();
    }
}

